(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('StdAggregatedChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils, ChartFeatures) {

        $scope.ChartFeatures = ChartFeatures;
        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };

        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data);
        };

        $scope.acceptDimension = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimension(data);
        };

        $scope.getDim0List = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.genericHierarchyDimension : $scope.chart.def.genericDimension0;
    });
})();
