(function(){
    'use strict';

    const sharedPagination = {
        bindings: {
            pageSize: '<',
            listSize: '<',
            selectedPage: '<',
            pageRangeDisplayed: '<',
            marginpageDisplayed: '<',
            showBreaking: '<',
            onPageSelect: '&',
        },
        transclude: true,
        templateUrl: 'static/dataiku/shared/components/shared-pagination/shared-pagination.component.html',
        controller: function(){
            this.pages = [];
            this.displayedPages = [];
            function createRange(length){
                return [...Array(length).keys()];
            }
            this.selectPage = function(pageIndex){
                this.onPageSelect({$event: { pageIndex, pageSize: this.pageSize }});
            }
    
            this.selectPreviousPage = function(){
                this.onPageSelect({$event: { pageIndex: this.selectedPage - 1, pageSize: this.pageSize }});
            }
    
            this.selectNextPage = function(){
                this.onPageSelect({$event: { pageIndex: this.selectedPage + 1, pageSize: this.pageSize }});
            }
    
            this.$onChanges = function(){
                if (angular.isUndefined(this.pageRangeDisplayed)){
                    this.pageRangeDisplayed = 7;
                }
                if (angular.isUndefined(this.marginpageDisplayed)){
                    this.marginPageDisplayed = 0;
                }
                if (angular.isUndefined(this.showBreaking)){
                    this.showBreaking = false;
                }
                if(this.listSize){
                    this.displayedPages = [];
                    this.pages = createRange(Math.floor(this.listSize / this.pageSize) + (this.listSize % this.pageSize !== 0 ? 1 : 0) );
                    const pageCount = this.pages.length;

                    if(pageCount <= this.pageRangeDisplayed){
                        for (let index = 0; index < pageCount; index++) {
                            this.displayedPages.push({type: 'page', index: this.pages[index]});
                        }
                    } else {
                        let leftSide = this.pageRangeDisplayed / 2;
                        let rightSide = this.pageRangeDisplayed - leftSide;

                        if (this.selectedPage > pageCount - this.pageRangeDisplayed / 2) {
                            rightSide = pageCount - this.selectedPage ;
                            leftSide = this.pageRangeDisplayed - rightSide;
                        } else if (this.selectedPage  < this.pageRangeDisplayed / 2) {
                            leftSide = this.selectedPage ;
                            rightSide = this.pageRangeDisplayed - leftSide;
                        }

                        this.displayedPages = this.pages.reduce((previousValue, newPage) => {
                            const page = newPage + 1;
                            if (page <= this.marginPageDisplayed) {
                                return [...previousValue, {type: 'page', index: newPage}];
                            }

                            if (page > pageCount - this.marginPageDisplayed) {
                                return [...previousValue, {type: 'page', index: newPage}];
                            }

                            const adjustedRightSide =
                                this.selectedPage === 0 && this.pageRangeDisplayed > 1
                                    ? rightSide - 1
                                    : rightSide;

                            if (
                                newPage >= this.selectedPage - leftSide &&
                                newPage <= this.selectedPage + adjustedRightSide
                            ) {
                                return [...previousValue, {type: 'page', index: newPage}];
                            }


                            if (
                                this.showBreaking  &&
                                previousValue.length > 0 &&
                                previousValue[previousValue.length - 1].type !== 'break' &&
                                // We do not show break if only one active page is displayed.
                                (this.pageRangeDisplayed > 0 || this.marginPageDisplayed > 0)
                            ) {
                                return [...previousValue, {type: 'break', index: newPage}];
                            }
                            return previousValue;
                        }, []);
                    }
                }
            }
        },
    }

    angular.module('dataiku.shared')
    .component('sharedPagination', sharedPagination);
})();
