class GenAIEvalException(Exception):
    """
    Inspired by DoctorException, but without the scipy dependency
    """
    def __init__(self, message='', code=400, original_exception=None):
        self.value = message
        self.code = code
        self.message = message
        self.original_exception = original_exception
        # We override self.args because when ErrorMonitoringWrapper consumes the exception, under the hood, it uses safe_unicode_str,
        # which itself does not really care about the message field: it uses o.args[0] as the message.
        self.args = (message, code, original_exception)

    def __str__(self):
        return repr(self.value)


class LLMEvalException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(LLMEvalException, self).__init__(message=message, original_exception=original_exception)


class AgentEvalException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(AgentEvalException, self).__init__(message=message, original_exception=original_exception)


class BertScoreException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(BertScoreException, self).__init__(message=message, original_exception=original_exception)


class BleuException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(BleuException, self).__init__(message=message, original_exception=original_exception)


class RougeException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(RougeException, self).__init__(message=message, original_exception=original_exception)


class ToolCallException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(ToolCallException, self).__init__(message=message, original_exception=original_exception)


class RagasException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        # Don't scare the user.
        message = message.replace(' Read the traceback above to debug it. You can also pass `raise_exceptions=False` incase you want to show only a warning message instead.', '')
        # Fix Ragas Typo
        message = message.replace('exeception', 'exception')
        super(RagasException, self).__init__(message=message, original_exception=original_exception)


class TokenCountException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(TokenCountException, self).__init__(message=message, original_exception=original_exception)


class CustomMetricException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(CustomMetricException, self).__init__(message=message, original_exception=original_exception)


class PromptRecipeInputException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(PromptRecipeInputException, self).__init__(message=message, original_exception=original_exception)


class MissingColumnException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(MissingColumnException, self).__init__(message=message, original_exception=original_exception)

class MetricInputException(GenAIEvalException):
    def __init__(self, message, original_exception=None):
        super(MetricInputException, self).__init__(message=message, original_exception=original_exception)
