# Wrapper used to execute R recipes in Docker/Kubernetes
options(echo=F)
tryCatch({
    args <- commandArgs(TRUE);
    print (paste("Executing R script: ", args));
    
    dkuExecEnv = NULL;
    if (file.exists("remote-run-env-def.json")) {
        library("RJSONIO");
        dkuExecEnv = RJSONIO::fromJSON(file("remote-run-env-def.json"))
    }
    
    if (!is.null(dkuExecEnv)) {
        # Save the old R_LIBS and R_LIBS_USER since they were correctly set in R-code-env-wrapper.sh with the correct paths for this container
        original_r_libs = Sys.getenv("R_LIBS")
        original_r_libs_user = Sys.getenv("R_LIBS_USER")

        do.call(Sys.setenv, as.list(dkuExecEnv$env)) # as gruik as Python

        # Put the saved R_LIBS and R_LIBS_USER back in the env
        Sys.setenv(R_LIBS = original_r_libs)
        Sys.setenv(R_LIBS_USER = original_r_libs_user)

        # also put R_LIBS and R_LIBS_USER in the path (otherwise R will run with Livy's env)
        r_libs = strsplit(Sys.getenv("R_LIBS"), ":")[[1]]
        r_libs_user = strsplit(Sys.getenv("R_LIBS_USER"), ":")[[1]]
        libs_chunks = unique(c(r_libs, r_libs_user))
        .libPaths(c(.libPaths(), libs_chunks)) # a bit gruik
    }

	source(args[1], echo=TRUE, keep.source=T);

}, error = function(err){
	library("RJSONIO");
	print("********** R code failed **********");

	msg <- err$message;
    try({
	    if (!(is.character(msg) && length(msg) == 1)) {
	        msg <- RJSONIO::toJSON(msg);
	    }
    });
    msg <- toString(msg);
	print(paste("Error evaluating R code:", msg));

	rErrorType = class(err)[1];
	
	jsonErr = list(message = msg,
				   detailedMessage = paste(rErrorType, ": ", msg),
				   errorType = paste("R.", rErrorType));
	jsonData = RJSONIO::toJSON(jsonErr);
	write(jsonData, file = "error.json");
	quit("no", 1 ,FALSE);
});
