/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldString;
import org.apache.hadoop.io.Text;

public final class VectorUDFUnixTimeStampString
extends VectorUDFTimestampFieldString {
    private static final long serialVersionUID = 1L;
    private final transient SimpleDateFormat format = VectorUDFUnixTimeStampString.getFormatter();
    private final transient Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public VectorUDFUnixTimeStampString(int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum, -1, -1);
    }

    public VectorUDFUnixTimeStampString() {
    }

    @Override
    protected long doGetField(byte[] bytes, int start, int length) throws ParseException {
        Date date = null;
        try {
            date = this.format.parse(Text.decode((byte[])bytes, (int)start, (int)length));
        }
        catch (CharacterCodingException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        this.calendar.setTime(date);
        return this.calendar.getTimeInMillis() / 1000L;
    }

    private static SimpleDateFormat getFormatter() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }
}

