/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AesEncrypt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, key[, mode[, padding[, iv[, aad]]]]) - Returns an encrypted value of `expr` using AES in given `mode` with the specified `padding`.\n      Key lengths of 16, 24 and 32 bits are supported. Supported combinations of (`mode`, `padding`) are ('ECB', 'PKCS'), ('GCM', 'NONE') and ('CBC', 'PKCS').\n      Optional initialization vectors (IVs) are only supported for CBC and GCM modes. These must be 16 bytes for CBC and 12 bytes for GCM. If not provided, a random vector will be generated and prepended to the output.\n      Optional additional authenticated data (AAD) is only supported for GCM. If provided for encryption, the identical AAD value must be provided for decryption.\n      The default mode is GCM.\n  ", arguments="\n    Arguments:\n      * expr - The binary value to encrypt.\n      * key - The passphrase to use to encrypt the data.\n      * mode - Specifies which block cipher mode should be used to encrypt messages.\n               Valid modes: ECB, GCM, CBC.\n      * padding - Specifies how to pad messages whose length is not a multiple of the block size.\n                  Valid values: PKCS, NONE, DEFAULT. The DEFAULT padding means PKCS for ECB, NONE for GCM and PKCS for CBC.\n      * iv - Optional initialization vector. Only supported for CBC and GCM modes.\n             Valid values: None or ''. 16-byte array for CBC mode. 12-byte array for GCM mode.\n      * aad - Optional additional authenticated data. Only supported for GCM mode. This can be any free-form input and\n              must be provided for both encryption and decryption.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_('Spark', '0000111122223333'));\n       83F16B2AA704794132802D248E6BFD4E380078182D1544813898AC97E709B28A94\n      > SELECT hex(_FUNC_('Spark SQL', '0000111122223333', 'GCM'));\n       6E7CA17BBB468D3084B5744BCA729FB7B2B7BCB8E4472847D02670489D95FA97DBBA7D3210\n      > SELECT base64(_FUNC_('Spark SQL', '1234567890abcdef', 'ECB', 'PKCS'));\n       3lmwu+Mw0H3fi5NDvcu9lg==\n      > SELECT base64(_FUNC_('Apache Spark', '1234567890abcdef', 'CBC', 'DEFAULT'));\n       2NYmDCjgXTbbxGA3/SnJEfFC/JQ7olk2VQWReIAAFKo=\n      > SELECT base64(_FUNC_('Spark', 'abcdefghijklmnop12345678ABCDEFGH', 'CBC', 'DEFAULT', unhex('00000000000000000000000000000000')));\n       AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=\n      > SELECT base64(_FUNC_('Spark', 'abcdefghijklmnop12345678ABCDEFGH', 'GCM', 'DEFAULT', unhex('000000000000000000000000'), 'This is an AAD mixed into the input'));\n       AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4\n  ", since="3.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0016-\u0001fB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005u!A\u0001\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005R\u0001\tE\t\u0015!\u0003;\u0011!\u0011\u0006A!f\u0001\n\u0003q\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011\u0002\u001e\t\u0011Q\u0003!Q3A\u0005\u00029C\u0001\"\u0016\u0001\u0003\u0012\u0003\u0006IA\u000f\u0005\t-\u0002\u0011)\u001a!C\u0001\u001d\"Aq\u000b\u0001B\tB\u0003%!\b\u0003\u0005Y\u0001\tU\r\u0011\"\u0001O\u0011!I\u0006A!E!\u0002\u0013Q\u0004\"\u0002.\u0001\t\u0003Y\u0006\u0002C2\u0001\u0011\u000b\u0007I\u0011\t(\t\u000bi\u0003A\u0011\u00013\t\u000bi\u0003A\u0011\u00016\t\u000bi\u0003A\u0011A8\t\u000bi\u0003A\u0011A:\t\u000bY\u0004A\u0011I<\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u0018\u0001\u0011E\u0013\u0011\u0007\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005\u0015\u0004!%A\u0005\u0002\u0005=\u0003\"CA4\u0001E\u0005I\u0011AA(\u0011%\tI\u0007AI\u0001\n\u0003\ty\u0005C\u0005\u0002l\u0001\t\n\u0011\"\u0001\u0002P!I\u0011Q\u000e\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003_\u0002\u0011\u0011!C!\u0003cB\u0011\"!!\u0001\u0003\u0003%\t!a!\t\u0013\u0005-\u0005!!A\u0005\u0002\u00055\u0005\"CAM\u0001\u0005\u0005I\u0011IAN\u0011%\tI\u000bAA\u0001\n\u0003\tY\u000bC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\u001eI\u0011\u0011\u001d\u0017\u0002\u0002#\u0005\u00111\u001d\u0004\tW1\n\t\u0011#\u0001\u0002f\"1!,\nC\u0001\u0003gD\u0011\"!>&\u0003\u0003%)%a>\t\u0013\u0005eX%!A\u0005\u0002\u0006m\b\"\u0003B\u0005K\u0005\u0005I\u0011\u0011B\u0006\u0011%\u0011i\"JA\u0001\n\u0013\u0011yB\u0001\u0006BKN,en\u0019:zaRT!!\f\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003_A\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0007\u0001ir\u0014\t\u0012&\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#AC#yaJ,7o]5p]B\u00111hP\u0005\u0003\u00012\u0012!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u00111HQ\u0005\u0003\u00072\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\b!J|G-^2u!\t)5*\u0003\u0002M\r\na1+\u001a:jC2L'0\u00192mK\u0006)\u0011N\u001c9viV\t!(\u0001\u0004j]B,H\u000fI\u0001\u0004W\u0016L\u0018\u0001B6fs\u0002\nA!\\8eK\u0006)Qn\u001c3fA\u00059\u0001/\u00193eS:<\u0017\u0001\u00039bI\u0012Lgn\u001a\u0011\u0002\u0005%4\u0018aA5wA\u0005\u0019\u0011-\u00193\u0002\t\u0005\fG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fqkfl\u00181bEB\u00111\b\u0001\u0005\u0006\u001b6\u0001\rA\u000f\u0005\u0006!6\u0001\rA\u000f\u0005\u0006%6\u0001\rA\u000f\u0005\u0006)6\u0001\rA\u000f\u0005\u0006-6\u0001\rA\u000f\u0005\u000616\u0001\rAO\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000f\u0006\u0004]K\u001a<\u0007.\u001b\u0005\u0006\u001b>\u0001\rA\u000f\u0005\u0006!>\u0001\rA\u000f\u0005\u0006%>\u0001\rA\u000f\u0005\u0006)>\u0001\rA\u000f\u0005\u0006->\u0001\rA\u000f\u000b\u00069.dWN\u001c\u0005\u0006\u001bB\u0001\rA\u000f\u0005\u0006!B\u0001\rA\u000f\u0005\u0006%B\u0001\rA\u000f\u0005\u0006)B\u0001\rA\u000f\u000b\u00059B\f(\u000fC\u0003N#\u0001\u0007!\bC\u0003Q#\u0001\u0007!\bC\u0003S#\u0001\u0007!\bF\u0002]iVDQ!\u0014\nA\u0002iBQ\u0001\u0015\nA\u0002i\n!\u0002\u001d:fiRLh*Y7f+\u0005A\bcA=\u0002\u00029\u0011!P \t\u0003w\u001ak\u0011\u0001 \u0006\u0003{b\na\u0001\u0010:p_Rt\u0014BA@G\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0019\u0019FO]5oO*\u0011qPR\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0006!\u0019\ti!a\u0006\u0002\u001e9!\u0011qBA\n\u001d\rY\u0018\u0011C\u0005\u0002\u000f&\u0019\u0011Q\u0003$\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+1\u0005\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0002'A\u0003usB,7/\u0003\u0003\u0002(\u0005\u0005\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA\u0017!\u0015\ti!a\u0006;\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002;\u0003gAq!!\u000e\u0017\u0001\u0004\t9$A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007#BA\u0007\u0003sQ\u0014\u0002BA\u001e\u00037\u0011!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u001bq\u000b\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0011\u001diu\u0003%AA\u0002iBq\u0001U\f\u0011\u0002\u0003\u0007!\bC\u0004S/A\u0005\t\u0019\u0001\u001e\t\u000fQ;\u0002\u0013!a\u0001u!9ak\u0006I\u0001\u0002\u0004Q\u0004b\u0002-\u0018!\u0003\u0005\rAO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tFK\u0002;\u0003'Z#!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?2\u0015AC1o]>$\u0018\r^5p]&!\u00111MA-\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005!A.\u00198h\u0015\t\ti(\u0001\u0003kCZ\f\u0017\u0002BA\u0002\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\"\u0011\u0007\u0015\u000b9)C\u0002\u0002\n\u001a\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a$\u0002\u0016B\u0019Q)!%\n\u0007\u0005MeIA\u0002B]fD\u0011\"a&!\u0003\u0003\u0005\r!!\"\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002 \u0006\u0015\u0016qR\u0007\u0003\u0003CS1!a)G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAW\u0003g\u00032!RAX\u0013\r\t\tL\u0012\u0002\b\u0005>|G.Z1o\u0011%\t9JIA\u0001\u0002\u0004\ty)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003[\u000bI\fC\u0005\u0002\u0018\u000e\n\t\u00111\u0001\u0002\u0010\":\u0002!!0\u0002D\u0006\u0015\u0017\u0011ZAf\u0003\u001f\f\t.!6\u0002X\u0006m\u0017Q\u001c\t\u0004w\u0005}\u0016bAAaY\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAd\u0003\u0015%&\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO\u001d\u0017!W\u0016L8\f\f\u0011n_\u0012,7\f\f\u0011qC\u0012$\u0017N\\4\\Y\u0001Jgo\u0017\u0017!C\u0006$W,X/^S\u0001j\u0003EU3ukJt7\u000fI1oA\u0015t7M]=qi\u0016$\u0007E^1mk\u0016\u0004sN\u001a\u0011aKb\u0004(\u000f\u0019\u0011vg&tw\rI!F'\u0002Jg\u000eI4jm\u0016t\u0007\u0005Y7pI\u0016\u0004\u0007e^5uQ\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0002\u0007/\u00193eS:<\u0007M\f\u0006!A\u0001\u0002\u0003\u0005I&fs\u0002bWM\\4uQN\u0004sN\u001a\u00112m1\u0002#\u0007\u000e\u0011b]\u0012\u00043G\r\u0011cSR\u001c\b%\u0019:fAM,\b\u000f]8si\u0016$g\u0006I*vaB|'\u000f^3eA\r|WNY5oCRLwN\\:!_\u001a\u0004\u0003\u0006Y7pI\u0016\u0004G\u0006\t1qC\u0012$\u0017N\\4aS\u0001\n'/\u001a\u0011)O\u0015\u001b%i\n\u0017!OA[5iU\u0014*Y\u0001BseR\"NO1\u0002sET(O\u000b\u001eJ\u0003%\u00198eA!:3IQ\"(Y\u0001:\u0003kS\"TO%r#\u0002\t\u0011!A\u0001\u0002s\n\u001d;j_:\fG\u000eI5oSRL\u0017\r\\5{CRLwN\u001c\u0011wK\u000e$xN]:!Q%36/\u000b\u0011be\u0016\u0004sN\u001c7zAM,\b\u000f]8si\u0016$\u0007EZ8sA\r\u00135\tI1oI\u0002:5)\u0014\u0011n_\u0012,7O\f\u0011UQ\u0016\u001cX\rI7vgR\u0004#-\u001a\u00112m\u0001\u0012\u0017\u0010^3tA\u0019|'\u000fI\"C\u0007\u0002\ng\u000e\u001a\u00112e\u0001\u0012\u0017\u0010^3tA\u0019|'\u000fI$D\u001b:\u0002\u0013J\u001a\u0011o_R\u0004\u0003O]8wS\u0012,G\r\f\u0011bAI\fg\u000eZ8nAY,7\r^8sA]LG\u000e\u001c\u0011cK\u0002:WM\\3sCR,G\rI1oI\u0002\u0002(/\u001a9f]\u0012,G\r\t;pAQDW\rI8viB,HO\f\u0006!A\u0001\u0002\u0003\u0005I(qi&|g.\u00197!C\u0012$\u0017\u000e^5p]\u0006d\u0007%Y;uQ\u0016tG/[2bi\u0016$\u0007\u0005Z1uC\u0002B\u0013)\u0011#*A%\u001c\be\u001c8ms\u0002\u001aX\u000f\u001d9peR,G\r\t4pe\u0002:5)\u0014\u0018!\u0013\u001a\u0004\u0003O]8wS\u0012,G\r\t4pe\u0002*gn\u0019:zaRLwN\u001c\u0017!i\",\u0007%\u001b3f]RL7-\u00197!\u0003\u0006#\u0005E^1mk\u0016\u0004S.^:uA\t,\u0007\u0005\u001d:pm&$W\r\u001a\u0011g_J\u0004C-Z2ssB$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007\u0005Z3gCVdG\u000fI7pI\u0016\u0004\u0013n\u001d\u0011H\u00076s#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAg\u0003\u0019\r%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\b%\f\u0011UQ\u0016\u0004#-\u001b8bef\u0004c/\u00197vK\u0002\"x\u000eI3oGJL\b\u000f\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A-,\u0017\u0010I\u0017!)\",\u0007\u0005]1tgBD'/Y:fAQ|\u0007%^:fAQ|\u0007%\u001a8def\u0004H\u000f\t;iK\u0002\"\u0017\r^1/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jw\u000eZ3![\u0001\u001a\u0006/Z2jM&,7\u000fI<iS\u000eD\u0007E\u00197pG.\u00043-\u001b9iKJ\u0004Sn\u001c3fAMDw.\u001e7eA\t,\u0007%^:fI\u0002\"x\u000eI3oGJL\b\u000f\u001e\u0011nKN\u001c\u0018mZ3t])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c+\u00197jI\u0002jw\u000eZ3tu\u0001*5I\u0011\u0017!\u000f\u000ekE\u0006I\"C\u0007:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1eI&tw\rI\u0017!'B,7-\u001b4jKN\u0004\u0003n\\<!i>\u0004\u0003/\u00193![\u0016\u001c8/Y4fg\u0002:\bn\\:fA1,gn\u001a;iA%\u001c\bE\\8uA\u0005\u0004S.\u001e7uSBdW\rI8gAQDW\r\t2m_\u000e\\\u0007e]5{K:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!-\u0006d\u0017\u000e\u001a\u0011wC2,Xm\u001d\u001e!!.\u001b5\u000b\f\u0011O\u001f:+E\u0006\t#F\r\u0006+F\n\u0016\u0018!)\",\u0007\u0005R#G\u0003VcE\u000b\t9bI\u0012Lgn\u001a\u0011nK\u0006t7\u000f\t)L\u0007N\u0003cm\u001c:!\u000b\u000e\u0013E\u0006\t(P\u001d\u0016\u0003cm\u001c:!\u000f\u000ek\u0005%\u00198eAA[5i\u0015\u0011g_J\u00043IQ\"/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001Jg\u000fI\u0017!\u001fB$\u0018n\u001c8bY\u0002Jg.\u001b;jC2L'0\u0019;j_:\u0004c/Z2u_Jt\u0003e\u00148ms\u0002\u001aX\u000f\u001d9peR,G\r\t4pe\u0002\u001a%i\u0011\u0011b]\u0012\u0004siQ'![>$Wm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011WC2LG\r\t<bYV,7O\u000f\u0011O_:,\u0007e\u001c:!O\u001dr\u0003%\r\u001c.Ef$X\rI1se\u0006L\bEZ8sA\r\u00135\tI7pI\u0016t\u0003%\r\u001a.Ef$X\rI1se\u0006L\bEZ8sA\u001d\u001bU\nI7pI\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006I1bI\u0002j\u0003e\u00149uS>t\u0017\r\u001c\u0011bI\u0012LG/[8oC2\u0004\u0013-\u001e;iK:$\u0018nY1uK\u0012\u0004C-\u0019;b]\u0001ze\u000e\\=!gV\u0004\bo\u001c:uK\u0012\u0004cm\u001c:!\u000f\u000ek\u0005%\\8eK:\u0002C\u000b[5tA\r\fg\u000e\t2fA\u0005t\u0017\u0010\t4sK\u0016lcm\u001c:nA%t\u0007/\u001e;!C:$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\\;ti\u0002\u0012W\r\t9s_ZLG-\u001a3!M>\u0014\bEY8uQ\u0002*gn\u0019:zaRLwN\u001c\u0011b]\u0012\u0004C-Z2ssB$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0017ab\u001e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA!,\u0007\u0010K0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!OA\u0002\u0004\u0007M\u00192cE\u0012$G\r\u001a4gM\u001at%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Aa\u001ad)\r\u001cCe\u0005\u000bu\u0007\r\u001b8sQ\n4G\r\u001d1e\u0011\u0013D\u0007O#7\u0005\u001a#E'R\u001a9aA:\u0004(\r\u001d3\tF*D\u0007\u000e\u001d2gaJ\u0004(Q\":o\u0015;\u0004'\u000f\"3q\u0005KDG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iKbDsLR+O\u0007~Cse\u00159be.\u00043+\u0015'(Y\u0001:\u0003\u0007\r\u00191cE\n\u0014G\r\u001a3eM\u001a4gM\u0014-A\u001d:5)T\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002c'R\u001cD\u0003F:$I\u0011\"5ma\"5\u0007\r\u001d5\u0005V:D\u0007\u000e\"D\u0003^\u0012\u0014H\u0012\"8\u0005J\u0012uGQ\"Cq\u0015#Dg\u000e\u001a9i]\"\u0005G\r\u001c8aQB\u0014\bR\u001d6\r\u0006Kt\u0007\u0012\"C\u0003^\"5GM\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0017m]37i!zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-A\u001d\n$g\r\u001b6m]B\u0014\bM1cG\u0012,gm\n\u0017!O\u0015\u001b%i\n\u0017!OA[5iU\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007\\7xk.ju\u000f\r%4M&,d\n\u0012<dkfbw-P\u001f\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\t\f7/\u001a\u001c5Q}3UKT\"`Q\u001d\n\u0005/Y2iK\u0002\u001a\u0006/\u0019:lO1\u0002s%\r\u001a4iU2t\u0007O\u001d1C\n\u001cG-\u001a4(Y\u0001:3IQ\"(Y\u0001:C)\u0012$B+2#v%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIr\u0015,\u001c#DU\u001eDFK\u00192y\u000f\u0006\u001btf\u00158K\u000b\u001a45i\f&Ro=d7N\r,R/J+\u0017*Q!G\u0017>l$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t2bg\u00164D\u0007K0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!O\u0005\u00147\rZ3gO\"L'n\u001b7n]>\u0004\u0018GM\u001a5kY:\u0004(\u0011\"D\t\u00163u\tS\u0014-A\u001d\u001a%iQ\u0014-A\u001d\"UIR!V\u0019R;C\u0006I;oQ\u0016D\bf\n\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA:\u0013&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003B\u001bF\rN7Xs6SV'\u001c5wU&\f\u0005+\u0015&oM\u001el$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t2bg\u00164D\u0007K0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!O\u0005\u00147\rZ3gO\"L'n\u001b7n]>\u0004\u0018GM\u001a5kY:\u0004(\u0011\"D\t\u00163u\tS\u0014-A\u001d:5)T\u0014-A\u001d\"UIR!V\u0019R;C\u0006I;oQ\u0016D\bf\n\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191a\u001dJC\u0006I\u0014UQ&\u001c\b%[:!C:\u0004\u0013)\u0011#![&DX\r\u001a\u0011j]R|\u0007\u0005\u001e5fA%t\u0007/\u001e;(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003%Q!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!RSfK7f\u001d+M[^ZE)O+d5JrGN\u00153Z\t\u0016|\u0003\u000b\u0017\u001b\u000bA\u0001\nQa]5oG\u0016\f#!!7\u0002\u000bMr3G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0017AC7jg\u000e|f-\u001e8dg\u0006Q\u0011)Z:F]\u000e\u0014\u0018\u0010\u001d;\u0011\u0005m*3\u0003B\u0013\u0002h*\u00032\"!;\u0002pjR$H\u000f\u001e;96\u0011\u00111\u001e\u0006\u0004\u0003[4\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003c\fYOA\tBEN$(/Y2u\rVt7\r^5p]Z\"\"!a9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001d\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001bq\u000bi0a@\u0003\u0002\t\r!Q\u0001B\u0004\u0011\u0015i\u0005\u00061\u0001;\u0011\u0015\u0001\u0006\u00061\u0001;\u0011\u0015\u0011\u0006\u00061\u0001;\u0011\u0015!\u0006\u00061\u0001;\u0011\u00151\u0006\u00061\u0001;\u0011\u0015A\u0006\u00061\u0001;\u0003\u001d)h.\u00199qYf$BA!\u0004\u0003\u001aA)QIa\u0004\u0003\u0014%\u0019!\u0011\u0003$\u0003\r=\u0003H/[8o!%)%Q\u0003\u001e;uiR$(C\u0002\u0003\u0018\u0019\u0013a\u0001V;qY\u00164\u0004\u0002\u0003B\u000eS\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0011!\u0011\t)Ha\t\n\t\t\u0015\u0012q\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class AesEncrypt
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Expression key;
    private final Expression mode;
    private final Expression padding;
    private final Expression iv;
    private final Expression aad;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Expression, Expression>> unapply(AesEncrypt aesEncrypt) {
        return AesEncrypt$.MODULE$.unapply(aesEncrypt);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Expression, Expression>, AesEncrypt> tupled() {
        return AesEncrypt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, AesEncrypt>>>>>> curried() {
        return AesEncrypt$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression key() {
        return this.key;
    }

    public Expression mode() {
        return this.mode;
    }

    public Expression padding() {
        return this.padding;
    }

    public Expression iv() {
        return this.iv;
    }

    public Expression aad() {
        return this.aad;
    }

    private Expression replacement$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, (DataType)BinaryType$.MODULE$, "aesEncrypt", (Seq<Expression>)((Seq)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)new .colon.colon((Object)this.iv(), (List)new .colon.colon((Object)this.aad(), (List)Nil$.MODULE$))))))), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "aes_encrypt";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$))))));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)new .colon.colon((Object)this.iv(), (List)new .colon.colon((Object)this.aad(), (List)Nil$.MODULE$))))));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5));
    }

    public AesEncrypt copy(Expression input, Expression key, Expression mode, Expression padding, Expression iv, Expression aad) {
        return new AesEncrypt(input, key, mode, padding, iv, aad);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.key();
    }

    public Expression copy$default$3() {
        return this.mode();
    }

    public Expression copy$default$4() {
        return this.padding();
    }

    public Expression copy$default$5() {
        return this.iv();
    }

    public Expression copy$default$6() {
        return this.aad();
    }

    @Override
    public String productPrefix() {
        return "AesEncrypt";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.key();
            }
            case 2: {
                return this.mode();
            }
            case 3: {
                return this.padding();
            }
            case 4: {
                return this.iv();
            }
            case 5: {
                return this.aad();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AesEncrypt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AesEncrypt)) return false;
        boolean bl = true;
        if (!bl) return false;
        AesEncrypt aesEncrypt = (AesEncrypt)x$1;
        Expression expression = this.input();
        Expression expression2 = aesEncrypt.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.key();
        Expression expression4 = aesEncrypt.key();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mode();
        Expression expression6 = aesEncrypt.mode();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.padding();
        Expression expression8 = aesEncrypt.padding();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.iv();
        Expression expression10 = aesEncrypt.iv();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.aad();
        Expression expression12 = aesEncrypt.aad();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        if (!aesEncrypt.canEqual(this)) return false;
        return true;
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding, Expression iv, Expression aad) {
        this.input = input;
        this.key = key;
        this.mode = mode;
        this.padding = padding;
        this.iv = iv;
        this.aad = aad;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding, Expression iv) {
        this(input, key, mode, padding, iv, Literal$.MODULE$.apply(""));
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding) {
        this(input, key, mode, padding, Literal$.MODULE$.apply(""));
    }

    public AesEncrypt(Expression input, Expression key, Expression mode) {
        this(input, key, mode, Literal$.MODULE$.apply("DEFAULT"));
    }

    public AesEncrypt(Expression input, Expression key) {
        this(input, key, Literal$.MODULE$.apply("GCM"));
    }
}

