/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.custom_pages;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.configuration.CustomPageOrderGovernConfiguration;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesDataService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomPagesService
implements ICustomPagesService {
    private static final String GEN_AI_REGISTRY = "cp.system.gen-ai-registry";
    private static final List<String> DEFAULT_STANDARD_ORDER = Arrays.asList("cp.system.governable-items", "cp.system.model-registry", "cp.system.gen-ai-registry", "cp.system.bundle-registry", "cp.system.business-initiatives", "cp.system.governed-projects");
    private static final Set<String> STANDARD_PAGE_HIDDEN_WITH_STANDARD_LICENSE = Set.of("cp.system.gen-ai-registry");
    @Autowired
    private ICustomPagesDataService customPagesDataService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;
    @Autowired
    private IPermissionsService permissionsService;

    @Override
    @GHReadonlyTransaction
    public CustomPage getCustomPage(AuthCtx authCtx, String customPageId) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.customPagesDataService.getCustomPage(customPageId);
    }

    @Override
    @GHReadonlyTransaction
    public List<CustomPage> listCustomPages(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        List<CustomPage> customPages = this.customPagesDataService.listCustomPages();
        CustomPageOrderGovernConfiguration configuration = (CustomPageOrderGovernConfiguration)this.governConfigurationDataService.getConfigurationItemOrNull("custom-page-order");
        if (configuration != null) {
            Map<String, CustomPage> mappedPages = customPages.stream().collect(Collectors.toMap(customPage -> customPage.id, customPage -> customPage));
            List orderedCustomPages = configuration.customPageIds.stream().distinct().map(mappedPages::get).collect(Collectors.toList());
            Set missingPagesFromConfiguration = customPages.stream().map(customPage -> customPage.id).collect(Collectors.toSet());
            missingPagesFromConfiguration.removeAll(new HashSet<String>(configuration.customPageIds));
            orderedCustomPages.addAll(missingPagesFromConfiguration.stream().map(mappedPages::get).collect(Collectors.toList()));
            customPages = orderedCustomPages;
        }
        if (!this.licenseEnforcementService.isGovernBlueprintDesignerAllowed()) {
            customPages = this.downgradeCustomPagesToStandardLicense(customPages);
        }
        if (!this.permissionsService.isGovernArchitect(authCtx)) {
            customPages = customPages.stream().filter(customPage -> customPage.visible).collect(Collectors.toList());
        }
        return customPages;
    }

    private List<CustomPage> downgradeCustomPagesToStandardLicense(List<CustomPage> customPages) {
        ArrayList<CustomPage> downgraded = new ArrayList<CustomPage>();
        downgraded.addAll(customPages.stream().filter(cp -> IdentifiersUtils.getSourceFromCustomPageId(cp.id) == IdentifiersUtils.ItemSource.SYSTEM).filter(cp -> !STANDARD_PAGE_HIDDEN_WITH_STANDARD_LICENSE.contains(cp.id)).peek(cp -> {
            cp.visible = true;
        }).sorted(Comparator.comparingInt(cp -> DEFAULT_STANDARD_ORDER.indexOf(cp.id))).collect(Collectors.toList()));
        downgraded.addAll(customPages.stream().filter(cp -> IdentifiersUtils.getSourceFromCustomPageId(cp.id) != IdentifiersUtils.ItemSource.SYSTEM).collect(Collectors.toList()));
        return downgraded;
    }
}

