/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.helpers;

import com.dataiku.gh.core.models.blueprints.ui.view_components.ViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.containers.Layout;
import com.dataiku.gh.core.models.blueprints.ui.view_components.containers.SequentialLayout;
import com.dataiku.gh.core.models.blueprints.ui.view_components.containers.ViewComponentContainer;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.ActionViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.FieldViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.PluginActionViewComponent;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.search.ArtifactFilterArtifactVisitor;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ViewComponentFilter {
    public static List<ViewComponent> filterReadable(List<ViewComponent> viewComponents, EffectivePermissionsItem effectivePermissionsItem) {
        return viewComponents.stream().map(vc -> ViewComponentFilter.filterReadable(vc, effectivePermissionsItem)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static ViewComponent filterReadable(ViewComponent viewComponent, EffectivePermissionsItem effectivePermissionsItem) {
        ViewComponentPermissionFilter viewComponentPermissionFilter = new ViewComponentPermissionFilter(effectivePermissionsItem);
        viewComponent.accept(viewComponentPermissionFilter);
        return viewComponentPermissionFilter.viewComponent;
    }

    public static List<ViewComponent> filterCondition(List<ViewComponent> viewComponents, EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
        return viewComponents.stream().map(vc -> ViewComponentFilter.filterCondition(vc, enrichedArtifact, artifactsDataService)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static ViewComponent filterCondition(ViewComponent viewComponent, EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
        ViewComponentConditionFilter viewComponentConditionFilter = new ViewComponentConditionFilter(enrichedArtifact, artifactsDataService);
        viewComponent.accept(viewComponentConditionFilter);
        return viewComponentConditionFilter.viewComponent;
    }

    private static class ViewComponentPermissionFilter
    implements IBlueprintVersionVisitor {
        private final EffectivePermissionsItem effectivePermissionsItem;
        public ViewComponent viewComponent;

        public ViewComponentPermissionFilter(EffectivePermissionsItem effectivePermissionsItem) {
            this.effectivePermissionsItem = effectivePermissionsItem;
        }

        @Override
        public void visit(ActionViewComponent actionViewComponent) {
            this.viewComponent = actionViewComponent;
        }

        @Override
        public void visit(PluginActionViewComponent pluginActionViewComponent) {
            this.viewComponent = pluginActionViewComponent;
        }

        @Override
        public void visit(FieldViewComponent fieldViewComponent) {
            this.viewComponent = this.effectivePermissionsItem.artifactPermissionsItem.hasReadPermission() && this.effectivePermissionsItem.fieldPermissionsItems.get(fieldViewComponent.fieldId) != null && this.effectivePermissionsItem.fieldPermissionsItems.get(fieldViewComponent.fieldId).hasReadPermission() ? fieldViewComponent : null;
        }

        @Override
        public void visit(ViewComponentContainer viewComponentContainer) {
            ViewComponentContainer newVcc = new ViewComponentContainer();
            newVcc.label = viewComponentContainer.label;
            newVcc.description = viewComponentContainer.description;
            newVcc.documentation = viewComponentContainer.documentation;
            newVcc.visibilityCondition = viewComponentContainer.visibilityCondition;
            newVcc.absoluteUiIndex = viewComponentContainer.absoluteUiIndex;
            if (viewComponentContainer.layout != null) {
                LayoutPermissionFilter layoutPermissionFilter = new LayoutPermissionFilter(this.effectivePermissionsItem);
                viewComponentContainer.layout.accept(layoutPermissionFilter);
                newVcc.layout = layoutPermissionFilter.layout;
            }
            this.viewComponent = newVcc;
        }
    }

    private static class ViewComponentConditionFilter
    implements IBlueprintVersionVisitor {
        private final EnrichedArtifactWithoutPermissions enrichedArtifact;
        private final IArtifactsDataService artifactsDataService;
        private ViewComponent viewComponent;

        public ViewComponentConditionFilter(EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
            this.enrichedArtifact = enrichedArtifact;
            this.artifactsDataService = artifactsDataService;
        }

        @Override
        public void visit(ViewComponentContainer viewComponentContainer) {
            ViewComponentContainer newVcc = new ViewComponentContainer();
            newVcc.label = viewComponentContainer.label;
            newVcc.description = viewComponentContainer.description;
            newVcc.documentation = viewComponentContainer.documentation;
            newVcc.visibilityCondition = viewComponentContainer.visibilityCondition;
            newVcc.absoluteUiIndex = viewComponentContainer.absoluteUiIndex;
            if (newVcc.visibilityCondition == null) {
                this.viewComponent = newVcc;
                this.setViewComponentContainerLayout(viewComponentContainer, newVcc);
            } else {
                ArtifactFilterArtifactVisitor visitor = new ArtifactFilterArtifactVisitor(this.enrichedArtifact, this.artifactsDataService);
                newVcc.visibilityCondition.getQueryableArtifactFilter().accept(visitor);
                if (visitor.artifactMatches) {
                    this.viewComponent = newVcc;
                    this.setViewComponentContainerLayout(viewComponentContainer, newVcc);
                } else {
                    this.viewComponent = null;
                }
            }
        }

        private void setViewComponentContainerLayout(ViewComponentContainer viewComponentContainer, ViewComponentContainer vcc) {
            if (viewComponentContainer.layout != null) {
                LayoutConditionFilter layoutPermissionFilter = new LayoutConditionFilter(this.enrichedArtifact, this.artifactsDataService);
                viewComponentContainer.layout.accept(layoutPermissionFilter);
                vcc.layout = layoutPermissionFilter.layout;
            }
        }

        @Override
        public void visit(FieldViewComponent fieldViewComponent) {
            if (fieldViewComponent.visibilityCondition == null) {
                this.viewComponent = fieldViewComponent;
                return;
            }
            ArtifactFilterArtifactVisitor visitor = new ArtifactFilterArtifactVisitor(this.enrichedArtifact, this.artifactsDataService);
            fieldViewComponent.visibilityCondition.getQueryableArtifactFilter().accept(visitor);
            if (visitor.artifactMatches) {
                this.viewComponent = fieldViewComponent;
            }
        }

        @Override
        public void visit(ActionViewComponent actionViewComponent) {
            this.viewComponent = actionViewComponent;
        }

        @Override
        public void visit(PluginActionViewComponent pluginActionViewComponent) {
            this.viewComponent = pluginActionViewComponent;
        }
    }

    private static class LayoutConditionFilter
    implements IBlueprintVersionVisitor {
        private final EnrichedArtifactWithoutPermissions enrichedArtifact;
        private final IArtifactsDataService artifactsDataService;
        public Layout layout;

        public LayoutConditionFilter(EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
            this.enrichedArtifact = enrichedArtifact;
            this.artifactsDataService = artifactsDataService;
        }

        @Override
        public void visit(SequentialLayout sequentialLayout) {
            SequentialLayout newLayout = new SequentialLayout();
            newLayout.viewComponents = ViewComponentFilter.filterCondition(sequentialLayout.viewComponents, this.enrichedArtifact, this.artifactsDataService);
            this.layout = newLayout;
        }
    }

    private static class LayoutPermissionFilter
    implements IBlueprintVersionVisitor {
        private final EffectivePermissionsItem effectivePermissionsItem;
        public Layout layout;

        public LayoutPermissionFilter(EffectivePermissionsItem effectivePermissionsItem) {
            this.effectivePermissionsItem = effectivePermissionsItem;
        }

        @Override
        public void visit(SequentialLayout sequentialLayout) {
            SequentialLayout newLayout = new SequentialLayout();
            newLayout.viewComponents = ViewComponentFilter.filterReadable(sequentialLayout.viewComponents, this.effectivePermissionsItem);
            this.layout = newLayout;
        }
    }
}

