/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService
implements IPermissionsService {
    public static final String ALL_USERS_GROUP = "$$ALL_USERS$$";
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.permissions");

    @Override
    public boolean isAdmin(AuthCtx authCtx) {
        return authCtx.isAdmin();
    }

    @Override
    public void checkAdmin(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
        }
    }

    @Override
    public void checkAdmin(AuthCtx authCtx, String reason) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin: " + reason, "not-admin");
        }
    }

    private boolean isManagedKeyOrDataikerAdmin(GHAuthCtx dAuthCtx) {
        AbstractGlobalScopePublicAPIKey publicAPIKey = (AbstractGlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
        UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
        return publicAPIKey.managedKey != false || gp.dataikerAdmin != null && gp.dataikerAdmin != false;
    }

    @Override
    public boolean hasAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) {
        if (!this.isAdmin(authCtx)) {
            return false;
        }
        if (!DKUApp.isDataikuCloud()) {
            return true;
        }
        GHAuthCtx dAuthCtx = (GHAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                AbstractGlobalScopePublicAPIKey publicAPIKey = (AbstractGlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                return publicAPIKey.managedKey;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                return gp.dataikerAdmin != null && gp.dataikerAdmin != false;
            }
            case GLOBAL_API_KEY_WITH_GROUPS: {
                return this.isManagedKeyOrDataikerAdmin(dAuthCtx);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public void checkAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) throws UnauthorizedException {
        this.checkAdmin(authCtx);
        if (!DKUApp.isDataikuCloud()) {
            return;
        }
        GHAuthCtx dAuthCtx = (GHAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                AbstractGlobalScopePublicAPIKey publicAPIKey = (AbstractGlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                if (!publicAPIKey.managedKey.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-super-admin");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                if (gp.dataikerAdmin == null || !gp.dataikerAdmin.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-dataiker-admin");
                }
                return;
            }
            case GLOBAL_API_KEY_WITH_GROUPS: {
                if (!this.isManagedKeyOrDataikerAdmin(dAuthCtx)) {
                    throw new UnauthorizedException("Action forbidden", "not-dataiker-admin");
                }
                return;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public boolean isCloudDataikerAdmin(AuthCtx authCtx) {
        return DKUApp.isDataikuCloud() && this.hasAdditionalCloudDataikerAdminPermission(authCtx);
    }

    @Override
    public boolean isGovernArchitect(AuthCtx authCtx) {
        return ((GHAuthCtx)authCtx).getPermissions().isGovernArchitect();
    }

    @Override
    public void checkIsGovernArchitect(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isGovernArchitect(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not a govern architect", "not-govern-architect");
        }
    }
}

