/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt;

import com.dataiku.dss.shadelibpoi.org.apache.poi.common.Duplicatable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.common.usermodel.GenericRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.ChainingMode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.CipherAlgorithm;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.HashAlgorithm;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class EncryptionVerifier
implements GenericRecord,
Duplicatable {
    private byte[] salt;
    private byte[] encryptedVerifier;
    private byte[] encryptedVerifierHash;
    private byte[] encryptedKey;
    private int spinCount;
    private CipherAlgorithm cipherAlgorithm;
    private ChainingMode chainingMode;
    private HashAlgorithm hashAlgorithm;

    protected EncryptionVerifier() {
    }

    protected EncryptionVerifier(EncryptionVerifier other) {
        this.salt = other.salt == null ? null : (byte[])other.salt.clone();
        this.encryptedVerifier = other.encryptedVerifier == null ? null : (byte[])other.encryptedVerifier.clone();
        this.encryptedVerifierHash = other.encryptedVerifierHash == null ? null : (byte[])other.encryptedVerifierHash.clone();
        this.encryptedKey = other.encryptedKey == null ? null : (byte[])other.encryptedKey.clone();
        this.spinCount = other.spinCount;
        this.cipherAlgorithm = other.cipherAlgorithm;
        this.chainingMode = other.chainingMode;
        this.hashAlgorithm = other.hashAlgorithm;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getEncryptedVerifier() {
        return this.encryptedVerifier;
    }

    public byte[] getEncryptedVerifierHash() {
        return this.encryptedVerifierHash;
    }

    public int getSpinCount() {
        return this.spinCount;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public ChainingMode getChainingMode() {
        return this.chainingMode;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt == null ? null : (byte[])salt.clone();
    }

    public void setEncryptedVerifier(byte[] encryptedVerifier) {
        this.encryptedVerifier = encryptedVerifier == null ? null : (byte[])encryptedVerifier.clone();
    }

    public void setEncryptedVerifierHash(byte[] encryptedVerifierHash) {
        this.encryptedVerifierHash = encryptedVerifierHash == null ? null : (byte[])encryptedVerifierHash.clone();
    }

    public void setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = encryptedKey == null ? null : (byte[])encryptedKey.clone();
    }

    public void setSpinCount(int spinCount) {
        this.spinCount = spinCount;
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setChainingMode(ChainingMode chainingMode) {
        this.chainingMode = chainingMode;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public abstract EncryptionVerifier copy();

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        LinkedHashMap<String, Supplier<Object>> m = new LinkedHashMap<String, Supplier<Object>>();
        m.put("salt", this::getSalt);
        m.put("encryptedVerifier", this::getEncryptedVerifier);
        m.put("encryptedVerifierHash", this::getEncryptedVerifierHash);
        m.put("encryptedKey", this::getEncryptedKey);
        m.put("spinCount", this::getSpinCount);
        m.put("cipherAlgorithm", this::getCipherAlgorithm);
        m.put("chainingMode", this::getChainingMode);
        m.put("hashAlgorithm", this::getHashAlgorithm);
        return Collections.unmodifiableMap(m);
    }
}

