/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.ConsumerFulfillmentsImpl;
import com.databricks.internal.sdk.service.marketplace.ConsumerFulfillmentsService;
import com.databricks.internal.sdk.service.marketplace.GetListingContentMetadataRequest;
import com.databricks.internal.sdk.service.marketplace.GetListingContentMetadataResponse;
import com.databricks.internal.sdk.service.marketplace.ListFulfillmentsRequest;
import com.databricks.internal.sdk.service.marketplace.ListFulfillmentsResponse;
import com.databricks.internal.sdk.service.marketplace.ListingFulfillment;
import com.databricks.internal.sdk.service.marketplace.SharedDataObject;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class ConsumerFulfillmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerFulfillmentsAPI.class);
    private final ConsumerFulfillmentsService impl;

    public ConsumerFulfillmentsAPI(ApiClient apiClient) {
        this.impl = new ConsumerFulfillmentsImpl(apiClient);
    }

    public ConsumerFulfillmentsAPI(ConsumerFulfillmentsService mock) {
        this.impl = mock;
    }

    public Iterable<SharedDataObject> get(String listingId) {
        return this.get(new GetListingContentMetadataRequest().setListingId(listingId));
    }

    public Iterable<SharedDataObject> get(GetListingContentMetadataRequest request) {
        return new Paginator(request, this.impl::get, GetListingContentMetadataResponse::getSharedDataObjects, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<ListingFulfillment> list(String listingId) {
        return this.list(new ListFulfillmentsRequest().setListingId(listingId));
    }

    public Iterable<ListingFulfillment> list(ListFulfillmentsRequest request) {
        return new Paginator(request, this.impl::list, ListFulfillmentsResponse::getFulfillments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConsumerFulfillmentsService impl() {
        return this.impl;
    }
}

