/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.model.telemetry;

import com.databricks.internal.fasterxml.jackson.annotation.JsonProperty;
import com.databricks.internal.sdk.support.ToStringer;
import com.databricks.jdbc.common.AuthFlow;
import com.databricks.jdbc.common.AuthMech;
import com.databricks.jdbc.model.telemetry.HostDetails;
import java.util.List;

public class DriverConnectionParameters {
    @JsonProperty(value="http_path")
    String httpPath;
    @JsonProperty(value="mode")
    String driverMode;
    @JsonProperty(value="host_info")
    HostDetails hostDetails;
    @JsonProperty(value="auth_mech")
    AuthMech authMech;
    @JsonProperty(value="auth_flow")
    AuthFlow driverAuthFlow;
    @JsonProperty(value="auth_scope")
    String authScope;
    @JsonProperty(value="use_proxy")
    boolean useProxy;
    @JsonProperty(value="use_system_proxy")
    boolean useSystemProxy;
    @JsonProperty(value="use_cf_proxy")
    boolean useCfProxy;
    @JsonProperty(value="proxy_host_info")
    HostDetails proxyHostDetails;
    @JsonProperty(value="cf_proxy_host_info")
    HostDetails cfProxyHostDetails;
    @JsonProperty(value="discovery_mode_enabled")
    boolean discoveryModeEnabled;
    @JsonProperty(value="discovery_url")
    String discoveryUrl;
    @JsonProperty(value="identity_federation_client_id")
    String identityFederationClientId;
    @JsonProperty(value="use_empty_metadata")
    boolean useEmptyMetadata;
    @JsonProperty(value="support_many_parameters")
    boolean supportManyParameters;
    @JsonProperty(value="ssl_trust_store_type")
    String sslTrustStoreType;
    @JsonProperty(value="check_certificate_revocation")
    boolean checkCertificateRevocation;
    @JsonProperty(value="accept_undetermined_certificate_revocation")
    boolean acceptUndeterminedCertificateRevocation;
    @JsonProperty(value="enable_arrow")
    boolean enableArrow;
    @JsonProperty(value="enable_direct_results")
    boolean enableDirectResults;
    @JsonProperty(value="enable_jwt_assertion")
    boolean enableJwtAssertion;
    @JsonProperty(value="jwt_key_file")
    String jwtKeyFile;
    @JsonProperty(value="jwt_algorithm")
    String jwtAlgorithm;
    @JsonProperty(value="google_service_account")
    String googleServiceAccount;
    @JsonProperty(value="google_credential_file_path")
    String googleCredentialFilePath;
    @JsonProperty(value="allowed_volume_ingestion_paths")
    String allowedVolumeIngestionPaths;
    @JsonProperty(value="enable_complex_datatype_support")
    boolean enableComplexDatatypeSupport;
    @JsonProperty(value="enable_geospatial_support")
    boolean enableGeoSpatialSupport;
    @JsonProperty(value="azure_workspace_resource_id")
    String azureWorkspaceResourceId;
    @JsonProperty(value="azure_tenant_id")
    String azureTenantId;
    @JsonProperty(value="string_column_length")
    int stringColumnLength;
    @JsonProperty(value="socket_timeout")
    int socketTimeout;
    @JsonProperty(value="enable_token_cache")
    boolean enableTokenCache;
    @JsonProperty(value="auth_endpoint")
    String authEndpoint;
    @JsonProperty(value="token_endpoint")
    String tokenEndpoint;
    @JsonProperty(value="non_proxy_hosts")
    List<String> nonProxyHosts;
    @JsonProperty(value="http_connection_pool_size")
    int httpConnectionPoolSize;
    @JsonProperty(value="enable_sea_hybrid_results")
    boolean enableSeaHybridResults;
    @JsonProperty(value="allow_self_signed_support")
    boolean allowSelfSignedSupport;
    @JsonProperty(value="use_system_trust_store")
    boolean useSystemTrustStore;
    @JsonProperty(value="rows_fetched_per_block")
    int rowsFetchedPerBlock;
    @JsonProperty(value="async_poll_interval_millis")
    int asyncPollIntervalMillis;
    @JsonProperty(value="enable_metric_view_metadata")
    boolean enableMetricViewMetadata;

    public DriverConnectionParameters setHttpPath(String httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public DriverConnectionParameters setDriverMode(String clientType) {
        this.driverMode = clientType.toString();
        return this;
    }

    public DriverConnectionParameters setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        return this;
    }

    public DriverConnectionParameters setAuthMech(AuthMech authMech) {
        this.authMech = authMech;
        return this;
    }

    public DriverConnectionParameters setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
        return this;
    }

    public DriverConnectionParameters setUseCfProxy(boolean useCfProxy) {
        this.useCfProxy = useCfProxy;
        return this;
    }

    public DriverConnectionParameters setHostDetails(HostDetails hostDetails) {
        this.hostDetails = hostDetails;
        return this;
    }

    public DriverConnectionParameters setCfProxyHostDetails(HostDetails cfProxyHostDetails) {
        this.cfProxyHostDetails = cfProxyHostDetails;
        return this;
    }

    public DriverConnectionParameters setProxyHostDetails(HostDetails proxyHostDetails) {
        this.proxyHostDetails = proxyHostDetails;
        return this;
    }

    public DriverConnectionParameters setDriverAuthFlow(AuthFlow driverAuthFlow) {
        this.driverAuthFlow = driverAuthFlow;
        return this;
    }

    public DriverConnectionParameters setDiscoveryModeEnabled(boolean discoveryModeEnabled) {
        this.discoveryModeEnabled = discoveryModeEnabled;
        return this;
    }

    public DriverConnectionParameters setAuthScope(String authScope) {
        this.authScope = authScope;
        return this;
    }

    public DriverConnectionParameters setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
        return this;
    }

    public DriverConnectionParameters setIdentityFederationClientId(String identityFederationClientId) {
        this.identityFederationClientId = identityFederationClientId;
        return this;
    }

    public DriverConnectionParameters setUseEmptyMetadata(boolean useEmptyMetadata) {
        this.useEmptyMetadata = useEmptyMetadata;
        return this;
    }

    public DriverConnectionParameters setSupportManyParameters(boolean supportManyParameters) {
        this.supportManyParameters = supportManyParameters;
        return this;
    }

    public DriverConnectionParameters setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
        return this;
    }

    public DriverConnectionParameters setCheckCertificateRevocation(boolean checkCertificateRevocation) {
        this.checkCertificateRevocation = checkCertificateRevocation;
        return this;
    }

    public DriverConnectionParameters setAcceptUndeterminedCertificateRevocation(boolean acceptUndeterminedCertificateRevocation) {
        this.acceptUndeterminedCertificateRevocation = acceptUndeterminedCertificateRevocation;
        return this;
    }

    public DriverConnectionParameters setEnableArrow(boolean enableArrow) {
        this.enableArrow = enableArrow;
        return this;
    }

    public DriverConnectionParameters setEnableDirectResults(boolean enableDirectResults) {
        this.enableDirectResults = enableDirectResults;
        return this;
    }

    public DriverConnectionParameters setEnableJwtAssertion(boolean enableJwtAssertion) {
        this.enableJwtAssertion = enableJwtAssertion;
        return this;
    }

    public DriverConnectionParameters setJwtKeyFile(String jwtKeyFile) {
        this.jwtKeyFile = jwtKeyFile;
        return this;
    }

    public DriverConnectionParameters setJwtAlgorithm(String jwtAlgorithm) {
        this.jwtAlgorithm = jwtAlgorithm;
        return this;
    }

    public DriverConnectionParameters setGoogleServiceAccount(String googleServiceAccount) {
        this.googleServiceAccount = googleServiceAccount;
        return this;
    }

    public DriverConnectionParameters setGoogleCredentialFilePath(String googleCredentialFilePath) {
        this.googleCredentialFilePath = googleCredentialFilePath;
        return this;
    }

    public DriverConnectionParameters setAllowedVolumeIngestionPaths(String allowedVolumeIngestionPaths) {
        this.allowedVolumeIngestionPaths = allowedVolumeIngestionPaths;
        return this;
    }

    public DriverConnectionParameters setEnableComplexDatatypeSupport(boolean enableComplexDatatypeSupport) {
        this.enableComplexDatatypeSupport = enableComplexDatatypeSupport;
        return this;
    }

    public DriverConnectionParameters setEnableGeoSpatialSupport(boolean enableGeoSpatialSupport) {
        this.enableGeoSpatialSupport = enableGeoSpatialSupport;
        return this;
    }

    public DriverConnectionParameters setAzureWorkspaceResourceId(String azureWorkspaceResourceId) {
        this.azureWorkspaceResourceId = azureWorkspaceResourceId;
        return this;
    }

    public DriverConnectionParameters setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
        return this;
    }

    public DriverConnectionParameters setStringColumnLength(int stringColumnLength) {
        this.stringColumnLength = stringColumnLength;
        return this;
    }

    public DriverConnectionParameters setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public DriverConnectionParameters setEnableTokenCache(boolean enableTokenCache) {
        this.enableTokenCache = enableTokenCache;
        return this;
    }

    public DriverConnectionParameters setAuthEndpoint(String authEndpoint) {
        this.authEndpoint = authEndpoint;
        return this;
    }

    public DriverConnectionParameters setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public DriverConnectionParameters setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public DriverConnectionParameters setHttpConnectionPoolSize(int httpConnectionPoolSize) {
        this.httpConnectionPoolSize = httpConnectionPoolSize;
        return this;
    }

    public DriverConnectionParameters setEnableSeaHybridResults(boolean enableSeaHybridResults) {
        this.enableSeaHybridResults = enableSeaHybridResults;
        return this;
    }

    public DriverConnectionParameters setAllowSelfSignedSupport(boolean allowSelfSignedSupport) {
        this.allowSelfSignedSupport = allowSelfSignedSupport;
        return this;
    }

    public DriverConnectionParameters setUseSystemTrustStore(boolean useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public DriverConnectionParameters setRowsFetchedPerBlock(int rowsFetchedPerBlock) {
        this.rowsFetchedPerBlock = rowsFetchedPerBlock;
        return this;
    }

    public DriverConnectionParameters setAsyncPollIntervalMillis(int asyncPollIntervalMillis) {
        this.asyncPollIntervalMillis = asyncPollIntervalMillis;
        return this;
    }

    public DriverConnectionParameters setEnableMetricViewMetadata(boolean enableMetricViewMetadata) {
        this.enableMetricViewMetadata = enableMetricViewMetadata;
        return this;
    }

    public String toString() {
        return new ToStringer(DriverConnectionParameters.class).add("httpPath", this.httpPath).add("driverMode", this.driverMode).add("hostDetails", this.hostDetails).add("authMech", (Object)this.authMech).add("driverAuthFlow", (Object)this.driverAuthFlow).add("authScope", this.authScope).add("useProxy", this.useProxy).add("useSystemProxy", this.useSystemProxy).add("useCfProxy", this.useCfProxy).add("proxyHostDetails", this.proxyHostDetails).add("cfProxyHostDetails", this.cfProxyHostDetails).add("discoveryModeEnabled", this.discoveryModeEnabled).add("discoveryUrl", this.discoveryUrl).add("identityFederationClientId", this.identityFederationClientId).add("useEmptyMetadata", this.useEmptyMetadata).add("supportManyParameters", this.supportManyParameters).add("sslTrustStoreType", this.sslTrustStoreType).add("checkCertificateRevocation", this.checkCertificateRevocation).add("acceptUndeterminedCertificateRevocation", this.acceptUndeterminedCertificateRevocation).add("enableArrow", this.enableArrow).add("enableDirectResults", this.enableDirectResults).add("enableJwtAssertion", this.enableJwtAssertion).add("jwtKeyFile", this.jwtKeyFile).add("jwtAlgorithm", this.jwtAlgorithm).add("googleServiceAccount", this.googleServiceAccount).add("googleCredentialFilePath", this.googleCredentialFilePath).add("allowedVolumeIngestionPaths", this.allowedVolumeIngestionPaths).add("enableComplexDatatypeSupport", this.enableComplexDatatypeSupport).add("enableGeoSpatialSupport", this.enableGeoSpatialSupport).add("azureWorkspaceResourceId", this.azureWorkspaceResourceId).add("azureTenantId", this.azureTenantId).add("stringColumnLength", this.stringColumnLength).add("socketTimeout", this.socketTimeout).add("enableTokenCache", this.enableTokenCache).add("authEndpoint", this.authEndpoint).add("tokenEndpoint", this.tokenEndpoint).add("nonProxyHosts", this.nonProxyHosts).add("httpConnectionPoolSize", this.httpConnectionPoolSize).add("enableSeaHybridResults", this.enableSeaHybridResults).add("allowSelfSignedSupport", this.allowSelfSignedSupport).add("useSystemTrustStore", this.useSystemTrustStore).add("rowsFetchedPerBlock", this.rowsFetchedPerBlock).add("asyncPollIntervalMillis", this.asyncPollIntervalMillis).add("enableMetricViewMetadata", this.enableMetricViewMetadata).toString();
    }
}

