/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client.transport.rest.sse;

import com.dataiku.dss.shadeliba2a.com.google.protobuf.InvalidProtocolBufferException;
import com.dataiku.dss.shadeliba2a.com.google.protobuf.Message;
import com.dataiku.dss.shadeliba2a.com.google.protobuf.util.JsonFormat;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.rest.RestErrorMapper;
import com.dataiku.dss.shadeliba2a.io.a2a.grpc.StreamResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.grpc.utils.ProtoUtils;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.EventKind;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.StreamingEventKind;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class RestSSEEventListener {
    private static final Logger log = Logger.getLogger(RestSSEEventListener.class.getName());
    private final Consumer<StreamingEventKind> eventHandler;
    private final Consumer<Throwable> errorHandler;

    public RestSSEEventListener(Consumer<StreamingEventKind> eventHandler, Consumer<Throwable> errorHandler) {
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
    }

    public void onMessage(String message, @Nullable Future<Void> completableFuture) {
        try {
            log.fine("Streaming message received: " + message);
            StreamResponse.Builder builder = StreamResponse.newBuilder();
            JsonFormat.parser().merge(message, (Message.Builder)builder);
            this.handleMessage(builder.build());
        }
        catch (InvalidProtocolBufferException e) {
            this.errorHandler.accept(RestErrorMapper.mapRestError(message, 500));
        }
    }

    public void onError(Throwable throwable, @Nullable Future<Void> future) {
        if (this.errorHandler != null) {
            this.errorHandler.accept(throwable);
        }
        if (future != null) {
            future.cancel(true);
        }
    }

    private void handleMessage(StreamResponse response) {
        EventKind event;
        switch (response.getPayloadCase()) {
            case MSG: {
                event = ProtoUtils.FromProto.message(response.getMsg());
                break;
            }
            case TASK: {
                event = ProtoUtils.FromProto.task(response.getTask());
                break;
            }
            case STATUS_UPDATE: {
                event = ProtoUtils.FromProto.taskStatusUpdateEvent(response.getStatusUpdate());
                break;
            }
            case ARTIFACT_UPDATE: {
                event = ProtoUtils.FromProto.taskArtifactUpdateEvent(response.getArtifactUpdate());
                break;
            }
            default: {
                log.warning("Invalid stream response " + String.valueOf(response.getPayloadCase()));
                this.errorHandler.accept(new IllegalStateException("Invalid stream response from server: " + String.valueOf(response.getPayloadCase())));
                return;
            }
        }
        this.eventHandler.accept((StreamingEventKind)((Object)event));
    }
}

