/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.server;

import com.dataiku.dss.shadeliba2a.io.a2a.server.TransportMetadata;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentInterface;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TransportProtocol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AgentCardValidator {
    private static final Logger LOGGER = Logger.getLogger(AgentCardValidator.class.getName());
    public static final String SKIP_PROPERTY = "com.dataiku.dss.shadeliba2a.io.a2a.transport.skipValidation";
    public static final String SKIP_JSONRPC_PROPERTY = "com.dataiku.dss.shadeliba2a.io.a2a.transport.jsonrpc.skipValidation";
    public static final String SKIP_GRPC_PROPERTY = "com.dataiku.dss.shadeliba2a.io.a2a.transport.grpc.skipValidation";
    public static final String SKIP_REST_PROPERTY = "com.dataiku.dss.shadeliba2a.io.a2a.transport.rest.skipValidation";

    public static void validateTransportConfiguration(AgentCard agentCard) {
        AgentCardValidator.validateTransportConfiguration(agentCard, AgentCardValidator.getAvailableTransports());
    }

    static void validateTransportConfiguration(AgentCard agentCard, Set<String> availableTransports) {
        Set<String> unsupportedTransports;
        boolean skip = Boolean.getBoolean(SKIP_PROPERTY);
        if (skip) {
            return;
        }
        Set<String> agentCardTransports = AgentCardValidator.getAgentCardTransports(agentCard);
        Set<String> filteredAvailableTransports = AgentCardValidator.filterSkippedTransports(availableTransports);
        Set<String> filteredAgentCardTransports = AgentCardValidator.filterSkippedTransports(agentCardTransports);
        Set<String> missingTransports = filteredAvailableTransports.stream().filter(transport -> !filteredAgentCardTransports.contains(transport)).collect(Collectors.toSet());
        if (!missingTransports.isEmpty()) {
            LOGGER.warning(String.format("AgentCard does not include all available transports. Missing: %s. Available transports: %s. AgentCard transports: %s", AgentCardValidator.formatTransports(missingTransports), AgentCardValidator.formatTransports(filteredAvailableTransports), AgentCardValidator.formatTransports(filteredAgentCardTransports)));
        }
        if (!(unsupportedTransports = filteredAgentCardTransports.stream().filter(transport -> !filteredAvailableTransports.contains(transport)).collect(Collectors.toSet())).isEmpty()) {
            String errorMessage = String.format("AgentCard specifies transport interfaces for unavailable transports: %s. Available transports: %s. Consider removing these interfaces or adding the required transport dependencies.", AgentCardValidator.formatTransports(unsupportedTransports), AgentCardValidator.formatTransports(filteredAvailableTransports));
            LOGGER.severe(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        if (agentCard.additionalInterfaces() != null) {
            agentCard.additionalInterfaces().stream().filter(agentInterface -> agentInterface.transport().equals(agentCard.preferredTransport())).findFirst().ifPresent(preferredTransportAgentInterface -> {
                if (!preferredTransportAgentInterface.url().equals(agentCard.url())) {
                    LOGGER.warning(String.format("AgentCard's URL=%s does not correspond to the URL of the preferred transport=%s.", agentCard.url(), preferredTransportAgentInterface.url()));
                }
            });
        }
    }

    private static Set<String> getAgentCardTransports(AgentCard agentCard) {
        ArrayList<String> transportStrings = new ArrayList<String>();
        if (agentCard.preferredTransport() != null) {
            transportStrings.add(agentCard.preferredTransport());
        }
        if (agentCard.additionalInterfaces() != null) {
            for (AgentInterface agentInterface : agentCard.additionalInterfaces()) {
                if (agentInterface.transport() == null) continue;
                transportStrings.add(agentInterface.transport());
            }
        }
        return new HashSet<String>(transportStrings);
    }

    private static String formatTransports(Set<String> transports) {
        return transports.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    private static Set<String> filterSkippedTransports(Set<String> transports) {
        return transports.stream().filter(transport -> !AgentCardValidator.isTransportSkipped(transport)).collect(Collectors.toSet());
    }

    private static boolean isTransportSkipped(String transport) {
        if (transport.equals(TransportProtocol.JSONRPC.asString())) {
            return Boolean.getBoolean(SKIP_JSONRPC_PROPERTY);
        }
        if (transport.equals(TransportProtocol.GRPC.asString())) {
            return Boolean.getBoolean(SKIP_GRPC_PROPERTY);
        }
        if (transport.equals(TransportProtocol.HTTP_JSON.asString())) {
            return Boolean.getBoolean(SKIP_REST_PROPERTY);
        }
        return false;
    }

    private static Set<String> getAvailableTransports() {
        return ServiceLoader.load(TransportMetadata.class).stream().map(ServiceLoader.Provider::get).filter(TransportMetadata::isAvailable).map(TransportMetadata::getTransportProtocol).collect(Collectors.toSet());
    }
}

