/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.server.util.async;

import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;
import com.dataiku.dss.shadeliba2a.mutiny.zero.BackpressureStrategy;
import com.dataiku.dss.shadeliba2a.mutiny.zero.Tube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.TubeConfiguration;
import com.dataiku.dss.shadeliba2a.mutiny.zero.ZeroPublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.operators.Transform;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncUtils {
    private static final int DEFAULT_TUBE_BUFFER_SIZE = 256;

    public static TubeConfiguration createTubeConfig() {
        return AsyncUtils.createTubeConfig(256);
    }

    public static TubeConfiguration createTubeConfig(int bufferSize) {
        return new TubeConfiguration().withBackpressureStrategy(BackpressureStrategy.BUFFER).withBufferSize(256);
    }

    public static <T> void consumer(TubeConfiguration config, Flow.Publisher<T> source, final Function<T, Boolean> nextFunction, Consumer<Throwable> errorConsumer) {
        BiFunction nextBiFunction = new BiFunction<Consumer<Throwable>, T, Boolean>(){

            @Override
            public Boolean apply(Consumer<Throwable> throwableConsumer, T t) {
                return (Boolean)nextFunction.apply(t);
            }
        };
        ZeroPublisher.create(config, tube -> source.subscribe(new ConsumingSubscriber(nextBiFunction, errorConsumer))).subscribe(new Flow.Subscriber<Object>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(Object item) {
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                this.subscription.cancel();
            }

            @Override
            public void onComplete() {
                this.subscription.cancel();
            }
        });
    }

    public static <T> Flow.Publisher<T> processor(TubeConfiguration config, Flow.Publisher<T> source, BiFunction<Consumer<Throwable>, T, Boolean> nextFunction) {
        return ZeroPublisher.create(config, tube -> source.subscribe(new ProcessingSubscriber(tube, nextFunction)));
    }

    public static <T, N> Flow.Publisher<N> convertingProcessor(Flow.Publisher<T> source, Function<T, N> converterFunction) {
        return new Transform<T, N>(source, converterFunction);
    }

    private static class ProcessingSubscriber<T>
    extends AbstractSubscriber<T> {
        private Flow.Subscription subscription;
        private final Tube<T> tube;

        public ProcessingSubscriber(Tube<T> tube, BiFunction<Consumer<Throwable>, T, Boolean> nextFunction) {
            super(nextFunction, tube::send, t -> {
                if (t == null) {
                    tube.complete();
                } else {
                    tube.fail((Throwable)t);
                }
            });
            Assert.checkNotNullParam("tube", tube);
            this.tube = tube;
        }
    }

    private static class ConsumingSubscriber<T>
    extends AbstractSubscriber<T> {
        public ConsumingSubscriber(BiFunction<Consumer<Throwable>, T, Boolean> nextFunction, Consumer<Throwable> failureOrCompleteConsumer) {
            super(nextFunction, null, failureOrCompleteConsumer);
        }
    }

    private static class ConvertingProcessingSubscriber<T, N>
    implements Flow.Subscriber<T> {
        private Flow.Subscription subscription;
        private Tube<N> tube;
        private final BiFunction<Consumer<Throwable>, T, N> converterBiFunction;

        public ConvertingProcessingSubscriber(Tube<N> tube, Function<T, N> converterFunction) {
            Assert.checkNotNullParam("tube", tube);
            Assert.checkNotNullParam("converterFunction", converterFunction);
            this.tube = tube;
            this.converterBiFunction = (throwableConsumer, t) -> converterFunction.apply(t);
        }

        public ConvertingProcessingSubscriber(Tube<N> tube, BiFunction<Consumer<Throwable>, T, N> converterBiFunction) {
            Assert.checkNotNullParam("tube", tube);
            Assert.checkNotNullParam("converterBiFunction", converterBiFunction);
            this.tube = tube;
            this.converterBiFunction = converterBiFunction;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(1L);
        }

        @Override
        public void onNext(T item) {
            AtomicBoolean errorRaised = new AtomicBoolean(false);
            Consumer<Throwable> errorConsumer = t -> {
                errorRaised.set(true);
                this.onError((Throwable)t);
            };
            Object converted = null;
            try {
                converted = this.converterBiFunction.apply(errorConsumer, (Consumer<Throwable>)item);
            }
            catch (Throwable t2) {
                errorConsumer.accept(t2);
                return;
            }
            if (!errorRaised.get()) {
                this.tube.send(converted);
                this.subscription.request(1L);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.subscription.cancel();
            this.tube.fail(throwable);
        }

        @Override
        public void onComplete() {
            this.subscription.cancel();
            this.tube.complete();
        }
    }

    private static abstract class AbstractSubscriber<T>
    implements Flow.Subscriber<T> {
        private Flow.Subscription subscription;
        private final BiFunction<Consumer<Throwable>, T, Boolean> nextFunction;
        private final Consumer<T> publishNextConsumer;
        private final Consumer<Throwable> failureOrCompleteConsumer;

        protected AbstractSubscriber(BiFunction<Consumer<Throwable>, T, Boolean> nextFunction, Consumer<T> publishNextConsumer, Consumer<Throwable> failureOrCompleteConsumer) {
            Assert.checkNotNullParam("nextFunction", nextFunction);
            this.nextFunction = nextFunction;
            this.publishNextConsumer = publishNextConsumer != null ? publishNextConsumer : t -> {};
            this.failureOrCompleteConsumer = failureOrCompleteConsumer != null ? failureOrCompleteConsumer : t -> {};
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(1L);
        }

        @Override
        public void onNext(T item) {
            AtomicReference errorRaised = new AtomicReference();
            Consumer<Throwable> errorConsumer = t -> {
                errorRaised.set(t);
                this.onError((Throwable)t);
            };
            boolean continueProcessing = false;
            if (errorRaised.get() == null) {
                try {
                    continueProcessing = this.nextFunction.apply(errorConsumer, (Consumer<Throwable>)item);
                }
                catch (Throwable t2) {
                    errorConsumer.accept(t2);
                }
            }
            if (!continueProcessing || errorRaised.get() != null) {
                this.subscription.cancel();
            } else {
                if (this.publishNextConsumer != null) {
                    this.publishNextConsumer.accept(item);
                }
                this.subscription.request(1L);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.subscription.cancel();
            if (this.failureOrCompleteConsumer != null) {
                this.failureOrCompleteConsumer.accept(throwable);
            }
        }

        @Override
        public void onComplete() {
            this.subscription.cancel();
            if (this.failureOrCompleteConsumer != null) {
                this.failureOrCompleteConsumer.accept(null);
            }
        }
    }
}

