/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero.internal;

import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.AlreadyCompletedSubscription;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.IteratorSubscription;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StreamPublisher<T>
implements Flow.Publisher<T> {
    private final Supplier<Stream<T>> supplier;

    public StreamPublisher(Supplier<Stream<T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Stream<T> stream = this.supplier.get();
        if (stream == null) {
            subscriber.onSubscribe(new AlreadyCompletedSubscription());
            subscriber.onError(new NullPointerException("The supplied stream cannot be null"));
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(stream.iterator(), subscriber));
        }
    }
}

