/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.fs;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class Path
implements Comparable<Path>,
Serializable,
ObjectInputValidation {
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");
    private static final Pattern SLASHES = Pattern.compile("/+");
    private static final long serialVersionUID = 708623L;
    private URI uri;

    public Path(String string, String string2) {
        this(new Path(string), new Path(string2));
    }

    public Path(Path path, String string) {
        this(path, new Path(string));
    }

    public Path(String string, Path path) {
        this(new Path(string), path);
    }

    public Path(Path path, Path path2) {
        URI uRI = path.uri;
        String string = uRI.getPath();
        if (!string.equals(SEPARATOR) && !string.isEmpty()) {
            try {
                uRI = new URI(uRI.getScheme(), uRI.getAuthority(), uRI.getPath() + SEPARATOR, null, uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
        }
        URI uRI2 = uRI.resolve(path2.uri);
        this.initialize(uRI2.getScheme(), uRI2.getAuthority(), uRI2.getPath(), uRI2.getFragment());
    }

    private void checkPathArg(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String string) throws IllegalArgumentException {
        this.checkPathArg(string);
        if (Path.hasWindowsDrive(string) && string.charAt(0) != '/') {
            string = SEPARATOR + string;
        }
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(47);
        if (n2 != -1 && (n3 == -1 || n2 < n3)) {
            string2 = string.substring(0, n2);
            n = n2 + 1;
        }
        if (string.startsWith("//", n) && string.length() - n > 2) {
            int n4 = string.indexOf(47, n + 2);
            int n5 = n4 > 0 ? n4 : string.length();
            string3 = string.substring(n + 2, n5);
            n = n5;
        }
        String string4 = string.substring(n, string.length());
        this.initialize(string2, string3, string4, null);
    }

    public Path(URI uRI) {
        this.uri = uRI.normalize();
    }

    public Path(String string, String string2, String string3) {
        this.checkPathArg(string3);
        if (Path.hasWindowsDrive(string3) && string3.charAt(0) != '/') {
            string3 = SEPARATOR + string3;
        }
        if (!WINDOWS && string3.charAt(0) != '/') {
            string3 = "./" + string3;
        }
        this.initialize(string, string2, string3, null);
    }

    private void initialize(String string, String string2, String string3, String string4) {
        try {
            this.uri = new URI(string, string2, Path.normalizePath(string, string3), null, string4).normalize();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    private static String normalizePath(String string, String string2) {
        string2 = SLASHES.matcher(string2).replaceAll(SEPARATOR);
        if (WINDOWS && (Path.hasWindowsDrive(string2) || string == null || string.isEmpty() || string.equals("file"))) {
            string2 = string2.replace("\\", SEPARATOR);
        }
        int n = Path.startPositionWithoutWindowsDrive(string2) + 1;
        if (string2.length() > n && string2.endsWith(SEPARATOR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private static boolean hasWindowsDrive(String string) {
        return WINDOWS && HAS_DRIVE_LETTER_SPECIFIER.matcher(string).find();
    }

    private static int startPositionWithoutWindowsDrive(String string) {
        if (Path.hasWindowsDrive(string)) {
            return string.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    public URI toUri() {
        return this.uri;
    }

    public boolean isUriPathAbsolute() {
        int n = Path.startPositionWithoutWindowsDrive(this.uri.getPath());
        return this.uri.getPath().startsWith(SEPARATOR, n);
    }

    public boolean isAbsolute() {
        return this.isUriPathAbsolute();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String getName() {
        String string = this.uri.getPath();
        int n = string.lastIndexOf(SEPARATOR);
        return string.substring(n + 1);
    }

    public Path getParent() {
        String string = this.uri.getPath();
        int n = string.lastIndexOf(47);
        int n2 = Path.startPositionWithoutWindowsDrive(string);
        if (string.length() == n2 || n == n2 && string.length() == n2 + 1) {
            return null;
        }
        String string2 = n == -1 ? CUR_DIR : string.substring(0, n == n2 ? n2 + 1 : n);
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.uri.getScheme() != null) {
            stringBuilder.append(this.uri.getScheme()).append(":");
        }
        if (this.uri.getAuthority() != null) {
            stringBuilder.append("//").append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String string = this.uri.getPath();
            if (string.indexOf(47) == 0 && Path.hasWindowsDrive(string) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                string = string.substring(1);
            }
            stringBuilder.append(string);
        }
        if (this.uri.getFragment() != null) {
            stringBuilder.append("#").append(this.uri.getFragment());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        return this.uri.equals(path.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(Path path) {
        return this.uri.compareTo(path.uri);
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.uri == null) {
            throw new InvalidObjectException("No URI in deserialized Path");
        }
    }

    public static String getName(String string) {
        return new Path(string).getName();
    }
}

