/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.arrays;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="array_get", value="_FUNC_(array<text>, N, MAX) - returns an array<array<text>> with all the subsequences of length <= N from the array")
public class UDFArraySubSequences
extends UDF {
    private Text out = new Text();

    public static <T> List<List<T>> mysubn(int n, int max, List<T> li) {
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = li.size();
        if (n == 0) {
            ret.add(new ArrayList());
            return ret;
        }
        if (li.isEmpty()) {
            return ret;
        }
        if (size < n) {
            return ret;
        }
        if (size == n) {
            ret.add(li);
            return ret;
        }
        ArrayList<ListIterator<T>> iters = new ArrayList<ListIterator<T>>(n);
        ArrayList currElems = new ArrayList(n);
        int[] counters = new int[n];
        int[] endings = new int[n];
        for (int i = 0; i < n; ++i) {
            iters.add(li.listIterator(i));
            currElems.add(((ListIterator)iters.get(i)).next());
            counters[i] = i;
            endings[i] = size - n + i;
        }
        while (counters[0] <= endings[0] && ret.size() < max) {
            int c;
            ArrayList sub = new ArrayList();
            for (int i = 0; i < n; ++i) {
                sub.add(currElems.get(i));
            }
            ret.add(sub);
            for (c = n - 1; c > 0 && counters[c] >= endings[c]; --c) {
            }
            int n2 = c;
            counters[n2] = counters[n2] + 1;
            if (((ListIterator)iters.get(c)).hasNext()) {
                currElems.set(c, ((ListIterator)iters.get(c)).next());
            }
            ++c;
            while (c < n) {
                counters[c] = counters[c - 1] + 1;
                iters.set(c, li.listIterator(counters[c]));
                if (((ListIterator)iters.get(c)).hasNext()) {
                    currElems.set(c, ((ListIterator)iters.get(c)).next());
                }
                ++c;
            }
        }
        return ret;
    }

    public List<List<String>> evaluate(List<String> a, int n, int max) {
        return UDFArraySubSequences.mysubn(n, max, a);
    }
}

