/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.CredentialsProvider;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksConfig;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksException;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.HeaderFactory;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.ClientCredentials;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.Token;
import com.dataiku.dss.shadelibdatabricks.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;

public class OAuthM2MServicePrincipalCredentialsProvider
implements CredentialsProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "oauth-m2m";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        if (config.getClientId() == null || config.getClientSecret() == null || config.getHost() == null) {
            return null;
        }
        try {
            OpenIDConnectEndpoints jsonResponse = config.getOidcEndpoints();
            ClientCredentials tokenSource = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getClientId()).withClientSecret(config.getClientSecret()).withTokenUrl(jsonResponse.getTokenEndpoint()).withScopes(Collections.singletonList("all-apis")).withAuthParameterPosition(AuthParameterPosition.HEADER).build();
            return () -> {
                Token token = tokenSource.getToken();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
                return headers;
            };
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to fetch OIDC endpoint: " + e.getMessage(), e);
        }
    }
}

