/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnitsService;
import javax.measure.spi.UnitFormatService;
import tech.units.indriya.quantity.DefaultQuantityFactory;

public abstract class AbstractServiceProvider
extends ServiceProvider
implements Comparable<ServiceProvider> {
    private final Map<Class, List<Object>> servicesLoaded = new ConcurrentHashMap<Class, List<Object>>();
    private static final Comparator<Object> SERVICE_COMPARATOR = AbstractServiceProvider::compareServices;
    private final Map<Class, QuantityFactory> QUANTITY_FACTORIES = new ConcurrentHashMap<Class, QuantityFactory>();

    protected <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    protected <T> T getService(Class<T> serviceType) {
        List<T> services = this.getServices(serviceType);
        if (services.isEmpty()) {
            return null;
        }
        return services.get(0);
    }

    private static int compareServices(Object o1, Object o2) {
        boolean prio1 = false;
        boolean prio2 = false;
        if (prio1 < prio2) {
            return 1;
        }
        if (prio2 < prio1) {
            return -1;
        }
        return o2.getClass().getSimpleName().compareTo(o1.getClass().getSimpleName());
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            Collections.sort(services, SERVICE_COMPARATOR);
            ArrayList<T> previousServices = this.servicesLoaded.putIfAbsent(serviceType, services);
            return Collections.unmodifiableList(previousServices != null ? previousServices : services);
        }
        catch (Exception e) {
            Logger.getLogger(AbstractServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            Collections.sort(services, SERVICE_COMPARATOR);
            return services;
        }
    }

    @Override
    public int compareTo(ServiceProvider o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public SystemOfUnitsService getSystemOfUnitsService() {
        return this.getService(SystemOfUnitsService.class);
    }

    public UnitFormatService getUnitFormatService() {
        return this.getService(UnitFormatService.class);
    }

    public FormatService getFormatService() {
        return this.getService(FormatService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> quantity) {
        if (quantity == null) {
            throw new NullPointerException();
        }
        if (!this.QUANTITY_FACTORIES.containsKey(quantity)) {
            Map<Class, QuantityFactory> map = this.QUANTITY_FACTORIES;
            synchronized (map) {
                this.QUANTITY_FACTORIES.put(quantity, DefaultQuantityFactory.getInstance(quantity));
            }
        }
        return this.QUANTITY_FACTORIES.get(quantity);
    }

    public abstract String toString();
}

