/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.input.formats.JSONFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileInputFormat;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileOutputFormat;
import com.dataiku.dip.spark.CsvWriter$;
import com.dataiku.dip.spark.DeltaWriter$;
import com.dataiku.dip.spark.JsonWriter$;
import com.dataiku.dip.spark.ORCWriter$;
import com.dataiku.dip.spark.ParquetWriter$;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.compat.package$;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class HadoopFormatsSupport$ {
    public static HadoopFormatsSupport$ MODULE$;
    private final Logger logger;

    static {
        new HadoopFormatsSupport$();
    }

    public Tuple2<Object, String> getCsvReadUsability(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, String filterExpression, List<String> partitions) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isCsvDataset(dataset));
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)dataset.getFormatParamsAs(CSVFormatConfig.class);
        if (csvFormatConfig.skipRowsBeforeHeader != 0 || csvFormatConfig.skipRowsAfterHeader != 0) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Skipping rows before or after the header is not supported");
        }
        CSVFormatConfig.CSVComplexTypeSerialization cSVComplexTypeSerialization = csvFormatConfig.arrayMapFormat;
        CSVFormatConfig.CSVComplexTypeSerialization cSVComplexTypeSerialization2 = CSVFormatConfig.CSVComplexTypeSerialization.json;
        if (cSVComplexTypeSerialization == null ? cSVComplexTypeSerialization2 != null : !cSVComplexTypeSerialization.equals(cSVComplexTypeSerialization2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only json formatting of complex types is supported");
        }
        CSVFormatConfig.ReadAdditionalColumnsBehavior readAdditionalColumnsBehavior = csvFormatConfig.readAdditionalColumnsBehavior;
        CSVFormatConfig.ReadAdditionalColumnsBehavior readAdditionalColumnsBehavior2 = CSVFormatConfig.ReadAdditionalColumnsBehavior.DISCARD_SILENT;
        if (readAdditionalColumnsBehavior == null ? readAdditionalColumnsBehavior2 != null : !readAdditionalColumnsBehavior.equals(readAdditionalColumnsBehavior2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only silent discard of additional columns is supported");
        }
        CSVFormatConfig.ReadMissingColumnsBehavior readMissingColumnsBehavior = csvFormatConfig.readMissingColumnsBehavior;
        CSVFormatConfig.ReadMissingColumnsBehavior readMissingColumnsBehavior2 = CSVFormatConfig.ReadMissingColumnsBehavior.DISCARD_SILENT;
        if (readMissingColumnsBehavior == null ? readMissingColumnsBehavior2 != null : !readMissingColumnsBehavior.equals(readMissingColumnsBehavior2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only silent discard of missing columns is supported");
        }
        StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior = csvFormatConfig.readDataTypeMismatchBehavior;
        StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior2 = StorageTypeVerifier.DataTypeMismatchBehavior.ERROR;
        if (dataTypeMismatchBehavior == null ? dataTypeMismatchBehavior2 != null : !dataTypeMismatchBehavior.equals(dataTypeMismatchBehavior2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only error on bad data is supported");
        }
        if (filterExpression != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"filter expression is active");
        }
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        if (this.isCsvInputDisabled(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Csv fast-path is disabled in configuration");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getCsvWriteUsability(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        if (this.isCsvOutputDisabled(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Csv fast-path output is disabled in configuration");
        }
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)dataset.getFormatParamsAs(CSVFormatConfig.class);
        if (csvFormatConfig.skipRowsBeforeHeader != 0 || csvFormatConfig.skipRowsAfterHeader != 0) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Skipping rows before or after the header is not supported");
        }
        CSVFormatConfig.CSVComplexTypeSerialization cSVComplexTypeSerialization = csvFormatConfig.arrayMapFormat;
        CSVFormatConfig.CSVComplexTypeSerialization cSVComplexTypeSerialization2 = CSVFormatConfig.CSVComplexTypeSerialization.json;
        if (cSVComplexTypeSerialization == null ? cSVComplexTypeSerialization2 != null : !cSVComplexTypeSerialization.equals(cSVComplexTypeSerialization2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only json formatting of complex types is supported");
        }
        StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior = csvFormatConfig.writeDataTypeMismatchBehavior;
        StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior2 = StorageTypeVerifier.DataTypeMismatchBehavior.ERROR;
        if (dataTypeMismatchBehavior == null ? dataTypeMismatchBehavior2 != null : !dataTypeMismatchBehavior.equals(dataTypeMismatchBehavior2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Only error on bad data is supported");
        }
        if (!CsvWriter$.MODULE$.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(71).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Csv writer: incompatible schemas").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public boolean isCsvInputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.csv.reader";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "true"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Csv reader disabled");
        }
        return value;
    }

    public boolean isCsvOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.csv.writer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "true"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Csv writer disabled");
        }
        return value;
    }

    public Tuple2<Object, String> getJsonReadUsability(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, String filterExpression, List<String> partitions, boolean canUnnest) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isJsonDataset(dataset));
        JSONFormatConfig jsonFormatConfig = (JSONFormatConfig)dataset.getFormatParamsAs(JSONFormatConfig.class);
        if (jsonFormatConfig.extractFromSingleElement) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Extracting from a single element is not supported");
        }
        if (!canUnnest && jsonFormatConfig.maxExpansionDepth != 1) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Cannot unnest fields at read-time");
        }
        JSONFormatExtractor.NestedArraysHandling nestedArraysHandling = jsonFormatConfig.nestedArraysHandling;
        JSONFormatExtractor.NestedArraysHandling nestedArraysHandling2 = JSONFormatExtractor.NestedArraysHandling.PRESERVE;
        if (nestedArraysHandling == null ? nestedArraysHandling2 != null : !nestedArraysHandling.equals(nestedArraysHandling2)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Arrays can only be preserved as is");
        }
        if (filterExpression != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"filter expression is active");
        }
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        if (this.isJsonInputDisabled(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Json fast-path is disabled in configuration");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getJsonWriteUsability(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        if (this.isJsonOutputDisabled(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Json fast-path output is disabled in configuration");
        }
        JSONFormatConfig jsonFormatConfig = (JSONFormatConfig)dataset.getFormatParamsAs(JSONFormatConfig.class);
        if (jsonFormatConfig.extractFromSingleElement) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Writing to a root element is not supported");
        }
        if (!JsonWriter$.MODULE$.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(72).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Json writer: incompatible schemas").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public boolean isJsonInputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.json.reader";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Json reader disabled");
        }
        return value;
    }

    public boolean isJsonInputMultiline(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.native.json.reader.multiline";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Read json as single-record multiline");
        }
        return value;
    }

    public boolean isJsonOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.json.writer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Json writer disabled");
        }
        return value;
    }

    public Tuple2<Object, String> getParquetReadUsability(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, String filterExpression, List<String> partitions) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isParquetDataset(dataset));
        if (filterExpression != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"filter expression is active");
        }
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        if (this.isParquetInputDisabled(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Parquet fast-path is disabled in configuration");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getParquetWriteUsability(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        if (this.isParquetOutputDisabled(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Parquet fast-path output is disabled in configuration");
        }
        ParquetFormatConfig parquetFormatConfig = (ParquetFormatConfig)dataset.getFormatParamsAs(ParquetFormatConfig.class);
        ParquetFormatConfig.Flavor flavor = parquetFormatConfig.parquetFlavor;
        ParquetFormatConfig.Flavor flavor2 = ParquetFormatConfig.Flavor.HIVE;
        if (flavor == null ? flavor2 != null : !flavor.equals(flavor2)) {
            ParquetFormatConfig.Flavor flavor3 = parquetFormatConfig.parquetFlavor;
            ParquetFormatConfig.Flavor flavor4 = ParquetFormatConfig.Flavor.SPARK;
            if (flavor3 == null ? flavor4 != null : !flavor3.equals(flavor4)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(79).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Parquet writer: not Hive or Spark flavor").toString());
            }
        }
        if (parquetFormatConfig.parquetLowerCaseIdentifiers) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(76).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Parquet writer: lowercase identifiers").toString());
        }
        if (!ParquetWriter$.MODULE$.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(75).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Parquet writer: incompatible schemas").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public boolean isParquetInputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.parquet.reader";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Parquet reader disabled");
        }
        return value;
    }

    public boolean isParquetOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.parquet.writer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Parquet writer disabled");
        }
        return value;
    }

    public Tuple2<Object, String> getORCReadUsability(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, String filterExpression, List<String> partitions) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isORCDataset(dataset));
        if (!package$.MODULE$.isHiveContext(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"passed SQLContext is not Hive-aware");
        }
        if (filterExpression != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"filter expression is active");
        }
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        if (this.isORCInputDisabled(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"ORC fast-path is disabled in configuration");
        }
        if (!StdDataikuSparkContext$.MODULE$.arePathsOrcCompatible(sqlContext, dataset, partitions)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Requested partition paths are not compatible with ORC fast-path");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getORCWriteUsability(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isORCDataset(dataset));
        if (!package$.MODULE$.isHiveContext(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"passed SQLContext is not Hive-aware");
        }
        if (this.isORCOutputDisabled(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"ORC fast-path is disabled in configuration");
        }
        if (!ORCWriter$.MODULE$.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(71).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native ORC writer: incompatible schemas").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public boolean isORCInputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.orc.reader";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native ORC reader disabled");
        }
        return value;
    }

    public boolean isORCOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.orc.writer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native ORC writer disabled");
        }
        return value;
    }

    public boolean isDeltaOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.delta.writer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.logger().info((Object)"Native Delta writer disabled");
        }
        return value;
    }

    public Tuple2<Object, String> getDeltaReadUsability(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, String filterExpression, List<String> partitions) {
        if (!package$.MODULE$.isHiveContext(sqlContext)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"passed SQLContext is not Hive-aware");
        }
        if (filterExpression != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"filter expression is active");
        }
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isDeltaCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getDeltaWriteUsability(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        Predef$.MODULE$.assert(StdDataikuSparkContext$.MODULE$.isDeltaDataset(dataset));
        if (!package$.MODULE$.isHiveContext(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"passed SQLContext is not Hive-aware");
        }
        if (this.isDeltaOutputDisabled(df.sqlContext())) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Delta fast-path is disabled in configuration");
        }
        if (!DeltaWriter$.MODULE$.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(73).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native Delta writer: incompatible schemas").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> getUniversalFormatReadUsability(Dataset dataset, SamplingParam sampling) {
        boolean samplingCompatibility = StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling);
        if (!samplingCompatibility) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"requested sampling is not supported");
        }
        String string = dataset.getFormatType();
        String string2 = CSVFormatExtractor.META.getType();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            CSVFormatConfig csvConfig = (CSVFormatConfig)dataset.getFormatParams();
            if (csvConfig != null && csvConfig.skipRowsBeforeHeader == 0 && !csvConfig.parseHeaderRow && csvConfig.skipRowsAfterHeader == 0) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)": non-empty header in CSV is not supported");
        }
        if (UniversalFileInputFormat.getFormatAdapter((FormatParams)dataset.getFormatParams()) != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"file format not supported for input");
    }

    public Tuple2<Object, String> getUniversalFormatWriteUsability(Dataset dataset) {
        String string = dataset.getFormatType();
        String string2 = CSVFormatExtractor.META.getType();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            CSVFormatConfig csvConfig = (CSVFormatConfig)dataset.getFormatParams();
            if (csvConfig != null && csvConfig.skipRowsBeforeHeader == 0 && !csvConfig.parseHeaderRow && csvConfig.skipRowsAfterHeader == 0) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)": non-empty header in CSV is not supported");
        }
        if (UniversalFileOutputFormat.getFormatAdapter((FormatParams)dataset.getFormatParams()) != null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"file format not supported for output");
    }

    public boolean isIcebergInputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.iceberg.reader";
            value = ctx.sparkContext().getConf().getBoolean(key, false);
            if (!value) break block0;
            this.logger().info((Object)"Native Iceberg reader disabled");
        }
        return value;
    }

    public boolean isIcebergOutputDisabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.disable.native.iceberg.writer";
            value = ctx.sparkContext().getConf().getBoolean(key, false);
            if (!value) break block0;
            this.logger().info((Object)"Native Iceberg writer disabled");
        }
        return value;
    }

    private Logger logger() {
        return this.logger;
    }

    private HadoopFormatsSupport$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.formats");
    }
}

