/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.StorageBackendsSupport$;
import com.dataiku.dip.spark.package$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class IcebergWriter$
extends NativeFormatWriter {
    public static IcebergWriter$ MODULE$;
    private final Logger logger;

    static {
        new IcebergWriter$();
    }

    public void saveIcebergDataset(IcebergDatasetHandler datasetHandler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = datasetHandler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : Partition.newNP();
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.addPartitionValues(this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged()), dataset, dssPartition);
        StdDataikuSparkContext$.MODULE$.executeCommand("datasets/prepare-iceberg-table-for-write/", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)dataset.getProjectKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)dataset.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)partition), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeMode"), (Object)writeMode.toString())}))), apiTicket, ClassTag$.MODULE$.apply(InfoMessage.InfoMessages.class));
        this.logger().info((Object)"Prepare sqlcontext for iceberg write");
        Buffer extraConf = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(datasetHandler.getExtraConf()).asScala();
        Buffer extraHadoopConf = (Buffer)extraConf.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.name.startsWith("spark.hadoop.")));
        Buffer extraCatalogConf = (Buffer)extraConf.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)IcebergWriter$.$anonfun$saveIcebergDataset$2(p)));
        SQLConf sqlConf = SQLConf$.MODULE$.get();
        extraCatalogConf.foreach((Function1 & Serializable & scala.Serializable)p -> {
            sqlConf.setConfString(p.name, p.value);
            return BoxedUnit.UNIT;
        });
        Configuration hadoopConfiguration = dssDataframe.sqlContext().sparkContext().hadoopConfiguration();
        Configuration hadoopConfiguration2 = package$.MODULE$.getSparkHadoopUtilConf();
        extraHadoopConf.foreach((Function1 & Serializable & scala.Serializable)p -> {
            IcebergWriter$.$anonfun$saveIcebergDataset$4(hadoopConfiguration, hadoopConfiguration2, p);
            return BoxedUnit.UNIT;
        });
        StorageBackendsSupport$.MODULE$.preloadDriverForIcebergJDBC(datasetHandler);
        List qualifiedTable = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(datasetHandler.getResolvedTableChunks()).asScala()).toList();
        String quotedQualifiedTable = ((TraversableOnce)qualifiedTable.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(2).append("`").append((String)x).append("`").toString(), List$.MODULE$.canBuildFrom())).mkString(".");
        this.logger().info((Object)new StringBuilder(19).append("Save Iceberg table ").append(quotedQualifiedTable).toString());
        dssDataframe.writeTo(quotedQualifiedTable).append();
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            dssDataframe.elem = IcebergWriter$.MODULE$.adaptDataFrameColumn((org.apache.spark.sql.Dataset<Row>)((org.apache.spark.sql.Dataset)dssDataframe.elem), field, dssSchema, isManaged);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$saveIcebergDataset$2(AbstractSQLConnection.CustomDatabaseProperty p) {
        return !p.name.startsWith("spark.hadoop.");
    }

    public static final /* synthetic */ void $anonfun$saveIcebergDataset$4(Configuration hadoopConfiguration$1, Configuration hadoopConfiguration2$1, AbstractSQLConnection.CustomDatabaseProperty p) {
        String key = p.name.substring("spark.hadoop.".length());
        hadoopConfiguration$1.set(key, p.value);
        hadoopConfiguration2$1.set(key, p.value);
    }

    private IcebergWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.context");
    }
}

