/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.Beta;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec.Condition;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec.Operand;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec.PathOperand;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec.Precedence;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;
import java.util.List;

@Beta
public final class InCondition
extends Condition {
    private final PathOperand attribute;
    private final List<? extends Operand> operands;

    InCondition(PathOperand attribute, List<? extends Operand> operands) {
        this.attribute = attribute;
        this.operands = operands;
    }

    @Override
    String asSubstituted(SubstitutionContext context) {
        StringBuilder sb = new StringBuilder(this.attribute.asSubstituted(context)).append(" IN (");
        boolean first = true;
        for (Operand operand : this.operands) {
            if (first) {
                sb.append(operand.asSubstituted(context));
                first = false;
                continue;
            }
            sb.append(", ").append(operand.asSubstituted(context));
        }
        return sb.append(")").toString();
    }

    @Override
    boolean atomic() {
        return true;
    }

    @Override
    int precedence() {
        return Precedence.IN.value();
    }
}

