/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderDeviceOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessTrustProviderRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessTrustProviderRequest>, ModifyVerifiedAccessTrustProviderRequest> {
    @Override
    public Request<ModifyVerifiedAccessTrustProviderRequest> marshall(ModifyVerifiedAccessTrustProviderRequest modifyVerifiedAccessTrustProviderRequest) {
        ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
        if (modifyVerifiedAccessTrustProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVerifiedAccessTrustProviderRequest> request = new DefaultRequest<ModifyVerifiedAccessTrustProviderRequest>(modifyVerifiedAccessTrustProviderRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessTrustProvider");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId() != null) {
            request.addParameter("VerifiedAccessTrustProviderId", StringUtils.fromString(modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId()));
        }
        if ((oidcOptions = modifyVerifiedAccessTrustProviderRequest.getOidcOptions()) != null) {
            if (oidcOptions.getIssuer() != null) {
                request.addParameter("OidcOptions.Issuer", StringUtils.fromString(oidcOptions.getIssuer()));
            }
            if (oidcOptions.getAuthorizationEndpoint() != null) {
                request.addParameter("OidcOptions.AuthorizationEndpoint", StringUtils.fromString(oidcOptions.getAuthorizationEndpoint()));
            }
            if (oidcOptions.getTokenEndpoint() != null) {
                request.addParameter("OidcOptions.TokenEndpoint", StringUtils.fromString(oidcOptions.getTokenEndpoint()));
            }
            if (oidcOptions.getUserInfoEndpoint() != null) {
                request.addParameter("OidcOptions.UserInfoEndpoint", StringUtils.fromString(oidcOptions.getUserInfoEndpoint()));
            }
            if (oidcOptions.getClientId() != null) {
                request.addParameter("OidcOptions.ClientId", StringUtils.fromString(oidcOptions.getClientId()));
            }
            if (oidcOptions.getClientSecret() != null) {
                request.addParameter("OidcOptions.ClientSecret", StringUtils.fromString(oidcOptions.getClientSecret()));
            }
            if (oidcOptions.getScope() != null) {
                request.addParameter("OidcOptions.Scope", StringUtils.fromString(oidcOptions.getScope()));
            }
        }
        if ((deviceOptions = modifyVerifiedAccessTrustProviderRequest.getDeviceOptions()) != null && deviceOptions.getPublicSigningKeyUrl() != null) {
            request.addParameter("DeviceOptions.PublicSigningKeyUrl", StringUtils.fromString(deviceOptions.getPublicSigningKeyUrl()));
        }
        if (modifyVerifiedAccessTrustProviderRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(modifyVerifiedAccessTrustProviderRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessTrustProviderRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = modifyVerifiedAccessTrustProviderRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

