/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonWebServiceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.Response;
import com.dataiku.dss.legacy.aws.com.amazonaws.handlers.RequestHandler2;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class TimestampFormatRequestHandler
extends RequestHandler2 {
    private static final Pattern PATTERN = Pattern.compile("\\.\\d\\d\\dZ");
    private static final String START_TIME = "StartTime";
    private static final String VALID_FROM = "SpotFleetRequestConfig.ValidFrom";
    private static final String VALID_UNTIL = "SpotFleetRequestConfig.ValidUntil";

    @Override
    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest original = request.getOriginalRequest();
        if (original instanceof DescribeSpotFleetRequestHistoryRequest) {
            Map<String, List<String>> params = request.getParameters();
            List<String> startTime = params.get(START_TIME);
            if (startTime != null && !startTime.isEmpty()) {
                params.put(START_TIME, Arrays.asList(this.sanitize(startTime.get(0))));
            }
        } else if (original instanceof RequestSpotFleetRequest) {
            Map<String, List<String>> params = request.getParameters();
            List<String> validFrom = params.get(VALID_FROM);
            List<String> validUntil = params.get(VALID_UNTIL);
            if (validFrom != null && !validFrom.isEmpty()) {
                params.put(VALID_FROM, Arrays.asList(this.sanitize(validFrom.get(0))));
            }
            if (validUntil != null && !validUntil.isEmpty()) {
                params.put(VALID_UNTIL, Arrays.asList(this.sanitize(validUntil.get(0))));
            }
        }
    }

    private String sanitize(String input) {
        return PATTERN.matcher(input).replaceFirst("Z");
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

