/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.HostedZoneConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.VPC;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringInputStream;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateHostedZoneRequestMarshaller
implements Marshaller<Request<CreateHostedZoneRequest>, CreateHostedZoneRequest> {
    @Override
    public Request<CreateHostedZoneRequest> marshall(CreateHostedZoneRequest createHostedZoneRequest) {
        if (createHostedZoneRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHostedZoneRequest> request = new DefaultRequest<CreateHostedZoneRequest>(createHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHostedZoneRequest");
            if (createHostedZoneRequest != null) {
                HostedZoneConfig hostedZoneConfig;
                VPC vPC;
                if (createHostedZoneRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(createHostedZoneRequest.getName()).endElement();
                }
                if ((vPC = createHostedZoneRequest.getVPC()) != null) {
                    xmlWriter.startElement("VPC");
                    if (vPC.getVPCRegion() != null) {
                        xmlWriter.startElement("VPCRegion").value(vPC.getVPCRegion()).endElement();
                    }
                    if (vPC.getVPCId() != null) {
                        xmlWriter.startElement("VPCId").value(vPC.getVPCId()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createHostedZoneRequest.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(createHostedZoneRequest.getCallerReference()).endElement();
                }
                if ((hostedZoneConfig = createHostedZoneRequest.getHostedZoneConfig()) != null) {
                    xmlWriter.startElement("HostedZoneConfig");
                    if (hostedZoneConfig.getComment() != null) {
                        xmlWriter.startElement("Comment").value(hostedZoneConfig.getComment()).endElement();
                    }
                    if (hostedZoneConfig.getPrivateZone() != null) {
                        xmlWriter.startElement("PrivateZone").value(hostedZoneConfig.getPrivateZone()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createHostedZoneRequest.getDelegationSetId() != null) {
                    xmlWriter.startElement("DelegationSetId").value(createHostedZoneRequest.getDelegationSetId()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

