/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.spnego;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import net.sourceforge.spnego.UserAccessControl;
import net.sourceforge.spnego.UserInfo;

public class LdapAccessControl
implements UserAccessControl {
    private static final Logger LOGGER = Logger.getLogger(LdapAccessControl.class.getName());
    private static final String POLICY_FILE = "spnego.authz.policy.file";
    private static final String SERVER_REALM = "spnego.server.realm";
    private static final String LDAP_FACTORY = "spnego.authz.ldap.factory";
    private static final String LDAP_AUTHN = "spnego.authz.ldap.authn";
    private static final String LDAP_POOL = "spnego.authz.ldap.pool";
    private static final String LDAP_DEECE = "spnego.authz.ldap.deecee";
    private static final String LDAP_URL = "spnego.authz.ldap.url";
    private static final String LDAP_USERNAME = "spnego.authz.ldap.username";
    private static final String KRB5_USERNAME = "spnego.preauth.username";
    private static final String LDAP_PASSWORD = "spnego.authz.ldap.password";
    private static final String KRB5_PASSWORD = "spnego.preauth.password";
    private static final String TTL = "spnego.authz.ttl";
    private static final String UNIQUE = "spnego.authz.unique";
    private static final String PREFIX_FILTER = "spnego.authz.ldap.filter.";
    private static final String PREFIX_NAME = "spnego.authz.resource.name.";
    private static final String PREFIX_TYPE = "spnego.authz.resource.type.";
    private static final String PREFIX_ACCESS = "spnego.authz.resource.access.";
    private static final String HAS = "has";
    private static final String ANY = "any";
    private static final String USER_INFO = "spnego.authz.user.info";
    private static final String USER_INFO_FILTER = "spnego.authz.ldap.user.filter";
    private static final long DEFAULT_TTL = 1200000L;
    private static final int MAX_NUM_FILTERS = 200;
    private final transient ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final transient Lock readLock = this.readWriteLock.readLock();
    private final transient Lock writeLock = this.readWriteLock.writeLock();
    private final transient Map<String, Long> matchedList = new HashMap<String, Long>();
    private final transient Map<String, Long> unMatchedList = new HashMap<String, Long>();
    private final transient Map<String, UserInfo> userInfoList = new HashMap<String, UserInfo>();
    private transient Hashtable<String, String> environment;
    private transient SearchControls srchCntrls;
    private transient String deecee = "";
    private transient Set<String> policy = new HashSet<String>();
    private transient long expiration = 1200000L;
    private transient boolean uniqueOnly = true;
    private transient Map<String, Map<String, String[]>> resources = new HashMap<String, Map<String, String[]>>();
    private transient List<String> userInfoLabels = new ArrayList<String>();
    private transient String userInfoFilter;

    @Override
    public void destroy() {
        LOGGER.info("destroy()...");
        this.writeLock.lock();
        try {
            this.matchedList.clear();
            this.unMatchedList.clear();
            this.environment.clear();
            this.environment = null;
            this.srchCntrls = null;
            this.deecee = "";
            this.policy.clear();
            this.expiration = 1200000L;
            this.resources.clear();
            this.userInfoLabels.clear();
            this.userInfoFilter = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean anyRole(String username, String ... attributes) {
        for (String role : attributes) {
            if (!this.hasRole(username, role)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRole(String username, String attribute) {
        String key = username + "_attr_" + attribute;
        long now = System.currentTimeMillis();
        try {
            if (!this.matchedExpired(key, now)) {
                return true;
            }
            if (!this.unMatchedExpired(key, now)) {
                return false;
            }
            LOGGER.fine("username: " + username + "; role: " + attribute);
            this.writeLock.lock();
            try {
                this.matchedList.remove(key);
                this.unMatchedList.remove(key);
                int count = 0;
                InitialLdapContext context = new InitialLdapContext(this.environment, null);
                for (String filter : this.policy) {
                    NamingEnumeration<SearchResult> results = context.search(this.deecee, String.format(filter, username, attribute), this.srchCntrls);
                    boolean found = results.hasMoreElements();
                    results.close();
                    if (found) {
                        ++count;
                        this.matchedList.put(key, System.currentTimeMillis());
                        if (!this.uniqueOnly) break;
                    }
                    if (count <= 1 || !this.uniqueOnly) continue;
                    this.matchedList.remove(key);
                    throw new IllegalArgumentException("Uniqueness property violated. Found duplicate role/attribute:" + attribute + ". This MAY be caused by an improper policy definition; filter=" + filter + "; policy=" + this.policy);
                }
                context.close();
                if (0 == count) {
                    this.unMatchedList.put(key, System.currentTimeMillis());
                } else {
                    this.cacheUserInfo(username);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (NamingException lex) {
            LOGGER.severe(lex.getMessage());
            throw new RuntimeException(lex);
        }
        return this.hasRole(username, attribute);
    }

    @Override
    public boolean hasRole(String username, String attributeX, String ... attributeYs) {
        if (null == attributeYs || 0 == attributeYs.length) {
            String errorMsg = "Must provide at least two parameters";
            LOGGER.severe("Must provide at least two parameters");
            throw new IllegalArgumentException("Must provide at least two parameters");
        }
        boolean found = false;
        boolean featX = this.hasRole(username, attributeX);
        for (String featY : attributeYs) {
            boolean bl = found = featX && this.hasRole(username, featY);
            if (found) break;
        }
        return found;
    }

    @Override
    public boolean anyAccess(String username, String ... resources) {
        for (String resource : resources) {
            if (!this.hasAccess(username, resource)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAccess(String username, String resource) {
        long now;
        String key = username + "_res_" + resource;
        if (!this.matchedExpired(key, now = System.currentTimeMillis())) {
            return true;
        }
        if (!this.unMatchedExpired(key, now)) {
            return false;
        }
        LOGGER.fine("username: " + username + "; resource: " + resource);
        boolean matched = false;
        boolean containsHas = false;
        boolean containsAny = false;
        String[] attributes = new String[]{};
        this.readLock.lock();
        try {
            if (!this.resources.containsKey(resource)) {
                throw new IllegalArgumentException("Policy not found for user-defined Resource labeled: " + resource);
            }
            containsHas = this.resources.get(resource).containsKey(HAS);
            containsAny = this.resources.get(resource).containsKey(ANY);
            if (containsHas) {
                attributes = this.resources.get(resource).get(HAS);
            } else if (containsAny) {
                attributes = this.resources.get(resource).get(ANY);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (containsHas) {
            if (attributes.length > 1) {
                matched = this.hasRole(username, attributes[0], Arrays.copyOfRange(attributes, 1, attributes.length));
            } else {
                if (attributes.length != 1) throw new IllegalStateException("No attribute(s) defined for resource: " + resource);
                matched = this.hasRole(username, attributes[0]);
            }
        } else {
            if (!containsAny) throw new UnsupportedOperationException("Allowed resource.type(s): [any|has]");
            matched = this.anyRole(username, attributes);
        }
        this.writeLock.lock();
        try {
            if (matched) {
                this.matchedList.put(key, now);
                return matched;
            } else {
                this.unMatchedList.put(key, now);
            }
            return matched;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasAccess(String username, String resourceX, String ... resourceYs) {
        if (null == resourceYs || 0 == resourceYs.length) {
            String errorMsg = "Must provide at least two parameters";
            LOGGER.severe("Must provide at least two parameters");
            throw new IllegalArgumentException("Must provide at least two parameters");
        }
        boolean found = false;
        boolean resX = this.hasAccess(username, resourceX);
        for (String resY : resourceYs) {
            boolean bl = found = resX && this.hasAccess(username, resY);
            if (found) break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(String username) {
        long now = System.currentTimeMillis();
        boolean expired = this.matchedExpired(username, now);
        this.readLock.lock();
        try {
            if (!expired) {
                UserInfo userInfo = this.userInfoList.get(username);
                return userInfo;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            UserInfo userInfo = this.cacheUserInfo(username);
            return userInfo;
        }
        catch (NamingException nex) {
            String errorMessage = "Could not get user info for: " + username;
            LOGGER.warning(errorMessage);
            throw new IllegalStateException(errorMessage, nex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Properties props) {
        String errorMessage;
        LOGGER.info("init()...");
        this.readLock.lock();
        try {
            if (this.environment != null) {
                throw new IllegalStateException("LdapAccessControl already initialized");
            }
        }
        finally {
            this.readLock.unlock();
        }
        String policyFile = props.getProperty(POLICY_FILE, "");
        Properties policies = new Properties();
        if (!policyFile.isBlank()) {
            try {
                LOGGER.info("policy file: " + policyFile);
                try (FileInputStream fis = new FileInputStream(policyFile);){
                    policies.load(fis);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Policy File NOT Found: " + policyFile, e);
            }
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", policies.getProperty(LDAP_FACTORY, props.getProperty(LDAP_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory")));
        env.put("java.naming.security.authentication", policies.getProperty(LDAP_AUTHN, props.getProperty(LDAP_AUTHN, "Simple")));
        env.put("com.sun.jndi.ldap.connect.pool", policies.getProperty(LDAP_POOL, props.getProperty(LDAP_POOL, "true")));
        Object dc = policies.getProperty(LDAP_DEECE, props.getProperty(LDAP_DEECE, ""));
        if (((String)dc).isBlank()) {
            String tmp = props.getProperty(SERVER_REALM, policies.getProperty(SERVER_REALM, ""));
            if (tmp.trim().isBlank()) {
                throw new IllegalArgumentException("MUST provide the serve's deecee.  specify a value for the spnego.authz.ldap.deecee property.");
            }
            dc = "DC=" + tmp.replaceAll("\\.", ",DC=");
        }
        LOGGER.info((String)dc);
        if (policies.getProperty(LDAP_URL, props.getProperty(LDAP_URL, "")).isBlank()) {
            errorMessage = "Must provide a value for the spnego.authz.ldap.url parameter";
            LOGGER.severe("Must provide a value for the spnego.authz.ldap.url parameter");
            throw new IllegalStateException("Must provide a value for the spnego.authz.ldap.url parameter");
        }
        env.put("java.naming.provider.url", policies.getProperty(LDAP_URL, props.getProperty(LDAP_URL)));
        LOGGER.info("ldap provider url: " + (String)env.get("java.naming.provider.url"));
        if (policies.getProperty(LDAP_USERNAME, props.getProperty(LDAP_USERNAME, props.getProperty(KRB5_USERNAME, policies.getProperty(KRB5_USERNAME, "")))).isBlank()) {
            errorMessage = "Must provide a username to use for connecting to the LDAP server";
            LOGGER.severe("Must provide a username to use for connecting to the LDAP server");
            throw new IllegalArgumentException("Must provide a username to use for connecting to the LDAP server");
        }
        if (policies.getProperty(LDAP_PASSWORD, props.getProperty(LDAP_PASSWORD, props.getProperty(KRB5_PASSWORD, policies.getProperty(KRB5_PASSWORD, "")))).isBlank()) {
            errorMessage = "Must provide a password to use for connecting to the LDAP server";
            LOGGER.severe("Must provide a password to use for connecting to the LDAP server");
            throw new IllegalArgumentException("Must provide a password to use for connecting to the LDAP server");
        }
        env.put("java.naming.security.principal", policies.getProperty(LDAP_USERNAME, props.getProperty(LDAP_USERNAME, props.getProperty(KRB5_USERNAME, policies.getProperty(KRB5_USERNAME)))));
        env.put("java.naming.security.credentials", policies.getProperty(LDAP_PASSWORD, props.getProperty(LDAP_PASSWORD, props.getProperty(KRB5_PASSWORD, policies.getProperty(KRB5_PASSWORD)))));
        LOGGER.info("ldap security principal: " + (String)env.get("java.naming.security.principal"));
        long ttl = 1200000L;
        ttl = Long.parseLong(policies.getProperty(TTL, props.getProperty(TTL, "-1")));
        LOGGER.info("spnego.authz.ttl: " + ttl);
        this.uniqueOnly = Boolean.parseBoolean(policies.getProperty(UNIQUE, props.getProperty(UNIQUE, "true")));
        LOGGER.info("uniqueness property enabled: " + this.uniqueOnly);
        this.writeLock.lock();
        try {
            this.deecee = dc;
            this.loadPolicies(policies, props);
            this.loadResourceNames(policies, props);
            this.expiration = ttl < 1L ? 1200000L : ttl * 60L * 1000L;
            LOGGER.info("cache expiration in millis: " + this.expiration);
            this.srchCntrls = new SearchControls();
            this.srchCntrls.setSearchScope(2);
            this.environment = env;
            String[] labels = policies.getProperty(USER_INFO, props.getProperty(USER_INFO, "")).split(",");
            LOGGER.info("UserInfo label count: " + labels.length);
            for (String label : labels) {
                LOGGER.info(label);
                this.userInfoLabels.add(label.trim());
            }
            this.userInfoFilter = policies.getProperty(USER_INFO_FILTER, props.getProperty(USER_INFO_FILTER, ""));
            LOGGER.info("UserInfo filter: " + this.userInfoFilter);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchedExpired(String key, long now) {
        boolean matched = this.matchedList.containsKey(key);
        boolean matchExpired = true;
        this.readLock.lock();
        try {
            if (matched) {
                matchExpired = now - this.matchedList.get(key) > this.expiration;
            }
            boolean bl = !matched || matchExpired;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unMatchedExpired(String key, long now) {
        boolean unMatched = this.unMatchedList.containsKey(key);
        boolean unMatchedExpired = true;
        this.readLock.lock();
        try {
            if (unMatched) {
                unMatchedExpired = now - this.unMatchedList.get(key) > this.expiration;
            }
            boolean bl = !unMatched || unMatchedExpired;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void loadPolicies(Properties props, Properties policies) {
        for (int i = 0; i <= 200; ++i) {
            int idx = i + 1;
            String filter = policies.getProperty(PREFIX_FILTER + idx, props.getProperty(PREFIX_FILTER + idx, "")).trim();
            if (200 == i) {
                String errorMessage = "Over the max number of filters allowed: " + i;
                LOGGER.severe(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            if (filter.isBlank()) break;
            this.policy.add(filter);
        }
        if (0 == this.policy.size()) {
            String errorMessage = "Must specify at least one spnego.authz.ldap.filter.1";
            LOGGER.severe("Must specify at least one spnego.authz.ldap.filter.1");
            throw new IllegalStateException("Must specify at least one spnego.authz.ldap.filter.1");
        }
    }

    private void loadResourceNames(Properties props, Properties policies) {
        this.resources = new HashMap<String, Map<String, String[]>>();
        for (int i = 0; i <= 200; ++i) {
            int idx = i + 1;
            HashMap<String, String[]> access = new HashMap<String, String[]>();
            String resname = policies.getProperty(PREFIX_NAME + idx, props.getProperty(PREFIX_NAME + idx, "")).trim();
            String restype = policies.getProperty(PREFIX_TYPE + idx, props.getProperty(PREFIX_TYPE + idx, "").toLowerCase().trim());
            String[] resaccess = policies.getProperty(PREFIX_ACCESS + idx, props.getProperty(PREFIX_ACCESS + idx, "")).trim().split(",");
            for (int j = 0; j < resaccess.length; ++j) {
                resaccess[j] = resaccess[j].trim();
            }
            access.put(restype, resaccess);
            if (200 == i) {
                String errorMessage = "Over the max number of resources allowed: " + i;
                LOGGER.severe(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            if (resname.isBlank()) break;
            this.resources.put(resname, access);
        }
    }

    private UserInfo cacheUserInfo(String username) throws NamingException {
        if (null == this.userInfoFilter || this.userInfoFilter.isBlank() || this.userInfoLabels.size() == 0) {
            LOGGER.info("spnego.authz.ldap.user.filter was empty OR no value(s) specified for the spnego.authz.user.info property");
            return null;
        }
        InitialLdapContext context = new InitialLdapContext(this.environment, null);
        NamingEnumeration<SearchResult> results = context.search(this.deecee, String.format(this.userInfoFilter, username), this.srchCntrls);
        boolean found = false;
        final HashMap labelInfo = new HashMap();
        while (results.hasMoreElements()) {
            found = true;
            SearchResult result = (SearchResult)results.nextElement();
            Attributes attributes = result.getAttributes();
            NamingEnumeration<? extends Attribute> iter = attributes.getAll();
            while (iter.hasMore()) {
                Attribute attribute = iter.next();
                String label = attribute.getID();
                ArrayList<String> info = new ArrayList<String>();
                if (!this.userInfoLabels.contains(label)) continue;
                labelInfo.put(label, info);
                NamingEnumeration<?> enmr = attribute.getAll();
                while (enmr.hasMore()) {
                    info.add(enmr.next().toString());
                }
            }
        }
        results.close();
        context.close();
        if (!found) {
            throw new IllegalArgumentException("UserInfo not found. . This MAY be caused by an incorrect spnego.authz.ldap.user.filter definition; filter=" + this.userInfoFilter + "; policy=" + this.policy);
        }
        UserInfo userInfoObject = new UserInfo(){
            private final Map<String, List<String>> info;
            private final String labels;
            {
                this.info = labelInfo;
                this.labels = LdapAccessControl.this.userInfoLabels.toString();
            }

            @Override
            public List<String> getInfo(String label) {
                if (!this.hasInfo(label)) {
                    throw new NullPointerException("UserInfo label not found or not in user store: " + label + " - labels specified in property file: " + this.labels);
                }
                return new ArrayList<String>((Collection)this.info.get(label));
            }

            @Override
            public List<String> getLabels() {
                return new ArrayList<String>(this.info.keySet());
            }

            @Override
            public boolean hasInfo(String label) {
                return this.info.containsKey(label);
            }
        };
        this.userInfoList.put(username, userInfoObject);
        return userInfoObject;
    }
}

