/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceEndpointMonitoring;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.deployer.common.infra.DeploymentInfrasDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIDeployerControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/api-deployer"})
public class PublicAPIAPIDeployerController
extends PublicAPIDeployerControllerBase {
    @Autowired
    private APIServiceDeploymentsService deploymentsService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private ApiNodeInfrasService infrasService;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    private static final String DEPLOYMENT_TYPE = "API";
    private static final String PUBLISHED_ITEM_ID = "Service";
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.lambda");

    APIServiceDeploymentsService getDeploymentsService() {
        return this.deploymentsService;
    }

    PublishedAPIServicesService getPublishedItemsService() {
        return this.publishedAPIServicesService;
    }

    ApiNodeInfrasService getInfrasService() {
        return this.infrasService;
    }

    DeploymentInfrasDAO<AbstractAPIDeploymentInfra> getInfrasDAO() {
        return this.apiNodeInfrasDAO;
    }

    @Override
    protected boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures) {
        return licenseFeatures.apiNodeAllowed;
    }

    public PublicAPIAPIDeployerController() {
        super(DEPLOYMENT_TYPE, PUBLISHED_ITEM_ID);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployments-list"})
    @RequestMapping(value={"/deployments"}, method={RequestMethod.GET})
    public void listDeployments(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeployments(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}"}, method={RequestMethod.GET})
    public void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        super.getDeploymentLightStatus(req, resp, deploymentId);
    }

    @AuditInline
    @RequestMapping(value={"/deployments"}, method={RequestMethod.POST})
    public void createDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean ignoreWarnings) throws Exception {
        AbstractDeployment depl;
        GeneralSettingsDAO.GeneralSettings generalSettings;
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx authCtx;
        DeploymentCreationSettings creationSettings = (DeploymentCreationSettings)this.getRequestBodyAs(req, DeploymentCreationSettings.class);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.getDeploymentsService().checkDeployPermissions(creationSettings.infraId, creationSettings.publishedServiceId, authCtx);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)creationSettings.infraId, (AuthCtx)authCtx).infraBasicInfo;
            generalSettings = ApplicationConfigurator.getGeneralSettings();
        }
        PublishedApiServicePackageInfo publishedPackageInfo = null;
        if (infraBasicInfo instanceof AbstractInfraBasicInfo.FullyManagedAPIDeploymentInfraBasicInfo) {
            publishedPackageInfo = this.getPublishedItemsService().getPublishedPackageOrNull_Check_NT(creationSettings.publishedServiceId, creationSettings.version, authCtx);
        }
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, creationSettings.publishedServiceId, Collections.singletonList(creationSettings.version), ignoreWarnings);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            String deplId = this.getDeploymentsService().create_Check(authCtx, creationSettings.deploymentId, creationSettings.publishedServiceId, creationSettings.infraId, creationSettings.version, creationSettings.endpointId, publishedPackageInfo, false, creationSettings.authorizationsToQueryThroughDeployer, generalSettings.dataikuCloudK8SApiDeploymentSettings);
            depl = this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deplId, authCtx);
            t.commitV("Created API deployment: %s", new Object[]{depl.id});
            this.auditTrailService.generic("apideployer-deployment-create").with("deploymentId", creationSettings.deploymentId).with("infraId", creationSettings.infraId).with("publishedServiceId", creationSettings.publishedServiceId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("apideployer-deployment-create", (Throwable)e).with("deploymentId", creationSettings.deploymentId).with("infraId", creationSettings.infraId).with("publishedServiceId", creationSettings.publishedServiceId).emit();
            throw e;
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)depl);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-delete", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}"}, method={RequestMethod.DELETE})
    public void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) boolean ignorePreDeleteErrors) throws Exception {
        super.deleteDeployment(req, resp, deploymentId, ignorePreDeleteErrors);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/settings"}, method={RequestMethod.GET})
    public void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        super.getDeploymentSettings(req, resp, deploymentId);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-save", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/settings"}, method={RequestMethod.PUT})
    public void saveDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false, defaultValue="false") boolean ignoreWarnings) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractAPIServiceDeployment d = (AbstractAPIServiceDeployment)this.getRequestBodyAs(req, AbstractAPIServiceDeployment.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.getDeploymentsService().checkDeployPermissions(deploymentId, authCtx);
            String infraId = ((AbstractAPIServiceDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check((String)deploymentId, (AuthCtx)authCtx)).infraId;
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)authCtx).infraBasicInfo;
        }
        if (d.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        ArrayList<String> versionIds = new ArrayList<String>();
        d.generationsMapping.validate();
        for (GenerationsMapping.MappingEntry generationsMapping : d.generationsMapping.getEntries()) {
            versionIds.add(generationsMapping.generation);
        }
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, d.publishedServiceId, versionIds, ignoreWarnings);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.deploymentsService.save_Check((AbstractDeployment)d, t.getUser(), false);
            t.commitV("Updated settings of API deployment %s", new Object[]{deploymentId});
        }
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/status"}, method={RequestMethod.GET})
    public void getDeploymentHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getHeavyStatus_Unsafe_NT_Check(authCtx, deploymentId, true));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-run-test-queries", "deploymentId", "${deploymentId}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/actions/run-test-queries"})
    public void runTestQueries(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) String endpointIdParam, @RequestParam(required=false) String testQueriesParam) throws Exception {
        List testQueriesObj;
        String endpointId;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        APIServiceDeploymentHeavyStatus hs = null;
        if (null == endpointIdParam || null == testQueriesParam) {
            hs = this.deploymentsService.getHeavyStatus_Unsafe_NT_Check(authCtx, deploymentId, true);
        }
        if (null != endpointIdParam) {
            endpointId = endpointIdParam;
        } else if (hs.endpoints.size() == 1) {
            endpointId = ((APIServiceDeploymentHeavyStatus.EndpointSummary)hs.endpoints.get((int)0)).id;
        } else {
            throw ErrorContext.iaef((String)"Deployment %s has multiple endpoints, endpoint ID must be specified.", (Object)deploymentId, (Object[])new Object[0]);
        }
        if (null != testQueriesParam) {
            testQueriesObj = (List)JSON.parse((String)testQueriesParam, (TypeToken)new TypeToken<List<ApiEndpointQuery>>(){});
        } else {
            Optional<APIServiceDeploymentHeavyStatus.EndpointSummary> es = hs.endpoints.stream().filter(e -> e.id.equals(endpointId)).findFirst();
            if (es.isPresent()) {
                testQueriesObj = es.get().testQueries;
            } else {
                throw ErrorContext.iaef((String)"Could not find endpoints %s in deployment %s.", (Object)endpointId, (Object[])new Object[]{deploymentId});
            }
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.runQueries_NT_Check(deploymentId, endpointId, authCtx, testQueriesObj, null, true, false));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-run-queries", "deploymentId", "${deploymentId}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/actions/run-queries"})
    public void runQueries(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) String endpointId, @RequestParam String queries, @RequestParam(required=false, defaultValue="true") boolean adaptQueryForInfraType) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        if (endpointId == null) {
            APIServiceDeploymentHeavyStatus hs = this.deploymentsService.getHeavyStatusUnsafe_NT(authCtx, authCtx, deploymentId, true);
            if (hs.endpoints.size() == 1) {
                endpointId = ((APIServiceDeploymentHeavyStatus.EndpointSummary)hs.endpoints.get((int)0)).id;
            } else {
                throw ErrorContext.iaef((String)"Deployment %s has multiple endpoints, endpoint ID must be specified.", (Object)deploymentId, (Object[])new Object[0]);
            }
        }
        List queriesObj = (List)JSON.parse((String)queries, (TypeToken)new TypeToken<List<ApiEndpointQuery>>(){});
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.runQueries_NT_Check(deploymentId, endpointId, authCtx, queriesObj, null, false, adaptQueryForInfraType));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-sync", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/actions/update"}, method={RequestMethod.POST})
    public void updateDeployment(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) boolean rebuildCodeEnv) throws Exception {
        AuthCtx authCtx;
        APIDeployerClientProxyUser.DeploymentUpdateRequest dur = (APIDeployerClientProxyUser.DeploymentUpdateRequest)this.getRequestBodyAsOrNull(req, APIDeployerClientProxyUser.DeploymentUpdateRequest.class);
        if (dur == null) {
            dur = new APIDeployerClientProxyUser.DeploymentUpdateRequest();
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FutureResponse futureResponse = this.deploymentsService.executeOneStepSync_NT_Check(authCtx, deploymentId, dur.updateMode, rebuildCodeEnv);
        if (dur.synchronous) {
            PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.waitForFinalResponse(futureResponse));
        } else {
            PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)futureResponse);
        }
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get-open-api", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/get-open-api"}, method={RequestMethod.GET})
    public void getDeploymentOpenAPI(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        String oad = this.deploymentsService.getDeploymentOpenAPIDocContentOrNull_Check_NT(authCtx, deploymentId);
        if (oad == null) {
            PublicAPIAPIDeployerController.send404((String)"Documentation file not found", (HttpServletResponse)resp);
            return;
        }
        PublicAPIAPIDeployerController.writeJSONString((HttpServletResponse)resp, (String)oad);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-list-update-heads", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/update"}, method={RequestMethod.GET})
    public void listDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        List duiList = this.getDeploymentsService().listDeploymentUpdateHeads_Check_NT(deploymentId, authCtx);
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)duiList);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get-update", "deploymentId", "${deploymentId}", "timestamp", "${timestamp}"})
    @RequestMapping(value={"/deployments/{deploymentId}/update/{timestamp}"}, method={RequestMethod.GET})
    public void getDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @PathVariable String timestamp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FullDeploymentUpdate dui = this.getDeploymentsService().getDeploymentUpdate_Check_NT(deploymentId, timestamp, authCtx);
        if (dui == null) {
            PublicAPIAPIDeployerController.send404((String)("Deployment update " + timestamp + " does not exist"), (HttpServletResponse)resp);
            return;
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)dui);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get-last-update", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/last-update"}, method={RequestMethod.GET})
    public void getLastDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        DeploymentUpdate dui = this.getDeploymentsService().getLastDeploymentUpdate_Check_NT(deploymentId, authCtx);
        if (dui == null) {
            PublicAPIAPIDeployerController.send404((String)"There is no update for this deployment", (HttpServletResponse)resp);
            return;
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)dui);
    }

    @AuditInline
    @RequestMapping(value={"/deployments/{deploymentId}/governance-status"}, method={RequestMethod.GET})
    public void getGovernanceStatusForDeploymentId(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) String version) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            AbstractAPIServiceDeployment deployment;
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getTicketOrKey(req);
                deployment = (AbstractAPIServiceDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)user).infraBasicInfo;
            }
            ArrayList<String> versionIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)version)) {
                versionIds.add(version);
            } else {
                if (deployment.generationsMapping == null) {
                    throw ErrorContext.iae((String)"The deployment does not contain any version.");
                }
                deployment.generationsMapping.validate();
                for (GenerationsMapping.MappingEntry generationsMapping : deployment.generationsMapping.getEntries()) {
                    versionIds.add(generationsMapping.generation);
                }
            }
            InfoMessage.InfoMessages governanceMessages = this.deploymentsService.getGovernanceMessages_NT(infraBasicInfo, deployment.getPublishedItemId(), versionIds);
            PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
            this.auditTrailService.generic("apideployer-deployment-governance-status-get").with("deploymentId", deployment.id).with("publishedServiceId", deployment.getPublishedItemId()).with("infraId", deployment.infraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("apideployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "apideployer-services-list"})
    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public void listServices(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listItems(req, resp);
    }

    @AuditInline
    @RequestMapping(value={"/services"}, method={RequestMethod.POST})
    public void createService(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ServiceCreationSettings creationSettings = (ServiceCreationSettings)this.getRequestBodyAs(req, ServiceCreationSettings.class);
        super.createItem(req, resp, creationSettings.publishedServiceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-delete", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/services/{serviceId}"}, method={RequestMethod.DELETE})
    public void deleteService(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        super.deleteItem(authCtx, serviceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-get", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/services/{serviceId}"}, method={RequestMethod.GET})
    public void getServiceLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        super.getItemLightStatus(req, resp, serviceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-get", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/services/{serviceId}/settings"}, method={RequestMethod.GET})
    public void getServiceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        super.getItemSettings(req, resp, serviceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-save", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/services/{serviceId}/settings"}, method={RequestMethod.PUT})
    public void saveServiceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        super.saveItemSettings(req, resp, serviceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-package-publish", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/services/{serviceId}/packages/{version}", "/services/{serviceId}/versions"}, method={RequestMethod.POST})
    public void publishVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.checkLicense();
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        this.publishedAPIServicesService.publishVersionFromStream_NT_Check(serviceId, filePart.getInputStream(), authCtx);
    }

    @AuditedCall(value={"msgType", "apideployer-service-version-delete", "serviceId", "${serviceId}", "version", "${version}"})
    @RequestMapping(value={"/services/{serviceId}/versions/{version}"}, method={RequestMethod.DELETE})
    public void deleteVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String version) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        this.publishedAPIServicesService.deletePackage_NT_Check(serviceId, version, authCtx);
    }

    @AuditedCall(value={"msgType", "apideployer-service-version-download", "serviceId", "${serviceId}", "version", "${version}"})
    @RequestMapping(value={"/services/{serviceId}/versions/{version}"}, method={RequestMethod.GET})
    public void downloadVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String version) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        File f = this.publishedAPIServicesService.getPublishedPackageFileMandatory_Check(serviceId, version, authCtx);
        HTTPClientUtils.sendArchiveDownload((File)f, (HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "apideployer-stages-list"})
    @RequestMapping(value={"/stages"}, method={RequestMethod.GET})
    public void listStages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.getTicketOrKey_NT(req);
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().apiDeployerServerSettings.stages);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infras-list"})
    @RequestMapping(value={"/infras"}, method={RequestMethod.GET})
    public void listInfras(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfras(req, resp);
    }

    @AuditInline
    @RequestMapping(value={"/infras"}, method={RequestMethod.POST})
    public void createInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        this.checkLicense();
        InfraCreationSettings creationSettings = (InfraCreationSettings)this.getRequestBodyAs(req, InfraCreationSettings.class);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        AbstractAPIDeploymentInfra newInfra = this.infrasService.createDeploymentInfra_NT(authCtx, AbstractDeploymentInfra.InfraType.valueOf((String)creationSettings.type), creationSettings.id, creationSettings.stage, authCtx.getIdentifier(), AbstractDeploymentInfra.GovernCheckPolicy.valueOf((String)creationSettings.governCheckPolicy));
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.infrasService.create_Check((AbstractDeploymentInfra)newInfra, t.getUser());
            PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.infrasService.getSettingsMandatoryUnsafe_CheckAdmin(creationSettings.id, t.getUser()));
            t.commitV("Created %s infra: %s", new Object[]{JSON.getType((Object)newInfra), creationSettings.id});
            this.auditTrailService.generic("apideployer-infra-create").with("infraId", creationSettings.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("apideployer-infra-create", (Throwable)e).with("infraId", creationSettings.id).emit();
            throw e;
        }
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-get", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/settings"}, method={RequestMethod.GET})
    public void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.getInfraSettings(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-get", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}"}, method={RequestMethod.GET})
    public void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.getInfraLightStatus(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "apideployer-infra-save", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/settings"}, method={RequestMethod.PUT})
    public void saveInfraSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.getRequestBodyAs(req, AbstractAPIDeploymentInfra.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.getInfrasService().save_Check((AbstractDeploymentInfra)infra, t.getUser(), false);
            t.commitV("Updated settings of %s infra %s", new Object[]{JSON.getType((Object)infra), infraId});
        }
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-check-read-permission", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/check-read-permission"}, method={RequestMethod.GET})
    public void checkInfraReadPermission(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.checkInfraReadPermission(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "apideployer-infra-delete", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}"}, method={RequestMethod.DELETE})
    public void deleteInfra(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.deleteInfra(req, infraId);
    }

    @AuditedCall(value={"msgType", "apideployer-api-services-monitoring", "apiServiceId", "${apiServiceId}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/api-services/{apiServiceId}/monitoring/{endpointId}"}, method={RequestMethod.GET})
    public void getServiceEndpointMonitoring(HttpServletRequest req, HttpServletResponse resp, @PathVariable String apiServiceId, @PathVariable String endpointId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        APIServiceEndpointMonitoring apiServiceEndpointMonitoring = this.getPublishedItemsService().getServiceEndpointMonitoring_NT(apiServiceId, endpointId, authCtx);
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)apiServiceEndpointMonitoring);
    }

    @AuditedCall(value={"msgType", "apideployer-endpoints-queryable-through-deployer"})
    @RequestMapping(value={"/endpoints-queryable-through-deployer"}, method={RequestMethod.GET})
    public void listEndpointsQueryableThroughDeployer(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.listEndpointsQueryableThroughDeployer_Check(authCtx));
    }

    @AuditedCall(value={"msgType", "apideployer-endpoint-queryable-through-deployer", "${deploymentId}", "deploymentId", "${endpointId}", "endpointId"})
    @RequestMapping(value={"/endpoint-queryable-through-deployer"}, method={RequestMethod.GET})
    public void getEndpointQueryableThroughDeployer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String endpointId) throws DKUSecurityException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIAPIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getEndpointQueryableThroughDeployer_Check(authCtx, deploymentId, endpointId));
    }

    private static class DeploymentCreationSettings {
        String deploymentId;
        String publishedServiceId;
        String infraId;
        String version;
        String endpointId;
        List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer = new ArrayList<AbstractAPIServiceDeployment.AuthorizationItem>();

        private DeploymentCreationSettings() {
        }
    }

    private static class ServiceCreationSettings {
        String publishedServiceId;

        private ServiceCreationSettings() {
        }
    }

    private static class InfraCreationSettings {
        String id;
        String stage;
        String type = AbstractDeploymentInfra.InfraType.STATIC.name();
        String governCheckPolicy = AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK.name();

        private InfraCreationSettings() {
        }
    }
}

