/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.businessapps.BusinessAppStoreService;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppDescriptor;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceParams;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceResult;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PublicAPIBusinessAppsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private BusinessAppsService businessAppsService;
    @Autowired
    private BusinessAppStoreService businessAppStoreService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;

    @AuditedCall(value={"msgType", "business-apps-list"})
    @RequestMapping(value={"/publicapi/business-apps/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BusinessAppListItem> list(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        if (!this.businessAppsService.areBusinessAppsAllowed()) {
            return new ArrayList<BusinessAppListItem>();
        }
        return this.businessAppsService.list(new BusinessAppsDAO.ReadOption[]{BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS}).stream().filter(businessApp -> this.permissionsService.hasBusinessAppPrivilege(authCtx, businessApp.settings, BusinessAppsService.BusinessAppPrivilegeType.USE)).map(app -> app.desc).map(BusinessAppListItem::new).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "business-app-get", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}"}, method={RequestMethod.GET})
    @ResponseBody
    public BusinessAppDetails get(HttpServletRequest req, @PathVariable String businessAppId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.businessAppsService.checkBusinessAppsAllowedOrThrow();
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, new BusinessAppsService.BusinessAppPrivilegeType[]{BusinessAppsService.BusinessAppPrivilegeType.USE});
        }
        EnumSet<BusinessAppsDAO.ReadOption> options = EnumSet.of(BusinessAppsDAO.ReadOption.READ_DESCRIPTOR);
        if (this.permissionsService.isAdmin(authCtx)) {
            options.add(BusinessAppsDAO.ReadOption.READ_SETTINGS);
        }
        BusinessApp app = this.businessAppsService.getMandatory(businessAppId, (BusinessAppsDAO.ReadOption[])options.toArray(BusinessAppsDAO.ReadOption[]::new));
        return new BusinessAppDetails(app);
    }

    @AuditedCall(value={"msgType", "business-app-get-settings", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/settings"}, method={RequestMethod.GET})
    @ResponseBody
    public BusinessAppSettings getSettings(HttpServletRequest req, @PathVariable String businessAppId) throws Exception {
        boolean admin;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            admin = this.permissionsService.isAdmin(authCtx);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, new BusinessAppsService.BusinessAppPrivilegeType[]{BusinessAppsService.BusinessAppPrivilegeType.USE});
        }
        BusinessAppSettings settings = this.businessAppsService.getMandatory((String)businessAppId, (BusinessAppsDAO.ReadOption[])new BusinessAppsDAO.ReadOption[]{BusinessAppsDAO.ReadOption.READ_SETTINGS}).settings;
        if (!admin) {
            settings.permissions = null;
            settings.defaultPermission = null;
        }
        return settings;
    }

    @AuditedCall(value={"msgType", "business-app-save-settings", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/settings"}, method={RequestMethod.PUT})
    @ResponseBody
    public void saveSettings(HttpServletRequest req, @PathVariable String businessAppId, @RequestBody BusinessAppSettings settings) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.businessAppsService.saveSettings(businessAppId, settings);
    }

    @AuditedCall(value={"msgType", "business-app-list-instances", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/instances"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BusinessAppInstanceItem> listInstances(HttpServletRequest req, @PathVariable String businessAppId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, new BusinessAppsService.BusinessAppPrivilegeType[]{BusinessAppsService.BusinessAppPrivilegeType.USE});
            List<BusinessAppInstanceItem> list = this.businessAppsService.listInstancesUnsafe(authCtx, businessAppId).stream().map(BusinessAppInstanceItem::new).collect(Collectors.toList());
            return list;
        }
    }

    @AuditedCall(value={"msgType", "business-app-create-instance", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/instances"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CreateOrUpgradeInstanceResult> createInstance(HttpServletRequest req, @PathVariable String businessAppId, @RequestBody CreateInstanceRequest request) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkBusinessAppPrivileges((AuthCtx)authCtx, businessAppId, new BusinessAppsService.BusinessAppPrivilegeType[]{BusinessAppsService.BusinessAppPrivilegeType.CREATE});
        }
        this.checkNotBlank(request.projectKey, "projectKey is required", new Object[0]);
        CreateOrUpgradeInstanceParams params = new CreateOrUpgradeInstanceParams();
        params.businessAppId = businessAppId;
        params.projectKey = request.projectKey;
        params.projectName = request.projectName;
        params.shortDesc = request.shortDesc;
        return this.businessAppsService.createInstance(authCtx, params);
    }

    @AuditedCall(value={"msgType", "business-app-upgrade-instance", "businessAppId", "${businessAppId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/instances/{projectKey}/upgrade"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CreateOrUpgradeInstanceResult> upgradeInstance(HttpServletRequest req, @PathVariable String businessAppId, @PathVariable String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkBusinessAppPrivileges((AuthCtx)authCtx, businessAppId, new BusinessAppsService.BusinessAppPrivilegeType[]{BusinessAppsService.BusinessAppPrivilegeType.CREATE});
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
                throw new IllegalArgumentException("Project '" + projectKey + "' is not a Business Application instance");
            }
            if (!businessAppId.equals(sp.businessAppId)) {
                throw new IllegalArgumentException("Project '" + projectKey + "' is not an instance of Business Application '" + businessAppId + "'");
            }
        }
        return this.businessAppsService.upgradeInstance(authCtx, businessAppId, projectKey);
    }

    @AuditedCall(value={"msgType", "business-app-instance-get-user-permissions", "businessAppId", "${businessAppId}", "projectKey", "${projectKey}", "userLogin", "${userLogin}"})
    @RequestMapping(value={"/publicapi/business-apps/{businessAppId}/instances/{projectKey}/permissions/{userLogin}"}, method={RequestMethod.GET})
    @ResponseBody
    public BusinessAppInstanceUserPermissions getInstanceUserPermissions(HttpServletRequest req, @PathVariable String businessAppId, @PathVariable String projectKey, @PathVariable String userLogin) throws Exception {
        this.checkNotBlank(userLogin, "user is required", new Object[0]);
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS});
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
                throw new IllegalArgumentException("Project '" + projectKey + "' is not a Business Application instance");
            }
            if (!businessAppId.equals(sp.businessAppId)) {
                throw new IllegalArgumentException("Project '" + projectKey + "' is not an instance of Business Application '" + businessAppId + "'");
            }
            UsersDAO.User user = this.usersService.getInternalUserOrNullUnsafe(userLogin);
            if (user == null) {
                throw new NotFoundException("User '" + userLogin + "' does not exist");
            }
            BusinessAppInstanceUserPermissions result = new BusinessAppInstanceUserPermissions();
            DSSAuthCtx userAuthCtx = DSSAuthCtx.forUserLogin((UsersDAO.User)user);
            result.login = userLogin;
            result.admin = this.permissionsService.hasProjectPrivilege((AuthCtx)userAuthCtx, sp, Privileges.ProjectLevelPrivilegeType.ADMIN);
            result.writeProjectContent = result.admin || this.permissionsService.hasProjectPrivilege((AuthCtx)userAuthCtx, sp, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            result.readProjectContent = result.writeProjectContent || this.permissionsService.hasProjectPrivilege((AuthCtx)userAuthCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            BusinessAppInstanceUserPermissions businessAppInstanceUserPermissions = result;
            return businessAppInstanceUserPermissions;
        }
    }

    @AuditedCall(value={"msgType", "business-app-install-from-archive"})
    @RequestMapping(value={"/publicapi/business-apps/install-from-archive"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<BusinessAppStoreService.InstallationResult> installBusinessAppFromArchive(HttpServletRequest req, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"business-app-uploads");
        FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)BusinessAppStoreService.getBusinessAppArchive((File)tmpDir));
        return this.businessAppStoreService.startUploadAndInstall(tmpDir, authCtx);
    }

    public static class BusinessAppDetails
    extends BusinessAppListItem {
        public String webAppId;
        public String codeEnvName;
        public Map<String, String> connections;
        public BusinessAppSettings settings;

        public BusinessAppDetails(BusinessApp app) {
            super(app.desc);
            this.webAppId = app.desc.webAppId;
            this.codeEnvName = app.desc.codeEnvName;
            this.connections = app.desc.connections;
            this.settings = app.settings;
        }
    }

    public static class CreateInstanceRequest {
        public String projectKey;
        public String projectName;
        public String shortDesc;
    }

    public static class BusinessAppInstanceUserPermissions {
        public String login;
        public boolean admin;
        public boolean readProjectContent;
        public boolean writeProjectContent;
    }

    public static class BusinessAppInstanceItem {
        public String projectKey;
        public String name;
        public String businessAppId;
        public String businessAppVersion;

        public BusinessAppInstanceItem(SerializedProject sp) {
            this.projectKey = sp.projectKey;
            this.name = sp.name;
            this.businessAppId = sp.businessAppId;
            this.businessAppVersion = sp.businessAppVersion;
        }
    }

    public static class BusinessAppListItem {
        public String id;
        public String version;
        public String name;
        public String description;
        public String documentationURL;

        public BusinessAppListItem(BusinessAppDescriptor descriptor) {
            this.id = descriptor.id;
            this.version = descriptor.version;
            this.name = descriptor.name;
            this.description = descriptor.description;
            this.documentationURL = descriptor.documentationURL;
        }
    }
}

