/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi"})
public class PublicAPIPersonalKeysController
extends PublicAPIControllerBase {
    public static final String KEY_NOT_FOUND_MESSAGE = "Key not found";
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private IPermissionsService permissionsService;

    @AuditedCall(value={"msgType", "publicapi-get-personal-api-key", "id", "${id}"})
    @RequestMapping(value={"/personal-api-keys/{id:.+}"}, method={RequestMethod.GET})
    public void getPersonalKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        Optional<PersonalPublicAPIKey> optionalKey;
        try (Transaction t = this.transactionService.beginRead();){
            optionalKey = this.getPersonalPublicAPIKey(req, id);
        }
        if (optionalKey.isPresent()) {
            PersonalPublicAPIKey key = optionalKey.get();
            PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, (Object)key);
        } else {
            PublicAPIPersonalKeysController.send404((String)KEY_NOT_FOUND_MESSAGE, (HttpServletResponse)resp);
        }
    }

    @AuditInline
    @RequestMapping(value={"/personal-api-keys/{id:.+}"}, method={RequestMethod.PUT})
    public void updatePersonalKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        PersonalPublicAPIKey personalKey = (PersonalPublicAPIKey)this.getRequestBodyAs(req, PersonalPublicAPIKey.class);
        this.require(personalKey.id.equals(id), "'id' mismatch URI vs Body");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            Optional<PersonalPublicAPIKey> isKey = this.getPersonalPublicAPIKey(req, id);
            if (!isKey.isPresent()) {
                PublicAPIPersonalKeysController.send404((String)KEY_NOT_FOUND_MESSAGE, (HttpServletResponse)resp);
                return;
            }
            this.publicApiKeyService.updatePersonalAPIKey(personalKey.id, personalKey.label, personalKey.description);
            t.commit("Updated personal public API key for " + t.getUser().getAssociatedDSSUser() + ", id: " + personalKey.id);
            this.auditService.generic("publicapi-personal-key-edit").with("id", personalKey.id).emit();
        }
        catch (Exception e) {
            this.auditService.failure("publicapi-personal-key-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/personal-api-keys/{id:.+}"}, method={RequestMethod.DELETE})
    public void deletePersonalKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        PersonalPublicAPIKey personalPublicAPIKey;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            Optional<PersonalPublicAPIKey> isKey = this.getPersonalPublicAPIKey(req, id);
            if (!isKey.isPresent()) {
                PublicAPIPersonalKeysController.send404((String)KEY_NOT_FOUND_MESSAGE, (HttpServletResponse)resp);
                return;
            }
            personalPublicAPIKey = this.publicApiKeyService.deletePersonalAPIKeyById(id);
            t.commit("Deleted personal API Key for " + t.getUser().getAssociatedDSSUser() + ", id: " + personalPublicAPIKey.id);
            this.auditService.generic("publicapi-personal-key-delete").with("id", personalPublicAPIKey.id).emit();
        }
        PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, (Object)personalPublicAPIKey);
    }

    @AuditedCall(value={"msgType", "publicapi-personal-api-keys-list"})
    @RequestMapping(value={"/personal-api-keys/"}, method={RequestMethod.GET})
    public void getPersonalKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List personalKeys;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.checkHasAssociatedDSSUser(authCtx);
            personalKeys = this.publicApiKeyService.getPersonalKeys();
        }
        List filteredKeys = personalKeys.stream().filter(key -> authCtx.getAssociatedDSSUser().equals(key.user)).collect(Collectors.toList());
        PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, filteredKeys);
    }

    @AuditInline
    @RequestMapping(value={"/personal-api-keys/"}, method={RequestMethod.POST})
    public void createPersonalKey(HttpServletRequest req, HttpServletResponse resp, @RequestBody PersonalPublicAPIKey key) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.checkHasAssociatedDSSUser(authCtx);
            if (!StringUtils.isBlank((String)key.user) && !key.user.equals(authCtx.getAssociatedDSSUser())) {
                throw ErrorContext.iae((String)"Can't setup a key on behalf of another user");
            }
            key.user = authCtx.getAssociatedDSSUser();
            PersonalPublicAPIKey apiKey = this.publicApiKeyService.createPersonalAPIKeyInternal(authCtx, key.user, key.label, key.description);
            PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, (Object)apiKey);
            t.commit("Created personal API key for " + apiKey.user + ", id: " + apiKey.id);
            this.auditService.generic("publicapi-personal-key-created").with("id", apiKey.id).emit();
        }
        resp.setStatus(HttpStatus.CREATED.value());
    }

    @AuditedCall(value={"msgType", "publicapi-all-personal-api-keys-list"})
    @RequestMapping(value={"/admin/personal-api-keys/"}, method={RequestMethod.GET})
    public void getAllPersonalKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List personalKeys;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            personalKeys = this.publicApiKeyService.getPersonalKeys();
        }
        PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, (Object)personalKeys);
    }

    @AuditInline
    @RequestMapping(value={"/admin/personal-api-keys/"}, method={RequestMethod.POST})
    public void createPersonalKeyForUser(HttpServletRequest req, HttpServletResponse resp, @RequestBody PersonalPublicAPIKey key, @RequestParam(required=false) boolean forceKey) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            if (StringUtils.isBlank((String)key.user)) {
                throw ErrorContext.iae((String)"Key user is mandatory");
            }
            if (this.usersDAO.getOrNull(key.user) == null) {
                throw ErrorContext.iae((String)("User '" + key.user + "' doesn't exist."));
            }
            String secret = forceKey ? key.key : null;
            PersonalPublicAPIKey apiKey = this.publicApiKeyService.createPersonalAPIKeyInternal(authCtx, key.user, key.label, key.description, secret);
            PublicAPIPersonalKeysController.writeJSON((HttpServletResponse)resp, (Object)apiKey);
            t.commit("Created personal API key for " + apiKey.user + ", id: " + apiKey.id);
            this.auditService.generic("publicapi-personal-key-for-user-created").with("id", apiKey.id).emit();
        }
        resp.setStatus(HttpStatus.CREATED.value());
    }

    private void checkHasAssociatedDSSUser(AuthCtx authCtx) {
        if (authCtx.getAssociatedDSSUser() == null) {
            throw ErrorContext.iae((String)"This API is only accessible using a key associated with a DSS user");
        }
    }

    private Optional<PersonalPublicAPIKey> getPersonalPublicAPIKey(HttpServletRequest req, String id) throws DKUSecurityException, IOException {
        AuthCtx authCtx = this.authService.getTicketOrKey(req);
        if (authCtx.isAdmin()) {
            return this.publicApiKeyService.getPersonalKeyById(id);
        }
        this.checkHasAssociatedDSSUser(authCtx);
        Optional key = this.publicApiKeyService.getPersonalKeyById(id);
        if (key.isPresent() && !((PersonalPublicAPIKey)key.get()).user.equals(authCtx.getAssociatedDSSUser())) {
            return Optional.empty();
        }
        return key;
    }
}

