/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/admin/code-studios"})
public class PublicAPICodeStudioTemplatesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;

    @AuditedCall(value={"msgType", "code-studio-templates-list-heads"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CodeStudioTemplate.ListItem> listHeads(HttpServletRequest req) throws Exception {
        CodeStudioTemplate.FilteredListItems heads = new CodeStudioTemplate.FilteredListItems();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            for (CodeStudioTemplate.ListItem head : this.codeStudioTemplatesService.listHeads()) {
                if (!this.permissionsService.hasAnyCodeStudioTemplateAccess(authCtx, head.id)) continue;
                heads.items.add(head);
            }
        }
        return heads.items;
    }

    @AuditedCall(value={"msgType", "code-studio-templates-get", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/{codeStudioTemplateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeStudioTemplate get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String codeStudioTemplateId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioTemplate template = this.codeStudioTemplatesService.getOrNullUnsafe(codeStudioTemplateId);
            if (template == null) {
                throw new NotFoundException("Code studio template '" + codeStudioTemplateId + "' doesn't exist");
            }
            if (!this.permissionsService.hasAnyCodeStudioTemplateAccess(authCtx, codeStudioTemplateId)) {
                throw new UnauthorizedException("Cannot access the code studio template", "code-studio-template-read");
            }
            CodeStudioTemplate codeStudioTemplate = template;
            return codeStudioTemplate;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-save", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/{codeStudioTemplateId:.+}"}, method={RequestMethod.PUT})
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String codeStudioTemplateId) throws Exception {
        CodeStudioTemplate template = (CodeStudioTemplate)this.getRequestBodyAs(req, CodeStudioTemplate.class);
        template.id = codeStudioTemplateId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioTemplate existing = this.codeStudioTemplatesService.getOrNullUnsafe(codeStudioTemplateId);
            if (existing == null) {
                throw new NotFoundException("Code studio template '" + codeStudioTemplateId + "' doesn't exist");
            }
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new UnauthorizedException("Cannot update the code studio template", "code-studio-template-update");
            }
            this.codeStudioTemplatesService.save(template);
            t.commit(String.format("Saved Code Studio template %s (%s)", template.getLabel(), template.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-build", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/{codeStudioTemplateId}/build"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CodeStudioTemplatesService.CodeStudioTemplateBuildResults> build(HttpServletRequest req, HttpServletResponse resp, @PathVariable String codeStudioTemplateId, @RequestParam(required=false, defaultValue="false") boolean withNoCache) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioTemplate template = this.codeStudioTemplatesService.getOrNullUnsafe(codeStudioTemplateId);
            if (template == null) {
                throw new NotFoundException("Code studio template '" + codeStudioTemplateId + "' doesn't exist");
            }
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new UnauthorizedException("Cannot build the code studio template", "code-studio-template-update");
            }
            FutureResponse futureResponse = this.codeStudioTemplatesService.startBuild(authCtx, codeStudioTemplateId, withNoCache);
            return futureResponse;
        }
    }
}

