/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.internal;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.datacatalog.UIDataCatalog;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.featurestore.Usages;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DataCollectionPermissionsService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.CatalogFlushRequestedEvent;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.CustomMultiFieldQueryParser;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.server.services.catalog.LuceneConfiguration;
import com.dataiku.dip.server.services.catalog.LuceneHelpers;
import com.dataiku.dip.server.services.catalog.LuceneHighlighter;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneMigrationHelper;
import com.dataiku.dip.server.services.catalog.LuceneQueryWrapper;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.server.services.catalog.TotalHitsCount;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.internal.InternalCatalogIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.internal.InternalDataCatalogHelper;
import com.dataiku.dip.server.services.catalog.opensearch.CombineFunction;
import com.dataiku.dip.server.services.catalog.opensearch.FieldValueFactorFunction;
import com.dataiku.dip.server.services.catalog.opensearch.FunctionScoreQuery;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.document.IntPoint;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.QueryParser;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectorManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchAllDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollectorManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class InternalDataCatalogService
extends AbstractSearchService
implements IInternalDataCatalogService {
    private final InternalCatalogIndexingQueueHandler queueHandler = new InternalCatalogIndexingQueueHandler();
    @Autowired
    protected InterestsService interestsService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDBService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ExternalDataCatalogService externalDataCatalogService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private DataStewardService dataStewardService;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private DataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    @Qualifier(value="internalMappingsAnalyzer")
    private LuceneMappingsAnalyzer internalLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="columnMappingsAnalyzer")
    private LuceneMappingsAnalyzer columnLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="internalAndExternalMultiMappingsAnalyzer")
    private LuceneMappingsAnalyzer internalAndExternalMultiMappingsAnalyzer;
    @Autowired
    @Qualifier(value="internalIndexManager")
    private LuceneIndexManager internalIndexManager;
    @Autowired
    @Qualifier(value="columnIndexManager")
    private LuceneIndexManager columnIndexManager;
    @Autowired
    @Qualifier(value="internalAndExternalMultiIndexManager")
    private LuceneIndexManager internalAndExternalMultiIndexManager;
    protected static final List<String> DATASET_PARAMS = Arrays.asList("table", "connection", "collection", "index", "path");

    @Override
    public void subscribeEvents() {
        this.pubSub.subscribe("flush-requested", (DSSEventListener)this);
        this.pubSub.subscribe("data-collection-change", (DSSEventListener)this);
        this.pubSub.subscribe("dataset-change", (DSSEventListener)this);
        this.pubSub.subscribe("dataset-charts-change", (DSSEventListener)this);
        this.pubSub.subscribe("discussion-close", (DSSEventListener)this);
        this.pubSub.subscribe("discussion-delete", (DSSEventListener)this);
        this.pubSub.subscribe("discussion-import", (DSSEventListener)this);
        this.pubSub.subscribe("discussion-reply", (DSSEventListener)this);
        this.pubSub.subscribe("discussion-update", (DSSEventListener)this);
        this.pubSub.subscribe("meaning-change", (DSSEventListener)this);
        this.pubSub.subscribe("meanings-folder-change", (DSSEventListener)this);
        this.pubSub.subscribe("object-change", (DSSEventListener)this);
        this.pubSub.subscribe("timeline-item", (DSSEventListener)this);
    }

    @Override
    public AbstractIndexingQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        CatalogFlushRequestedEvent flushRequestedEvent = new CatalogFlushRequestedEvent();
        this.pubSub.publish((DSSEvent)flushRequestedEvent);
        Object object = flushRequestedEvent.lock;
        synchronized (object) {
            while (!flushRequestedEvent.done) {
                flushRequestedEvent.lock.wait();
            }
        }
    }

    public LuceneResponseWrapper searchColumn(String query, Map<String, List<String>> facetMap, AuthCtx user, @Nullable String explainDocId) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        return this.searchColumn(query, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAggregations(false).withExplainDocId(explainDocId).withExplainDocType(IndexableType.COLUMN.index()), null);
    }

    public LuceneResponseWrapper searchColumn(String query, Map<String, List<String>> facetMap, AuthCtx user, IInternalDataCatalogService.Options options, Query additionalFilter) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
        if (additionalFilter != null) {
            filterBuilder.add(additionalFilter, BooleanClause.Occur.MUST);
        }
        filterBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.COLUMN.index())), BooleanClause.Occur.FILTER);
        return this.search(query, facetMap, user, IndexableType.COLUMN, (Query)filterBuilder.build(), options.withExplainDocType(IndexableType.COLUMN.index()), true, this.columnIndexManager);
    }

    public LuceneResponseWrapper searchNoHighlight(Query stringQuery, AuthCtx user, IInternalDataCatalogService.Options options) throws IOException, DKUSecurityException, LuceneIndexException {
        return this.searchNoHighlight(stringQuery, user, IndexableType.ALL, options, this.internalAndExternalMultiIndexManager);
    }

    public LuceneResponseWrapper search(String queryString, Map<String, List<String>> facets, AuthCtx user, IInternalDataCatalogService.Options options) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        return this.search(queryString, facets, user, IndexableType.ALL, null, options, true, this.internalAndExternalMultiIndexManager);
    }

    public LuceneResponseWrapper searchInternal(String queryString, Map<String, List<String>> facets, AuthCtx user, IInternalDataCatalogService.Options options) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        return this.search(queryString, facets, user, IndexableType.ALL, null, options, true, this.internalIndexManager);
    }

    public LuceneResponseWrapper searchInternal(String queryString, Map<String, List<String>> facets, AuthCtx user, IInternalDataCatalogService.Options options, Query additionalFilter) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        return this.search(queryString, facets, user, IndexableType.ALL, additionalFilter, options, true, this.internalIndexManager);
    }

    public LuceneResponseWrapper searchDataset(String queryString, Map<String, List<String>> facets, AuthCtx user, IInternalDataCatalogService.Options options, Query additionalFilter) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        return this.search(queryString, facets, user, IndexableType.DATASET, additionalFilter, options, true, this.internalIndexManager);
    }

    public Map<String, List<String>> getDatasetAndExternalTableFacets(AuthCtx user) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        IInternalDataCatalogService.Options options = new IInternalDataCatalogService.Options(1, true, true, false);
        HashMap<String, List<String>> facetsMap = new HashMap<String, List<String>>();
        facetsMap.put("_type", List.of(IndexableType.DATASET.index(), IndexableType.TABLE.index()));
        return this.search((String)"", facetsMap, (AuthCtx)user, (IndexableType)IndexableType.ALL, null, (IInternalDataCatalogService.Options)options, (boolean)true, (LuceneIndexManager)this.internalAndExternalMultiIndexManager).aggregations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LuceneResponseWrapper.Aggregation)e.getValue()).labelsAndValues.stream().map(lv -> lv.label).filter(l -> !"__DKU__NULL__VALUE__".equals(l)).toList()));
    }

    public LuceneResponseWrapper.Hit getDatasetById(String projectKey, String datasetId) throws IOException, LuceneIndexException, NoSuchElementException {
        String fullDatasetId = InternalDataCatalogHelper.objectKey(projectKey, ITaggingService.TaggableType.DATASET, datasetId, null);
        LuceneResponseWrapper response = this.getLuceneDocByIdMainIndex(fullDatasetId, IndexableType.DATASET);
        if (response.totalHits.value == 0L) {
            throw new NoSuchElementException("No datasets match the ID " + fullDatasetId);
        }
        response.serializeJsonPayloads(this.internalLuceneMappingsAnalyzer.getJsons(IndexableType.DATASET.index()));
        return (LuceneResponseWrapper.Hit)response.hits.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<DataCollection>, Integer> getDataCollectionsOfDataset(AuthCtx user, String projectKey, String datasetId) throws LuceneIndexException, IOException {
        List dataCollections;
        Document datasetPartialDocument;
        this.checkIndexReady();
        String fullDatasetId = InternalDataCatalogHelper.objectKey(projectKey, ITaggingService.TaggableType.DATASET, datasetId, null);
        BooleanQuery datasetQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_id", fullDatasetId)), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term("_type", IndexableType.DATASET.index())), BooleanClause.Occur.FILTER).build();
        IndexSearcher indexSearcher = this.internalIndexManager.acquireIndexSearcher();
        try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.search.getDataCollectionsOfDataset");){
            TopDocs topDocs = indexSearcher.search((Query)datasetQuery, 1);
            if (topDocs.totalHits.value == 0L) {
                logger.warnV("Dataset [%s] not found", new Object[]{fullDatasetId});
                Pair pair = new Pair(List.of(), (Object)0);
                return pair;
            }
            datasetPartialDocument = indexSearcher.getIndexReader().storedFields().document(topDocs.scoreDocs[0].doc, Set.of("dataCollection"));
        }
        finally {
            this.internalIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        List dataCollectionIds = Arrays.stream(datasetPartialDocument.getFields("dataCollection")).map(IndexableField::stringValue).collect(Collectors.toList());
        try (Transaction ignored = this.transactionService.beginRead();){
            dataCollections = dataCollectionIds.stream().map(arg_0 -> ((DataCollectionsService)this.dataCollectionsService).getOrNullNoThrowsUnsafe(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List readableCollections = dataCollections.stream().filter(dataCollection -> this.dataCollectionPermissionsService.filterOnHasDataCollectionPrivileges(user, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.READ})).sorted(Comparator.comparing(DataCollection::getDisplayName)).collect(Collectors.toList());
        return new Pair(readableCollections, (Object)dataCollections.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataCollection> searchDataCollections(AuthCtx user, String rawQuery) throws LuceneIndexException, IOException, ParseException {
        List dataCollections;
        List userReadableDataCollections;
        Query inputQueryOnDataset;
        Query inputQueryOnDataCollection;
        this.checkIndexReady();
        Map<String, Float> fieldsToSearchOnDataCollection = Map.ofEntries(Map.entry("name", Float.valueOf(5.0f)), Map.entry("tag", Float.valueOf(3.0f)), Map.entry("description", Float.valueOf(1.0f)));
        Map<String, Float> fieldsToSearchOnDataset = Map.ofEntries(Map.entry("name", Float.valueOf(3.0f)));
        try {
            inputQueryOnDataCollection = this.buildStringQueryForType(IndexableType.DATA_COLLECTION, this.internalIndexManager, fieldsToSearchOnDataCollection, rawQuery);
            inputQueryOnDataset = this.buildStringQueryForType(IndexableType.DATASET, this.internalIndexManager, fieldsToSearchOnDataset, rawQuery);
        }
        catch (ParseException e) {
            if (AbstractSearchService.isEscapedQueryString(rawQuery)) {
                throw e;
            }
            String escapedRawQuery = QueryParser.escape((String)rawQuery);
            inputQueryOnDataCollection = this.buildStringQueryForType(IndexableType.DATA_COLLECTION, this.internalIndexManager, fieldsToSearchOnDataCollection, escapedRawQuery);
            inputQueryOnDataset = this.buildStringQueryForType(IndexableType.DATASET, this.internalIndexManager, fieldsToSearchOnDataset, escapedRawQuery);
        }
        BooleanQuery queryOnDataCollection = new BooleanQuery.Builder().add(InternalDataCatalogService.buildQueryTypeIs(IndexableType.DATA_COLLECTION), BooleanClause.Occur.FILTER).add(inputQueryOnDataCollection, BooleanClause.Occur.MUST).build();
        BooleanQuery queryOnDataset = new BooleanQuery.Builder().add(InternalDataCatalogService.buildQueryFieldIs("isInDataCollection", "true"), BooleanClause.Occur.FILTER).add(InternalDataCatalogService.buildQueryTypeIs(IndexableType.DATASET), BooleanClause.Occur.FILTER).add(inputQueryOnDataset, BooleanClause.Occur.MUST).build();
        BooleanQuery finalQuery = new BooleanQuery.Builder().add((Query)queryOnDataCollection, BooleanClause.Occur.SHOULD).add((Query)queryOnDataset, BooleanClause.Occur.SHOULD).build();
        LinkedHashSet<String> resultsOnDataCollection = new LinkedHashSet<String>();
        LinkedHashMap resultsOnDataset = new LinkedHashMap();
        IndexSearcher indexSearcher = this.internalIndexManager.acquireIndexSearcher();
        try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.search.searchDataCollections");){
            TopDocs topDocs = indexSearcher.search((Query)finalQuery, 1000);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document partialDocument = indexSearcher.getIndexReader().storedFields().document(scoreDoc.doc, Set.of("_id", "_type", "dataCollection"));
                if (InternalDataCatalogService.isDocumentOfType(partialDocument, IndexableType.DATA_COLLECTION)) {
                    resultsOnDataCollection.add(InternalDataCatalogHelper.objectId(partialDocument.getField("_id").stringValue()));
                    continue;
                }
                if (!InternalDataCatalogService.isDocumentOfType(partialDocument, IndexableType.DATASET)) continue;
                resultsOnDataset.put(partialDocument.getField("_id").stringValue(), Arrays.stream(partialDocument.getFields("dataCollection")).map(IndexableField::stringValue).collect(Collectors.toSet()));
            }
        }
        finally {
            this.internalIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            userReadableDataCollections = this.dataCollectionsService.listReadableUnsafe(user);
            Set itemRefsOfUserReadableDataCollections = userReadableDataCollections.stream().flatMap(dataCollection -> dataCollection.items.stream()).map(AbstractDataCollectionItem::getRef).collect(Collectors.toSet());
            resultsOnDataset.keySet().stream().filter(datasetId -> itemRefsOfUserReadableDataCollections.contains(new AbstractDataCollectionItemRef.DatasetRef(InternalDataCatalogHelper.projectKey(datasetId), InternalDataCatalogHelper.objectId(datasetId)))).filter(datasetId -> !resultsOnDataCollection.containsAll((Collection)resultsOnDataset.get(datasetId))).filter(datasetId -> this.dataCollectionPermissionsService.hasAnyVisibilityOnDataCollectionObjectNoThrows(user, InternalDataCatalogHelper.projectKey(datasetId), ITaggingService.TaggableType.DATASET, InternalDataCatalogHelper.objectId(datasetId))).map(resultsOnDataset::get).forEachOrdered(resultsOnDataCollection::addAll);
            dataCollections = resultsOnDataCollection.stream().map(arg_0 -> ((DataCollectionsService)this.dataCollectionsService).getOrNullNoThrowsUnsafe(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Set userReadableDataCollectionRefs = userReadableDataCollections.stream().map(TaggableObjectsService.TaggableObject::getRef).collect(Collectors.toSet());
        return dataCollections.stream().filter(dataCollection -> userReadableDataCollectionRefs.contains(dataCollection.getRef())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper searchNoHighlight(Query stringQuery, AuthCtx user, IndexableType docType, IInternalDataCatalogService.Options options, LuceneIndexManager indexManager) throws IOException, DKUSecurityException, LuceneIndexException {
        assert (options.isHighlightDisabled());
        this.checkIndexReady();
        LuceneQueryWrapper luceneQueryWrapper = new LuceneQueryWrapper();
        LuceneMappingsAnalyzer luceneMappingsAnalyzer = indexManager.getMappingsAnalyzer();
        PerFieldAnalyzerWrapper perFieldAnalyzerWrapper = docType.equals((Object)IndexableType.ALL) ? luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper() : luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(docType.index());
        Map isTermVectorEnabledByField = docType.equals((Object)IndexableType.ALL) ? luceneMappingsAnalyzer.getTermVectorCondensedMapping() : luceneMappingsAnalyzer.getTermVectorMappingForType(docType.index());
        BooleanQuery.Builder scoreFunctionQueryBuilder = this.buildBoolQueryBuilder(stringQuery, user);
        BooleanQuery scoreFunctionQuery = scoreFunctionQueryBuilder.build();
        Query query = this.boostLargeProjectsAndDatasets(scoreFunctionQuery);
        luceneQueryWrapper.setQuery(query);
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        IndexSearcher indexSearcher = indexManager.acquireIndexSearcher();
        try {
            Query topDocsCollectorQuery = luceneQueryWrapper.getTopDocsCollectorQuery();
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.search.request");){
                TopDocs topDocs = options.needsAccurateTotalHits() ? (TopDocs)indexSearcher.search(topDocsCollectorQuery, (CollectorManager)new TopScoreDocCollectorManager(options.getMaxSize(), LuceneResponseWrapper.MAX_TOTAL_HITS)) : indexSearcher.search(topDocsCollectorQuery, options.getMaxSize());
                LuceneSecureIndexReader secureIndexReader = indexManager.getSecureIndexReader(indexSearcher);
                this.addHitsInResponse(secureIndexReader, docType, topDocs, result, indexManager, null, isTermVectorEnabledByField, null, perFieldAnalyzerWrapper);
                if (options.needsAggregation()) {
                    this.searchFacets(indexSearcher, secureIndexReader, luceneQueryWrapper, result);
                }
            }
            LuceneMigrationHelper.logLuceneExplanation(indexSearcher, topDocsCollectorQuery, options);
        }
        finally {
            indexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        result.serializeJsonPayloads(docType == IndexableType.ALL ? luceneMappingsAnalyzer.getCondensedJsons() : luceneMappingsAnalyzer.getJsons(docType.index()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper search(String inputString, Map<String, List<String>> facets, AuthCtx user, IndexableType docType, Query additionalFilter, IInternalDataCatalogService.Options options, boolean retryEscaped, LuceneIndexManager indexManager) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        Query stringQuery;
        LuceneQueryWrapper luceneQueryWrapper = new LuceneQueryWrapper();
        LuceneMappingsAnalyzer luceneMappingsAnalyzer = indexManager.getMappingsAnalyzer();
        FacetsConfig facetsConfig = luceneMappingsAnalyzer.getFacetsConfig();
        this.prepareSearch(facets, facetsConfig, docType, luceneMappingsAnalyzer.getBooleanFieldCondensedSet(), luceneQueryWrapper);
        if (docType.equals((Object)IndexableType.ALL) && luceneQueryWrapper.getRequestedTypes().size() == 1) {
            IndexableType potentialDocType = (IndexableType)luceneQueryWrapper.getRequestedTypes().stream().findFirst().get();
            if (luceneMappingsAnalyzer.getTypes().contains(potentialDocType.index())) {
                docType = potentialDocType;
            }
        }
        Map mapping = docType.equals((Object)IndexableType.ALL) ? luceneMappingsAnalyzer.getCondensedMapping() : luceneMappingsAnalyzer.getMappingForType(docType.index());
        PerFieldAnalyzerWrapper perFieldAnalyzerWrapper = docType.equals((Object)IndexableType.ALL) ? luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper() : luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(docType.index());
        Map isTermVectorEnabledByField = docType.equals((Object)IndexableType.ALL) ? luceneMappingsAnalyzer.getTermVectorCondensedMapping() : luceneMappingsAnalyzer.getTermVectorMappingForType(docType.index());
        String preparedString = InternalDataCatalogService.escapeReservedLuceneWords(inputString);
        Map<String, Float> boosts = InternalDataCatalogService.getSearchableFields(luceneQueryWrapper.getRequestedTypes(), luceneMappingsAnalyzer);
        if (indexManager == this.internalAndExternalMultiIndexManager) {
            boosts.putAll(ExternalDataCatalogService.getSearchableFields());
        }
        try {
            stringQuery = this.buildStringQuery(preparedString, boosts, perFieldAnalyzerWrapper, mapping);
        }
        catch (ParseException e) {
            if (retryEscaped && !AbstractSearchService.isEscapedQueryString(inputString)) {
                inputString = QueryParser.escape((String)inputString);
                return this.search(inputString, facets, user, docType, additionalFilter, options, false, indexManager);
            }
            throw e;
        }
        BooleanQuery.Builder scoreFunctionQueryBuilder = this.buildBoolQueryBuilder(stringQuery, user);
        if (!InternalDataCatalogService.expandQueryString(inputString).equals(inputString) && StringUtils.isNotBlank((String)inputString)) {
            Query exactMatchBoostQuery = this.exactMatchBoosting(perFieldAnalyzerWrapper, luceneMappingsAnalyzer, preparedString);
            scoreFunctionQueryBuilder.add((Query)new BoostQuery(exactMatchBoostQuery, 5.0f), BooleanClause.Occur.SHOULD);
        }
        if (additionalFilter != null) {
            scoreFunctionQueryBuilder.add(additionalFilter, BooleanClause.Occur.FILTER);
        }
        BooleanQuery scoreFunctionQuery = scoreFunctionQueryBuilder.build();
        Query query = this.boostLargeProjectsAndDatasets(scoreFunctionQuery);
        luceneQueryWrapper.setQuery(query);
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        Set<String> fieldsToHighlight = null;
        Query highlightQuery = null;
        if (!options.isHighlightDisabled()) {
            fieldsToHighlight = boosts.keySet();
            highlightQuery = this.buildStringQueryForHighlight(preparedString, boosts, perFieldAnalyzerWrapper, mapping, false);
        }
        IndexSearcher indexSearcher = indexManager.acquireIndexSearcher();
        try {
            Query topDocsCollectorQuery = luceneQueryWrapper.getTopDocsCollectorQuery();
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.search.request");){
                TopDocs topDocs = options.needsAccurateTotalHits() ? (TopDocs)indexSearcher.search(topDocsCollectorQuery, (CollectorManager)new TopScoreDocCollectorManager(options.getMaxSize(), LuceneResponseWrapper.MAX_TOTAL_HITS)) : indexSearcher.search(topDocsCollectorQuery, options.getMaxSize());
                LuceneSecureIndexReader secureIndexReader = indexManager.getSecureIndexReader(indexSearcher);
                this.addHitsInResponse(secureIndexReader, docType, topDocs, result, indexManager, options.isHighlightDisabled() ? null : fieldsToHighlight, isTermVectorEnabledByField, highlightQuery, perFieldAnalyzerWrapper);
                if (options.needsAggregation()) {
                    this.searchFacets(indexSearcher, secureIndexReader, luceneQueryWrapper, result);
                }
            }
            LuceneMigrationHelper.logLuceneExplanation(indexSearcher, topDocsCollectorQuery, options);
        }
        finally {
            indexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        if (result.totalHits.value == 0L && retryEscaped && !AbstractSearchService.isEscapedQueryString(inputString)) {
            inputString = QueryParser.escape((String)inputString);
            return this.search(inputString, facets, user, docType, additionalFilter, options, false, indexManager);
        }
        result.serializeJsonPayloads(docType == IndexableType.ALL ? luceneMappingsAnalyzer.getCondensedJsons() : luceneMappingsAnalyzer.getJsons(docType.index()));
        return result;
    }

    private Query exactMatchBoosting(PerFieldAnalyzerWrapper perFieldAnalyzerWrapper, LuceneMappingsAnalyzer luceneMappingsAnalyzer, String queryString) throws ParseException {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name.raw", Float.valueOf(5.0f));
        boosts.put("name.lower", Float.valueOf(5.0f));
        boosts.put("columns.name.raw", Float.valueOf(3.0f));
        boosts.put("columns.comment.raw", Float.valueOf(2.0f));
        String[] fields = boosts.keySet().toArray(new String[0]);
        CustomMultiFieldQueryParser queryParser = new CustomMultiFieldQueryParser(fields, (Analyzer)perFieldAnalyzerWrapper, boosts, luceneMappingsAnalyzer.getCondensedMapping(), new CustomMultiFieldQueryParser.ParserOptions(false, false));
        return queryParser.parse(queryString);
    }

    private Query boostLargeProjectsAndDatasets(BooleanQuery query) {
        float boostFactorInCollection = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsInCollection", 200.0f);
        float boostFactorInProject = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsInProject", 20.0f);
        float boostFactorFinalOutput = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsFinalOutput", 1.0f);
        float boostFactorDirectSuccessor = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsDirectSuccessor", 1.0f);
        float boostFactorInitialInput = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsInitialInput", 0.5f);
        float boostFactorDirectAncestor = DKUApp.getParams().getFloatParam("dku.catalog.boostFactor.dsDirectAncestor", 0.5f);
        ArrayList<FunctionScoreQuery.FilterScoreFunction> filterFunctions = new ArrayList<FunctionScoreQuery.FilterScoreFunction>();
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numDataCollections", boostFactorInCollection, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numUsedIn", boostFactorInProject, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numOutputs", boostFactorFinalOutput, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numSuccessors", boostFactorDirectSuccessor, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numInputs", boostFactorInitialInput, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        filterFunctions.add(new FunctionScoreQuery.FilterScoreFunction((Query)query, new FieldValueFactorFunction("numAncestors", boostFactorDirectAncestor, FieldValueFactorFunction.Modifier.NONE, 0.0)));
        return new FunctionScoreQuery((Query)query, FunctionScoreQuery.ScoreMode.LOG10P_OF_SUM, filterFunctions.toArray(new FunctionScoreQuery.FilterScoreFunction[0]), CombineFunction.MULTIPLY, null, Float.MAX_VALUE);
    }

    private static Set<String> getFieldsToHighlight() {
        return Set.of("attachments.displayName.raw", "attachments.displayName", "attachments.mimeType", "attachments.projectKey", "attachments.type", "code", "column.plaintext", "column", "dataset.plaintext", "dataset.raw", "dataset", "description.plaintext", "description", "discussionAuthor", "discussionAuthorName", "discussionReply", "discussions.topic", "name.plaintext", "name.raw", "name", "projectKey.plaintext", "projectKey", "projectName.plaintext", "projectName", "shortDesc.plaintext", "shortDesc", "tag.plaintext", "tag", "text");
    }

    public static Map<String, Float> getSearchableFields(Set<IndexableType> docTypes, LuceneMappingsAnalyzer luceneMappingsAnalyzer) {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name", Float.valueOf(5.0f));
        boosts.put("name.lower", Float.valueOf(5.0f));
        boosts.put("name.plaintext", Float.valueOf(5.0f));
        boosts.put("columns.name", Float.valueOf(3.0f));
        boosts.put("columns.comment", Float.valueOf(2.0f));
        boosts.put("column", Float.valueOf(3.0f));
        boosts.put("column.plaintext", Float.valueOf(3.0f));
        boosts.put("shortDesc", Float.valueOf(2.0f));
        boosts.put("shortDesc.plaintext", Float.valueOf(2.0f));
        boosts.put("description", Float.valueOf(1.0f));
        boosts.put("description.plaintext", Float.valueOf(1.0f));
        boosts.put("tag", Float.valueOf(2.0f));
        boosts.put("tag.plaintext", Float.valueOf(2.0f));
        boosts.put("type", Float.valueOf(1.0f));
        boosts.put("code", Float.valueOf(0.5f));
        boosts.put("params.table", Float.valueOf(1.0f));
        boosts.put("params.connection", Float.valueOf(1.0f));
        boosts.put("params.collection", Float.valueOf(1.0f));
        boosts.put("params.index", Float.valueOf(1.0f));
        boosts.put("params.path", Float.valueOf(1.0f));
        boosts.put("projectName", Float.valueOf(0.1f));
        boosts.put("projectName.plaintext", Float.valueOf(0.1f));
        boosts.put("projectKey", Float.valueOf(0.1f));
        boosts.put("projectKey.plaintext", Float.valueOf(0.1f));
        boosts.put("workspaceKey", Float.valueOf(0.1f));
        boosts.put("workspaceName", Float.valueOf(0.1f));
        boosts.put("dataset", Float.valueOf(1.0f));
        boosts.put("discussionAuthor", Float.valueOf(0.1f));
        boosts.put("discussionAuthorName", Float.valueOf(0.1f));
        boosts.put("discussionReply", Float.valueOf(0.5f));
        boosts.put("discussions.topic", Float.valueOf(0.5f));
        boosts.put("text", Float.valueOf(1.0f));
        boosts.put("attachments.projectKey", Float.valueOf(0.01f));
        boosts.put("attachments.type", Float.valueOf(0.1f));
        boosts.put("attachments.displayName", Float.valueOf(0.5f));
        boosts.put("attachments.displayName.lower", Float.valueOf(0.5f));
        boosts.put("attachments.mimeType", Float.valueOf(0.1f));
        boosts.put("objectName", Float.valueOf(1.0f));
        boosts.put("objectName.lower", Float.valueOf(1.0f));
        Set docTypeStrings = docTypes.stream().filter(docType -> docType != IndexableType.TABLE).map(IndexableType::index).collect(Collectors.toSet());
        if (!docTypes.contains(IndexableType.ALL) && !docTypes.isEmpty() && luceneMappingsAnalyzer.getTypes().containsAll(docTypeStrings)) {
            Set availableFields = docTypes.stream().filter(docType -> docType != IndexableType.TABLE).map(docType -> luceneMappingsAnalyzer.getMappingForType(docType.index()).keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
            return boosts.entrySet().stream().filter(entry -> availableFields.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return boosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper searchMeaning(String queryString, Map<String, List<String>> facets, AuthCtx user, boolean retryEscaped, @Nullable String explainDocId) throws LuceneIndexException, ParseException, IOException {
        Query meaningStringQuery;
        if (!LuceneConfiguration.IS_CATALOG_ENABLED) {
            throw new IndexingDisabledException();
        }
        if (!this.indexingQueueHandler.isInitialized()) {
            throw new IndexNotBuiltException();
        }
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        LuceneQueryWrapper luceneQueryWrapper = new LuceneQueryWrapper();
        BooleanQuery.Builder meaningRootBoolQueryBuilder = new BooleanQuery.Builder();
        this.addAggregationsAndFilters(facets, IndexableType.MEANING, this.columnLuceneMappingsAnalyzer.getFacetsConfig(), this.columnLuceneMappingsAnalyzer.getBooleanFieldSetForType(IndexableType.MEANING.index()), luceneQueryWrapper);
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("label", Float.valueOf(4.0f));
        boosts.put("prefix", Float.valueOf(4.0f));
        boosts.put("description", Float.valueOf(2.0f));
        try {
            meaningStringQuery = this.buildStringQuery(queryString, boosts, this.columnLuceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(IndexableType.MEANING.index()), false, this.columnLuceneMappingsAnalyzer.getMappingForType(IndexableType.MEANING.index()), false);
        }
        catch (ParseException e) {
            if (retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
                queryString = QueryParser.escape((String)queryString);
                return this.searchMeaning(queryString, facets, user, false, explainDocId);
            }
            throw e;
        }
        meaningRootBoolQueryBuilder.add(meaningStringQuery, BooleanClause.Occur.MUST);
        meaningRootBoolQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.MEANING.index())), BooleanClause.Occur.FILTER);
        BooleanQuery meaningRootBoolQuery = meaningRootBoolQueryBuilder.build();
        luceneQueryWrapper.setQuery((Query)meaningRootBoolQuery);
        IndexSearcher indexSearcher = this.columnIndexManager.acquireIndexSearcher();
        try {
            Query topDocsCollectorQuery = luceneQueryWrapper.getTopDocsCollectorQuery();
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.searchMeaning.request");){
                TopDocs topDocs = indexSearcher.search(topDocsCollectorQuery, MAX_RESULTS);
                result.totalHits = new TotalHitsCount(topDocs.totalHits);
                LuceneSecureIndexReader secureIndexReader = this.columnIndexManager.getSecureIndexReader(indexSearcher);
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    Document document = secureIndexReader.document(scoreDoc.doc, IndexableType.MEANING);
                    LuceneResponseWrapper.Hit hit = new LuceneResponseWrapper.Hit(this.columnIndexManager.getIndexName());
                    LuceneHighlighter.highlight(meaningStringQuery, secureIndexReader, document, scoreDoc.doc, Set.of("label", "prefix", "description"), this.columnLuceneMappingsAnalyzer.getMultivaluedFieldSetForType(IndexableType.MEANING.index()), this.columnLuceneMappingsAnalyzer.getTermVectorMappingForType(IndexableType.MEANING.index()), this.columnLuceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(IndexableType.MEANING.index()), hit);
                    LuceneHelpers.convertDocumentToSourceMap(document, (LuceneResponseWrapper.HitCommon)hit, this.columnLuceneMappingsAnalyzer);
                    hit._score = scoreDoc.score;
                    result.hits.add(hit);
                    TopDocs subTopDocs = indexSearcher.search((Query)new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", "column")), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("meaning", document.getField("id").stringValue())), BooleanClause.Occur.MUST).build(), 1000);
                    HashMap<String, LuceneResponseWrapper.InnerHitsList> innerHitMap = new HashMap<String, LuceneResponseWrapper.InnerHitsList>();
                    LuceneResponseWrapper.InnerHitsList innerHitsList = new LuceneResponseWrapper.InnerHitsList();
                    for (int j = 0; j < subTopDocs.scoreDocs.length; ++j) {
                        Document innerHitDoc = secureIndexReader.document(subTopDocs.scoreDocs[j].doc, IndexableType.COLUMN);
                        LuceneResponseWrapper.InnerHit innerHit = new LuceneResponseWrapper.InnerHit();
                        innerHit._id = innerHitDoc.get("_id");
                        innerHit._index = this.columnIndexManager.getIndexName();
                        innerHit._score = subTopDocs.scoreDocs[j].score;
                        innerHit._type = IndexableType.COLUMN.index();
                        LuceneHelpers.convertDocumentToSourceMap(innerHitDoc, (LuceneResponseWrapper.HitCommon)innerHit, this.columnLuceneMappingsAnalyzer);
                        innerHitsList.hits.add(innerHit);
                    }
                    innerHitsList.total = subTopDocs.scoreDocs.length;
                    innerHitMap.put("column", innerHitsList);
                    hit.inner_hits = innerHitMap;
                    if (!innerHitsList.hits.isEmpty()) continue;
                    hit._score /= 2.0f;
                }
                this.searchFacets(indexSearcher, secureIndexReader, luceneQueryWrapper, result);
            }
            LuceneMigrationHelper.logLuceneExplanation(indexSearcher, topDocsCollectorQuery, explainDocId, IndexableType.MEANING.index());
        }
        finally {
            this.columnIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        if (result.totalHits.value == 0L && retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
            queryString = QueryParser.escape((String)queryString);
            return this.searchMeaning(queryString, facets, user, false, explainDocId);
        }
        result.serializeJsonPayloads(this.columnLuceneMappingsAnalyzer.getJsons(IndexableType.MEANING.index()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper columnsWithMeaning(String meaningId, AuthCtx user) throws IOException, DKUSecurityException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.COLUMN.index())), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term(IndexableType.MEANING.index(), meaningId)), BooleanClause.Occur.FILTER);
        if (!user.isAdmin()) {
            booleanQueryBuilder.add(this.accessFilter(user), BooleanClause.Occur.FILTER);
        }
        LuceneResponseWrapper response = new LuceneResponseWrapper();
        IndexSearcher indexSearcher = this.columnIndexManager.acquireIndexSearcher();
        try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.columnsWithMeaning.request");){
            TopDocs topDocs = indexSearcher.search((Query)booleanQueryBuilder.build(), MAX_RESULTS);
            this.addHitsInResponse(this.columnIndexManager.getSecureIndexReader(indexSearcher), IndexableType.COLUMN, topDocs, response, this.columnIndexManager);
        }
        finally {
            this.columnIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        return response;
    }

    @Override
    protected Query accessFilter(AuthCtx user) throws IOException, DKUSecurityException {
        return new BooleanQuery.Builder().add(this.dashboardAclFilter(user), BooleanClause.Occur.SHOULD).add(this.authorizedMembersAclFilter(user), BooleanClause.Occur.SHOULD).add(this.discussionAclFilter(user), BooleanClause.Occur.SHOULD).add(this.externalTableFilter(user), BooleanClause.Occur.SHOULD).add(this.limitedVisibilityAclFilter(), BooleanClause.Occur.SHOULD).build();
    }

    public Query discussionAclFilter(AuthCtx user) throws DKUSecurityException {
        BooleanQuery.Builder accessibleDiscussionsQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", IndexableType.DISCUSSION.index())), BooleanClause.Occur.MUST);
        if (user.isAdmin()) {
            return accessibleDiscussionsQuery.build();
        }
        BooleanQuery.Builder userDiscussionsQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("authorized_discussion_users", user.getIdentifier())), BooleanClause.Occur.SHOULD);
        user.getGroups().forEach(g -> userDiscussionsQuery.add((Query)new TermQuery(new Term("authorized_discussion_groups", g)), BooleanClause.Occur.SHOULD));
        return accessibleDiscussionsQuery.add((Query)userDiscussionsQuery.build(), BooleanClause.Occur.MUST).build();
    }

    public Query dashboardAclFilter(AuthCtx user) throws DKUSecurityException {
        return new BooleanQuery.Builder().add((Query)new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", IndexableType.DASHBOARD.index())), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("_type", IndexableType.INSIGHT.index())), BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.MUST).add((Query)new BooleanQuery.Builder().add((Query)new TermQuery(new Term("listed", "true")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("owner", user.getIdentifier())), BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.MUST).add(this.canReadProjectDashboardsFilter(user), BooleanClause.Occur.MUST).build();
    }

    private Query canReadProjectDashboardsFilter(AuthCtx user) throws DKUSecurityException {
        if (user.isAdmin()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder userDashboardsQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("authorized_dashboard_users", user.getIdentifier())), BooleanClause.Occur.SHOULD);
        user.getGroups().forEach(g -> userDashboardsQuery.add((Query)new TermQuery(new Term("authorized_dashboard_groups", g)), BooleanClause.Occur.SHOULD));
        return userDashboardsQuery.build();
    }

    public Query authorizedMembersAclFilter(AuthCtx user) throws DKUSecurityException {
        if (user.isAdmin()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder userObjectsQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("authorized_members", "u:" + user.getIdentifier())), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("authorized_members", "g:$$ALL_USERS$$")), BooleanClause.Occur.SHOULD);
        user.getGroups().forEach(g -> userObjectsQuery.add((Query)new TermQuery(new Term("authorized_members", "g:" + g)), BooleanClause.Occur.SHOULD));
        return userObjectsQuery.build();
    }

    private Query limitedVisibilityAclFilter() throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafeAutoTXN();
        if (generalSettings.projectVisibility.visibilityMode == GeneralSettingsDAO.InheritableEnabledSetting.ALL_DISABLED) {
            return new MatchNoDocsQuery();
        }
        if (generalSettings.projectVisibility.visibilityMode == GeneralSettingsDAO.InheritableEnabledSetting.ALL_ENABLED) {
            return new TermQuery(new Term("_type", IndexableType.PROJECT.index()));
        }
        if (generalSettings.projectVisibility.visibilityMode == GeneralSettingsDAO.InheritableEnabledSetting.DISABLED_BY_DEFAULT) {
            return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", IndexableType.PROJECT.index())), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("limitedVisibilityEnabled", GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.ENABLED.toString())), BooleanClause.Occur.MUST).build();
        }
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", IndexableType.PROJECT.index())), BooleanClause.Occur.MUST).add((Query)new BooleanQuery.Builder().add((Query)new TermQuery(new Term("limitedVisibilityEnabled", GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.ENABLED.toString())), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("limitedVisibilityEnabled", GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT.toString())), BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.MUST).build();
    }

    public Query buildQuery(String field, String value, float boost) throws ParseException {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put(field, Float.valueOf(boost));
        LuceneMappingsAnalyzer luceneMappingsAnalyzer = this.internalAndExternalMultiIndexManager.getMappingsAnalyzer();
        Map mapping = luceneMappingsAnalyzer.getCondensedMapping();
        boolean mustExpand = ((LuceneMappingsAnalyzer.Field)mapping.get(field)).getType() != LuceneMappingsAnalyzer.MappingFieldType.STRING;
        PerFieldAnalyzerWrapper perFieldAnalyzerWrapper = luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper();
        return this.buildStringQueryFromInputString(value, boosts, perFieldAnalyzerWrapper, false, mustExpand, mapping, true, true);
    }

    private Query externalTableFilter(AuthCtx user) throws DKUSecurityException {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", IndexableType.TABLE.index())), BooleanClause.Occur.MUST).add(this.externalDataCatalogService.accessFilter(user), BooleanClause.Occur.MUST).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper getListedNonEmptyDashboards(AuthCtx user) throws IOException, LuceneIndexException, DKUSecurityException {
        this.checkIndexReady();
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder().add(this.canReadProjectDashboardsFilter(user), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term("_type", "dashboard")), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term("listed", "true")), BooleanClause.Occur.FILTER).add(IntPoint.newRangeQuery((String)"point_numTiles", (int)1, (int)Integer.MAX_VALUE), BooleanClause.Occur.FILTER);
        IndexSearcher indexSearcher = this.internalIndexManager.acquireIndexSearcher();
        try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.listDashboards.request");){
            TopDocs topDocs = indexSearcher.search((Query)bqBuilder.build(), Math.max(1000, MAX_RESULTS));
            this.addHitsInResponse(this.internalIndexManager.getSecureIndexReader(indexSearcher), IndexableType.DASHBOARD, topDocs, result, this.internalIndexManager);
        }
        finally {
            this.internalIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        return result;
    }

    public String searchResultPostTreatment(AuthCtx authCtx, Iterable<LuceneResponseWrapper.Hit> hits, String serialized, Function<JsonObject, JsonArray> getHitsArray) {
        JsonObject parsed = JsonParser.parseString((String)serialized).getAsJsonObject();
        JsonArray parsedHits = getHitsArray.apply(parsed);
        int index = 0;
        for (LuceneResponseWrapper.Hit hit : hits) {
            try {
                JsonObject source = parsedHits.get(index).getAsJsonObject().getAsJsonObject("_source");
                if (!this.projectsService.hasCustomProjectAccess(authCtx, source)) {
                    parsedHits.remove(index);
                    --index;
                } else if (IndexableType.PROJECT.index().equals(hit._type)) {
                    this.projectsService.searchResultPostTreatment(authCtx, source);
                }
                ++index;
            }
            catch (Exception e) {
                logger.error((Object)"Unable to process result from search", (Throwable)e);
                parsedHits.remove(index);
            }
        }
        return parsed.toString();
    }

    public UIDataCatalog.AbstractDatasetDetails getReadableDatasetItemDetails_NT(AuthCtx authCtx, String projectKey, String datasetId) throws Exception {
        PublicUser defaultDataSteward;
        PublicUser dataSteward;
        Usages usages;
        boolean canExportData;
        ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        SerializedDataset dataset;
        SerializedProject project;
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<UIDataCatalog.DetailsDimension> partitioningDimensions = new ArrayList<UIDataCatalog.DetailsDimension>();
        try (Transaction t = this.transactionService.beginRead();){
            project = this.projectsService.getMandatoryUnsafe(projectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetId);
            objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, datasetId, ITaggingService.TaggableType.DATASET, authCtx);
            canExportData = project != null && this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            usages = this.exposedObjectsService.getUsages(authCtx, projectKey, datasetId, ITaggingService.TaggableType.DATASET);
            dataSteward = dataset.getDataSteward() == null ? null : this.usersService.getPublicUser(dataset.getDataSteward());
            defaultDataSteward = this.dataStewardService.getDefaultDataStewardUser_safe(dataset);
        }
        Iterator nameIter = dataset.partitioning.getDimensionNames().iterator();
        Iterator typeIter = dataset.partitioning.getDimensionTypes().iterator();
        while (nameIter.hasNext() && typeIter.hasNext()) {
            partitioningDimensions.add(new UIDataCatalog.DetailsDimension((String)nameIter.next(), (DimensionType)typeIter.next()));
        }
        DatasetMetricsStatusService.DatasetSummaryStatus status = this.datasetMetricsStatusService.getCachedSummaryStatus((Partitionable)Dataset.fromSerializedUnsafe((String)dataset.getFullName(), (SerializedDataset)dataset));
        InterestsInternalDB.Interest interest = this.interestsService.getObjectAndUserInterest_NT(authCtx, ITaggingService.TaggableType.DATASET, projectKey, datasetId, null);
        long lastBuildTime = -1L;
        try {
            ReadOnlyJobsInternalDB.ObjectBuild ob = this.jobsDBService.getLatestSuccessfulBuildForObject(projectKey, datasetId);
            lastBuildTime = ob == null ? -1L : ob.buildStartTime;
        }
        catch (SQLException e) {
            logger.warn((Object)("Failed to get last build time for dataset " + projectKey + "." + datasetId), (Throwable)e);
        }
        DataQualityDailyStatus dataQualityStatus = this.getDataQualityStatus(dataset);
        Pair<List<DataCollection>, Integer> dataCollections = this.getDataCollectionsOfDataset(authCtx, projectKey, datasetId);
        UIDataCatalog.DatasetDetails datasetDetails = new UIDataCatalog.DatasetDetails(project, dataset, objectAuthorizations, dataSteward, defaultDataSteward, interest, canExportData, status, usages, partitioningDimensions, lastBuildTime, dataQualityStatus, (List)dataCollections.first, ((Integer)dataCollections.second).intValue());
        this.enrichReadableDatasetFromCatalog(projectKey, datasetId, datasetDetails);
        return datasetDetails;
    }

    public void enrichReadableDatasetFromCatalog(String projectKey, String datasetId, UIDataCatalog.DatasetDetails datasetDetails) throws IOException {
        LuceneResponseWrapper.Hit dataset;
        try {
            dataset = this.getDatasetById(projectKey, datasetId);
        }
        catch (LuceneIndexException | NoSuchElementException e) {
            logger.error((Object)"Failed to enrich dataset details from catalog", e);
            return;
        }
        JsonArray inputs = (JsonArray)dataset._source.get("recursiveInputs");
        LinkedList<TaggableObjectsService.TaggableObjectRefWithName> inputObjects = new LinkedList<TaggableObjectsService.TaggableObjectRefWithName>();
        for (JsonElement input : inputs) {
            inputObjects.add(this.parseCatalogObject(JsonUtils.getStringMemberOrEmpty((JsonObject)input.getAsJsonObject(), (String)"name"), JsonUtils.getStringMemberOrEmpty((JsonObject)input.getAsJsonObject(), (String)"type")));
        }
        JsonArray outputs = (JsonArray)dataset._source.get("recursiveOutputs");
        LinkedList<TaggableObjectsService.TaggableObjectRefWithName> outputObjects = new LinkedList<TaggableObjectsService.TaggableObjectRefWithName>();
        for (JsonElement output : outputs) {
            outputObjects.add(this.parseCatalogObject(JsonUtils.getStringMemberOrEmpty((JsonObject)output.getAsJsonObject(), (String)"name"), JsonUtils.getStringMemberOrEmpty((JsonObject)output.getAsJsonObject(), (String)"type")));
        }
        datasetDetails.splitInputsByType = InternalDataCatalogService.computeCatalogDatasetInputsOutputsByType(inputObjects);
        datasetDetails.splitOutputsByType = InternalDataCatalogService.computeCatalogDatasetInputsOutputsByType(outputObjects);
        datasetDetails.creationDate = dataset._source.getOrDefault("createdOn", datasetDetails.creationDate);
        String createdByLogin = dataset._source.getOrDefault("createdBy", null);
        String lastModifiedByLogin = dataset._source.getOrDefault("lastModifiedBy", null);
        datasetDetails.lastModificationDate = dataset._source.getOrDefault("lastModifiedOn", datasetDetails.lastModificationDate);
        try (Transaction t = this.transactionService.beginRead();){
            if (createdByLogin != null) {
                datasetDetails.createdBy = this.usersService.getPublicUser(createdByLogin);
            }
            if (lastModifiedByLogin != null) {
                datasetDetails.lastModifiedBy = this.usersService.getPublicUser(lastModifiedByLogin);
            }
        }
    }

    private static Map<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRefWithName>> computeCatalogDatasetInputsOutputsByType(List<TaggableObjectsService.TaggableObjectRefWithName> inputsOrOutputs) {
        return inputsOrOutputs.stream().collect(Collectors.groupingBy(TaggableObjectsService.TaggableObjectRef::getType));
    }

    private TaggableObjectsService.TaggableObjectRefWithName parseCatalogObject(String name, String type) throws IOException {
        ITaggingService.TaggableType objectType = ITaggingService.TaggableType.valueOf((String)type.toUpperCase(Locale.ROOT));
        String[] splitName = name.split("\\.");
        if (splitName.length >= 2) {
            String displayName;
            String projectKey = splitName[0];
            String id = splitName[splitName.length - 1];
            try (Transaction t = this.transactionService.beginRead();){
                TaggableObjectsService.TaggableObject object = this.taggableObjectsReadService.getOrNullUnsafe(projectKey, objectType, id);
                displayName = object == null ? id : object.getDisplayName();
            }
            return new TaggableObjectsService.TaggableObjectRefWithName(projectKey, objectType, id, displayName);
        }
        logger.error((Object)("Unexpected name format for catalog object: " + name));
        return null;
    }

    public UIDataCatalog.DiscoverableDatasetDetails getDiscoverableDatasetItemDetails_NT(AuthCtx authCtx, String projectKey, String datasetId) throws Exception {
        PublicUser defaultDataSteward;
        PublicUser dataSteward;
        SerializedDataset dataset;
        SerializedProject project;
        ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, datasetId, ITaggingService.TaggableType.DATASET, authCtx);
            project = this.projectsService.getMandatoryUnsafe(projectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetId);
            dataSteward = dataset.getDataSteward() == null ? null : this.usersService.getPublicUser(dataset.getDataSteward());
            defaultDataSteward = this.dataStewardService.getDefaultDataStewardUser_safe(dataset);
        }
        DataQualityDailyStatus dataQualityStatus = this.getDataQualityStatus(dataset);
        Pair<List<DataCollection>, Integer> dataCollections = this.getDataCollectionsOfDataset(authCtx, projectKey, datasetId);
        return new UIDataCatalog.DiscoverableDatasetDetails(project, dataset, objectAuthorizations, dataSteward, defaultDataSteward, dataQualityStatus, (List)dataCollections.first, ((Integer)dataCollections.second).intValue());
    }

    private DataQualityDailyStatus getDataQualityStatus(SerializedDataset dataset) throws SQLException {
        return this.dataQualityService.getDatasetStatusLast_NT(dataset);
    }

    public LuceneResponseWrapper getLuceneDocByIdMainIndex(String docId, IndexableType docType) throws IOException, LuceneIndexException {
        return this.getLuceneDocById(docId, docType, this.internalIndexManager);
    }

    public LuceneResponseWrapper getLuceneDocByIdColumnIndex(String docId, IndexableType docType) throws IOException, LuceneIndexException {
        return this.getLuceneDocById(docId, docType, this.columnIndexManager);
    }

    public static class ProjectItemCounts {
        int numCodeStudios = 0;
        int numDatasets = 0;
        int numRecipes = 0;
        int numModels = 0;
        int numNotebooks = 0;
        int numAnalyses = 0;
        int numManagedFolders = 0;
        int numScenarios = 0;
        int numDashboards = 0;
        int numInsights = 0;
        int numWebApps = 0;
        int numReports = 0;
        int numSavedModels = 0;
        int numModelEvaluationStores = 0;
        int numGenAiEvaluationStores = 0;
        int numModelEvaluationComparators = 0;
        int numGenAiEvaluationComparators = 0;
        int numTasks = 0;
        int numWikiArticles = 0;
        int numStatisticsWorksheets = 0;
        int numFlowZones = 0;
        int numLabelingTasks = 0;
        int numAgentReviews = 0;
        int numKnowledgeBanks = 0;
        int numPromptStudios = 0;
        int numGenAIModels = 0;
        int numAgents = 0;
    }

    static class TimelineDigest {
        Long createdOn;
        String createdBy;
        Long lastModifiedOn;
        String lastModifiedBy;
        List<String> contributors;

        TimelineDigest() {
        }
    }
}

