/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.server.controllers.ETaggedResponseBody;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.AbstractResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EtaggedResponseAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class converterType) {
        return returnType.hasMethodAnnotation(ETaggedResponseBody.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String newETag = EtaggedResponseAdvice.computeETag(body, response);
        String previousETag = request.getHeaders().getFirst("If-None-Match");
        response.getHeaders().setETag(newETag);
        if (EtaggedResponseAdvice.areETagsEqual(previousETag, newETag)) {
            response.setStatusCode((HttpStatusCode)HttpStatus.NOT_MODIFIED);
            return null;
        }
        return body;
    }

    private static boolean areETagsEqual(String previousETag, String newETag) {
        return previousETag != null && previousETag.substring(2).equals(newETag);
    }

    private static String computeETag(Object body, ServerHttpResponse response) {
        if (body instanceof AbstractResource) {
            long contentLength = response.getHeaders().getContentLength();
            String lastModified = response.getHeaders().getFirst("X-Last-Modified");
            return String.format("\"%d-%s\"", contentLength, lastModified);
        }
        return String.format("\"%s\"", Hex.encodeHexString((byte[])JSON.sha256((Object)body)));
    }
}

