/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.vectorstore;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryTool;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolRunner;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServer;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerAPI;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerKernelDesc;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServerKernelPool;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VectorStoreQueryToolServerPool
extends LLMRelatedPoolablePythonServerKernelPool<VectorStoreQueryToolServer, VectorStoreQueryToolServerKernelDesc, VectorStoreQueryToolServerKernelDesc> {
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private TransactionService transactionService;
    public static final String VIRTUAL_TOOL_ID_PREFIX = "KB_SEARCH_";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.vectorstore.pool");

    public void invalidateKernels(AgentTool tool) {
        this.manager.clearKernels(kd -> tool.projectKey.equals(kd.sourceProjectKey) && tool.id.equals(kd.toolId), KernelPool.DeathReason.OUTDATED);
    }

    public boolean stopDevKernel(DSSAuthCtx authCtx, AgentTool tool) {
        VectorStoreQueryToolServerKernelDesc kernelDesc = new VectorStoreQueryToolServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.sourceProjectKey = tool.projectKey;
        kernelDesc.toolId = tool.id;
        kernelDesc.isDevKernel = true;
        Optional kernelID = this.manager.getKernelIdFiltered(kd -> kd.isSameDevKernel(kernelDesc));
        if (kernelID.isEmpty()) {
            return false;
        }
        return this.manager.forceStopKernel((String)kernelID.get(), KernelPool.DeathReason.USER_REQUEST);
    }

    public void wakeUp(DSSAuthCtx authCtx, String projectKey, AgentTool at) throws Exception {
        VectorStoreQueryToolServerKernelDesc desc;
        if (!Objects.equals(VectorStoreQueryTool.META.getType(), at.type)) {
            throw new RuntimeException("Cannot wake up an agent tool with type " + at.type + ".");
        }
        try (VectorStoreQueryToolRunner runner = (VectorStoreQueryToolRunner)VectorStoreQueryTool.META.buildRunner(authCtx, projectKey, at);){
            desc = runner.buildKernelDesc();
        }
        this.manager.handle(kernel -> CompletableFuture.completedFuture(null), (Object)desc, desc.poolKey, null);
    }

    public static VectorStoreQueryToolServerKernelDesc buildKernelDesc(DSSAuthCtx authCtx, String contextProjectKey, AgentTool tool, RetrievableKnowledge rk, VectorStoreQueryTool.VectorStoreQueryToolParams params, String envName, String containerConfName, String clusterId, boolean devKernel) throws IOException {
        VectorStoreQueryToolServerKernelDesc kernelDesc = new VectorStoreQueryToolServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.contextProjectKey = contextProjectKey;
        kernelDesc.sourceProjectKey = tool.projectKey;
        kernelDesc.toolId = tool.id;
        kernelDesc.toolVersionNumber = tool.versionTag != null ? tool.versionTag.versionNumber : 0L;
        kernelDesc.isDevKernel = devKernel;
        kernelDesc.rk = rk;
        kernelDesc.params = params;
        kernelDesc.dkuProperties = tool.dkuProperties;
        kernelDesc.singleInstance = tool.singleInstance;
        kernelDesc.envName = envName;
        kernelDesc.containerConfName = containerConfName;
        kernelDesc.clusterId = clusterId;
        kernelDesc.poolKey = authCtx.getIdentifier() + "-" + contextProjectKey + "-" + tool.id + "-" + DigestUtils.sha1Hex((String)StringUtils.join((Object[])new String[]{JSON.json((Object)tool), JSON.json((Object)rk), JSON.json((Object)params), envName, containerConfName, clusterId, "" + devKernel}, (String)"__DKU__"));
        kernelDesc.rkVersion = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(rk);
        return kernelDesc;
    }

    public VectorStoreQueryToolServerAPI getServerAPI(final VectorStoreQueryToolServerKernelDesc kernelDesc) {
        return new VectorStoreQueryToolServerAPI(){

            @Override
            public CompletableFuture<AgentToolRunner.AgentToolOutput> runAsync(AgentToolRunner.AgentToolInput input) {
                return VectorStoreQueryToolServerPool.this.manager.handle(kernel -> kernel.runAsync(input), (Object)kernelDesc, kernelDesc.poolKey, (Object)input);
            }

            @Override
            public SmartLogTail getKernelLog() {
                try {
                    if (!kernelDesc.isDevKernel) {
                        throw new IllegalArgumentException("Production kernels can't return logs");
                    }
                    String kernelID = (String)VectorStoreQueryToolServerPool.this.manager.getKernelIdFiltered(kd -> kd.isSameDevKernel(kernelDesc)).orElseThrow(() -> new IllegalArgumentException("Dev kernel not found: " + kernelDesc.getDevKernelKey()));
                    return (SmartLogTail)VectorStoreQueryToolServerPool.this.manager.getKernelLogs(kernelID).orElseThrow(() -> new IllegalArgumentException("Logs not found for dev kernel: " + kernelDesc.getDevKernelKey()));
                }
                catch (Exception e) {
                    SmartLogTail fakeSLT = new SmartLogTail();
                    fakeSLT.appendLine(e.getMessage());
                    return fakeSLT;
                }
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public VectorStoreQueryToolServerPool() {
        super("vector-store-tool");
        this.setManager(new KernelPool((KernelPool.KernelController)new LLMRelatedPoolablePythonServerKernelPool.LLMRelatedPoolablePythonServerKernelController("dku.agents.tools.vectorstore"){

            @Nonnull
            public VectorStoreQueryToolServer createKernel(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                return new VectorStoreQueryToolServer(kernelDesc.authCtx, kernelDesc.contextProjectKey, kernelDesc.rk, kernelDesc.params, CodeEnvSelection.explicitEnv(kernelDesc.envName), kernelDesc.containerConfName, kernelDesc.clusterId);
            }

            @Nonnull
            public CompletableFuture<Void> startKernel(VectorStoreQueryToolServer kernel, VectorStoreQueryToolServerKernelDesc kernelDesc) {
                File logBaseDir = DKUApp.getFile((String[])new String[]{"agent-tools", kernelDesc.contextProjectKey, kernelDesc.toolId, "logs"});
                return DKUCompletableFuture.runAsync(() -> {
                    DSSKernelUtils.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                    AnyLoc toolSmartId = new AnyLoc(kernelDesc.sourceProjectKey, kernelDesc.toolId);
                    kernel.init(kernelDesc.isDevKernel, false, logBaseDir, toolSmartId);
                }, (Executor)VectorStoreQueryToolServerPool.this.executorService);
            }

            public Long getQueuedRequestTimeoutInNs() {
                return ApplicationConfigurator.getParams().getLongParam(this.propertiesPrefix + ".queuedRequestTimeoutInS", 1800L) * 1000L * 1000L * 1000L;
            }

            @Override
            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".maxKernels", Integer.valueOf(50));
            }

            public Integer getMaxKernelCount(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                Params localParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(kernelDesc.dkuProperties);
                return DSSKernelUtils.getMaxKernelCount(localParams, this.propertiesPrefix + ".maxKernelPerAgentTool", this.propertiesPrefix + ".maxKernelProportionPerAgentTool", kernelDesc.singleInstance, this.getGlobalMaxKernelCount());
            }

            public int getHardMaxParallelRequests(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                Params localParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(kernelDesc.dkuProperties);
                return DSSKernelUtils.getIntParamWithFallback(localParams, this.propertiesPrefix + ".hardMaxRequestsPerKernel", 16);
            }

            public int getSoftMaxParallelRequests(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                Params localParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(kernelDesc.dkuProperties);
                return DSSKernelUtils.getIntParamWithFallback(localParams, this.propertiesPrefix + ".softMaxRequestsPerKernel", 16);
            }

            public int getAutoscaleTimeWindowSeconds(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                if (kernelDesc.isDevKernel) {
                    return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".dev.autoscaleWindowSeconds", Integer.valueOf(120));
                }
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".autoscaleWindowSeconds", Integer.valueOf(600));
            }

            public int getMinimumRetentionTimeSeconds(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                if (kernelDesc.isDevKernel) {
                    return 0;
                }
                AgentTool tool = this.getAgentToolUnsafe(kernelDesc);
                if (tool != null && tool.minimumRetentionTimeSeconds != null && tool.minimumRetentionTimeSeconds >= 0) {
                    return tool.minimumRetentionTimeSeconds;
                }
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".minimumRetentionTimeSeconds", Integer.valueOf(1800));
            }

            public boolean isOutdated(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                try {
                    String version = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(kernelDesc.rk);
                    if (!Objects.equals(version, kernelDesc.rkVersion)) {
                        return true;
                    }
                    if (kernelDesc.toolId.startsWith(VectorStoreQueryToolServerPool.VIRTUAL_TOOL_ID_PREFIX)) {
                        return false;
                    }
                    AgentTool tool = this.getAgentToolUnsafe(kernelDesc);
                    return tool == null || tool.versionTag != null && tool.versionTag.versionNumber != kernelDesc.toolVersionNumber;
                }
                catch (IOException e) {
                    logger.error((Object)String.format("Failed to check if KB %s is outdated", kernelDesc.rk.getFullId()), (Throwable)e);
                    return false;
                }
            }

            @Nullable
            private AgentTool getAgentToolUnsafe(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                AgentTool agentTool;
                block9: {
                    if (kernelDesc.toolId == null || kernelDesc.sourceProjectKey == null || kernelDesc.toolId.startsWith(VectorStoreQueryToolServerPool.VIRTUAL_TOOL_ID_PREFIX)) {
                        return null;
                    }
                    Transaction t = VectorStoreQueryToolServerPool.this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
                    try {
                        agentTool = (AgentTool)VectorStoreQueryToolServerPool.this.agentToolsDAO.getOrNullUnsafe(kernelDesc.sourceProjectKey, kernelDesc.toolId);
                        if (t == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (t != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            logger.error((Object)String.format("Failed to load agent tool %s.%s", kernelDesc.sourceProjectKey, kernelDesc.toolId), (Throwable)e);
                            return null;
                        }
                    }
                    t.close();
                }
                return agentTool;
            }

            public SmartLogTail getKernelLog(VectorStoreQueryToolServer kernel) {
                return kernel.getKernelLog();
            }
        }, "vector-store-tool", logger));
    }
}

