/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations.flow;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.ExplainStuffFutureThread;
import com.dataiku.dip.aiexplanations.flow.RecipeSummarizer;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowZoneNode;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIFlowExplanationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.aiexplanations.flow");

    public FutureResponse<ExplainStuffFrontendResponse> startExplainingProject(AuthCtx authCtx, String projectKey, String explanationOptions, boolean disableThrottling) throws Exception {
        AIFeaturesUtil.parseAndValidateExplanationOptions(explanationOptions);
        ExplainThatFlowFutureThread futureThread = new ExplainThatFlowFutureThread(authCtx, projectKey, null, explanationOptions, disableThrottling);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ExplainStuffFrontendResponse>>(){});
    }

    public FutureResponse<ExplainStuffFrontendResponse> startExplainingFlowZone(AuthCtx authCtx, String projectKey, String zoneId, String explanationOptions, boolean disableThrottling) throws Exception {
        AIFeaturesUtil.parseAndValidateExplanationOptions(explanationOptions);
        ExplainThatFlowFutureThread futureThread = new ExplainThatFlowFutureThread(authCtx, projectKey, zoneId, explanationOptions, disableThrottling);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ExplainStuffFrontendResponse>>(){});
    }

    private class ExplainThatFlowFutureThread
    extends ExplainStuffFutureThread {
        private final String projectKey;
        private final String zoneId;

        public ExplainThatFlowFutureThread(AuthCtx owner, @Nullable String projectKey, String zoneId, String explanationOptions, boolean disableThrottling) {
            super(owner, AIFlowExplanationService.this.licenseStatusService, explanationOptions, disableThrottling);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey));
            this.projectKey = projectKey;
            this.zoneId = zoneId;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_explain_flow", (String)"AI Explain Flow");
        }

        @Override
        protected ExplainStuffFutureThread.ExplainStuffBackendQuery createQuery() throws IOException {
            try (Transaction ignored = AIFlowExplanationService.this.transactionService.beginRead();){
                ExplainThatFlowBackendQuery explainThatFlowBackendQuery;
                List zones = AIFlowExplanationService.this.zonesDAO.listUnsafe(this.projectKey);
                if (zones.isEmpty() && this.zoneId != null) {
                    throw new IllegalArgumentException("Project has no Flow zones and zoneId specified");
                }
                ExplainThatFlowBackendQuery explainQuery = new ExplainThatFlowBackendQuery();
                HashMap<AnyLoc, Zone> zonesMap = new HashMap<AnyLoc, Zone>();
                for (Zone zone : zones) {
                    for (SmartObjectRef objectRef : zone.getItems()) {
                        zonesMap.put(AnyLoc.resolveFull(objectRef.getFullId(this.projectKey)), zone);
                    }
                }
                if (!zones.isEmpty() && this.zoneId == null) {
                    Object object;
                    List<FlowZoneNode> allZones = AIFlowExplanationService.this.graphService.getFlowZoneNodes(this.projectKey, zonesMap);
                    TraversalOrderBuilder traversalOrderBuilder = new TraversalOrderBuilder(null, zonesMap);
                    allZones.forEach(traversalOrderBuilder::addFrom);
                    List sortedZones = traversalOrderBuilder.ret.stream().map(node -> (FlowZoneNode)node).collect(Collectors.toList());
                    explainQuery.flowZones = new ArrayList<FlowSummary>();
                    boolean areAllZonesEmpty = true;
                    for (FlowZoneNode zone : sortedZones) {
                        FlowSummary zoneSummary = this.generateFlowSummary(zonesMap, zone.getFullId());
                        if (zoneSummary.isEmpty()) {
                            logger.info((Object)("When generating explanations, ignore zone " + zone.getName() + " as it is empty."));
                            continue;
                        }
                        zoneSummary.setName(zone.getName());
                        explainQuery.flowZones.add(zoneSummary);
                        areAllZonesEmpty = false;
                    }
                    if (areAllZonesEmpty) {
                        logger.info((Object)"Not querying DADA endpoint since the Flow zones contain neither any input datasets nor any recipes nor any output datasets");
                        object = null;
                        return object;
                    }
                    object = explainQuery;
                    return object;
                }
                FlowSummary flowSummary = this.generateFlowSummary(zonesMap, this.zoneId);
                if (flowSummary.isEmpty()) {
                    logger.info((Object)"Not querying DADA endpoint since the Flow contains neither any input datasets nor any recipes nor any output datasets");
                    explainThatFlowBackendQuery = null;
                    return explainThatFlowBackendQuery;
                }
                explainQuery.addProjectSummary(flowSummary);
                explainThatFlowBackendQuery = explainQuery;
                return explainThatFlowBackendQuery;
            }
        }

        private FlowSummary generateFlowSummary(Map<AnyLoc, Zone> zonesMap, String zoneId) throws IOException {
            FlowSummary flowSummary = new FlowSummary();
            List<FlowRunnable> sourceRecipesOfFlow = AIFlowExplanationService.this.graphService.getInitialRunnablesOfFlow(this.projectKey, zoneId, zonesMap);
            TraversalOrderBuilder traversalOrderBuilder = new TraversalOrderBuilder(zoneId, zonesMap);
            sourceRecipesOfFlow.forEach(traversalOrderBuilder::addFrom);
            logger.info((Object)("List of nodes considered: " + JSON.prettyLog(traversalOrderBuilder.ret.stream().map(GraphNode::getFullId).collect(Collectors.toList()))));
            List<FlowRecipe> recipesOfTheFlow = traversalOrderBuilder.ret.stream().filter(node -> node instanceof FlowRecipe).map(node -> (FlowRecipe)node).collect(Collectors.toList());
            flowSummary.recipes = recipesOfTheFlow.stream().flatMap(recipe -> {
                logger.info((Object)("Summarizing recipe " + recipe.getFullId()));
                RecipeSummarizer recipeSummarizer = new RecipeSummarizer();
                try {
                    return Stream.of(recipeSummarizer.summarize((FlowRecipe)recipe));
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to summarize recipe", (Throwable)e);
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
            logger.info((Object)("Recipes of Flow: " + JSON.log(recipesOfTheFlow.stream().map(FlowRecipe::getFullId).collect(Collectors.toList()))));
            logger.info((Object)"--------------------------------------");
            ArrayList<FlowComputable> sourceComputablesOfFlow = new ArrayList<FlowComputable>();
            recipesOfTheFlow.forEach(recipe -> {
                logger.info((Object)("Study recipe " + recipe.getFullId()));
                for (GraphNode graphNode : recipe.getPredecessors()) {
                    logger.info((Object)("  Study predecessor computable " + graphNode.getFullId()));
                    boolean noPredecessorsPredecessorIsInFlow = graphNode.getPredecessors().isEmpty();
                    if (zoneId != null) {
                        for (GraphNode graphNode2 : graphNode.getPredecessors()) {
                            noPredecessorsPredecessorIsInFlow |= !this.isInZone(graphNode2, zoneId, zonesMap);
                        }
                    }
                    logger.infoV("  No predecessor of predecessor computable %s in Flow: %b", new Object[]{graphNode.getFullId(), noPredecessorsPredecessorIsInFlow});
                    if (!noPredecessorsPredecessorIsInFlow) continue;
                    logger.infoV("  Hence %s is a source computable of the Flow", new Object[]{graphNode.getFullId()});
                    if (this.isInSet(graphNode, sourceComputablesOfFlow)) continue;
                    logger.info((Object)("Add " + graphNode.getFullId()));
                    sourceComputablesOfFlow.add((FlowComputable)graphNode);
                }
            });
            Collection<FlowComputable> targetComputablesOfFlow = AIFlowExplanationService.this.graphService.getFinalComputablesOfFlow(this.projectKey, zoneId);
            flowSummary.inputDatasets = this.createDatasetSummaries(this.projectKey, sourceComputablesOfFlow);
            flowSummary.outputDatasets = this.createDatasetSummaries(this.projectKey, targetComputablesOfFlow);
            logger.info((Object)("Summary of the zone: " + JSON.prettyLog((Object)flowSummary)));
            return flowSummary;
        }

        @Override
        protected ExplainStuffFrontendResponse createEmptyBackendQueryFrontendResponse() {
            ExplainStuffFrontendResponse response = new ExplainStuffFrontendResponse();
            response.ok = true;
            response.reason = "EMPTY_FLOW";
            return response;
        }

        @Override
        protected String createBackendApiEndpointPath() {
            return "/explain-stuff/explain-flow";
        }

        @Override
        protected String createFailureReason() {
            return "AI was not able to explain that Flow";
        }

        @Override
        protected String createNdcMessage() {
            return "ai-explain-flow: " + this.projectKey;
        }

        private DatasetSummary createDatasetSummary(String projectKey, FlowComputable flowComputable) {
            if (flowComputable instanceof FlowDataset) {
                SerializedDataset serializedDataset;
                DatasetSummary datasetSummary = new DatasetSummary();
                datasetSummary.name = AnyLoc.resolveFull(flowComputable.getFullId()).getSmartName(projectKey);
                AnyLoc datasetLoc = AnyLoc.resolveFull(flowComputable.getFullId());
                try {
                    serializedDataset = (SerializedDataset)AIFlowExplanationService.this.datasetsDAO.getMandatory(datasetLoc);
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to get dataset", (Throwable)e);
                    return null;
                }
                datasetSummary.cols = serializedDataset.getSchema().columns.stream().limit(50L).map(SchemaColumn::getName).toList();
                datasetSummary.datasetColumns = serializedDataset.getSchema().columns.stream().limit(50L).map(SchemaColumn::getColumnSummary).toList();
                datasetSummary.shortDesc = serializedDataset.shortDesc;
                return datasetSummary;
            }
            return null;
        }

        private List<DatasetSummary> createDatasetSummaries(String projectKey, Collection<FlowComputable> flowComputables) {
            return flowComputables.stream().map(fc -> this.createDatasetSummary(projectKey, (FlowComputable)fc)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private boolean isInZone(GraphNode node, String zoneId, Map<AnyLoc, Zone> zonesMap) {
            AnyLoc nodeLoc = AnyLoc.resolveFull(node.getFullId());
            Zone nodeZone = zonesMap.get(nodeLoc);
            String nodeZoneId = nodeZone != null ? nodeZone.getId() : Zone.DEFAULT_ZONE.getId();
            logger.debugV("Checking whether node %s is in zone %s", new Object[]{node.getFullId(), nodeZoneId});
            return nodeZoneId.equals(zoneId);
        }

        private boolean isInSet(GraphNode node, List<? extends GraphNode> ret) {
            for (GraphNode graphNode : ret) {
                if (!graphNode.getClass().equals(node.getClass()) || !graphNode.getFullId().equals(node.getFullId())) continue;
                return true;
            }
            return false;
        }

        private class ExplainThatFlowBackendQuery
        extends ExplainStuffFutureThread.ExplainStuffBackendQuery {
            List<DatasetSummary> inputDatasets = new ArrayList<DatasetSummary>();
            List<RecipeSummarizer.RecipeSummary> recipes;
            List<DatasetSummary> outputDatasets = new ArrayList<DatasetSummary>();
            List<FlowSummary> flowZones;

            private ExplainThatFlowBackendQuery() {
            }

            private void addProjectSummary(FlowSummary flowSummary) {
                this.inputDatasets = flowSummary.inputDatasets;
                this.recipes = flowSummary.recipes;
                this.outputDatasets = flowSummary.outputDatasets;
            }
        }

        private class TraversalOrderBuilder {
            private final Map<AnyLoc, Zone> zonesMap;
            private final String zoneId;
            final List<GraphNode> ret = new ArrayList<GraphNode>();
            private final Set<GraphNode> nodesVisited = new HashSet<GraphNode>();

            TraversalOrderBuilder(String restrictToZoneId, Map<AnyLoc, Zone> zonesMap) {
                this.zoneId = restrictToZoneId;
                this.zonesMap = zonesMap;
            }

            void addToSet(GraphNode node) {
                this.ret.add(node);
            }

            void addFrom(GraphNode node) {
                logger.info((Object)("TraversalOrderBuilder: adding " + node.getFullId()));
                this.nodesVisited.add(node);
                for (GraphNode graphNode : node.getPredecessors()) {
                    if (this.zoneId != null && !ExplainThatFlowFutureThread.this.isInZone(graphNode, this.zoneId, this.zonesMap)) {
                        logger.info((Object)("Not recursing to " + graphNode.getFullId() + " which is not in zone"));
                        continue;
                    }
                    if (ExplainThatFlowFutureThread.this.isInSet(graphNode, this.ret) || this.nodesVisited.contains(graphNode)) continue;
                    this.addFrom(graphNode);
                }
                if (!ExplainThatFlowFutureThread.this.isInSet(node, this.ret)) {
                    this.addToSet(node);
                }
                for (GraphNode graphNode : node.getSuccessors()) {
                    if (this.zoneId != null && !ExplainThatFlowFutureThread.this.isInZone(graphNode, this.zoneId, this.zonesMap)) {
                        logger.info((Object)("Not recursing to " + graphNode.getFullId() + " which is not in zone"));
                        continue;
                    }
                    if (ExplainThatFlowFutureThread.this.isInSet(graphNode, this.ret)) continue;
                    this.addFrom(graphNode);
                }
            }
        }

        private class FlowSummary {
            List<DatasetSummary> inputDatasets = new ArrayList<DatasetSummary>();
            List<RecipeSummarizer.RecipeSummary> recipes;
            List<DatasetSummary> outputDatasets = new ArrayList<DatasetSummary>();
            @Nullable
            String name;

            private FlowSummary() {
            }

            public void setName(String name) {
                this.name = name;
            }

            private boolean isEmpty() {
                return this.inputDatasets.isEmpty() && this.recipes.isEmpty() && this.outputDatasets.isEmpty();
            }
        }

        private static class DatasetSummary {
            String name;
            List<String> cols;
            List<SchemaColumn.ColumnSummary> datasetColumns;
            String shortDesc;

            private DatasetSummary() {
            }
        }
    }
}

