/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.aigenerations.AIFlowPlanEditor;
import com.dataiku.dip.aigenerations.AIGenerationService;
import com.dataiku.dip.aigenerations.AiAssistantTransactionService;
import com.dataiku.dip.aigenerations.capabilities.AICapability;
import com.dataiku.dip.aigenerations.capabilities.AiCapabilityFactory;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.AiAssistantsDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.FlowAssistantStateUpdateEvent;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIFlowGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private AIGenerationService aiGenerationService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private AiAssistantsDAO aiAssistantsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TaggableObjectsDeletionService taggableObjectsDeletionService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private AiAssistantTransactionService aiAssistantTransactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AIFlowPlanEditor assistantStateEditor;
    private static final Map<String, TranslationKey> _EXPLANATION_TRANSLATIONS = Map.of("FLOW_ASSISTANT_NOT_SUPPORTED_CAPABILITY", new TranslationKey("AIFLOW_GENERATION.MESSAGE.NOT_SUPPORTED", "That's not a supported capability so I am not able to help with that right now. Select the datasets you want to work with and tell me what you need."));
    private final Map<String, HttpPost> currentRequests = new ConcurrentHashMap<String, HttpPost>();
    private static final DKULogger logger = DKULogger.getLogger(AIFlowGenerationService.class);

    public FutureResponse<AIFlowAssistantState> startFlowGenerationPlan(AuthCtx authCtx, String projectKey, String query, AIFlowAssistantState state, List<DatasetContext> additionalContext, @Nullable String frontendId) throws Exception {
        AIFlowGenerationPlanThread futureThread = new AIFlowGenerationPlanThread(authCtx, this.licenseStatusService.getLicensingStatus(), projectKey, query, state, additionalContext, frontendId);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIFlowAssistantState>>(){});
    }

    public FutureResponse<AIFlowAssistantState> startFlowGenerationExecution(AuthCtx authCtx, String projectKey, AIFlowAssistantState state) throws Exception {
        AIFlowGenerationExecutionThread futureThread = new AIFlowGenerationExecutionThread(authCtx, this.licenseStatusService.getLicensingStatus(), projectKey, state);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIFlowAssistantState>>(){});
    }

    public List<String> deleteAICreatedObjects(AuthCtx authCtx, String projectKey, String conversationId, boolean onlyDeleteReferences) throws Exception {
        ArrayList<String> failedItems;
        HashSet<TaggableObjectsService.TaggableObjectRef> ignored = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem> toDelete = new LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject> taggableObjectsMap = new HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject>();
        LinkedHashSet<Object> entry = new LinkedHashSet();
        try (RWTransaction t = this.aiAssistantTransactionService.beginWrite(authCtx);){
            AIGeneratedObjects items = this.aiAssistantsDAO.getAIGeneratedObjects((TransactionRef)t, projectKey);
            if (items != null) {
                if (onlyDeleteReferences) {
                    items.objectsToDeleteByConversationId.remove(conversationId);
                    this.aiAssistantsDAO.saveAIGeneratedObjects((RWTransactionRef)t, projectKey, items);
                    t.commit("Reset ai-generated-objects.json in" + projectKey);
                } else if (items.objectsToDeleteByConversationId.containsKey(conversationId)) {
                    entry = items.objectsToDeleteByConversationId.get(conversationId);
                }
            }
        }
        if (entry.isEmpty()) {
            return new ArrayList<String>();
        }
        t = this.transactionService.beginRead();
        try {
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            failedItems = new ArrayList<String>();
            for (TaggableObjectsDeletionService.DeletionRequestItem deletionRequestItem : entry) {
                TaggableObjectsService.TaggableObjectRef drAsTaggableObjectRef = new TaggableObjectsService.TaggableObjectRef(deletionRequestItem.projectKey, deletionRequestItem.type, deletionRequestItem.id);
                ignored.add(drAsTaggableObjectRef);
                try {
                    this.taggableObjectsDeletionService.failIfCannotDelete(deletionRequestItem, authCtx);
                    TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(deletionRequestItem);
                    toDelete.add(deletionRequestItem);
                    taggableObjectsMap.put(deletionRequestItem, to);
                }
                catch (Exception e) {
                    String msg = this.translationService.translateNoContext(lang, "AIFLOW_GENERATION.ERROR.SKIPPING_DELETION", "Skipping deletion item {{displayName}} because it could not be read or cannot be deleted: {{errorMessage}}", "displayName", deletionRequestItem.displayName, "errorMessage", e.getMessage());
                    logger.warn((Object)msg, (Throwable)e);
                    failedItems.add(msg);
                }
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        this.taggableObjectsDeletionService.delete_NT(toDelete, taggableObjectsMap, projectKey, ignored, authCtx);
        t = this.aiAssistantTransactionService.beginWrite(authCtx);
        try {
            AIGeneratedObjects current = this.aiAssistantsDAO.getAIGeneratedObjects((TransactionRef)t, projectKey);
            if (current != null) {
                current.objectsToDeleteByConversationId.remove(conversationId);
                this.aiAssistantsDAO.saveAIGeneratedObjects((RWTransactionRef)t, projectKey, current);
            }
            t.commit("Deleted " + conversationId + "ai-generated-objects in" + projectKey);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return failedItems;
    }

    public AIFlowAssistantState getAIFlowAssistantState(AuthCtx authCtx, String projectKey) throws Exception {
        try (Transaction t = this.aiAssistantTransactionService.beginRead();){
            AIFlowAssistantState aIFlowAssistantState = this.aiAssistantsDAO.getAIFlowAssistantState((TransactionRef)t, projectKey, authCtx);
            return aIFlowAssistantState;
        }
    }

    public void setAIFlowAssistantState(AuthCtx authCtx, String projectKey, @Nullable AIFlowAssistantState state) throws Exception {
        try (RWTransaction t = this.aiAssistantTransactionService.beginWrite(authCtx);){
            this.aiAssistantsDAO.setAIFlowAssistantState((RWTransactionRef)t, projectKey, authCtx, state);
            t.commit((state != null ? "Saved" : "Cleared") + " AI Flow Assistant state for user " + authCtx.getIdentifier() + " and project " + projectKey);
        }
    }

    public void setAIFlowAssistantStateAndNotify(String lang, AuthCtx authCtx, String projectKey, @Nullable AIFlowAssistantState state, boolean refreshFlow, @Nullable String frontendId) throws Exception {
        this.setAIFlowAssistantState(authCtx, projectKey, state);
        if (state != null && state.plan != null && _EXPLANATION_TRANSLATIONS.containsKey(state.plan.explanation)) {
            TranslationKey config = _EXPLANATION_TRANSLATIONS.get(state.plan.explanation);
            state.plan.explanation = this.translationService.translateNoContext(lang, config.key(), config.defaultTranslation(), new Object[0]);
        }
        this.pubSubService.publish((DSSEvent)new FlowAssistantStateUpdateEvent(projectKey, authCtx.getIdentifier(), state == null ? new AIFlowAssistantState() : state, refreshFlow, frontendId));
    }

    private class AIFlowGenerationPlanThread
    extends AIFlowGenerationThread<AIFlowAssistantState> {
        private final String query;
        String frontendId;

        public AIFlowGenerationPlanThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String projectKey, String query, AIFlowAssistantState state, @Nullable List<DatasetContext> additionalContext, String frontendId) {
            super(owner, licensingStatus, projectKey, "text2flow/plan", "text2flow_planning", state, additionalContext);
            this.query = query;
            this.frontendId = frontendId;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected AIFlowAssistantState compute() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String getFriendlyErrorMessage(@Nullable String errorDetailsMessage) {
            if (errorDetailsMessage != null && !errorDetailsMessage.isEmpty()) {
                return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.AI_PLAN_SUGGESTION_FAILED_WITH_DETAILS", "Unfortunately, AI was not able to suggest a plan from your instructions. You may want to update the description and try again.\nError message: `{{errorMessage}}`", "errorMessage", errorDetailsMessage);
            }
            return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.AI_PLAN_SUGGESTION_FAILED", "Unfortunately, AI was not able to suggest a plan from your instructions. You may want to update the description and try again.", new Object[0]);
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_flow_generation_plan", (String)"AI Flow Generation Plan");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GeneratedState<PlanState> plan(List<AIGenerationService.AIDatasetInformation> datasetsInformation) throws DKUSecurityException {
            NDC.push((String)("ai-flowgenerationplan: " + this.query));
            try {
                PlanBackendQueryBase planQuery = this.createFlowGenerationPlanQuery(this.query, datasetsInformation);
                GeneratedState<PlanState> generatedState = this.requestAIServerBackendAndProcessResponse(planQuery);
                return generatedState;
            }
            catch (IOException e) {
                GeneratedState<PlanState> generatedState = this.handleFailedRequestFromAIServer(e, false);
                return generatedState;
            }
            catch (CodedRuntimeException e) {
                GeneratedState<PlanState> generatedState = this.handleFailedRequestFromAIServer((Exception)((Object)e), true);
                return generatedState;
            }
            finally {
                NDC.pop();
            }
        }

        private PlanBackendQueryBase createFlowGenerationPlanQuery(String query, List<AIGenerationService.AIDatasetInformation> datasetsInformation) throws IOException {
            PlanBackendQueryBase ret = new PlanBackendQueryBase();
            ret.conversationHistory = AIFlowGenerationService.this.assistantStateEditor.sanitizeConversationForLlm(this.projectKey, this.resultState.conversation.messages);
            ret.conversationHistory = ret.conversationHistory.subList(0, ret.conversationHistory.size() - 1);
            ret.query = AIFlowGenerationService.this.assistantStateEditor.sanitizeQueryForLlm(this.projectKey, query);
            LicenseStatusService.LicensingStatus ls = AIFlowGenerationService.this.licenseStatusService.getLicensingStatus();
            ret.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
            ret.conversationId = this.resultState.conversation.id;
            ret.datasetsInformation = datasetsInformation;
            ret.datasetsContext = new ArrayList<String>();
            if (this.resultState.datasetsContext != null && !this.resultState.datasetsContext.isEmpty()) {
                ret.datasetsContext.addAll(this.resultState.datasetsContext.stream().map(datasetContext -> datasetContext.datasetId).toList());
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GeneratedState<PlanState> requestAIServerBackendAndProcessResponse(PlanBackendQueryBase flowGenerationPlanQuery) throws IOException, DKUSecurityException {
            GeneratedState<PlanState> planGeneration;
            String requestId = null;
            Optional<Object> error = Optional.empty();
            try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);){
                HttpPost postObject = apiClient.createPostObject("/text2flow/plan", (Object)flowGenerationPlanQuery);
                AIFlowGenerationService.this.currentRequests.put(this.jobId, postObject);
                BackendResponse resp = (BackendResponse)apiClient.executePostObject(postObject, (TypeToken)new TypeToken<BackendResponse<PlanState>>(){});
                logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                requestId = resp.requestId;
                GeneratedState stateGeneration = resp.result;
                planGeneration = !stateGeneration.ok ? this.handleWarningFromAIServer(stateGeneration.displayableErrorMsg, "AI flow generation was not able to suggest a valid plan") : GeneratedState.success((PlanState)resp.result.state);
            }
            catch (DKUSecurityException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                planGeneration = this.handleFailedGenerationOverridingMessage("Configuration error while connecting to AI server", e, false);
            }
            catch (Exception e) {
                planGeneration = this.handleFailedGenerationOverridingMessage("AI plan generation failed", e, true);
            }
            finally {
                AIFlowGenerationService.this.currentRequests.remove(this.jobId);
            }
            if (planGeneration.displayableErrorMsg != null) {
                error = Optional.of("Error: " + planGeneration.displayableErrorMsg);
            }
            if (planGeneration.state != null && ((PlanState)planGeneration.state).plan != null) {
                ((PlanState)planGeneration.state).plan.requestId = requestId;
            }
            AIFeaturesUtil.logValidation(requestId, error.orElse(""), this.licensingStatus, this.aiDrivenAnalyticsSettings.telemetryEnabled, this.featureName, planGeneration.ok, this.generalSettings);
            return planGeneration;
        }

        private static /* synthetic */ boolean lambda$compute$1(AIGenerationService.AIDatasetInformation dataset) {
            return !dataset.ok;
        }

        private /* synthetic */ void lambda$compute$0() {
            List<Message> messages = this.resultState.conversation.messages;
            for (int i = messages.size() - 1; i >= 0; --i) {
                if (messages.get((int)i).role != Message.MessageRole.USER) continue;
                messages.remove(i);
                break;
            }
            if (!messages.isEmpty() && messages.get((int)(messages.size() - 1)).plan != null) {
                messages.add(new Message(Message.MessageRole.AUTOMATIC, AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.MESSAGE.CONFIRM_PLAN", "If you're happy with the plan, click Generate. Otherwise, describe the changes you'd like.", new Object[0])));
            }
            this.onAbort(AIFlowAssistantState.Phase.PLAN_CREATION, AIFlowAssistantState.Action.CHAT_WAIT);
        }
    }

    @UIModel
    public static class AIFlowAssistantState {
        public Conversation conversation;
        public Plan plan;
        @Nullable
        CurrentTask task;
        List<DatasetContext> datasetsContext;
        public Action action;
        public boolean canRevert;
        public List<String> errorMessages;
        public List<String> warningMessages;
        @Nullable
        String jobId;

        public AIFlowAssistantState() {
            this.conversation = new Conversation();
            this.plan = new Plan();
            this.task = null;
            this.datasetsContext = new ArrayList<DatasetContext>();
            this.action = Action.CHAT_WAIT;
            this.canRevert = false;
            this.errorMessages = new ArrayList<String>();
            this.warningMessages = new ArrayList<String>();
        }

        public AIFlowAssistantState(AIFlowAssistantState stateToClone) {
            this.conversation = new Conversation(stateToClone.conversation);
            this.plan = new Plan(stateToClone.plan);
            this.task = stateToClone.task != null ? new CurrentTask(stateToClone.task) : null;
            this.datasetsContext = stateToClone.datasetsContext.stream().map(DatasetContext::new).collect(Collectors.toCollection(ArrayList::new));
            this.action = stateToClone.action;
            this.canRevert = stateToClone.canRevert;
            this.errorMessages = new ArrayList<String>(stateToClone.errorMessages);
            this.warningMessages = new ArrayList<String>(stateToClone.warningMessages);
            this.jobId = stateToClone.jobId;
        }

        public static enum Action {
            CHAT_WAIT,
            CHAT_THINK,
            TASK_EXECUTE,
            DONE,
            FAILED,
            ABORTED;

        }

        public static enum Phase {
            PLAN_CREATION,
            PLAN_EXECUTION;

        }
    }

    private class AIFlowGenerationExecutionThread
    extends AIFlowGenerationThread<AIFlowAssistantState> {
        Optional<String> runJobId;

        public AIFlowGenerationExecutionThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String projectKey, AIFlowAssistantState state) {
            super(owner, licensingStatus, projectKey, "text2flow/execute", "text2flow_execution", state, new ArrayList<DatasetContext>());
            this.runJobId = Optional.empty();
        }

        @Override
        protected AIFlowAssistantState compute() throws Exception {
            this.checkUserCanUseAIFlowGeneration();
            try {
                AIFlowAssistantState aIFlowAssistantState;
                block17: {
                    FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(() -> {
                        this.runJobId.ifPresent(id -> AIFlowGenerationService.this.flowExecutionService.abort_NT(this.owner, this.projectKey, (String)id));
                        this.resultState.canRevert = true;
                        this.onAbort(AIFlowAssistantState.Phase.PLAN_EXECUTION, AIFlowAssistantState.Action.ABORTED);
                    });
                    try {
                        this.resultState.jobId = this.jobId;
                        if (!List.of(AIFlowAssistantState.Action.TASK_EXECUTE, AIFlowAssistantState.Action.FAILED).contains((Object)this.resultState.action)) {
                            throw new IllegalArgumentException("Not executing a task");
                        }
                        if (this.resultState.plan.tasks.isEmpty()) {
                            this.resultState.conversation.messages.add(new Message(Message.MessageRole.ASSISTANT, this.resultState.plan.explanation));
                        } else {
                            this.executePlan();
                        }
                        AIFlowAssistantState workingState = new AIFlowAssistantState(this.resultState);
                        workingState.task = null;
                        workingState.action = AIFlowAssistantState.Action.DONE;
                        workingState.canRevert = true;
                        if (!this.isAborted()) {
                            this.resultState = workingState;
                        }
                        aIFlowAssistantState = this.resultState;
                        if (ignored == null) break block17;
                    }
                    catch (Throwable workingState) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable) {
                                    workingState.addSuppressed(throwable);
                                }
                            }
                            throw workingState;
                        }
                        catch (Exception e) {
                            this.resultState.action = this.isAborted() ? AIFlowAssistantState.Action.ABORTED : AIFlowAssistantState.Action.FAILED;
                            this.resultState.canRevert = true;
                            String errorType = "AI flow generation plan execution failed";
                            String errorDetails = Optional.ofNullable(e.getMessage()).orElse(e.getClass().getSimpleName());
                            if (this.resultState.task != null && StringUtils.isEmpty((String)this.resultState.task.errorMessage)) {
                                this.resultState.task.errorMessage = errorType + ": " + errorDetails;
                            }
                            logger.error((Object)errorType, (Throwable)e);
                            throw new AIFlowGenerationException(errorType, errorDetails);
                        }
                    }
                    ignored.close();
                }
                return aIFlowAssistantState;
            }
            finally {
                if (!this.isAborted()) {
                    this.resultState.jobId = null;
                    AIFlowGenerationService.this.setAIFlowAssistantStateAndNotify(this.lang, this.owner, this.projectKey, this.resultState, true, null);
                }
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_flow_generation", (String)"AI Flow Generation");
        }

        private void executePlan() throws Exception {
            AIFlowAssistantState workingState = new AIFlowAssistantState(this.resultState);
            workingState.action = AIFlowAssistantState.Action.TASK_EXECUTE;
            if (workingState.task == null) {
                throw new IllegalArgumentException("Undefined current task");
            }
            while (workingState.task.index < workingState.plan.tasks.size()) {
                Iterator<CurrentTask.Action> actionIterator = CurrentTask.Action.getIterator(workingState.task.action);
                boolean refreshFlow = false;
                block7: while (actionIterator.hasNext()) {
                    workingState.task.action = actionIterator.next();
                    logger.debug((Object)("Executing task index " + workingState.task.index + " action " + String.valueOf((Object)workingState.task.action)));
                    this.resultState = new AIFlowAssistantState(workingState);
                    AIFlowGenerationService.this.setAIFlowAssistantStateAndNotify(this.lang, this.owner, this.projectKey, this.resultState, refreshFlow, null);
                    switch (workingState.task.action) {
                        case TASK_GENERATE: {
                            Task currentTask = workingState.plan.tasks.get(workingState.task.index);
                            List<DatasetContext> inputContext = currentTask.inputDatasetNames.stream().map(DatasetContext::new).toList();
                            AIFlowGenerationThread.DatasetResolutionResult inputResolution = this.resolveDatasetsContext(inputContext);
                            if (!inputResolution.removedDatasetIds().isEmpty()) {
                                String missingIds = String.join((CharSequence)", ", inputResolution.removedDatasetIds());
                                String error = "Some input datasets were removed: [" + missingIds + "]. Please ensure these datasets are available before retrying. Or generate a new plan";
                                workingState.task.action = CurrentTask.Action.TASK_GENERATE_FAILED;
                                workingState.task.errorMessage = error;
                                this.resultState.task = workingState.task;
                                throw new AIFlowGenerationException("Task Generation failed", error);
                            }
                            List<Dataset> datasetList = inputResolution.datasets();
                            List<AIGenerationService.AIDatasetInformation> datasetInformations = this.getDatasetsInformation(datasetList, "");
                            List<AIGenerationService.AIDatasetInformation> datasetWithNoSchema = datasetInformations.stream().filter(dataset -> !dataset.ok).toList();
                            if (!datasetWithNoSchema.isEmpty()) {
                                String error = this.getNoSchemaMessage(datasetWithNoSchema);
                                workingState.task.action = CurrentTask.Action.TASK_GENERATE_FAILED;
                                workingState.task.errorMessage = error;
                                this.resultState.task = workingState.task;
                                throw new AIFlowGenerationException("Task Generation failed", error);
                            }
                            GeneratedState<AICapability.CapabilityCreationSettings> creationSettingsGeneration = this.generateTask(currentTask, datasetList, datasetInformations);
                            if (!creationSettingsGeneration.ok) {
                                workingState.task.action = CurrentTask.Action.TASK_GENERATE_FAILED;
                                workingState.task.errorMessage = creationSettingsGeneration.displayableErrorMsg;
                                this.resultState.task = workingState.task;
                                throw new AIFlowGenerationException("Task Generation failed", creationSettingsGeneration.displayableErrorMsg);
                            }
                            workingState.task.creationSettings = (AICapability.CapabilityCreationSettings)creationSettingsGeneration.state;
                            Map<String, String> renamedOutputDatasets = Objects.requireNonNull(workingState.task.creationSettings).renamedOutputDatasets;
                            if (!renamedOutputDatasets.isEmpty()) {
                                workingState = AIFlowGenerationService.this.assistantStateEditor.renameDatasets(workingState, workingState.task.index, renamedOutputDatasets);
                            }
                            refreshFlow = false;
                            break;
                        }
                        case TASK_CREATE: {
                            GeneratedState<AICapability.CapabilityCreationResponse> creationGeneration = this.createTask(workingState.task.creationSettings);
                            workingState.task.creationResponse = (AICapability.CapabilityCreationResponse)creationGeneration.state;
                            workingState.plan.tasks.get((int)workingState.task.index).creationResponse = (AICapability.CapabilityCreationResponse)creationGeneration.state;
                            if (!creationGeneration.ok) {
                                workingState.task.action = CurrentTask.Action.TASK_CREATE_FAILED;
                                workingState.task.errorMessage = creationGeneration.displayableErrorMsg;
                                this.resultState.task = workingState.task;
                                throw new AIFlowGenerationException("Task Creation failed", creationGeneration.displayableErrorMsg);
                            }
                            workingState.task.creationSettings = null;
                            refreshFlow = true;
                            break;
                        }
                        case TASK_RUN: {
                            GeneratedState<Void> runStatus = this.runCapability(workingState.task.creationResponse);
                            if (!runStatus.ok) {
                                workingState.task.action = CurrentTask.Action.TASK_RUN_FAILED;
                                workingState.task.errorMessage = runStatus.displayableErrorMsg;
                                this.resultState.task = workingState.task;
                                throw new AIFlowGenerationException("Task Run failed", runStatus.displayableErrorMsg);
                            }
                            workingState.task.creationResponse = null;
                            refreshFlow = true;
                            break;
                        }
                        case TASK_CREATE_FAILED: 
                        case TASK_RUN_FAILED: 
                        case TASK_DONE: {
                            continue block7;
                        }
                        default: {
                            throw new RuntimeException("Invalid current task action " + String.valueOf((Object)workingState.task.action));
                        }
                    }
                    if (!this.isAborted()) continue;
                    if (workingState.task.action == CurrentTask.Action.TASK_CREATE) {
                        this.resultState.task = workingState.task;
                        this.resultState.task.action = actionIterator.next();
                        AIFlowGenerationService.this.setAIFlowAssistantStateAndNotify(this.lang, this.owner, this.projectKey, this.resultState, refreshFlow, null);
                    }
                    return;
                }
                ++workingState.task.index;
                workingState.task.action = CurrentTask.Action.TASK_GENERATE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GeneratedState<AICapability.CapabilityCreationSettings> generateTask(Task task, List<Dataset> datasets, List<AIGenerationService.AIDatasetInformation> datasetInformations) throws DKUSecurityException {
            NDC.push((String)"ai-flowgenerationexecute");
            try {
                ExecutionBackendQueryBase executeQuery = this.createFlowGenerationExecuteQuery(task, datasetInformations);
                GeneratedState<AICapability.CapabilityCreationSettings> generatedState = this.requestAIServerBackendAndProcessResponse(datasets, executeQuery);
                return generatedState;
            }
            catch (IOException e) {
                GeneratedState<AICapability.CapabilityCreationSettings> generatedState = this.handleFailedRequestFromAIServer(e, false);
                return generatedState;
            }
            catch (CodedRuntimeException e) {
                GeneratedState<AICapability.CapabilityCreationSettings> generatedState = this.handleFailedRequestFromAIServer((Exception)((Object)e), true);
                return generatedState;
            }
            finally {
                NDC.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneratedState<AICapability.CapabilityCreationResponse> createTask(AICapability.CapabilityCreationSettings settings) {
            NDC.push((String)"ai-flowgenerationcreate");
            try {
                GeneratedState<AICapability.CapabilityCreationResponse> generatedState;
                if (settings == null) {
                    GeneratedState<AICapability.CapabilityCreationResponse> generatedState2 = GeneratedState.externalFailure("No creation settings found");
                    return generatedState2;
                }
                AICapability capability = AiCapabilityFactory.get(settings.capabilityId);
                AICapability.CapabilityCreationResponse resp = capability.create(this.owner, settings);
                LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem> toAddToDeletionList = new LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
                ITaggingService.TaggableType type = ITaggingService.TaggableType.valueOf(settings.capabilityId);
                if (type == ITaggingService.TaggableType.RECIPE) {
                    type = ITaggingService.TaggableType.DATASET;
                    for (String outputDatasetName : settings.outputDatasetNames) {
                        TaggableObjectsDeletionService.DeletionRequestItem item = new TaggableObjectsDeletionService.DeletionRequestItem(this.projectKey, type, outputDatasetName);
                        item.displayName = outputDatasetName;
                        item.options.dropData = true;
                        item.options.dropMetastoreTable = true;
                        toAddToDeletionList.add(item);
                    }
                } else {
                    TaggableObjectsDeletionService.DeletionRequestItem item = new TaggableObjectsDeletionService.DeletionRequestItem(this.projectKey, type, resp.id);
                    item.displayName = resp.id;
                    toAddToDeletionList.add(item);
                }
                try (RWTransaction t = AIFlowGenerationService.this.aiAssistantTransactionService.beginWrite(this.owner);){
                    AIFlowGenerationService.this.aiAssistantsDAO.appendAIGeneratedObjects((RWTransactionRef)t, this.projectKey, this.resultState.conversation.id, toAddToDeletionList);
                    t.commit("Saved AI-generated objects for " + this.projectKey);
                }
                if (resp.error != null) {
                    generatedState = GeneratedState.externalFailure(resp.error);
                    return generatedState;
                }
                generatedState = GeneratedState.success(resp);
                return generatedState;
            }
            catch (Exception e) {
                GeneratedState<AICapability.CapabilityCreationResponse> generatedState = GeneratedState.exception(e);
                return generatedState;
            }
            finally {
                NDC.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GeneratedState<Void> runCapability(AICapability.CapabilityCreationResponse creation) {
            GeneratedState<Void> generatedState;
            NDC.push((String)"ai-flowgenerationrun");
            try {
                if (creation == null) {
                    GeneratedState<Void> generatedState2 = GeneratedState.externalFailure("No creation settings found");
                    return generatedState2;
                }
                AICapability capability = AiCapabilityFactory.get(creation.capabilityTypeId);
                this.runJobId = capability.run(this.owner, this.projectKey, creation.id);
                if (this.runJobId.isPresent()) {
                    EnhancedSerializedJobStatus status = AIFlowGenerationService.this.flowExecutionService.waitUntilFinished_NT(this.projectKey, this.runJobId.get());
                    if (!List.of(JobState.DONE, JobState.ABORTED).contains((Object)status.baseStatus.state)) {
                        GeneratedState<Void> generatedState3 = GeneratedState.externalFailure(status.errorMessage);
                        return generatedState3;
                    }
                }
                generatedState = GeneratedState.success(null);
                return generatedState;
            }
            catch (Exception e) {
                generatedState = GeneratedState.exception(e);
                return generatedState;
            }
            finally {
                NDC.pop();
            }
        }

        private ExecutionBackendQueryBase createFlowGenerationExecuteQuery(Task task, List<AIGenerationService.AIDatasetInformation> datasetInformations) {
            ExecutionBackendQueryBase ret = new ExecutionBackendQueryBase();
            ret.task = task;
            LicenseStatusService.LicensingStatus ls = AIFlowGenerationService.this.licenseStatusService.getLicensingStatus();
            ret.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
            ret.datasetsInformation = datasetInformations;
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GeneratedState<AICapability.CapabilityCreationSettings> requestAIServerBackendAndProcessResponse(List<Dataset> datasets, ExecutionBackendQueryBase flowGenerationExecuteQuery) throws IOException, DKUSecurityException {
            GeneratedState<AICapability.CapabilityCreationSettings> creationSettingsGeneration;
            String requestId = null;
            Optional<Object> error = Optional.empty();
            try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);){
                HttpPost postObject = apiClient.createPostObject("/text2flow/execute", (Object)flowGenerationExecuteQuery);
                AIFlowGenerationService.this.currentRequests.put(this.jobId, postObject);
                BackendResponse resp = (BackendResponse)apiClient.executePostObject(postObject, (TypeToken)new TypeToken<BackendResponse<CapabilityState>>(){});
                logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                requestId = resp.requestId;
                GeneratedState<CapabilityState> stateGeneration = resp.result;
                creationSettingsGeneration = !stateGeneration.ok ? this.handleWarningFromAIServer(stateGeneration.displayableErrorMsg, "AI flow generation was not able to execute the plan") : GeneratedState.success(this.getCapabilityCreationSettings(datasets, stateGeneration, this.lang));
            }
            catch (DKUSecurityException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                creationSettingsGeneration = this.handleFailedGenerationOverridingMessage("Configuration error while connecting to AI server", e, false);
            }
            catch (Exception e) {
                creationSettingsGeneration = this.handleFailedGenerationOverridingMessage("AI plan execution failed", e, true);
            }
            finally {
                AIFlowGenerationService.this.currentRequests.remove(this.jobId);
            }
            if (creationSettingsGeneration.displayableErrorMsg != null) {
                error = Optional.of("Error: " + creationSettingsGeneration.displayableErrorMsg);
            }
            if (creationSettingsGeneration.state != null) {
                ((AICapability.CapabilityCreationSettings)creationSettingsGeneration.state).requestId = requestId;
            }
            AIFeaturesUtil.logValidation(requestId, error.orElse(""), this.licensingStatus, this.aiDrivenAnalyticsSettings.telemetryEnabled, this.featureName, creationSettingsGeneration.ok, this.generalSettings);
            return creationSettingsGeneration;
        }

        private AICapability.CapabilityCreationSettings getCapabilityCreationSettings(List<Dataset> datasets, GeneratedState<CapabilityState> stateGeneration, String lang) throws Exception {
            if (stateGeneration.state == null) {
                throw new AICapability.AICapabilityServerException("Missing capability state", "AI execution was not able to generate a capability state");
            }
            AICapability capability = AiCapabilityFactory.get(((CapabilityState)stateGeneration.state).capabilityId);
            return capability.getCreationSettings(this.owner, (CapabilityState)stateGeneration.state, this.projectKey, lang, datasets);
        }
    }

    public static class AIGeneratedObjects {
        public Map<String, LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>> objectsToDeleteByConversationId = new LinkedHashMap<String, LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AIGeneratedObjects that = (AIGeneratedObjects)o;
            return Objects.equals(this.objectsToDeleteByConversationId, that.objectsToDeleteByConversationId);
        }

        public int hashCode() {
            return Objects.hashCode(this.objectsToDeleteByConversationId);
        }
    }

    @UIModel
    public static class Plan {
        public String explanation;
        public List<Task> tasks;
        String requestId = "";
        public PlanFeedbacks planFeedbacks;

        public Plan() {
            this.explanation = "";
            this.tasks = new ArrayList<Task>();
            this.planFeedbacks = new PlanFeedbacks();
        }

        public Plan(Plan planToClone) {
            this.explanation = planToClone.explanation;
            this.tasks = planToClone.tasks.stream().map(Task::new).collect(Collectors.toCollection(ArrayList::new));
            this.requestId = planToClone.requestId;
            this.planFeedbacks = new PlanFeedbacks(planToClone.planFeedbacks);
        }
    }

    private record TranslationKey(String key, String defaultTranslation) {
    }

    private abstract class AIFlowGenerationThread<T>
    extends SimpleFutureThread<T> {
        protected final LicenseStatusService.LicensingStatus licensingStatus;
        protected final GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings;
        protected final GeneralSettingsDAO.GeneralSettings generalSettings;
        protected final String projectKey;
        private final String endpointName;
        protected final String featureName;
        protected final String lang;
        protected AIFlowAssistantState resultState;
        List<DatasetContext> additionalContext;

        public AIFlowGenerationThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String projectKey, String endpointName, String featureName, AIFlowAssistantState state, List<DatasetContext> additionalContext) {
            super(owner);
            this.licensingStatus = licensingStatus;
            this.aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.projectKey = projectKey;
            this.endpointName = endpointName;
            this.featureName = featureName;
            this.resultState = state;
            this.additionalContext = additionalContext;
            try (Transaction t = AIFlowGenerationService.this.transactionService.beginRead();){
                this.lang = AIFlowGenerationService.this.userSettingsService.getLangForUser(owner.getIdentifier());
            }
        }

        protected String getNoSchemaMessage(List<AIGenerationService.AIDatasetInformation> datasetsWithNoSchema) {
            boolean isPlural = datasetsWithNoSchema.size() != 1;
            String datasetNames = datasetsWithNoSchema.stream().map(dataset -> dataset.name).collect(Collectors.joining(", "));
            if (isPlural) {
                return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.DATASET_NO_SCHEMA.PLURAL", "Datasets {{datasetNames}} have no schema, please build them or define their schema", "datasetNames", datasetNames);
            }
            return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.DATASET_NO_SCHEMA.SINGULAR", "Dataset {{datasetName}} has no schema, please build it or define its schema", "datasetName", datasetsWithNoSchema.get((int)0).name);
        }

        protected String getDatasetsRemovedMessage(List<String> removedDatasets) {
            boolean isPlural = removedDatasets.size() != 1;
            String datasetNames = String.join((CharSequence)", ", removedDatasets);
            if (isPlural) {
                return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.MESSAGE.DATASETS_REMOVED_FROM_CONTEXT.PLURAL", "Datasets {{datasetNames}} don't exist in your project, they have been removed from your context, trying to generate the plan without them", "datasetNames", datasetNames);
            }
            return AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.MESSAGE.DATASETS_REMOVED_FROM_CONTEXT.SINGULAR", "Dataset {{datasetName}} doesn't exist in your project, it has been removed from your context, trying to generate the plan without it", "datasetName", removedDatasets.get(0));
        }

        protected void onAbort(AIFlowAssistantState.Phase phaseName, AIFlowAssistantState.Action actionWhenAborted) {
            logger.info((Object)("AI flow generation " + String.valueOf((Object)phaseName) + " aborted"));
            this.resultState.action = actionWhenAborted;
            this.resultState.jobId = null;
            try {
                AIFlowGenerationService.this.setAIFlowAssistantStateAndNotify(this.lang, this.owner, this.projectKey, this.resultState, true, null);
                HttpPost pm = AIFlowGenerationService.this.currentRequests.get(this.jobId);
                if (pm != null) {
                    pm.abort();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to notify AI flow generation " + String.valueOf((Object)phaseName) + " abortion"), (Throwable)e);
            }
        }

        protected DatasetResolutionResult resolveDatasetsContext(List<DatasetContext> datasetsContext) throws IOException, DKUSecurityException {
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            ArrayList<String> removedDatasetIds = new ArrayList<String>();
            ArrayList<DatasetContext> validDatasetContext = new ArrayList<DatasetContext>();
            try (Transaction t = AIFlowGenerationService.this.transactionService.beginRead();){
                for (DatasetContext contextDataset : datasetsContext) {
                    String contextDatasetId = contextDataset.datasetId;
                    DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(this.projectKey, contextDatasetId);
                    AIFlowGenerationService.this.projectsService.failIfNoDatasetReadUseAccess(this.owner, datasetLoc, this.projectKey);
                    Dataset d = AIFlowGenerationService.this.datasetAccessService.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (d == null) {
                        logger.warn((Object)("Removing dataset [" + contextDatasetId + "] from Flow Assistant context"));
                        removedDatasetIds.add(contextDatasetId);
                        continue;
                    }
                    validDatasetContext.add(contextDataset);
                    datasets.add(d);
                }
            }
            return new DatasetResolutionResult(datasets, validDatasetContext, removedDatasetIds);
        }

        protected List<AIGenerationService.AIDatasetInformation> getDatasetsInformation(List<Dataset> datasets, String query) {
            Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap = AIFlowGenerationService.this.aiGenerationService.getDatasetNameToTWRMap(this.owner, this.projectKey, datasets);
            return AIFlowGenerationService.this.aiGenerationService.getDatasetsInformation(this.projectKey, datasets, query, datasetNameToTWRMap);
        }

        protected <U> GeneratedState<U> handleFailedRequestFromAIServer(Exception e, boolean isErrorMessageIncluded) {
            String error = "Exception while getting response from " + this.endpointName;
            logger.error((Object)error, (Throwable)e);
            AIFeaturesUtil.logValidation(null, e.getMessage(), this.licensingStatus, this.aiDrivenAnalyticsSettings.telemetryEnabled, this.featureName, false, this.generalSettings);
            return GeneratedState.exception(e, error + (String)(isErrorMessageIncluded ? ": " + e.getMessage() : ""));
        }

        protected <U> GeneratedState<U> handleFailedGenerationOverridingMessage(String errorMessage, Exception e, boolean includeMessage) {
            logger.error((Object)errorMessage, (Throwable)e);
            String overrideMessage = errorMessage + (String)(includeMessage ? ": " + e.getMessage() : "");
            return GeneratedState.exception(e, overrideMessage);
        }

        protected <U> GeneratedState<U> handleWarningFromAIServer(String errorMessage, String warningMessage) {
            logger.warn((Object)warningMessage);
            return GeneratedState.externalFailure(errorMessage);
        }

        protected void checkUserCanUseAIFlowGeneration() {
            LicenseStatusService.LicensingStatus ls = AIFlowGenerationService.this.licenseStatusService.getLicensingStatus();
            if (ls == null || ls.community) {
                throw new IllegalArgumentException(AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.NOT_AVAILABLE_FREE_EDITION", "AI Assistants are not available with Dataiku Free Edition", new Object[0]));
            }
            if (!this.aiDrivenAnalyticsSettings.enabled) {
                throw new IllegalStateException(AIFlowGenerationService.this.translationService.translateNoContext(this.lang, "AIFLOW_GENERATION.ERROR.NOT_ENABLED", "AI Assistants are not enabled", new Object[0]));
            }
        }

        record DatasetResolutionResult(List<Dataset> datasets, List<DatasetContext> validDatasetContext, List<String> removedDatasetIds) {
        }
    }

    @UIModel
    public static final class DatasetContext {
        public String datasetId;
        public String domId;

        public DatasetContext(DatasetContext contextToClone) {
            this.datasetId = contextToClone.datasetId;
            this.domId = contextToClone.domId;
        }

        public DatasetContext(String datasetId) {
            this.datasetId = datasetId;
            this.domId = null;
        }
    }

    @UIModel
    public static final class CurrentTask {
        public int index;
        public Action action;
        @Nullable
        public AICapability.CapabilityCreationSettings creationSettings;
        @Nullable
        public AICapability.CapabilityCreationResponse creationResponse;
        @Nullable
        public String errorMessage;

        public CurrentTask(CurrentTask taskToClone) {
            this.index = taskToClone.index;
            this.action = taskToClone.action;
            this.creationSettings = taskToClone.creationSettings;
            this.creationResponse = taskToClone.creationResponse;
            this.errorMessage = taskToClone.errorMessage;
        }

        public static enum Action {
            TASK_GENERATE,
            TASK_CREATE,
            TASK_RUN,
            TASK_DONE,
            TASK_GENERATE_FAILED,
            TASK_CREATE_FAILED,
            TASK_RUN_FAILED;


            public static Iterator<Action> getIterator(Action fromAction) {
                return new ActionIterator(fromAction);
            }

            private static class ActionIterator
            implements Iterator<Action> {
                private Action current;

                ActionIterator(Action initAction) {
                    this.current = initAction;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public Action next() {
                    Action action = this.current;
                    switch (this.current) {
                        case TASK_GENERATE: {
                            this.current = TASK_CREATE;
                            break;
                        }
                        case TASK_CREATE: 
                        case TASK_CREATE_FAILED: 
                        case TASK_RUN_FAILED: {
                            this.current = TASK_RUN;
                            break;
                        }
                        case TASK_RUN: {
                            this.current = TASK_DONE;
                            break;
                        }
                        case TASK_DONE: 
                        case TASK_GENERATE_FAILED: {
                            this.current = null;
                            break;
                        }
                        default: {
                            throw new NoSuchElementException();
                        }
                    }
                    return action;
                }
            }
        }
    }

    @UIModel
    public static final class Conversation {
        public String id;
        List<Message> messages;

        public Conversation() {
            this.id = UUID.randomUUID().toString();
            this.messages = new ArrayList<Message>();
        }

        public Conversation(Conversation conversationToClone) {
            this.id = conversationToClone.id;
            this.messages = conversationToClone.messages.stream().map(Message::new).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    @UIModel
    public static final class Message {
        public final String id;
        public final Long timestamp;
        public final MessageRole role;
        @Nullable
        public String content;
        @Nullable
        public List<Task> plan;

        @VisibleForTesting
        Message(String id, Long timestamp, MessageRole role, @Nullable String content, @Nullable List<Task> plan) {
            this.id = id;
            this.timestamp = timestamp;
            this.role = role;
            this.content = content;
            this.plan = plan;
        }

        private Message(MessageRole role, @Nullable String content, @Nullable List<Task> plan) {
            this(UUID.randomUUID().toString(), System.currentTimeMillis(), role, content, plan);
        }

        public Message(MessageRole role, String content) {
            this(role, content, null);
        }

        public Message(List<Task> plan) {
            this(MessageRole.ASSISTANT, null, plan);
        }

        public Message(Message messageToClone) {
            this(messageToClone.id, messageToClone.timestamp, messageToClone.role, messageToClone.content, messageToClone.plan);
        }

        public static enum MessageRole {
            ASSISTANT,
            USER,
            AUTOMATIC;

        }
    }

    public static class ExecutionBackendQueryBase {
        String licenseId;
        Task task;
        List<AIGenerationService.AIDatasetInformation> datasetsInformation;
    }

    public static class PlanBackendQueryBase {
        String licenseId;
        String conversationId;
        List<Message> conversationHistory;
        String query;
        List<AIGenerationService.AIDatasetInformation> datasetsInformation;
        List<String> datasetsContext;
    }

    public static class BackendResponse<T> {
        public String requestId;
        public GeneratedState<T> result;
    }

    public static class GeneratedState<T> {
        public final boolean ok;
        @Nullable
        public final Exception exception;
        @Nullable
        public final String displayableErrorMsg;
        @Nullable
        public final T state;

        public static <T> GeneratedState<T> success(T state) {
            return new GeneratedState<T>(state, null, null, true);
        }

        public static <T> GeneratedState<T> exception(Exception e) {
            return new GeneratedState<Object>(null, e, e.getMessage(), false);
        }

        public static <T> GeneratedState<T> exception(Exception e, String overrideErrorMessage) {
            return new GeneratedState<Object>(null, e, overrideErrorMessage, false);
        }

        public static <T> GeneratedState<T> externalFailure(String errorMessage) {
            return new GeneratedState<Object>(null, null, errorMessage, false);
        }

        private GeneratedState(T state, Exception exception, String displayableErrorMsg, boolean ok) {
            this.ok = ok;
            this.state = state;
            this.exception = exception;
            this.displayableErrorMsg = displayableErrorMsg;
        }
    }

    public static class CapabilityState {
        public String query;
        public CapabilityGeneration generationResult;
        public String capabilityId;
        public String capabilitySubtype;
    }

    public static class RunStatus {
        public JobState state;
        @Nullable
        public String error;
    }

    public static class CreationResponse {
        public String id;

        public CreationResponse(String id) {
            this.id = id;
        }
    }

    public static class CapabilityGeneration {
        public JsonObject config;
        public String raw_chain_response;
    }

    @UIModel
    public static class PlanState {
        @Nullable
        Plan plan;
        String conversationId = "";

        public PlanState(String conversationId, String message) {
            this.conversationId = conversationId;
            this.plan = new Plan();
            this.plan.explanation = message;
        }
    }

    @UIModel
    public static class PlanFeedbacks {
        public FeedbackStatus generateFeedback = FeedbackStatus.NONE;
        public FeedbackStatus executeFeedback = FeedbackStatus.NONE;

        public PlanFeedbacks() {
        }

        public PlanFeedbacks(PlanFeedbacks other) {
            if (other != null) {
                this.generateFeedback = other.generateFeedback;
                this.executeFeedback = other.executeFeedback;
            }
        }

        public static enum FeedbackStatus {
            NONE,
            BAD,
            GOOD,
            BAD_ONGOING;

        }
    }

    @UIModel
    public static class Task {
        public final String id;
        public String taskDescription;
        public List<String> inputDatasetNames;
        public List<String> outputDatasetNames;
        public String capabilityId;
        public String capabilitySubtype;
        @Nullable
        public AICapability.CapabilityCreationResponse creationResponse;

        private Task(String id, String taskDescription, List<String> inputDatasetNames, List<String> outputDatasetNames, String capabilityId, String capabilitySubtype, @Nullable AICapability.CapabilityCreationResponse creationResponse) {
            this.id = id;
            this.taskDescription = taskDescription;
            this.inputDatasetNames = inputDatasetNames;
            this.outputDatasetNames = outputDatasetNames;
            this.capabilityId = capabilityId;
            this.capabilitySubtype = capabilitySubtype;
            this.creationResponse = creationResponse;
        }

        public Task() {
            this(UUID.randomUUID().toString(), null, null, null, null, null, null);
        }

        public Task(Task taskToClone) {
            this(taskToClone.id, taskToClone.taskDescription, taskToClone.inputDatasetNames, taskToClone.outputDatasetNames, taskToClone.capabilityId, taskToClone.capabilitySubtype, taskToClone.creationResponse);
        }
    }

    public static class AIFlowGenerationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String message;

        public AIFlowGenerationException(String type, String message) {
            super(message);
            this.type = type;
            this.message = message;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

