/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class AIFlowPlanEditor {
    private final TransactionService transactionService;
    private final DatasetsDAO datasetsDAO;
    private final ProjectsService projectsService;

    @Autowired
    public AIFlowPlanEditor(TransactionService transactionService, DatasetsDAO datasetsDAO, ProjectsService projectsService) {
        this.transactionService = transactionService;
        this.datasetsDAO = datasetsDAO;
        this.projectsService = projectsService;
    }

    public List<AIFlowGenerationService.Message> sanitizeConversationForLlm(String projectKey, List<AIFlowGenerationService.Message> messages) {
        Pattern datasetMentionPattern = this.buildDatasetMentionPattern(projectKey);
        return messages.stream().map(message -> AIFlowPlanEditor.cleanupDatasetMentions(message, datasetMentionPattern)).filter(m -> m.role != AIFlowGenerationService.Message.MessageRole.AUTOMATIC).toList();
    }

    public String sanitizeQueryForLlm(String projectKey, String query) {
        Pattern datasetMentionPattern = this.buildDatasetMentionPattern(projectKey);
        return datasetMentionPattern.matcher(query).replaceAll("$1");
    }

    private Pattern buildDatasetMentionPattern(String projectKey) {
        Pattern pattern;
        block8: {
            Transaction ignored = this.transactionService.beginRead();
            try {
                Stream<String> localDatasets = this.datasetsDAO.listUnsafe(projectKey).stream().map(SerializedDataset::getId);
                Stream<String> foreignDatasets = this.projectsService.getExposedDatasets(projectKey).stream().map(AnyLoc::getFullName);
                Stream<String> datasetNames = Stream.concat(localDatasets, foreignDatasets);
                pattern = Pattern.compile("(?<!\\w)@(%s)\\b".formatted(datasetNames.collect(Collectors.joining("|"))), 2);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed sanitizing conversation history", e);
                }
            }
            ignored.close();
        }
        return pattern;
    }

    private static AIFlowGenerationService.Message cleanupDatasetMentions(AIFlowGenerationService.Message message, Pattern datasetMentionPattern) {
        String content = message.content;
        if (content == null) {
            return message;
        }
        AIFlowGenerationService.Message copy = new AIFlowGenerationService.Message(message);
        copy.content = datasetMentionPattern.matcher(content).replaceAll("$1");
        return copy;
    }

    public AIFlowGenerationService.AIFlowAssistantState renameDatasets(AIFlowGenerationService.AIFlowAssistantState state, int fromIndex, Map<String, String> renameMappings) {
        AIFlowGenerationService.AIFlowAssistantState newState = new AIFlowGenerationService.AIFlowAssistantState(state);
        AIFlowPlanEditor.renameDatasetsFrom(newState.plan.tasks, fromIndex, renameMappings);
        AIFlowPlanEditor.renameDatasetsFrom(AIFlowPlanEditor.findAssistantPlan(newState), fromIndex, renameMappings);
        return newState;
    }

    private static void renameDatasetsFrom(List<AIFlowGenerationService.Task> tasks, int fromIndex, Map<String, String> renameMappings) {
        for (int i = fromIndex; i < tasks.size(); ++i) {
            AIFlowGenerationService.Task task = tasks.get(i);
            if (i > fromIndex) {
                task.inputDatasetNames = AIFlowPlanEditor.applyRenames(task.inputDatasetNames, renameMappings);
            }
            task.outputDatasetNames = AIFlowPlanEditor.applyRenames(task.outputDatasetNames, renameMappings);
        }
    }

    private static List<String> applyRenames(List<String> names, Map<String, String> renameMappings) {
        return names.stream().map(name -> renameMappings.getOrDefault(name, (String)name)).toList();
    }

    private static List<AIFlowGenerationService.Task> findAssistantPlan(AIFlowGenerationService.AIFlowAssistantState state) {
        List<AIFlowGenerationService.Message> messages = state.conversation.messages;
        AIFlowGenerationService.Message lastAssistantMessage = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            if (messages.get((int)i).role != AIFlowGenerationService.Message.MessageRole.ASSISTANT) continue;
            lastAssistantMessage = messages.get(i);
            break;
        }
        if (lastAssistantMessage == null || lastAssistantMessage.plan == null) {
            throw new AIFlowGenerationService.AIFlowGenerationException("Task Run failed", "Expected the last assistant message to exist and contain a plan");
        }
        return lastAssistantMessage.plan;
    }
}

