/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class BackendNameExtractorJson
implements ModelExtractor<String> {
    private final String jsonPath;
    private final JsonPath compiled;

    public BackendNameExtractorJson(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            String modelBackendName = (String)documentContext.read(this.compiled);
            if (modelBackendName != null) {
                for (BackendName backendName : BackendName.values()) {
                    if (!backendName.name().equals(modelBackendName)) continue;
                    return backendName.getUserFriendlyName();
                }
                return modelBackendName;
            }
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }

    private static enum BackendName {
        PY_MEMORY("Python (in memory)"),
        MLLIB("Spark MLLib"),
        H2O("Sparkling Water (H2O)"),
        VERTICA("Vertica Advanced Analytics"),
        KERAS("Keras");

        private String userFriendlyName;

        private BackendName(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

