/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class TimeseriesAlgorithmCanScoreNewIdentifiersExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        PreTrainPredictionModelingParams.Algorithm algorithm = timeseriesModelDetails.modeling.algorithm;
        switch (algorithm) {
            case TRIVIAL_IDENTITY_TIMESERIES: 
            case SEASONAL_NAIVE: {
                return "Yes";
            }
            case AUTO_ARIMA: 
            case ARIMA: 
            case CROSTON: 
            case ETS: 
            case SEASONAL_LOESS: 
            case PROPHET: 
            case RIDGE_REGRESSION: 
            case RANDOM_FOREST_REGRESSION: 
            case XGBOOST_REGRESSION: 
            case LIGHTGBM_REGRESSION: {
                return "No";
            }
            case GLUONTS_NPTS_FORECASTER: 
            case GLUONTS_SIMPLE_FEEDFORWARD: 
            case GLUONTS_DEEPAR: 
            case GLUONTS_TRANSFORMER: 
            case GLUONTS_MQCNN: 
            case GLUONTS_TORCH_SIMPLE_FEEDFORWARD: 
            case GLUONTS_TORCH_DEEPAR: 
            case NHITS: 
            case TFT: {
                return "Yes";
            }
        }
        throw new IOException(String.format("Extractor '%s' does not support algorithms of type '%s'", new Object[]{this.getClass().getSimpleName(), algorithm}));
    }
}

