/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PartitionedExtractService;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.analysis.model.GridsearchData;
import com.dataiku.dip.analysis.model.KerasModelTrainingInfo;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.PreprocessingReport;
import com.dataiku.dip.analysis.model.core.CustomMetricFailure;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.CustomMetricSuccess;
import com.dataiku.dip.analysis.model.core.ModelCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.MultiCutCustomMetricSuccess;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.MulticlassModelPerf;
import com.dataiku.dip.analysis.model.prediction.OtherClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsAbsoluteImportance;
import com.dataiku.dip.analysis.model.prediction.PredictionIndividualExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionPartitionedModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionSubpopulation;
import com.dataiku.dip.analysis.model.prediction.PredictionSubpopulationModelPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedDeepHubPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesPredictionPermutationImportance;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.partitioning.StratifiedModelUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PredictionResultsReader {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.models.resultsreader");

    public static void addGridsearchData(PredictionModelSnippetData pms, ModelDetailsBase detail, FullModelId fmi) throws IOException {
        if (detail instanceof ClassicalPredictionModelDetails) {
            modelDetails = (ClassicalPredictionModelDetails)detail;
            pms.gridLength = modelDetails.modeling.gridLength;
            pms.pluginAlgoCustomGridSearch = modelDetails.modeling.pluginAlgoCustomGridSearch;
        } else if (detail instanceof TimeseriesForecastingModelDetails) {
            modelDetails = (TimeseriesForecastingModelDetails)detail;
            pms.gridLength = ((TimeseriesForecastingModelDetails)modelDetails).modeling.gridLength;
        } else if (detail instanceof CausalPredictionModelDetails) {
            pms.gridLength = ((CausalPredictionModelDetails)detail).modeling.gridLength;
        }
        if (fmi.getGridsearchScoresFile().exists()) {
            GridsearchData gsd = fmi.parseGridsearchScoresFile(GridsearchData.class);
            gsd.isFinalizing = fmi.hasSearchStopped();
            pms.gridsearchData = gsd;
        }
    }

    public static void addKerasModelTrainingInfo(PredictionModelSnippetData pms, FullModelId fmi) throws IOException {
        if (fmi.getKerasModelTrainingInfoFile().exists()) {
            KerasModelTrainingInfo mti = fmi.parseKerasModelTrainingInfoFile();
            mti.isFinalizing = fmi.hasSearchStopped();
            pms.modelTrainingInfo = mti;
        }
    }

    public static void addDeepHubModelTrainingInfo(PredictionModelSnippetData pms, FullModelId fmi) throws IOException {
        if (!fmi.getDeepHubModelTrainingInfoFile().exists()) {
            return;
        }
        KerasModelTrainingInfo mti = fmi.parseDeepHubModelTrainingInfoFile();
        mti.isFinalizing = fmi.hasSearchStopped();
        pms.modelTrainingInfo = mti;
    }

    public static void addPartitionedModelInfo(PredictionModelSnippetData pms, FullModelId fmi) {
        if (pms.partitionedModelEnabled && fmi.isModelPartition()) {
            pms.partitionName = fmi.getPartitionName();
            pms.trainDate = pms.trainInfo == null ? 0L : pms.trainInfo.endTime;
        }
    }

    public static void addPartitionedBaseModelInfo(PredictionModelSnippetData pms, FullModelId fmi) {
        if (pms.partitionedModelEnabled && fmi.isPartitionedBaseModel() && fmi.getPartFile().exists()) {
            PartitionedExtractService partitionedExtractService = (PartitionedExtractService)SpringUtils.getBean(PartitionedExtractService.class);
            try {
                pms.partitions = partitionedExtractService.read(fmi);
                PredictionResultsReader.addDiagnosticsToPartitionSummaries(pms.partitions.summaries.values());
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to retrieve partition extract: ", (Throwable)e);
            }
        }
    }

    public static void addDiagnosticsToPartitionSummaries(Collection<PartitionedModelExtract.PartitionedModelSummary> summaries) throws IOException {
        for (PartitionedModelExtract.PartitionedModelSummary summary : summaries) {
            FullModelId partFmi = FullModelId.parse(summary.snippet.fullModelId);
            summary.snippet.mlDiagnostics = partFmi.getMLDiagnostics();
        }
    }

    public static PredictionModelSnippetData makeSnippet(ModelDetailsBase details) {
        PredictionModelSnippetData snippetData;
        block17: {
            PredictionModelDetails modelDetails;
            snippetData = new PredictionModelSnippetData();
            logger.trace(() -> "Making PredictionModelSnippetData from " + JSON.prettyLog((Object)details));
            snippetData.fullModelId = details.fullModelId;
            snippetData.backendType = details.backendType;
            snippetData.sessionId = details.sessionId;
            snippetData.sessionDate = details.sessionDate;
            snippetData.trainInfo = details.trainInfo;
            snippetData.trainDate = details.trainInfo == null ? 0L : details.trainInfo.endTime;
            snippetData.userMeta = details.userMeta;
            snippetData.mlDiagnostics = details.mlDiagnostics;
            if (details instanceof ClassicalPredictionModelDetails) {
                modelDetails = (ClassicalPredictionModelDetails)details;
                if (null != modelDetails.coreParams) {
                    snippetData.predictionType = modelDetails.coreParams.prediction_type;
                    snippetData.partitionedModelEnabled = modelDetails.coreParams.isPartitioned();
                    snippetData.sampleWeightsEnabled = modelDetails.coreParams.weight.isSampleWeightEnabled();
                    snippetData.sampleWeightsVariable = modelDetails.coreParams.weight.sampleWeightVariable;
                }
                if (null != modelDetails.modeling) {
                    snippetData.isEnsembled = null != modelDetails.modeling.ensemble_params;
                    snippetData.algorithm = modelDetails.modeling.algorithm;
                    snippetData.evaluationMetric = modelDetails.modeling.getEvaluationMetricName();
                    snippetData.classAveragingMethod = modelDetails.modeling.metrics.classAveragingMethod;
                }
                snippetData.overridesParams = modelDetails.overridesParams;
            } else if (details instanceof CausalPredictionModelDetails) {
                modelDetails = (CausalPredictionModelDetails)details;
                snippetData.predictionType = ((CausalPredictionModelDetails)modelDetails).coreParams.prediction_type;
                snippetData.partitionedModelEnabled = false;
                snippetData.sampleWeightsEnabled = false;
                snippetData.inversePropensityWeightsEnabled = ((CausalPredictionModelDetails)modelDetails).modeling.metrics.causalWeighting == MetricParams.CausalWeighting.INVERSE_PROPENSITY;
                snippetData.algorithm = ((CausalPredictionModelDetails)modelDetails).modeling.algorithm;
                snippetData.causalMethod = ((CausalPredictionModelDetails)modelDetails).modeling.causal_method.name();
                if (snippetData.causalMethod.equals(PredictionModelingParams.CausalLearningMethod.META_LEARNER.toString())) {
                    snippetData.metaLearner = ((CausalPredictionModelDetails)modelDetails).modeling.meta_learner.displayName;
                }
                snippetData.evaluationMetric = ((CausalPredictionModelDetails)modelDetails).modeling.getEvaluationMetricName();
                snippetData.causalWeighting = ((CausalPredictionModelDetails)modelDetails).modeling.metrics.causalWeighting;
            } else if (details instanceof TimeseriesForecastingModelDetails) {
                modelDetails = (TimeseriesForecastingModelDetails)details;
                snippetData.predictionType = ((TimeseriesForecastingModelDetails)modelDetails).coreParams.prediction_type;
                snippetData.partitionedModelEnabled = ((TimeseriesForecastingModelDetails)modelDetails).coreParams.isPartitioned();
                snippetData.algorithm = ((TimeseriesForecastingModelDetails)modelDetails).modeling.algorithm;
                snippetData.evaluationMetric = ((TimeseriesForecastingModelDetails)modelDetails).modeling.getEvaluationMetricName();
            }
            try {
                if (snippetData.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
                    return snippetData;
                }
                if (details instanceof ClassicalPredictionModelDetails) {
                    modelDetails = (ClassicalPredictionModelDetails)details;
                    PredictionResultsReader.fillDriftMetrics(modelDetails.dataEvaluationMetrics, snippetData);
                    PredictionResultsReader.fillClassicalPerformanceMetrics(snippetData, modelDetails.coreParams != null ? modelDetails.coreParams.prediction_type : null, modelDetails.headTaskCMW, modelDetails.perf, modelDetails.modeling != null ? modelDetails.modeling.metrics : null, snippetData.userMeta.activeClassifierThreshold, modelDetails.coreParams != null ? modelDetails.coreParams.weight.sampleWeightVariable : null);
                    PredictionResultsReader.fillIntrinsicPerfInSnippet(modelDetails.iperf, snippetData);
                    PredictionResultsReader.fillGlobalExplanationsInSnippet(modelDetails.globalExplanationsAbsoluteImportance, snippetData);
                    break block17;
                }
                if (details instanceof DeepHubPredictionModelDetails) {
                    modelDetails = (DeepHubPredictionModelDetails)details;
                    PredictionResultsReader.fillDeepHubPerformanceMetrics(snippetData, (DeepHubPredictionModelDetails)modelDetails);
                    break block17;
                }
                if (details instanceof CausalPredictionModelDetails) {
                    modelDetails = (CausalPredictionModelDetails)details;
                    PredictionResultsReader.fillCausalPerformanceMetrics(snippetData, (CausalPredictionModelDetails)modelDetails);
                    PredictionResultsReader.fillIntrinsicPerfInSnippet(((CausalPredictionModelDetails)modelDetails).iperf, snippetData);
                    break block17;
                }
                if (details instanceof TimeseriesForecastingModelDetails) {
                    modelDetails = (TimeseriesForecastingModelDetails)details;
                    PredictionResultsReader.fillDriftMetrics(((TimeseriesForecastingModelDetails)modelDetails).dataEvaluationMetrics, snippetData);
                    if (((TimeseriesForecastingModelDetails)modelDetails).coreParams.prediction_type != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
                        throw new IllegalArgumentException("Unhandled prediction type: " + String.valueOf((Object)((TimeseriesForecastingModelDetails)modelDetails).coreParams.prediction_type));
                    }
                    FullModelId parsedFmi = FullModelId.parse(details.fullModelId);
                    if (!parsedFmi.isPartitionedBaseModel()) {
                        snippetData.forecasts = parsedFmi.getTimeseriesEvaluationForecastsForSnippet();
                    }
                    snippetData.predictionLength = ((TimeseriesForecastingModelDetails)modelDetails).coreParams.predictionLength;
                    snippetData.evaluationParams = ((TimeseriesForecastingModelDetails)modelDetails).coreParams.evaluationParams;
                    PredictionResultsReader.fillTimeseriesPerformanceMetrics(snippetData, ((TimeseriesForecastingModelDetails)modelDetails).perf);
                    PredictionResultsReader.fillIntrinsicPerfInSnippet(((TimeseriesForecastingModelDetails)modelDetails).iperf, snippetData);
                    break block17;
                }
                throw new IllegalArgumentException("Unknown model details: " + details.getClass().getSimpleName());
            }
            catch (Exception e) {
                logger.error((Object)"Failed to read model results", (Throwable)e);
                if (snippetData.trainInfo.state == ModelTrainInfo.ModelTrainState.FAILED) break block17;
                snippetData.trainInfo.state = ModelTrainInfo.ModelTrainState.FAILED;
                snippetData.trainInfo.failure = new APIError("Unknown", "Could not read model data: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return snippetData;
    }

    public static void fillCausalPerformanceMetrics(PredictionModelPerformanceMetrics metrics, CausalPredictionModelDetails modelDetails) {
        switch (modelDetails.coreParams.prediction_type) {
            case CAUSAL_BINARY_CLASSIFICATION: 
            case CAUSAL_REGRESSION: {
                metrics.causalWeighting = modelDetails.modeling.metrics.causalWeighting;
                metrics.auuc = modelDetails.perf.causalPerf.normalized.auuc;
                metrics.qini = modelDetails.perf.causalPerf.normalized.qini;
                metrics.netUplift = modelDetails.perf.causalPerf.normalized.netUplift;
                metrics.netUpliftPoint = modelDetails.perf.causalPerf.netUpliftPoint;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled prediction type: " + String.valueOf((Object)modelDetails.coreParams.prediction_type));
            }
        }
    }

    private static void fillDeepHubPerformanceMetrics(PredictionModelPerformanceMetrics metrics, DeepHubPredictionModelDetails modelDetails) {
        switch (modelDetails.coreParams.prediction_type) {
            case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                DeepHubPredictionModelPerf.DeepHubObjectDetectionPredictionModelPerf perf = (DeepHubPredictionModelPerf.DeepHubObjectDetectionPredictionModelPerf)modelDetails.perf;
                if (perf.metrics == null) {
                    logger.warn((Object)"Model metrics are empty");
                    break;
                }
                metrics.averagePrecisionIOU50 = perf.metrics.averagePrecisionIOU50;
                metrics.averagePrecisionIOU75 = perf.metrics.averagePrecisionIOU75;
                metrics.averagePrecisionAllIOU = perf.metrics.averagePrecisionAllIOU;
                break;
            }
            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                DeepHubPredictionModelPerf.DeepHubImageClassificationPredictionModelPerf perf = (DeepHubPredictionModelPerf.DeepHubImageClassificationPredictionModelPerf)modelDetails.perf;
                if (perf.metrics == null) {
                    logger.warn((Object)"Model metrics are empty");
                    break;
                }
                metrics.auc = perf.metrics.mrocAUC;
                metrics.accuracy = perf.metrics.accuracy;
                metrics.f1 = perf.metrics.f1;
                metrics.recall = perf.metrics.recall;
                metrics.precision = perf.metrics.precision;
                metrics.logLoss = perf.metrics.logLoss;
                metrics.averagePrecision = perf.metrics.averagePrecision;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled prediction type: " + String.valueOf((Object)modelDetails.coreParams.prediction_type));
            }
        }
    }

    public static void fillTimeseriesPerformanceMetrics(PredictionModelPerformanceMetrics metrics, TimeseriesForecastingModelPerf perf) {
        if (perf == null) {
            return;
        }
        TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics aggregatedMetrics = perf.aggregatedMetrics;
        if (aggregatedMetrics == null) {
            logger.warn((Object)"Model metrics are empty");
        } else {
            metrics.mase = aggregatedMetrics.mase;
            metrics.masestd = aggregatedMetrics.masestd;
            metrics.mape = aggregatedMetrics.mape;
            metrics.mapestd = aggregatedMetrics.mapestd;
            metrics.meanAbsoluteQuantileLoss = aggregatedMetrics.meanAbsoluteQuantileLoss;
            metrics.meanAbsoluteQuantileLossstd = aggregatedMetrics.meanAbsoluteQuantileLossstd;
            metrics.meanWeightedQuantileLoss = aggregatedMetrics.meanWeightedQuantileLoss;
            metrics.meanWeightedQuantileLossstd = aggregatedMetrics.meanWeightedQuantileLossstd;
            metrics.mse = aggregatedMetrics.mse;
            metrics.msestd = aggregatedMetrics.msestd;
            metrics.msis = aggregatedMetrics.msis;
            metrics.msisstd = aggregatedMetrics.msisstd;
            metrics.nd = aggregatedMetrics.nd;
            metrics.ndstd = aggregatedMetrics.ndstd;
            metrics.rmse = aggregatedMetrics.rmse;
            metrics.rmsestd = aggregatedMetrics.rmsestd;
            metrics.smape = aggregatedMetrics.smape;
            metrics.smapestd = aggregatedMetrics.smapestd;
            metrics.mae = aggregatedMetrics.mae;
            metrics.maestd = aggregatedMetrics.maestd;
            metrics.customMetricsResults = aggregatedMetrics.customMetricsResults;
            metrics.worstMase = aggregatedMetrics.worstMase;
            metrics.worstMape = aggregatedMetrics.worstMape;
            metrics.worstSmape = aggregatedMetrics.worstSmape;
            metrics.worstMse = aggregatedMetrics.worstMse;
            metrics.worstMsis = aggregatedMetrics.worstMsis;
            metrics.worstMae = aggregatedMetrics.worstMae;
        }
    }

    public static void fillClassicalPerformanceMetrics(PredictionModelPerformanceMetrics metrics, FullModelId fmi, ClassicalPredictionModelDetails details) throws IOException {
        Optional<PredictionModelPerf> predictionPerf = fmi.getClassicalPredictionPerf();
        if (predictionPerf.isPresent()) {
            PredictionResultsReader.fillClassicalPerformanceMetrics(metrics, fmi.getPredictionType(), details.modeling.metrics.costMatrixWeights, predictionPerf.get(), details.modeling.metrics, details.userMeta.activeClassifierThreshold, details.coreParams.weight.sampleWeightVariable);
        }
        PredictionResultsReader.fillDriftMetrics(details.dataEvaluationMetrics, metrics);
    }

    public static void fillClassicalPerformanceMetrics(PredictionModelPerformanceMetrics overallPerformanceMetrics, PredictionMLTask.PredictionType predictionType, MetricParams.CostMatrixWeights headTaskCMW, PredictionModelPerf perf, MetricParams metricParams, double activeClassifierThreshold, String sampleWeightsVariable) {
        if (perf == null) {
            return;
        }
        if (null == predictionType) {
            overallPerformanceMetrics.customMetricsResults = ((OtherClassificationModelPerf)perf).metrics.customMetricsResults;
            return;
        }
        overallPerformanceMetrics.sampleWeightsVariable = sampleWeightsVariable;
        switch (predictionType) {
            case BINARY_CLASSIFICATION: {
                BinaryClassificationModelPerf.ThresholdIndependentMetrics tiMetrics;
                BinaryClassificationModelPerf mp = (BinaryClassificationModelPerf)perf;
                BinaryClassificationModelPerf.CutData perCutData = mp.perCutData;
                if (perCutData == null) {
                    logger.warn((Object)"PerCutData is not defined");
                    if (mp == null || mp.tiMetrics == null) break;
                    overallPerformanceMetrics.customMetricsResults = mp.tiMetrics.customMetricsResults;
                    break;
                }
                int uti = mp.thresholdIndex(activeClassifierThreshold);
                if (perCutData.tp != null && headTaskCMW != null) {
                    float nrows = perCutData.tp[uti] + perCutData.tn[uti] + perCutData.fp[uti] + perCutData.fn[uti];
                    overallPerformanceMetrics.costMatrixGain = ((double)perCutData.tp[uti] * headTaskCMW.tpGain + (double)perCutData.tn[uti] * headTaskCMW.tnGain + (double)perCutData.fp[uti] * headTaskCMW.fpGain + (double)perCutData.fn[uti] * headTaskCMW.fnGain) / (double)nrows;
                }
                overallPerformanceMetrics.accuracy = perCutData.accuracy[uti];
                overallPerformanceMetrics.recall = perCutData.recall[uti];
                overallPerformanceMetrics.precision = perCutData.precision[uti];
                overallPerformanceMetrics.f1 = perCutData.f1[uti];
                if (perCutData.assertionsMetrics != null && perCutData.assertionsMetrics.length > uti) {
                    overallPerformanceMetrics.assertionsMetrics = perCutData.assertionsMetrics[uti];
                }
                if (perCutData.precisionstd != null) {
                    overallPerformanceMetrics.accuracystd = perCutData.accuracystd[uti];
                    overallPerformanceMetrics.recallstd = perCutData.recallstd[uti];
                    overallPerformanceMetrics.precisionstd = perCutData.precisionstd[uti];
                    overallPerformanceMetrics.f1std = perCutData.f1std[uti];
                }
                if ((tiMetrics = mp.tiMetrics) != null) {
                    overallPerformanceMetrics.logLoss = tiMetrics.logLoss;
                    overallPerformanceMetrics.logLossstd = tiMetrics.logLossstd;
                    overallPerformanceMetrics.auc = tiMetrics.auc;
                    overallPerformanceMetrics.aucstd = tiMetrics.aucstd;
                    overallPerformanceMetrics.lift = tiMetrics.lift;
                    overallPerformanceMetrics.liftstd = tiMetrics.liftstd;
                    overallPerformanceMetrics.calibrationLoss = tiMetrics.calibrationLoss;
                    overallPerformanceMetrics.calibrationLossstd = tiMetrics.calibrationLossstd;
                    overallPerformanceMetrics.averagePrecision = tiMetrics.averagePrecision;
                    overallPerformanceMetrics.averagePrecisionstd = tiMetrics.averagePrecisionstd;
                } else {
                    logger.warn((Object)"Model threshold-independent metrics are empty");
                }
                Double d = overallPerformanceMetrics.liftPoint = metricParams == null ? null : Double.valueOf(metricParams.liftPoint);
                if (metricParams != null && metricParams.evaluationMetric == MetricParams.EvaluationMetric.CUSTOM) {
                    ModelCustomEvaluationMetric customMetric = metricParams.getCustomEvaluationMetric();
                    if (StringUtils.isNotBlank((String)customMetric.metricCode)) {
                        if (customMetric.needsProbability && tiMetrics != null) {
                            overallPerformanceMetrics.customScore = tiMetrics.customScore;
                            overallPerformanceMetrics.customScorestd = tiMetrics.customScorestd;
                        } else {
                            if (perCutData.customScore != null) {
                                overallPerformanceMetrics.customScore = perCutData.customScore[uti];
                            }
                            if (perCutData.customScorestd != null) {
                                overallPerformanceMetrics.customScorestd = perCutData.customScorestd[uti];
                            }
                        }
                    }
                }
                if (metricParams == null) break;
                ArrayList<CustomMetricResult> foundCustomMetricResults = new ArrayList<CustomMetricResult>();
                if (tiMetrics != null && tiMetrics.customMetricsResults != null) {
                    Collections.addAll(foundCustomMetricResults, tiMetrics.customMetricsResults);
                }
                if (perCutData.customMetricsResults != null) {
                    for (CustomMetricResult customMetricResult : perCutData.customMetricsResults) {
                        if (customMetricResult instanceof MultiCutCustomMetricSuccess) {
                            CustomMetricSuccess flattenedMetricResult = new CustomMetricSuccess();
                            MultiCutCustomMetricSuccess castResult = (MultiCutCustomMetricSuccess)customMetricResult;
                            flattenedMetricResult.metric = castResult.metric;
                            flattenedMetricResult.value = castResult.values[uti];
                            if (castResult.valuesstd != null) {
                                flattenedMetricResult.valuestd = castResult.valuesstd[uti];
                            }
                            foundCustomMetricResults.add(flattenedMetricResult);
                            continue;
                        }
                        if (customMetricResult instanceof CustomMetricFailure) {
                            foundCustomMetricResults.add(customMetricResult);
                            continue;
                        }
                        logger.error((Object)String.format("Illegal State: Per-cut custom metric result for '%s' did not match either class MultiCutCustomMetricSuccess or CustomMetricFailure", customMetricResult.metric.name));
                        throw new IllegalStateException("Custom Metric Result configuration is broken");
                    }
                }
                overallPerformanceMetrics.customMetricsResults = foundCustomMetricResults.toArray(new CustomMetricResult[0]);
                break;
            }
            case MULTICLASS: {
                MulticlassModelPerf mp = (MulticlassModelPerf)perf;
                MulticlassModelPerf.Metrics multiclassMetrics = mp.metrics;
                if (multiclassMetrics == null) {
                    logger.warn((Object)"Model metrics are empty");
                    break;
                }
                overallPerformanceMetrics.classAveragingMethod = metricParams.classAveragingMethod;
                overallPerformanceMetrics.f1 = multiclassMetrics.f1;
                overallPerformanceMetrics.f1std = multiclassMetrics.f1std;
                overallPerformanceMetrics.recall = multiclassMetrics.recall;
                overallPerformanceMetrics.recallstd = multiclassMetrics.recallstd;
                overallPerformanceMetrics.precision = multiclassMetrics.precision;
                overallPerformanceMetrics.precisionstd = multiclassMetrics.precisionstd;
                overallPerformanceMetrics.accuracy = multiclassMetrics.accuracy;
                overallPerformanceMetrics.accuracystd = multiclassMetrics.accuracystd;
                overallPerformanceMetrics.logLoss = multiclassMetrics.logLoss;
                overallPerformanceMetrics.logLossstd = multiclassMetrics.logLossstd;
                overallPerformanceMetrics.auc = multiclassMetrics.mrocAUC;
                overallPerformanceMetrics.aucstd = multiclassMetrics.mrocAUCstd;
                overallPerformanceMetrics.averagePrecision = multiclassMetrics.averagePrecision;
                overallPerformanceMetrics.averagePrecisionstd = multiclassMetrics.averagePrecisionstd;
                overallPerformanceMetrics.calibrationLoss = multiclassMetrics.mcalibrationLoss;
                overallPerformanceMetrics.calibrationLossstd = multiclassMetrics.mcalibrationLossstd;
                overallPerformanceMetrics.customScore = multiclassMetrics.customScore;
                overallPerformanceMetrics.customScorestd = multiclassMetrics.customScorestd;
                overallPerformanceMetrics.assertionsMetrics = multiclassMetrics.assertionsMetrics;
                overallPerformanceMetrics.customMetricsResults = multiclassMetrics.customMetricsResults;
                break;
            }
            case REGRESSION: {
                RegressionModelPerf mp = (RegressionModelPerf)perf;
                RegressionModelPerf.RegressionMetrics regressionMetrics = mp.metrics;
                if (regressionMetrics == null) {
                    logger.warn((Object)"Model metrics are empty");
                    break;
                }
                overallPerformanceMetrics.r2 = regressionMetrics.r2;
                overallPerformanceMetrics.r2std = regressionMetrics.r2std;
                overallPerformanceMetrics.evs = regressionMetrics.evs;
                overallPerformanceMetrics.evsstd = regressionMetrics.evsstd;
                overallPerformanceMetrics.mape = regressionMetrics.mape;
                overallPerformanceMetrics.mapestd = regressionMetrics.mapestd;
                overallPerformanceMetrics.mae = regressionMetrics.mae;
                overallPerformanceMetrics.maestd = regressionMetrics.maestd;
                overallPerformanceMetrics.mse = regressionMetrics.mse;
                overallPerformanceMetrics.msestd = regressionMetrics.msestd;
                overallPerformanceMetrics.rmse = regressionMetrics.rmse;
                overallPerformanceMetrics.rmsestd = regressionMetrics.rmsestd;
                overallPerformanceMetrics.rmsle = regressionMetrics.rmsle;
                overallPerformanceMetrics.rmslestd = regressionMetrics.rmslestd;
                overallPerformanceMetrics.pearson = regressionMetrics.pearson;
                overallPerformanceMetrics.pearsonstd = regressionMetrics.pearsonstd;
                overallPerformanceMetrics.customScore = regressionMetrics.customScore;
                overallPerformanceMetrics.customScorestd = regressionMetrics.customScorestd;
                overallPerformanceMetrics.assertionsMetrics = regressionMetrics.assertionsMetrics;
                overallPerformanceMetrics.customMetricsResults = regressionMetrics.customMetricsResults;
                break;
            }
        }
    }

    public static ClassicalPredictionModelDetails makeDetails(FullModelId id) throws IOException {
        return (ClassicalPredictionModelDetails)PredictionResultsReader.makeModelDetails(id);
    }

    public static PredictionModelDetails makeModelDetails(FullModelId id) throws IOException {
        if (id.isExternalMLflowModelVersion()) {
            return PredictionResultsReader.makeMLflowPredictionDetails(id);
        }
        ResolvedPredictionCoreParams pcp = (ResolvedPredictionCoreParams)id.getResolvedCoreParams();
        if (pcp instanceof ResolvedClassicalPredictionCoreParams) {
            return PredictionResultsReader.makeClassicalPredictionDetails(id, (ResolvedClassicalPredictionCoreParams)pcp);
        }
        if (pcp instanceof ResolvedTimeseriesForecastingCoreParams) {
            return PredictionResultsReader.makeTimeseriesForecastingDetails(id, (ResolvedTimeseriesForecastingCoreParams)pcp);
        }
        if (pcp instanceof ResolvedDeepHubPredictionCoreParams) {
            return PredictionResultsReader.makeDeepHupPredictionDetails(id, (ResolvedDeepHubPredictionCoreParams)pcp);
        }
        if (pcp instanceof ResolvedCausalPredictionCoreParams) {
            return PredictionResultsReader.makeCausalPredictionDetails(id, null, (ResolvedCausalPredictionCoreParams)pcp);
        }
        throw new IllegalArgumentException("Unsupported core params: " + pcp.getClass().getSimpleName());
    }

    public static CausalPredictionModelDetails makeCausalPredictionDetails(FullModelId id, @Nullable String treatment, ResolvedCausalPredictionCoreParams pcp) throws IOException {
        CausalPredictionModelDetails ret = new CausalPredictionModelDetails();
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        if (ret.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            CausalPredictionModelPerf perf = id.parseModelFile("perf.json", CausalPredictionModelPerf.class);
            if (treatment != null) {
                if (treatment.contentEquals("<Empty>") && !pcp.treatment_values.contains("<Empty>")) {
                    treatment = "";
                }
                perf.causalPerf = perf.causalPerfMultiPerTreatmentAll.get(treatment);
                perf.propensityPerf = perf.propensityPerfMulti == null ? null : (CausalPredictionModelPerf.PropensityPerf)perf.propensityPerfMulti.getOrDefault(treatment, null);
            }
            ret.perf = perf;
            ret.iperf = id.parseModelFile("iperf.json", PredictionModelIntrinsicPerf.class);
            ret.actualParams = id.parseModelFile("actual_params.json", ActualModelParameters.class);
            ret.preprocessingReport = id.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
        }
        ret.preprocessing = id.parsePreprocessingFile("rpreprocessing_params.json", ResolvedCausalPredictionPreprocessingParams.class);
        ret.modeling = id.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
        ret.backendType = pcp.backendType;
        ret.coreParams = pcp;
        ret.trainedWithScript = id.parseSessionFile("script.json", SerializedShakerScript.class);
        ResultsReaderBase.readSplitData(id, ret);
        return ret;
    }

    private static DeepHubPredictionModelDetails makeDeepHupPredictionDetails(FullModelId id, ResolvedDeepHubPredictionCoreParams pcp) throws IOException {
        DeepHubPredictionModelDetails ret = new DeepHubPredictionModelDetails();
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        if (ret.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            ret.perf = id.getDeepHubPredictionPerf().orElse(null);
            ret.actualParams = id.parseModelFile("actual_params.json", ActualModelParameters.class);
            ret.preprocessingReport = id.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
            ret.predictionInfo = id.getDeepHubPredictionStatistics();
        }
        ret.preprocessing = id.parsePreprocessingFile("rpreprocessing_params.json", ResolvedPredictionPreprocessingParams.class);
        ret.modeling = id.parseModelFile("rmodeling_params.json", DeepHubPreTrainModelingParams.class);
        ret.backendType = pcp.backendType;
        ret.coreParams = pcp;
        ret.trainedWithScript = id.parseSessionFile("script.json", SerializedShakerScript.class);
        ResultsReaderBase.readSplitData(id, ret);
        return ret;
    }

    private static ClassicalPredictionModelDetails makeClassicalPredictionDetails(FullModelId id, ResolvedClassicalPredictionCoreParams pcp) throws IOException {
        ClassicalPredictionModelDetails ret = new ClassicalPredictionModelDetails();
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        if (ret.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            PredictionResultsReader.readClassicalModelAllPerfs(id, ret, pcp.prediction_type);
            if (!id.isPartitionedBaseModel()) {
                ret.actualParams = id.parseModelFile("actual_params.json", ActualModelParameters.class);
                ret.preprocessingReport = id.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
            }
            ret.globalExplanationsAbsoluteImportance = id.getGlobalExplanationsAbsoluteImportance().orElse(null);
        }
        if (id.hasPredictionStatisticsFile()) {
            PredictionResultsReader.readClassicalModelPredictions(id.getModelFolder(), ret, pcp.prediction_type);
        }
        ret.preprocessing = id.parsePreprocessingFile("rpreprocessing_params.json", ResolvedClassicalPredictionPreprocessingParams.class);
        if (id.getAssertionsFile().isFile()) {
            ret.assertionsParams = id.getAssertionsParams();
        }
        if (id.getOverridesFile().isFile()) {
            ret.overridesParams = id.getOverridesParams();
        }
        ret.modeling = id.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
        ret.backendType = ret.modeling.algorithm.backendType;
        ret.coreParams = pcp;
        ret.trainedWithScript = id.parseSessionFile("script.json", SerializedShakerScript.class);
        ret.javaScoreCompatibility = ret.getJavaScoreCompatibility();
        ret.javaExportCompatibility = ret.getJavaExportCompatibility();
        ret.sqlCompatibility = ret.getSQLCompatibility();
        ret.pmmlCompatibility = ret.getPMMLCompatibility();
        ret.pythonCompatibility = ret.getPythonExportCompatibility();
        ret.pythonApiNodeScoreCompatibility = ret.getPythonApiNodeScoreCompatibility();
        ret.apiNodeScoreCompatibility = ret.resolveApiNodeScoreCompatibility();
        ResultsReaderBase.readSplitData(id, ret);
        return ret;
    }

    private static TimeseriesForecastingModelDetails makeTimeseriesForecastingDetails(FullModelId id, ResolvedTimeseriesForecastingCoreParams pcp) throws IOException {
        TimeseriesForecastingModelDetails ret = new TimeseriesForecastingModelDetails();
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        if (ret.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            ret.perf = id.getTimeseriesForecastingPerf();
            ret.iperf = id.getTimeseriesForecastingIPerf();
            ret.actualParams = id.parseModelFile("actual_params.json", ActualModelParameters.class);
            if (!id.isPartitionedBaseModel()) {
                ret.preprocessingReport = id.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
            }
        }
        ret.preprocessing = id.parsePreprocessingFile("rpreprocessing_params.json", ResolvedTimeseriesForecastingPreprocessingParams.class);
        ret.modeling = id.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
        ret.backendType = ret.modeling.algorithm.backendType;
        ret.coreParams = pcp;
        ret.trainedWithScript = id.parseSessionFile("script.json", SerializedShakerScript.class);
        ResultsReaderBase.readSplitData(id, ret);
        return ret;
    }

    private static ClassicalPredictionModelDetails makeMLflowPredictionDetails(FullModelId id) throws IOException {
        assert (id.isExternalMLflowModelVersion());
        ClassicalPredictionModelDetails ret = new ClassicalPredictionModelDetails();
        ret.backendType = MLTask.BackendType.PY_MEMORY;
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        ret.trainInfo.state = ModelTrainInfo.ModelTrainState.DONE;
        MLFlowModelVersionInfo mmvi = id.getMLflowImportedModelMetadata();
        mmvi.fillMinimalCoreParamsOfPredictionDetails(ret);
        mmvi.fillMinimalPreprocessingParamsOfPredictionDetails(ret);
        ret.importedOn = mmvi.importedOn;
        ret.trainInfo.pythonVersion = mmvi.pythonVersion;
        if (id.hasReadableModelFile("MLModel")) {
            ret.mlflowMLModelFileContent = DKUFileUtils.readFileToStringUTF8((File)id.getModelFile("MLModel"));
        }
        ret.mlflowOrigin = mmvi.origin;
        mmvi.fillMinimalModelingParamsOfPredictionDetails(ret);
        if (id.hasReadableModelFile("perf.json")) {
            PredictionResultsReader.readClassicalModelAllPerfs(id, ret, ret.coreParams.prediction_type);
            ret.trainInfo.testRows = (long)ret.perf.globalMetrics.testWeight;
        }
        ret.globalExplanationsAbsoluteImportance = id.getGlobalExplanationsAbsoluteImportance().orElse(null);
        if (ret.coreParams.prediction_type != null && id.hasPredictionStatisticsFile()) {
            PredictionResultsReader.readClassicalModelPredictions(id.getModelFolder(), ret, ret.coreParams.prediction_type);
        }
        if (mmvi.isProxyModel()) {
            ret.proxyModelConfiguration = mmvi.proxyModelVersionConfiguration.proxyModelConfiguration;
        }
        ret.proxyModelEndpointInfo = mmvi.proxyModelEndpointInfo;
        ret.inputFormat = mmvi.inputFormat;
        ret.outputFormat = mmvi.outputFormat;
        String reasonMessage = "Not available for MLflow models";
        ret.javaScoreCompatibility = CompatibilityWithReason.nok(reasonMessage);
        ret.javaExportCompatibility = CompatibilityWithReason.nok(reasonMessage);
        ret.sqlCompatibility = CompatibilityWithReason.nok(reasonMessage);
        ret.pmmlCompatibility = CompatibilityWithReason.nok(reasonMessage);
        ret.pythonCompatibility = CompatibilityWithReason.ok();
        ret.pythonApiNodeScoreCompatibility = CompatibilityWithReason.ok();
        ret.apiNodeScoreCompatibility = ret.resolveApiNodeScoreCompatibility();
        String pythonCodeEnvName = id.getOriginalPythonCodeEnvName();
        if (pythonCodeEnvName == null) {
            ret.mlFlowCompatibilityInfo = new PythonCodeEnvPackagesUtils.MLflowCompatibilityInfo();
        } else {
            try {
                ret.mlFlowCompatibilityInfo = new PythonCodeEnvPackagesUtils.MLflowCompatibilityInfo(switch (ApplicationConfigurator.getNodeType()) {
                    case ApplicationConfigurator.DSSNodeType.DESIGN -> ((DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class)).getPythonEnvPackages(pythonCodeEnvName);
                    case ApplicationConfigurator.DSSNodeType.AUTOMATION -> ((AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class)).getPythonEnvPackages(id.getProjectKey(), pythonCodeEnvName);
                    default -> throw new IllegalStateException("Unreachable");
                });
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Error while retrieving MLflow compatibility info of SMV", new Object[]{id});
                ret.mlFlowCompatibilityInfo = new PythonCodeEnvPackagesUtils.MLflowCompatibilityInfo();
            }
        }
        return ret;
    }

    public static void readClassicalModelAllPerfs(FullModelId id, ClassicalPredictionModelDetails modelDetails, PredictionMLTask.PredictionType predictionType) throws IOException {
        PredictionResultsReader.readClassicalModelPerf(id.getModelFolder(), modelDetails, predictionType);
        PredictionResultsReader.readClassicalModelIPerf(id.getModelFolder(), modelDetails, predictionType);
    }

    public static void readClassicalModelPerf(File baseFolder, ClassicalPredictionModelDetails modelDetails, PredictionMLTask.PredictionType predictionType) throws IOException {
        modelDetails.perf = FullModelId.getClassicalPredictionPerf(baseFolder, predictionType);
        if (FullModelId.getPerfWithoutOverridesFile(baseFolder).isFile()) {
            modelDetails.perfWithoutOverrides = FullModelId.getClassicalPredictionPerfWithoutOverrides(baseFolder, predictionType);
        }
    }

    public static void readClassicalModelPredictions(File baseFolder, ClassicalPredictionModelDetails modelDetails, PredictionMLTask.PredictionType predictionType) throws IOException {
        modelDetails.predictionInfo = FullModelId.getPredictionStatistics(baseFolder, predictionType);
    }

    public static void readReferenceClassicalModelPredictions(File baseFolder, ClassicalPredictionModelDetails modelDetails, PredictionMLTask.PredictionType predictionType) throws IOException {
        modelDetails.referencePredictionInfo = FullModelId.getReferencePredictionStatistics(baseFolder, predictionType);
    }

    public static void readClassicalModelIPerf(File baseFolder, ClassicalPredictionModelDetails modelDetails, PredictionMLTask.PredictionType predictionType) throws IOException {
        modelDetails.iperf = FullModelId.getPredictionIntrinsicPerf(baseFolder, predictionType);
    }

    public static PredictionSubpopulationResults makeSubpopulationResults(FullModelId fmi) throws IOException {
        return PredictionResultsReader.makeSubpopulationResults(fmi, null, true);
    }

    public static PredictionSubpopulationResults makeSubpopulationResults(ModelLikeId mle, List<String> features, boolean computePerformanceMetrics) throws IOException {
        PredictionMLTask.PredictionType predictionType = mle.getPredictionType();
        if (!mle.getSubpopulationFile().exists()) {
            throw new IllegalArgumentException("No subpopulation analysis computed for '" + String.valueOf(mle) + "'. File " + mle.getSubpopulationFile().getAbsolutePath() + " does not exist.");
        }
        Class perfClass = switch (predictionType) {
            case PredictionMLTask.PredictionType.BINARY_CLASSIFICATION -> BinaryClassificationModelPerf.class;
            case PredictionMLTask.PredictionType.REGRESSION -> RegressionModelPerf.class;
            default -> throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)predictionType));
        };
        PredictionSubpopulation subpop = (PredictionSubpopulation)JSON.parseFile((File)mle.getSubpopulationFile(), PredictionSubpopulation.class);
        PredictionSubpopulationResults ret = new PredictionSubpopulationResults();
        ret.global = new PredictionSubpopulationResults.GlobalPerf();
        ret.global.perf = JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)mle.getPostOperationsFolder(), (String[])new String[]{"all_dataset_perf.json"}), perfClass);
        if (computePerformanceMetrics) {
            ret.global.performanceMetrics = PredictionResultsReader.getPerformanceMetrics((FullModelId)mle, predictionType, (PredictionModelPerf)ret.global.perf);
        }
        ret.global.randomState = subpop.randomState;
        ret.global.onSample = subpop.onSample;
        ret.subpopulationAnalyses = new ArrayList();
        if (features == null) {
            features = new ArrayList<String>();
            for (PredictionSubpopulation.FeatureInfo info : subpop.features) {
                features.add(info.feature);
            }
        }
        for (String feature : features) {
            PredictionSubpopulation.FeatureInfo featureInfo = subpop.getFeature(feature);
            if (featureInfo == null) {
                throw new IllegalArgumentException("Results for feature '" + feature + "' have not been computed.");
            }
            File subpopResultsFolder = DKUFileUtils.getWithinFollowLink((File)mle.getPostOperationsFolder(), (String[])new String[]{featureInfo.folderPath});
            PredictionSubpopulationModelPerf featurePerf = (PredictionSubpopulationModelPerf)JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)subpopResultsFolder, (String[])new String[]{"modality.json"}), PredictionSubpopulationModelPerf.class);
            for (PredictionSubpopulationModelPerf.FeatureModality modality : featurePerf.modalities) {
                if (modality.excluded || !StringUtils.isNotBlank((String)modality.filePath)) continue;
                modality.perf = JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)subpopResultsFolder, (String[])new String[]{modality.filePath}), perfClass);
            }
            featurePerf.randomState = subpop.randomState;
            featurePerf.onSample = subpop.onSample;
            ret.subpopulationAnalyses.add(featurePerf);
        }
        if (ret.subpopulationAnalyses.size() > 0) {
            ret.global.nbRecords = ret.subpopulationAnalyses.get((int)0).nbRecords;
            ret.global.weightedNbRecords = ret.subpopulationAnalyses.get((int)0).weightedNbRecords;
        }
        return ret;
    }

    private static PredictionModelPerformanceMetrics getPerformanceMetrics(FullModelId fmi, PredictionMLTask.PredictionType predictionType, PredictionModelPerf perf) throws IOException {
        PredictionModelPerformanceMetrics ret = new PredictionModelPerformanceMetrics();
        PredictionMLTask task = (PredictionMLTask)fmi.getHeadMLTask();
        if (!(task instanceof PredictionMLTask.ClassicalPredictionMLTask)) {
            throw new IllegalArgumentException("Unsupported PredictionMLTask: " + task.getClass().getSimpleName());
        }
        PredictionResultsReader.fillClassicalPerformanceMetrics(ret, predictionType, ((PredictionMLTask.ClassicalPredictionMLTask)task).modeling.metrics.costMatrixWeights, perf, fmi.parseModelFile((String)"rmodeling_params.json", PreTrainPredictionModelingParams.class).metrics, fmi.parseModelFile((String)"user_meta.json", ModelUserMeta.class).activeClassifierThreshold, ((PredictionMLTask.ClassicalPredictionMLTask)task).weight.sampleWeightVariable);
        DataEvaluationMetrics dataEvaluationMetrics = fmi.getDataEvaluationMetrics();
        PredictionResultsReader.fillDriftMetrics(dataEvaluationMetrics, ret);
        return ret;
    }

    public static PredictionSubpopulation getSubpopulationsInfo(ModelLikeId id) throws IOException {
        File subpopFile = id.getSubpopulationFile();
        if (subpopFile.exists()) {
            return (PredictionSubpopulation)JSON.parseFile((File)subpopFile, PredictionSubpopulation.class);
        }
        return null;
    }

    public static PartialDependenciesResult makePartialDependenceResults(File outputFolder) throws IOException {
        PartialDependenciesResult res = new PartialDependenciesResult();
        File iperfFile = DKUFileUtils.getWithinFollowLink((File)outputFolder, (String[])new String[]{"iperf.json"});
        if (!iperfFile.exists()) {
            throw new IllegalArgumentException("No intrinsic performance computed for this model");
        }
        PredictionModelIntrinsicPerf iperf = (PredictionModelIntrinsicPerf)JSON.parseFile((File)iperfFile, PredictionModelIntrinsicPerf.class);
        if (iperf.partialDependencies == null) {
            iperf.partialDependencies = new ArrayList<PredictionModelIntrinsicPerf.PartialDependenceData>();
        }
        res.partialDependencies = iperf.partialDependencies;
        return res;
    }

    public static LearningCurveResults<?> makeLearningCurveResults(ModelLikeId mle) throws IOException {
        File learningCurveFile = mle.getLearningCurveFile();
        if (!learningCurveFile.exists()) {
            return null;
        }
        return switch (mle.getPredictionType()) {
            case PredictionMLTask.PredictionType.BINARY_CLASSIFICATION -> (LearningCurveResults)JSON.parseFile((File)learningCurveFile, LearningCurveResultsBinary.class);
            case PredictionMLTask.PredictionType.MULTICLASS -> (LearningCurveResults)JSON.parseFile((File)learningCurveFile, LearningCurveResultsMultiClass.class);
            case PredictionMLTask.PredictionType.REGRESSION -> (LearningCurveResults)JSON.parseFile((File)learningCurveFile, LearningCurveResultsRegression.class);
            default -> throw new NotImplementedException("Unknown model type : " + String.valueOf((Object)mle.getPredictionType()));
        };
    }

    public static PredictionIndividualExplanations getIndividualExplanations(ModelLikeId mle) throws IOException {
        File individualExplanationsFile = mle.getIndividualExplanationsFile();
        if (individualExplanationsFile.exists()) {
            return (PredictionIndividualExplanations)JSON.parseFile((File)individualExplanationsFile, PredictionIndividualExplanations.class);
        }
        return null;
    }

    public static TimeseriesPredictionPermutationImportance getTsPermutationImportance(ModelLikeId mle) throws IOException {
        File permutationImportanceFile = mle.getPermutationImportanceFile();
        if (permutationImportanceFile.exists()) {
            return (TimeseriesPredictionPermutationImportance)JSON.parseFile((File)permutationImportanceFile, TimeseriesPredictionPermutationImportance.class);
        }
        return null;
    }

    public static PredictionPartitionedModelPerf makePartitionsPerfs(FullModelId fmi) throws IOException {
        ResolvedClassicalPredictionCoreParams pcp = fmi.parseSessionFile("core_params.json", ResolvedClassicalPredictionCoreParams.class);
        switch (pcp.prediction_type) {
            case BINARY_CLASSIFICATION: {
                return PredictionResultsReader.makePartitionsPerfs(fmi, BinaryClassificationModelPerf.class);
            }
            case MULTICLASS: {
                return PredictionResultsReader.makePartitionsPerfs(fmi, MulticlassModelPerf.class);
            }
            case REGRESSION: {
                return PredictionResultsReader.makePartitionsPerfs(fmi, RegressionModelPerf.class);
            }
            case TIMESERIES_FORECAST: {
                return PredictionResultsReader.makePartitionsPerfs(fmi, TimeseriesForecastingModelPerf.class);
            }
        }
        throw new Error("unreachable");
    }

    private static <T extends PredictionModelPerf> PredictionPartitionedModelPerf makePartitionsPerfs(FullModelId fmi, Class<T> clazz) throws IOException {
        PredictionPartitionedModelPerf perfs = new PredictionPartitionedModelPerf();
        perfs.allDatasetPerf = (PredictionModelPerf)fmi.parsePossiblyCompressedModelFile("perf.json", clazz);
        perfs.weightedNbRecords = 0.0;
        perfs.computed_as_type = FeaturePreprocessingParams.FeatureType.CATEGORY;
        ArrayList modalities = new ArrayList();
        for (FullModelId partitionFmi : StratifiedModelUtils.fetchPartitionFmis(fmi)) {
            PredictionSubpopulationModelPerf.FeatureModality modality = new PredictionSubpopulationModelPerf.FeatureModality();
            modality.value = partitionFmi.getPartitionName();
            if (partitionFmi.getPossiblyCompressedModelFile("perf.json").exists()) {
                PredictionModelPerf predPerf = (PredictionModelPerf)partitionFmi.parsePossiblyCompressedModelFile("perf.json", clazz);
                modality.perf = predPerf;
                if (clazz == TimeseriesForecastingModelPerf.class) {
                    modality.weightedCount = 1.0;
                    var8_8 = perfs;
                    Double.valueOf(var8_8.weightedNbRecords + 1.0);
                    var8_8.weightedNbRecords = var8_8.weightedNbRecords;
                } else {
                    modality.weightedCount = predPerf.globalMetrics.testWeight;
                    var8_8 = perfs;
                    Double.valueOf(var8_8.weightedNbRecords + predPerf.globalMetrics.testWeight);
                    var8_8.weightedNbRecords = var8_8.weightedNbRecords;
                }
            } else {
                modality.excluded = true;
                modality.weightedCount = 0.0;
                modality.reason = "Perf metrics unavailable (training failed?)";
            }
            modalities.add(modality);
        }
        perfs.modalities = modalities.toArray(new PredictionSubpopulationModelPerf.FeatureModality[0]);
        PartitionedModelExtract extract = fmi.getPartitionedModelExtract();
        for (Map.Entry<String, PartitionedModelExtract.PartitionedModelSummary> summaryEntry : extract.summaries.entrySet()) {
            perfs.partitionStates.put(summaryEntry.getKey(), summaryEntry.getValue().state);
        }
        return perfs;
    }

    private static void fillGlobalExplanationsInSnippet(PredictionGlobalExplanationsAbsoluteImportance globalExplanationsAbsoluteImportance, PredictionModelSnippetData snippet) {
        if (globalExplanationsAbsoluteImportance == null) {
            return;
        }
        List<FI> topImportances = new ArrayList<FI>();
        Map<String, Double> absoluteImportance = globalExplanationsAbsoluteImportance.absoluteImportance;
        if (absoluteImportance != null && !absoluteImportance.isEmpty()) {
            for (Map.Entry<String, Double> entry : absoluteImportance.entrySet()) {
                topImportances.add(new FI(entry.getKey(), entry.getValue()));
            }
            Collections.sort(topImportances);
            Collections.reverse(topImportances);
            if (topImportances.size() > 10) {
                topImportances = topImportances.subList(0, 10);
            }
        }
        snippet.globalExplanationsTopImportances = topImportances;
    }

    private static void fillIntrinsicPerfInSnippet(PredictionModelIntrinsicPerf ip, PredictionModelSnippetData snippetData) {
        if (ip == null) {
            return;
        }
        if (ip.rawImportance != null) {
            PredictionResultsReader.fillTopImportanceInSnippet(ip.rawImportance, snippetData);
        }
        if (ip.lmCoefficients != null) {
            PredictionResultsReader.fillTopCoefsInSnippet(ip.lmCoefficients, snippetData);
        }
    }

    private static void fillTopImportanceInSnippet(PredictionModelIntrinsicPerf.VariablesImportance importance, PredictionModelSnippetData snippet) {
        List<FI> list = new ArrayList<FI>();
        if (importance != null && importance.importances != null && importance.importances.length > 0) {
            for (int i = 0; i < importance.importances.length; ++i) {
                list.add(new FI(importance.variables[i], importance.importances[i]));
            }
            Collections.sort(list);
            Collections.reverse(list);
            if (list.size() > 10) {
                list = list.subList(0, 10);
            }
        }
        snippet.topImportance = list;
    }

    private static void fillTopCoefsInSnippet(PredictionModelIntrinsicPerf.Coefficients coef, PredictionModelSnippetData snippetData) {
        List<AFI> list = new ArrayList<AFI>();
        if (coef != null && coef.variables != null && coef.variables.length > 0) {
            for (int i = 0; i < coef.variables.length; ++i) {
                list.add(new AFI(coef.variables[i], coef.coefs[i], coef.pvalue != null ? Double.valueOf(coef.pvalue[i]) : null));
            }
            Collections.sort(list);
            Collections.reverse(list);
            if (list.size() > 10) {
                list = list.subList(0, 10);
            }
        }
        snippetData.topCoefs = list;
    }

    public static void fillDriftMetrics(DataEvaluationMetrics dataEvaluationMetrics, PredictionModelPerformanceMetrics metrics) {
        if (dataEvaluationMetrics != null) {
            if (dataEvaluationMetrics.driftModelAccuracy != null) {
                metrics.dataDrift = dataEvaluationMetrics.driftModelAccuracy.value;
                metrics.dataDriftPValue = dataEvaluationMetrics.driftModelAccuracy.pvalue;
                metrics.dataDriftDeviation = dataEvaluationMetrics.getDataDriftDeviation();
            }
            if (dataEvaluationMetrics.driftResult != null && dataEvaluationMetrics.driftResult.univariateDriftResult != null) {
                dataEvaluationMetrics.driftResult.univariateDriftResult.populateMetrics(metrics);
            }
            if (dataEvaluationMetrics.driftResult != null && dataEvaluationMetrics.driftResult.predictionDriftResult != null) {
                metrics.predictionDrift_KS = dataEvaluationMetrics.driftResult.predictionDriftResult.ksTestPvalue;
                metrics.predictionDrift_ChiSquare = dataEvaluationMetrics.driftResult.predictionDriftResult.chiSquareTestPvalue;
                metrics.predictionDrift_PSI = dataEvaluationMetrics.driftResult.predictionDriftResult.populationStabilityIndex;
            }
            if (dataEvaluationMetrics.driftResult != null && dataEvaluationMetrics.driftResult.textDriftResult != null) {
                dataEvaluationMetrics.driftResult.textDriftResult.populateMetrics(metrics);
            }
            if (dataEvaluationMetrics.driftResult != null && dataEvaluationMetrics.driftResult.imageDriftResult != null) {
                dataEvaluationMetrics.driftResult.imageDriftResult.populateMetrics(metrics);
            }
        }
    }

    public static class PredictionSubpopulationResults<T extends PredictionModelPerf> {
        GlobalPerf global;
        List<PredictionSubpopulationModelPerf<T>> subpopulationAnalyses;

        static class GlobalPerf<T> {
            Long nbRecords;
            Double weightedNbRecords;
            int randomState;
            boolean onSample;
            T perf;
            PredictionModelPerformanceMetrics performanceMetrics;

            GlobalPerf() {
            }
        }
    }

    public static class PartialDependenciesResult {
        List<PredictionModelIntrinsicPerf.PartialDependenceData> partialDependencies;
    }

    public static class LearningCurveResultsBinary
    extends LearningCurveResults<BinaryClassificationModelPerf> {
    }

    public static abstract class LearningCurveResults<T extends PredictionModelPerf> {
        LearningCurvePoint<T>[] perf_points;
    }

    public static class LearningCurveResultsMultiClass
    extends LearningCurveResults<MulticlassModelPerf> {
    }

    public static class LearningCurveResultsRegression
    extends LearningCurveResults<RegressionModelPerf> {
    }

    public static class FI
    implements Comparable<FI> {
        String s;
        double d;

        FI(String s, double d) {
            this.s = s;
            this.d = d;
        }

        @Override
        public int compareTo(FI o) {
            return Double.compare(this.d, o.d);
        }
    }

    public static class AFI
    implements Comparable<AFI> {
        String s;
        double d;
        Double p;

        AFI(String s, double d, Double p) {
            this.s = s;
            this.d = d;
            this.p = p;
        }

        @Override
        public int compareTo(AFI o) {
            return Double.compare(Math.abs(this.d), Math.abs(o.d));
        }
    }

    public static class LearningCurvePoint<T extends PredictionModelPerf> {
        long train_size;
        long test_size;
        float train_time;
        T train_metrics;
        T test_metrics;
    }
}

