/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.ml.shared.ParameterAutoCompleter;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.ArrayList;
import java.util.List;

public class RidgeMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Ridge (L2) regression";
    }

    @Override
    public boolean isShiftWindowsCompatible() {
        return true;
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.RidgeRegressionHyperparametersSpace rp = rpmp.ridge_grid;
        ModelTrainInfo.PreSearchDescription ret = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, rp));
        if (rp.alphaMode == PredictionModelingParams.RidgeSelectAlphaMode.MANUAL) {
            ret.withMVParam("alpha", rp.alpha);
        }
        return ret;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        if ((double)after.ridge.alpha != 0.0) {
            return new ModelTrainInfo.PostSearchDescription().withSVParam("alpha", Float.valueOf(after.ridge.alpha));
        }
        return new ModelTrainInfo.PostSearchDescription().withSVParam("alpha", "Auto-optimized");
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.RidgeRegressionHyperparametersSpace rp = pmp.ridge_regression;
        if (rp == null || !rp.enabled) {
            return;
        }
        if (rp.alphaMode == PredictionModelingParams.RidgeSelectAlphaMode.AUTO) {
            checks.addWarningSparse("Ridge regression with auto-select alpha");
        } else {
            checks.checkNumericalDimension(rp.alpha, "Alpha regularization coefficient (Ridge Regression)");
        }
    }

    @Override
    public ParameterAutoCompleter autoCompleter() {
        return new ParameterAutoCompleter.DummyDropAutoCompleter();
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return false;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.RidgeRegressionHyperparametersSpace rp = (PredictionModelingParams.RidgeRegressionHyperparametersSpace)space;
        if (rp.alphaMode == PredictionModelingParams.RidgeSelectAlphaMode.MANUAL) {
            return rp.alpha.getLength();
        }
        return 1;
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.RidgeRegressionHyperparametersSpace rp = pmp.ridge_regression;
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (rp == null || !rp.enabled) {
            return ret;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.RIDGE_REGRESSION, pmp);
        rcmp.ridge_grid = rp;
        WorkSet.ModelingSet ms = new WorkSet.ModelingSet(rcmp);
        rcmp.gridLength = this.getSearchSize(rcmp.grid_search_params, rp);
        ms.estimatedTrains = rcmp.gridLength > 1 ? rcmp.gridLength * gsFolds + 1 : 1;
        ret.add(ms);
        return ret;
    }

    @Override
    public boolean isJavaCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public boolean isPythonCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public boolean isSQLCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public boolean isPMMLCompatible() {
        return true;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams ret = this.getCopyWithGridStrategy(usedToTrain);
        ret.ridge_grid.alpha.setToSingleValueGrid(Double.valueOf(optimized.ridge.alpha));
        return ret;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.ridge_regression = preTrain.ridge_grid;
        target.ridge_regression.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.ridge_regression = usedToTrain.ridge_grid;
        target.ridge_regression.enabled = true;
    }
}

