/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class DatasetDumpSchemaCommand
extends CLICommand {
    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public String usageString() {
        return "dku dataset-dump-schema [OPTS] DATASET";
    }

    @Override
    public String description() {
        return "Dump a dataset schema in JSON format\n";
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "dataset-dump-schema");
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing 'dataset' argument");
        }
        try (DKUTransactionService transactionService = new DKUTransactionService();){
            int n;
            block13: {
                String dataset = cmdLine.getArgs()[1];
                Transaction t = transactionService.beginRead();
                try {
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveWithEnvDefault(dataset);
                    SerializedDataset sd = (SerializedDataset)CLISetup.getDatasetsDAO().getMandatoryUnsafe(loc);
                    Schema schema = sd.getSchema();
                    ArrayList<JsonObject> columnTypes = new ArrayList<JsonObject>();
                    for (SchemaColumn column : schema.getColumns()) {
                        JsonObject columnType = new JsonObject();
                        columnType.addProperty("name", column.getName());
                        columnType.addProperty("type", column.getType().toString().toLowerCase());
                        columnTypes.add(columnType);
                    }
                    System.out.println(JSON.prettyLog(columnTypes));
                    n = 0;
                    if (t == null) break block13;
                }
                catch (Throwable throwable) {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                t.close();
            }
            return n;
        }
    }
}

