/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.impl.FilesBasedDatasetsDAO;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.CredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SQLTableSchemaCommand
extends CLICommand {
    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public String usageString() {
        return "dku sql-table-schema [OPTS] DATASET";
    }

    @Override
    public String description() {
        return "Prints the table schema (as a SQL command) for a SQL Table dataset";
    }

    @Override
    public int execute(String[] args) throws Exception {
        Dataset ds;
        CommandLine cmdLine = this.parseAndMiniSetup(args, "sql-table-schema");
        if (cmdLine.getArgs().length == 1) {
            return this.usage(1, "Missing argument: dataset");
        }
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        SpringUtils.getInstance().registerAndAutowire(FilesBasedUsersDAO.class);
        SpringUtils.getInstance().registerAndAutowire(CredentialsService.class);
        SpringUtils.getInstance().registerAndAutowire(FilesBasedDatasetsDAO.class);
        SpringUtils.getInstance().registerAndAutowire(DatasetAccessService.class);
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetAccessService datasetAccessService = (DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class);
        try (Transaction t = ts.beginRead();){
            ds = datasetAccessService.getMandatory(DatasetLocUtils.resolveWithEnvDefault(cmdLine.getArgs()[1]));
        }
        if (!DatasetInspector.isSQLTable(ds)) {
            return this.fatalErrorNoStack("Dataset '%s' is not a SQL Table", args[1]);
        }
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT((AuthCtx)DSSAuthCtx.newNone(), null, ((AbstractSQLDatasetHandler.AbstractSQLConfig)ds.getParams()).connection);
        System.out.println(connData.getDialect().getCreateTableStatementSQL(connData.getConnection(), ds, new InfoMessage.InfoMessages(), false));
        return 0;
    }
}

