/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;

public class CodeEnvVersionChecker {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.codeenvs.versioncheck");

    public boolean checkIfCodeEnvVersionIsUpToDate(CodeEnvModel.EnvLang envLang, File versionFolder, File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        logger.infoV("Checking if env lang=%s folder=%s matches export dir=%s", new Object[]{envLang, versionFolder, exportedEnvDir.getAbsolutePath()});
        switch (envLang) {
            case PYTHON: {
                return this.checkIfPythonEnvVersionIsUpToDate(versionFolder, exportedEnvDir, specMode);
            }
            case R: {
                return this.checkIfREnvVersionIsUpToDate(versionFolder, exportedEnvDir, specMode);
            }
        }
        throw new Error("unreachable");
    }

    boolean checkIfPythonEnvVersionIsUpToDate(File versionFolder, File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        File versionDescFolder = new File(versionFolder, "desc");
        logger.infoV("Checking if env dir=%s matches export dir=%s", new Object[]{versionFolder, exportedEnvDir.getAbsolutePath()});
        if (!new File(versionFolder, "ready.txt").isFile()) {
            logger.warnV("Version folder %s not ready (no marker file)", new Object[]{versionFolder});
            return false;
        }
        boolean descEquals = false;
        File versionDescFile = new File(versionDescFolder, "desc.json");
        File exportedDescFile = new File(exportedEnvDir, "desc.json");
        if (versionDescFile.exists() && exportedDescFile.exists()) {
            CodeEnvModel.PythonEnvDesc versionDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)versionDescFile, CodeEnvModel.PythonEnvDesc.class);
            CodeEnvModel.PythonEnvDesc exportedDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)exportedDescFile, CodeEnvModel.PythonEnvDesc.class);
            descEquals = versionDesc.useReferenceSpec == exportedDesc.useReferenceSpec;
            descEquals &= versionDesc.pythonInterpreter == exportedDesc.pythonInterpreter;
            if (versionDesc.pythonInterpreter == StandardPythonInterpreter.CUSTOM) {
                descEquals &= versionDesc.customInterpreter.equals(exportedDesc.customInterpreter);
            }
            descEquals &= versionDesc.installCorePackages == exportedDesc.installCorePackages;
            descEquals &= versionDesc.installJupyterSupport == exportedDesc.installJupyterSupport;
            if (versionDesc.installCorePackages) {
                descEquals &= versionDesc.corePackagesSet == exportedDesc.corePackagesSet;
            }
            descEquals &= versionDesc.predefinedContainerHooks.equals(exportedDesc.predefinedContainerHooks);
        }
        boolean reqEquals = false;
        boolean condaEquals = false;
        switch (specMode) {
            case ACTUAL: {
                reqEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"actual", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}));
                condaEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"actual", "environment.spec"}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual", "environment.spec"}));
                break;
            }
            case SPECIFIED: {
                reqEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}));
                condaEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", "environment.spec"}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", "environment.spec"}));
            }
        }
        File exportedResourcesInitScript = DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", "resources_init.py"});
        File versionResourcesInitScript = DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", "resources_init.py"});
        if (exportedResourcesInitScript.exists() || versionResourcesInitScript.exists()) {
            boolean resourcesInitEquals = this.fileEquals(exportedResourcesInitScript, versionResourcesInitScript);
            logger.infoV("descEquals=%s reqEquals=%s condaEquals=%s resourcesInitEquals=%s", new Object[]{descEquals, reqEquals, condaEquals, resourcesInitEquals});
            return descEquals && reqEquals && condaEquals && resourcesInitEquals;
        }
        logger.infoV("descEquals=%s reqEquals=%s condaEquals=%s", new Object[]{descEquals, reqEquals, condaEquals});
        return descEquals && reqEquals && condaEquals;
    }

    boolean checkIfREnvVersionIsUpToDate(File versionFolder, File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        File versionDescFolder = new File(versionFolder, "desc");
        logger.infoV("Checking if R env dir=%s matches export dir=%s", new Object[]{versionFolder, exportedEnvDir.getAbsolutePath()});
        if (!new File(versionFolder, "ready.txt").isFile()) {
            logger.warnV("Version folder %s not ready (no marker file)", new Object[]{versionFolder});
            return false;
        }
        boolean descEquals = false;
        File versionDescFile = new File(versionDescFolder, "desc.json");
        File exportedDescFile = new File(exportedEnvDir, "desc.json");
        if (versionDescFile.exists() && exportedDescFile.exists()) {
            CodeEnvModel.REnvDesc versionDesc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)versionDescFile, CodeEnvModel.REnvDesc.class);
            CodeEnvModel.REnvDesc exportedDesc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)exportedDescFile, CodeEnvModel.REnvDesc.class);
            descEquals = true;
            descEquals &= versionDesc.installCorePackages == exportedDesc.installCorePackages;
            descEquals &= versionDesc.installJupyterSupport == exportedDesc.installJupyterSupport;
        }
        boolean reqEquals = false;
        boolean condaEquals = false;
        switch (specMode) {
            case ACTUAL: {
                reqEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"actual", CodeEnvModel.EnvLang.R.getPackageFileName()}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual", CodeEnvModel.EnvLang.R.getPackageFileName()}));
                condaEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"actual", "environment.spec"}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual", "environment.spec"}));
                break;
            }
            case SPECIFIED: {
                reqEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", CodeEnvModel.EnvLang.R.getPackageFileName()}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", CodeEnvModel.EnvLang.R.getPackageFileName()}));
                condaEquals = this.fileEquals(DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", "environment.spec"}), DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", "environment.spec"}));
            }
        }
        logger.infoV("descEquals=%s packages=%s condaEquals=%s", new Object[]{descEquals, reqEquals, condaEquals});
        return descEquals && reqEquals && condaEquals;
    }

    private boolean fileEquals(File f1, File f2) throws IOException {
        boolean ret = FileUtils.contentEquals((File)f1, (File)f2);
        logger.infoV("Test equality of f1=%s exists=%s with f2=%s exists=%s -> %s", new Object[]{f1, f1.isFile(), f2, f2.isFile(), ret});
        return ret;
    }

    public String getCodeEnvSpecHash(CodeEnvModel.EnvLang envLang, File envDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        logger.infoV("Getting code env hash for lang=%s folder=%s ", new Object[]{envLang, envDir});
        Object hashed = "";
        File condaActual = DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"actual", "environment.spec"});
        File condaSpec = DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"spec", "environment.spec"});
        switch (envLang) {
            case PYTHON: {
                switch (specMode) {
                    case ACTUAL: {
                        hashed = (String)hashed + FileUtils.readFileToString((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"actual", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}), (Charset)StandardCharsets.UTF_8);
                        if (!condaActual.isFile()) break;
                        hashed = (String)hashed + FileUtils.readFileToString((File)condaActual, (Charset)StandardCharsets.UTF_8);
                        break;
                    }
                    case SPECIFIED: {
                        hashed = (String)hashed + FileUtils.readFileToString((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()}), (Charset)StandardCharsets.UTF_8);
                        if (!condaSpec.isFile()) break;
                        hashed = (String)hashed + FileUtils.readFileToString((File)condaSpec, (Charset)StandardCharsets.UTF_8);
                    }
                }
                hashed = (String)hashed + DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"spec", "resources_init.py"}));
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"desc.json"}), CodeEnvModel.PythonEnvDesc.class);
                hashed = (String)hashed + desc.pythonInterpreter.toString();
                if (StandardPythonInterpreter.CUSTOM == desc.pythonInterpreter) {
                    hashed = (String)hashed + desc.customInterpreter;
                }
                if (desc.installCorePackages || desc.installJupyterSupport) {
                    hashed = (String)hashed + CodeEnvPackageSystems.PIP.getMandatoryPackageList(desc);
                }
                if (desc.updateResourcesApiNode) {
                    hashed = (String)hashed + "+updateResourcesApiNode";
                }
                if (desc.conda) {
                    hashed = (String)hashed + "+isConda";
                }
                return DigestUtils.md5Hex((String)hashed);
            }
            case R: {
                switch (specMode) {
                    case ACTUAL: {
                        hashed = (String)hashed + FileUtils.readFileToString((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"actual", CodeEnvModel.EnvLang.R.getPackageFileName()}), (Charset)StandardCharsets.UTF_8);
                        if (!condaActual.isFile()) break;
                        hashed = (String)hashed + FileUtils.readFileToString((File)condaActual, (Charset)StandardCharsets.UTF_8);
                        break;
                    }
                    case SPECIFIED: {
                        hashed = (String)hashed + FileUtils.readFileToString((File)DKUFileUtils.getWithin((File)envDir, (String[])new String[]{"spec", CodeEnvModel.EnvLang.R.getPackageFileName()}), (Charset)StandardCharsets.UTF_8);
                        if (!condaSpec.isFile()) break;
                        hashed = (String)hashed + FileUtils.readFileToString((File)condaSpec, (Charset)StandardCharsets.UTF_8);
                    }
                }
                logger.info((Object)("Hashing specMode=" + String.valueOf((Object)specMode) + " : " + (String)hashed));
                return DigestUtils.md5Hex((String)hashed);
            }
        }
        throw new Error("unreachable");
    }
}

