/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class H2Connection
extends AbstractSQLConnection {
    public static final String connectionType = "H2";
    public Params params = new Params();
    private static H2SQLDialect dialect;

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public H2SQLDialect getDialect() {
        if (dialect == null) {
            dialect = this.params.dssRuntimeDB ? new H2SQLDialect() : new H2V2SQLDialect();
        }
        return dialect;
    }

    @Override
    String getJarsDirectory() {
        if (this.params.dssRuntimeDB || StringUtils.isNotBlank((String)this.params.jarsDirectory)) {
            return this.params.jarsDirectory;
        }
        return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-h2"}).getAbsolutePath();
    }

    @Override
    String getDriver() {
        return "org.h2.Driver";
    }

    @Override
    String getJdbcUrl() {
        return "jdbc:h2:" + this.params.folder + "/dataset";
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        return cd;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        throw new UnsupportedOperationException("Not applicable");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public String folder;
        public boolean dssRuntimeDB = true;
    }
}

