/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.containers.exec.YamlUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobRunCodes;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.runnables.DSSRunnablesService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;

public class KubernetesExecUtils {
    public static final long LOG_START_WAIT_TIMEOUT = 1800000L;
    public static final long LOG_POLL_WAIT_TIMEOUT = 120000L;
    public static final String KUBERNETES_VALIDATE_PROPERTY = "containersExec.kubernetes.validateJobConf";
    public static final String KUBERNETES_VALIDATE_DEFAULT = "true";
    public static final Pattern ALLOWED_ENV_VARS = Pattern.compile("[-._a-zA-Z][-._a-zA-Z0-9]*");
    public static final String DKU_EXEC_SUBMITTER_KEY = "dataiku.com/dku-exec-submitter";
    public static final String DKU_EXECUTION_ID_KEY = "dataiku.com/dku-execution-id";
    public static final String DKU_INSTALL_ID_KEY = "dataiku.com/dku-install-id";
    public static final String DKU_EXECUTION_TYPE_KEY = "dataiku.com/dku-execution-type";
    public static final String DKU_PROJECT_KEY_KEY = "dataiku.com/dku-project-key";
    public static final String DKU_ANALYSIS_ID_KEY = "dataiku.com/dku-analysis-id";
    public static final String DKU_WEBAPP_ID_KEY = "dataiku.com/dku-webapp-id";
    public static final String DKU_NOTEBOOK_ID_KEY = "dataiku.com/dku-notebook-id";
    public static final String DKU_DATASET_NAME_KEY = "dataiku.com/dku-dataset-name";
    public static final String DKU_JOB_ID_KEY = "dataiku.com/dku-job-id";
    public static final String DKU_PROCESS_TYPE_KEY = "dataiku.com/dku-process-type";
    public static final String DKU_ACTIVITY_ID_KEY = "dataiku.com/dku-activity-id";
    public static final String DKU_APIDEPLOYER_INFRA_ID_KEY = "dataiku.com/dku-apideployer-infra-id";
    public static final String DKU_APIDEPLOYER_DEPLOYMENT_ID_KEY = "dataiku.com/dku-apideployer-deployment-id";
    public static final String DKU_CODESTUDIO_ID_KEY = "dataiku.com/dku-codestudio-id";
    public static final String DKU_LLM_ID = "dataiku.com/dku-llm-id";
    public static final String DKU_CONTAINER_CONF_KEY = "dataiku.com/dku-container-conf";
    public static final String DKU_ROLE_KEY = "dataiku.com/dku-role";
    private static final String DKU_KUBERNETES_ALL_EXTRA_LABEL_KEY = "dku.kubernetes.all.extraLabels";
    private static final String DKU_KUBERNETES_ALL_CASE_INSENSITIVE_EXTRA_LABEL_KEY = "dku.kubernetes.all.caseSensitiveExtraLabels";
    private static final String DKU_KUBERNETES_ALL_EXTRA_ANNOTATIONS = "dku.kubernetes.all.extraAnnotations";
    private static final String EMPTY_JSON_ARRAY = "[]";
    private static final Pattern WORD_PATTERN = Pattern.compile("\\b(\\w)\\w+\\b");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containers.kubernetes");

    private KubernetesExecUtils() {
    }

    public static String[] getKubeCtlCommand(AuthCtx authCtx, @Nullable String projectKey, @Nullable String requestTimeout, ContainerExecRuntimeConfig containerConfig, boolean maybeCreateNamespace, String ... command) throws IOException, InterruptedException {
        if (containerConfig.noImplicitK8sClusterAndNoDefaultClusterId) {
            throw new RuntimeException("No default Kubernetes cluster selected and option `use builtin Kubernetes cluster` is disabled");
        }
        boolean withContext = StringUtils.isNotBlank((String)containerConfig.kubeCtlContext);
        String managedNamespace = maybeCreateNamespace ? KubernetesNamespacesService.getOrCreateNamespace(authCtx, projectKey, containerConfig) : KubernetesNamespacesService.getNamespace(authCtx, projectKey, containerConfig);
        boolean withNamespace = StringUtils.isNotBlank((String)managedNamespace);
        boolean withTimeout = StringUtils.isNotBlank((String)requestTimeout);
        String[] result = new String[command.length + 1 + (withContext ? 2 : 0) + (withNamespace ? 2 : 0) + (withTimeout ? 2 : 0)];
        result[0] = "kubectl";
        int i = 1;
        if (withContext) {
            result[i++] = "--context";
            result[i++] = containerConfig.kubeCtlContext;
        }
        if (withNamespace) {
            result[i++] = "--namespace";
            result[i++] = managedNamespace;
        }
        if (withTimeout) {
            result[i++] = "--request-timeout";
            result[i++] = requestTimeout;
        }
        for (String chunk : command) {
            result[i++] = chunk;
        }
        return result;
    }

    public static String[] getKubeCtlCommand(AuthCtx authCtx, @Nullable String projectKey, ContainerExecRuntimeConfig containerConfig, boolean maybeCreateNamespace, String ... command) throws IOException, InterruptedException {
        return KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, null, containerConfig, maybeCreateNamespace, command);
    }

    public static String[] getKubeCtlCommandNoNamespace(AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig, String ... command) throws IOException, InterruptedException {
        if (containerConfig.noImplicitK8sClusterAndNoDefaultClusterId) {
            throw new RuntimeException("No default Kubernetes cluster selected and option `use builtin Kubernetes cluster` is disabled");
        }
        boolean withContext = StringUtils.isNotBlank((String)containerConfig.kubeCtlContext);
        String[] result = new String[command.length + 1 + (withContext ? 2 : 0)];
        result[0] = "kubectl";
        int i = 1;
        if (withContext) {
            result[i++] = "--context";
            result[i++] = containerConfig.kubeCtlContext;
        }
        for (String chunk : command) {
            result[i++] = chunk;
        }
        return result;
    }

    public static Map<String, String> getKubeCtlEnv(ContainerExecRuntimeConfig containerConfig) {
        HashMap env = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)containerConfig.kubeConfigPath)) {
            env.put("KUBECONFIG", containerConfig.kubeConfigPath);
        }
        return env;
    }

    public static String[] getKubeCtlCreateCommand(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String ... args) throws IOException, InterruptedException {
        String[] command;
        if (ApplicationConfigurator.getProperty((String)KUBERNETES_VALIDATE_PROPERTY, (String)KUBERNETES_VALIDATE_DEFAULT).equalsIgnoreCase("false")) {
            command = new String[args.length + 2];
            command[command.length - 1] = "--validate=false";
        } else {
            command = new String[args.length + 1];
        }
        command[0] = "create";
        System.arraycopy(args, 0, command, 1, args.length);
        return KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, true, command);
    }

    public static String[] getKubeCtlApplyCommand(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String ... args) throws IOException, InterruptedException {
        String[] command;
        if (ApplicationConfigurator.getProperty((String)KUBERNETES_VALIDATE_PROPERTY, (String)KUBERNETES_VALIDATE_DEFAULT).equalsIgnoreCase("false")) {
            command = new String[args.length + 2];
            command[command.length - 1] = "--validate=false";
        } else {
            command = new String[args.length + 1];
        }
        command[0] = "apply";
        System.arraycopy(args, 0, command, 1, args.length);
        return KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, true, command);
    }

    public static String getTicketSecretName(String executionId) throws IOException {
        return String.format("dkusecret-%s", executionId);
    }

    public static String getTicketSecretConf(String executionId, String secret) throws IOException {
        return KubernetesExecUtils.getSecretConf(KubernetesExecUtils.getTicketSecretName(executionId), "Opaque", KubernetesExecUtils.getSpec("apiticket", secret));
    }

    private static String getSpec(String name, String value) {
        return String.format("  %s: %s # base64", name, Base64.encodeBase64String((byte[])value.getBytes(StandardCharsets.UTF_8)));
    }

    public static String getTicketSecretConf(String executionId, String apiTicket, String executionSecretId) throws IOException {
        ArrayList<String> secrets = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)apiTicket)) {
            secrets.add(KubernetesExecUtils.getSpec("apiticket", apiTicket));
        }
        if (StringUtils.isNotBlank((String)executionSecretId)) {
            secrets.add(KubernetesExecUtils.getSpec("secret_id", executionSecretId));
        }
        String spec = secrets.stream().collect(Collectors.joining("\n"));
        return KubernetesExecUtils.getSecretConf(KubernetesExecUtils.getTicketSecretName(executionId), "Opaque", spec);
    }

    public static String getTlsSecretConf(String name, String keyPath, String crtPath) throws IOException {
        byte[] crt;
        byte[] key;
        try (FileInputStream is = new FileInputStream(keyPath);){
            key = IOUtils.toByteArray((InputStream)is);
        }
        is = new FileInputStream(crtPath);
        try {
            crt = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            ((InputStream)is).close();
        }
        String spec = String.format("  tls.key: %s\n  tls.crt: %s\n", Base64.encodeBase64String((byte[])key), Base64.encodeBase64String((byte[])crt));
        return KubernetesExecUtils.getSecretConf(name, "kubernetes.io/tls", spec);
    }

    private static String getSecretConf(String name, String secretType, String secretSnippet) throws IOException {
        return DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "secret.yaml"})).replace("__NAME__", name).replace("__TYPE__", secretType).replace("__SPEC__", secretSnippet);
    }

    public static String getPodConf(AuthCtx submitter, String executionId, String contextProjectKey, String jobId, String activityId, LabelsAndAnnotations laa, Map<String, String> environment, String imageTag, ContainerExecRuntimeConfig containerConfig) throws IOException {
        String podDesc = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "pod.yaml"})).replace("__DKU_BACKEND_HOST__", RemoteRunNetworkingUtils.getBackendHost()).replace("__DKU_BACKEND_PORT__", RemoteRunNetworkingUtils.getBackendRPCPort()).replace("__DKU_BACKEND_PROTOCOL__", RemoteRunNetworkingUtils.getBackendRPCProtocol()).replace("__DKU_BASE_PORT__", RemoteRunNetworkingUtils.getBasePort()).replace("__DKU_BASE_PROTOCOL__", RemoteRunNetworkingUtils.getBaseProtocol()).replace("__DKU_BASE_CERT__", RemoteRunNetworkingUtils.getBaseSslCertificateAsB64()).replace("__DKU_SERVER_HOST__", RemoteRunNetworkingUtils.getServerHost()).replace("__DKU_SERVER_PORT__", String.valueOf(RemoteRunNetworkingUtils.getServerPort())).replace("__DKU_SERVER_KIND__", String.valueOf(RemoteRunNetworkingUtils.getServerKind())).replace("__DKU_SERVER_PROTOCOL__", String.valueOf(RemoteRunNetworkingUtils.getServerProtocol())).replace("__DKU_SERVER_CERT__", EncryptedRPC.getPEMCertificateTextB64orNA()).replace("__DKU_IMAGE_ID__", imageTag).replace("__DKU_TMPDIR__", containerConfig.DKU_TMPDIR).replace("__DKU_EXECUTION_ID__", executionId);
        Map<String, String> env = ContainerExecUtils.getContainerExecEnvironmentFlags(containerConfig, environment);
        podDesc = KubernetesExecUtils.fillLabelsAndAnnotations(laa, podDesc);
        podDesc = KubernetesExecUtils.fillEnv(env, podDesc, containerConfig);
        podDesc = KubernetesExecUtils.fillResources(containerConfig.kubernetesResources, podDesc);
        podDesc = KubernetesExecUtils.fillVolumes(containerConfig, podDesc);
        podDesc = KubernetesExecUtils.fillSecurityContext(containerConfig, podDesc);
        podDesc = KubernetesExecUtils.fillInitContainers(containerConfig, podDesc, imageTag);
        podDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_NODESELECTOR__", containerConfig.nodeSelector, podDesc);
        podDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_AFFINITY__", containerConfig.affinity, podDesc);
        podDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOLERATIONS__", containerConfig.tolerations, podDesc);
        podDesc = KubernetesExecUtils.setupImagePullSecretsManifestSection(containerConfig.imagePullSecretName, podDesc);
        return podDesc;
    }

    public static String setupImagePullSecretsManifestSection(String imagePullSecretName, String podDesc) {
        if (StringUtils.isNotEmpty((String)imagePullSecretName)) {
            String imagePullSecretsSection = "imagePullSecrets:\n- name: " + imagePullSecretName + "\n";
            podDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_IMAGE_PULL_SECRETS__", imagePullSecretsSection, podDesc);
        }
        return podDesc;
    }

    private static void addExtraLabelsFromAppConfig(LabelsAndAnnotations ret, String dkuKey, boolean lowerCase) {
        String additionalLabels = ApplicationConfigurator.getParams().getParam(dkuKey, EMPTY_JSON_ARRAY);
        KubernetesExecUtils.addExtraLabels(ret, dkuKey + " (global)", additionalLabels, lowerCase);
    }

    private static void addExtraLabels(LabelsAndAnnotations ret, String labelInLog, String additionalLabels, boolean lowerCase) {
        ExtraList labels = (ExtraList)JSON.parse((String)additionalLabels, ExtraList.class);
        for (SimpleKeyValue skv : labels) {
            if (skv != null) {
                ret.putLabel(skv.key, skv.value, false, lowerCase);
                continue;
            }
            logger.warn((Object)("Null key in label " + labelInLog + ", you may have an empty entry in your JSON string."));
        }
    }

    private static void addExtraAnnotationsFromAppConfig(LabelsAndAnnotations ret, String dkuKey) {
        String allExtraAnnotations = ApplicationConfigurator.getParams().getParam(dkuKey, EMPTY_JSON_ARRAY);
        KubernetesExecUtils.addExtraAnnotations(ret, dkuKey + " (global)", allExtraAnnotations);
    }

    private static void addExtraAnnotations(LabelsAndAnnotations ret, String labelInLog, String allExtraAnnotations) {
        ExtraList allAnnotations = (ExtraList)JSON.parse((String)allExtraAnnotations, ExtraList.class);
        for (SimpleKeyValue skv : allAnnotations) {
            if (skv != null) {
                ret.annotations.put(skv.key, skv.value);
                continue;
            }
            logger.warn((Object)("Null key in annotation " + labelInLog + ", you may have an empty entry in your JSON string."));
        }
    }

    public static LabelsAndAnnotations getIdentifiersBasedOnCRUContext(AuthCtx submitter, String executionId, ContainerExecRuntimeConfig containerConfig) {
        MainLoggingConfigurator.ProcessType processType;
        LabelsAndAnnotations ret = new LabelsAndAnnotations();
        String addKey = null;
        ComputeResourceUsageContext ctx = CurrentComputeResourceUsageContext.get();
        ret.putLabelAndAnnotation(DKU_EXEC_SUBMITTER_KEY, submitter.getIdentifier());
        ret.putLabel(DKU_EXECUTION_ID_KEY, executionId);
        ret.putLabelAndAnnotation(DKU_INSTALL_ID_KEY, ApplicationConfigurator.getInstallId());
        String nodeId = ApplicationConfigurator.getNodeId();
        if (nodeId != null) {
            ret.putLabel("dataiku.com/dku-node-id", nodeId);
        }
        if ((processType = ApplicationConfigurator.getProcessType()) != null && !StringUtils.isBlank((String)processType.name())) {
            ret.putLabel(DKU_PROCESS_TYPE_KEY, processType.name());
        }
        if (containerConfig != null && !StringUtils.isBlank((String)containerConfig.name)) {
            ret.putLabelAndAnnotation(DKU_CONTAINER_CONF_KEY, containerConfig.name);
        }
        KubernetesExecUtils.addExtraLabelsFromAppConfig(ret, DKU_KUBERNETES_ALL_EXTRA_LABEL_KEY, true);
        KubernetesExecUtils.addExtraLabelsFromAppConfig(ret, DKU_KUBERNETES_ALL_CASE_INSENSITIVE_EXTRA_LABEL_KEY, false);
        KubernetesExecUtils.addExtraAnnotationsFromAppConfig(ret, DKU_KUBERNETES_ALL_EXTRA_ANNOTATIONS);
        if (containerConfig != null) {
            KubernetesExecUtils.addExtraLabels(ret, DKU_KUBERNETES_ALL_EXTRA_LABEL_KEY, containerConfig.getProperty(DKU_KUBERNETES_ALL_EXTRA_LABEL_KEY, EMPTY_JSON_ARRAY), true);
            KubernetesExecUtils.addExtraLabels(ret, DKU_KUBERNETES_ALL_CASE_INSENSITIVE_EXTRA_LABEL_KEY, containerConfig.getProperty(DKU_KUBERNETES_ALL_CASE_INSENSITIVE_EXTRA_LABEL_KEY, EMPTY_JSON_ARRAY), false);
            KubernetesExecUtils.addExtraAnnotations(ret, DKU_KUBERNETES_ALL_EXTRA_ANNOTATIONS, containerConfig.getProperty(DKU_KUBERNETES_ALL_EXTRA_ANNOTATIONS, EMPTY_JSON_ARRAY));
        }
        if (ctx != null) {
            switch (ctx.type) {
                case ANALYSIS_ML_TRAIN: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_ANALYSIS_ID_KEY, ctx.analysisId);
                    ret.putLabel("dataiku.com/dku-mltask-id", ctx.mlTaskId);
                    ret.putLabel("dataiku.com/dku-mltask-session-id", ctx.sessionId);
                    break;
                }
                case WEBAPP_BACKEND: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_WEBAPP_ID_KEY, ctx.webappId);
                    break;
                }
                case JUPYTER_NOTEBOOK_KERNEL: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabel(DKU_NOTEBOOK_ID_KEY, ctx.jupyterNotebookId);
                    ret.annotations.put(DKU_NOTEBOOK_ID_KEY, ctx.jupyterNotebookId);
                    break;
                }
                case EDA: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_DATASET_NAME_KEY, ctx.datasetName);
                    break;
                }
                case JOB_ACTIVITY: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_JOB_ID_KEY, ctx.jobId, true);
                    ret.putLabel(DKU_ACTIVITY_ID_KEY, ctx.activityId, true, true);
                    break;
                }
                case CONTINUOUS_ACTIVITY: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_ACTIVITY_ID_KEY, ctx.activityId, true);
                    break;
                }
                case POOLED_SPARKSQL_CONNECTION: {
                    break;
                }
                case API_DEPLOYER_DEPLOYMENT: {
                    addKey = "dku.kubernetes.apideployer";
                    ret.putLabel(DKU_APIDEPLOYER_INFRA_ID_KEY, ctx.apiDeployerInfraId);
                    ret.putLabel("dataiku.com/dku-apideployer-service-id", ctx.apiDeployerServiceId);
                    ret.putLabelAndAnnotation(DKU_APIDEPLOYER_DEPLOYMENT_ID_KEY, ctx.apiDeployerDeploymentId);
                    break;
                }
                case CODE_STUDIO: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_CODESTUDIO_ID_KEY, ctx.codeStudioId);
                    break;
                }
                case HF_MODEL: {
                    addKey = "dku.kubernetes.jobs";
                    ret.putLabelAndAnnotation(DKU_LLM_ID, ctx.llmId);
                    break;
                }
                case SAVED_MODEL_OPERATION: 
                case MODEL_EVALUATION_OPERATION: {
                    logger.warn((Object)("Not yet implemented: compute identifiers for resource usage of type " + String.valueOf(ctx.type)));
                    break;
                }
                case JOB_MAIN_PROCESS: 
                case JOB_DEPS_COMPUTATION: 
                case SQL_NOTEBOOK: {
                    logger.warn((Object)("Should not be creating K8S identifiers for a compute resource usage of type " + String.valueOf(ctx.type)));
                }
            }
            if (StringUtils.isNotBlank((String)ctx.projectKey) && !"__DKU_ANY_PROJECT__".equals(ctx.projectKey)) {
                ret.putLabelAndAnnotation(DKU_PROJECT_KEY_KEY, ctx.projectKey);
            }
            if (ctx.type != null && StringUtils.isNotEmpty((String)ctx.type.toString())) {
                ret.putLabelAndAnnotation(DKU_EXECUTION_TYPE_KEY, ctx.type.toString());
            }
        }
        if (addKey != null) {
            String customExtraLabelsKey = addKey + ".extraLabels";
            KubernetesExecUtils.addExtraLabelsFromAppConfig(ret, customExtraLabelsKey, true);
            String customCaseInsensitiveExtraLabelsKey = addKey + ".caseSensitiveExtraLabels";
            KubernetesExecUtils.addExtraLabelsFromAppConfig(ret, customCaseInsensitiveExtraLabelsKey, false);
            String customExtraAnnotationsKey = addKey + ".extraAnnotations";
            KubernetesExecUtils.addExtraAnnotationsFromAppConfig(ret, customExtraAnnotationsKey);
            if (containerConfig != null) {
                KubernetesExecUtils.addExtraLabels(ret, customExtraLabelsKey, containerConfig.getProperty(customExtraLabelsKey, EMPTY_JSON_ARRAY), true);
                KubernetesExecUtils.addExtraLabels(ret, customCaseInsensitiveExtraLabelsKey, containerConfig.getProperty(customCaseInsensitiveExtraLabelsKey, EMPTY_JSON_ARRAY), false);
                KubernetesExecUtils.addExtraAnnotations(ret, customExtraAnnotationsKey, containerConfig.getProperty(customExtraAnnotationsKey, EMPTY_JSON_ARRAY));
            }
        }
        return ret;
    }

    public static float getKubernetesVersion(ContainerExecRuntimeConfig containerConfig) {
        String initialK8sVersion = containerConfig.getProperty("kubernetes.initial.version", "1.10");
        String v = containerConfig.getProperty("kubernetes.version", initialK8sVersion);
        try {
            String[] chunks = v.trim().split("\\.");
            if (chunks.length == 0) {
                return 1.01f;
            }
            if (chunks.length == 1) {
                return Float.parseFloat(chunks[0]);
            }
            int major = Integer.parseInt(chunks[0]);
            int minor = Integer.parseInt(chunks[1]);
            return (float)((double)major + 0.001 * (double)minor);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to parse kubernetes version in properties : " + v));
            return 1.01f;
        }
    }

    public static String getDeploymentApiVersion(ContainerExecRuntimeConfig containerConfig) {
        float k8Sversion = KubernetesExecUtils.getKubernetesVersion(containerConfig);
        logger.info((Object)("Working on K8S version " + k8Sversion));
        return k8Sversion < 1.01f ? "apps/v1beta2" : "apps/v1";
    }

    public static String getAutoscalerApiVersion(ContainerExecRuntimeConfig containerConfig) {
        float v = KubernetesExecUtils.getKubernetesVersion(containerConfig);
        if (v < 1.01f) {
            return "autoscaling/v1";
        }
        if (v < 1.012f) {
            return "autoscaling/v2beta1";
        }
        if (v < 1.026f) {
            return "autoscaling/v2beta2";
        }
        return "autoscaling/v2";
    }

    public static String padBlock(String block, String padding) {
        ArrayList lines = Lists.newArrayList((Object[])StringUtils.defaultIfBlank((String)block, (String)"").split("\n"));
        return lines.isEmpty() ? "" : "      " + Joiner.on((String)"\n      ").join((Iterable)lines) + "\n";
    }

    public static String getDeploymentConfForWebapp(AuthCtx submitter, String executionId, String contextProjectKey, LabelsAndAnnotations laa, Map<String, String> environment, String imageTag, ContainerExecRuntimeConfig containerConfig, int nbReplicas, String readinessProbe) throws IOException {
        String apiVersion = KubernetesExecUtils.getDeploymentApiVersion(containerConfig);
        String deploymentDesc = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "deployment.yaml"})).replace("__API_VERSION__", apiVersion).replace("__DKU_BACKEND_HOST__", RemoteRunNetworkingUtils.getBackendHost()).replace("__DKU_BACKEND_PORT__", RemoteRunNetworkingUtils.getBackendRPCPort()).replace("__DKU_BACKEND_PROTOCOL__", RemoteRunNetworkingUtils.getBackendRPCProtocol()).replace("__DKU_BASE_PORT__", RemoteRunNetworkingUtils.getBasePort()).replace("__DKU_BASE_PROTOCOL__", RemoteRunNetworkingUtils.getBaseProtocol()).replace("__DKU_BASE_CERT__", RemoteRunNetworkingUtils.getBaseSslCertificateAsB64()).replace("__DKU_SERVER_HOST__", RemoteRunNetworkingUtils.getServerHost()).replace("__DKU_SERVER_PORT__", String.valueOf(RemoteRunNetworkingUtils.getServerPort())).replace("__DKU_SERVER_KIND__", String.valueOf(RemoteRunNetworkingUtils.getServerKind())).replace("__DKU_SERVER_PROTOCOL__", String.valueOf(RemoteRunNetworkingUtils.getServerProtocol())).replace("__DKU_SERVER_CERT__", EncryptedRPC.getPEMCertificateTextB64orNA()).replace("__DKU_IMAGE_ID__", imageTag).replace("__NB_REPLICAS__", Integer.toString(nbReplicas)).replace("__DKU_READINESS_PATH__", readinessProbe).replace("__DKU_TMPDIR__", containerConfig.DKU_TMPDIR).replace("__DKU_EXECUTION_ID__", executionId);
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(contextProjectKey);
        Map<String, String> env = ContainerExecUtils.getContainerExecEnvironmentFlags(containerConfig, environment);
        deploymentDesc = KubernetesExecUtils.fillEnv(env, deploymentDesc, containerConfig);
        deploymentDesc = KubernetesExecUtils.fillLabelsAndAnnotations(laa, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillResources(containerConfig.kubernetesResources, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillVolumes(containerConfig, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_NODESELECTOR__", containerConfig.nodeSelector, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_AFFINITY__", containerConfig.affinity, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOLERATIONS__", containerConfig.tolerations, deploymentDesc);
        String tsc = containerConfig.deploymentTopologySpreadConstraints;
        deploymentDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOPOLOGY_SPREAD_CONSTRAINTS__", StringUtils.isBlank((String)tsc) ? tsc : vc.expandEmptyIfUnresolved(tsc), deploymentDesc);
        deploymentDesc = KubernetesExecUtils.setupImagePullSecretsManifestSection(containerConfig.imagePullSecretName, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillSecurityContext(containerConfig, deploymentDesc);
        deploymentDesc = KubernetesExecUtils.fillInitContainers(containerConfig, deploymentDesc, imageTag);
        return deploymentDesc;
    }

    public static String getDeploymentConfForCodeStudio(AuthCtx submitter, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException {
        String apiVersion = KubernetesExecUtils.getDeploymentApiVersion(launchEnv.containerConfig);
        String imageTag = ContainerExecImagesHelper.withRepositoryURL(launchEnv.containerConfig, launchEnv.templateImage);
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(launchEnv.projectKey);
        vc.add("executionId", launchEnv.executionId);
        vc.add("imageTag", imageTag);
        vc.add("baseUrl", launchEnv.baseUrlLNT);
        for (CodeStudioMeta.SyncZoneInstance synced : launchSpec.syncedZones) {
            CodeStudioSyncZones.lookup(synced.zone).addAsVariable(vc, synced);
        }
        LabelsAndAnnotations laa = new LabelsAndAnnotations();
        laa.putAllLabels(launchEnv.labels);
        laa.putAllLabels(launchSpec.extraLabels);
        laa.putLabelIfNotExists(DKU_EXECUTION_ID_KEY, launchEnv.executionId);
        String selector = laa.getLabel(DKU_EXECUTION_ID_KEY);
        laa.annotations.putAll(launchEnv.annotations);
        laa.annotations.putAll(launchSpec.extraAnnotations);
        Map<String, String> env = ContainerExecUtils.getContainerExecEnvironmentFlags(launchEnv.containerConfig, Maps.newHashMap());
        for (CodeStudioMeta.SyncZoneInstance synced : launchSpec.syncedZones) {
            CodeStudioSyncZones.lookup(synced.zone).addInMap(env, synced);
        }
        for (CodeStudioMeta.ExposedCodeStudioPort exposedPort : launchSpec.exposedPorts) {
            vc.add("exposedPort", Integer.toString(exposedPort.port));
            String baseUrlForPort = vc.expandAllowUnresolved(launchEnv.baseUrlLNTPerPort);
            env.put("DKU_CODE_STUDIO_BROWSER_PATH_" + exposedPort.port, baseUrlForPort);
            vc.add("baseUrlPort" + exposedPort.port, baseUrlForPort);
            env.put("DKU_CODE_STUDIO_IS_PUBLIC_PORT_" + exposedPort.port, exposedPort.containerPort == null || exposedPort.containerPort == exposedPort.port ? "1" : "0");
        }
        if (EncryptedRPC.enabled()) {
            env.put("DKU_SERVER_CERT", EncryptedRPC.getPEMCertificateText());
        }
        Object rdyProbe = "";
        if (launchSpec.useTcpReadiness) {
            if (launchSpec.exposedPorts.isEmpty()) {
                logger.warn((Object)"No exposed service to use a port from, not adding a readiness probe");
            } else {
                CodeStudioMeta.ExposedCodeStudioPort exposedPort;
                exposedPort = launchSpec.exposedPorts.get(0);
                int outsidePort = exposedPort.containerPort == null ? exposedPort.port : exposedPort.containerPort;
                rdyProbe = "readinessProbe:\n  tcpSocket:\n    port: " + outsidePort + "\n  initialDelaySeconds: 2\n  periodSeconds: 10\n  timeoutSeconds: 2\n";
            }
        } else if (StringUtils.isNotBlank((String)launchSpec.readinessProbeUrl)) {
            String readinessProbeUrl = vc.expandAllowUnresolved(launchSpec.readinessProbeUrl);
            try {
                HttpGetActionParts probeParts = KubernetesExecUtils.getProbeParts(readinessProbeUrl);
                rdyProbe = "readinessProbe:\n  httpGet:\n";
                if (StringUtils.isNotBlank((String)probeParts.scheme)) {
                    if ("http".equalsIgnoreCase(probeParts.scheme) || "https".equalsIgnoreCase(probeParts.scheme)) {
                        rdyProbe = (String)rdyProbe + "    scheme: " + probeParts.scheme.toUpperCase() + "\n";
                    } else {
                        logger.warn((Object)("Invalid scheme for probe, ignoring (defaulting to http): " + probeParts.scheme));
                    }
                }
                if (StringUtils.isNotBlank((String)probeParts.host)) {
                    rdyProbe = (String)rdyProbe + "    host: \"" + probeParts.host + "\"\n";
                }
                if (probeParts.port > 0) {
                    int port = probeParts.port;
                    for (CodeStudioMeta.ExposedCodeStudioPort exposedPort : launchSpec.exposedPorts) {
                        if (exposedPort.port != port) continue;
                        if (exposedPort.containerPort == null) break;
                        port = exposedPort.containerPort;
                        break;
                    }
                    rdyProbe = (String)rdyProbe + "    port: " + port + "\n";
                }
                if (StringUtils.isNotBlank((String)probeParts.path) && !"/".equals(probeParts.path)) {
                    rdyProbe = (String)rdyProbe + "    path: \"" + probeParts.path + "\"\n";
                }
                if (!launchSpec.readinessProbeHeaders.isEmpty()) {
                    rdyProbe = (String)rdyProbe + "    httpHeaders:\n";
                    for (SimpleKeyValue header : launchSpec.readinessProbeHeaders) {
                        rdyProbe = (String)rdyProbe + "    - name: \"" + header.key + "\"\n      value: \"" + header.value + "\"\n";
                    }
                }
                rdyProbe = (String)rdyProbe + "  initialDelaySeconds: 2\n  periodSeconds: 20\n  timeoutSeconds: 2\n";
            }
            catch (Exception e) {
                logger.warn((Object)"Readiness probe url is invalid, skipping probe", (Throwable)e);
            }
        }
        String template = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "code-studio.yaml"}));
        int startupProbePeriodSeconds = 10;
        int startupProbeFailureThreshold = 30;
        int progressDeadlineSeconds = 600;
        if (launchSpec.initialSyncTimeoutInMinutes != null) {
            progressDeadlineSeconds = launchSpec.initialSyncTimeoutInMinutes * 60;
            startupProbeFailureThreshold = (progressDeadlineSeconds - 20 - 5) / startupProbePeriodSeconds;
        }
        String yaml = template.replace("__API_VERSION__", apiVersion).replace("__DKU_EXECUTION_ID__", launchEnv.executionId).replace("__DKU_SELECTOR__", selector).replace("__DKU_IMAGE_ID__", imageTag).replace("__DKU_BACKEND_HOST__", RemoteRunNetworkingUtils.getBackendHost()).replace("__DKU_BACKEND_PORT__", RemoteRunNetworkingUtils.getBackendRPCPort()).replace("__DKU_BACKEND_PROTOCOL__", RemoteRunNetworkingUtils.getBackendRPCProtocol()).replace("__DKU_BASE_PORT__", RemoteRunNetworkingUtils.getBasePort()).replace("__DKU_BASE_PROTOCOL__", RemoteRunNetworkingUtils.getBaseProtocol()).replace("__DKU_BASE_CERT__", RemoteRunNetworkingUtils.getBaseSslCertificateAsB64()).replace("__DKU_CODE_STUDIO_BROWSER_PATH__", launchEnv.baseUrlLNT).replace("__DKU_DEFAULT_PROJECT_KEY__", launchEnv.projectKey).replace("__DKU_CURRENT_PROJECT_KEY__", launchEnv.projectKey).replace("__DKU_API_TICKET__", Base64.encodeBase64String(launchEnv.apiTicket != null ? launchEnv.apiTicket.getBytes(StandardCharsets.UTF_8) : null)).replace("__DKU_KUBERNETES_STARTUP_PROBE_PERIOD_SECONDS__", String.valueOf(startupProbePeriodSeconds)).replace("__DKU_KUBERNETES_STARTUP_PROBE_FAILURE_THRESHOLD__", String.valueOf(startupProbeFailureThreshold)).replace("__PROGRESS_DEADLINE_SECONDS__", String.valueOf(progressDeadlineSeconds)).replace("__DKU_TMPDIR__", launchEnv.containerConfig.DKU_TMPDIR);
        yaml = KubernetesExecUtils.setupImagePullSecretsManifestSection(launchEnv.containerConfig.imagePullSecretName, yaml);
        yaml = KubernetesExecUtils.fillContainerPorts(launchSpec.exposedPorts, yaml);
        yaml = KubernetesExecUtils.fillEnv(env, yaml, launchEnv.containerConfig);
        yaml = KubernetesExecUtils.fillLabelsAndAnnotations(laa, yaml);
        yaml = KubernetesExecUtils.fillResources(launchEnv.containerConfig.kubernetesResources, yaml);
        yaml = KubernetesExecUtils.fillVolumes(launchEnv.containerConfig, yaml);
        yaml = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_CONTAINER_READINESS_PROBE__", (String)rdyProbe, yaml);
        yaml = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_NODESELECTOR__", launchEnv.containerConfig.nodeSelector, yaml);
        yaml = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_AFFINITY__", launchEnv.containerConfig.affinity, yaml);
        yaml = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOLERATIONS__", launchEnv.containerConfig.tolerations, yaml);
        String tsc = launchEnv.containerConfig.deploymentTopologySpreadConstraints;
        yaml = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOPOLOGY_SPREAD_CONSTRAINTS__", StringUtils.isBlank((String)tsc) ? tsc : vc.expandEmptyIfUnresolved(tsc), yaml);
        yaml = KubernetesExecUtils.fillSecurityContext(launchEnv.containerConfig, yaml);
        yaml = KubernetesExecUtils.fillInitContainers(launchEnv.containerConfig, yaml, imageTag);
        return yaml;
    }

    public static String getReplicaSetConfForContinuous(AuthCtx submitter, String executionId, String contextProjectKey, LabelsAndAnnotations laa, Map<String, String> environment, String imageTag, ContainerExecRuntimeConfig containerConfig, int nbReplicas) throws IOException {
        String apiVersion = KubernetesExecUtils.getDeploymentApiVersion(containerConfig);
        String replicaSetDesc = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "replicaset.yaml"})).replace("__API_VERSION__", apiVersion).replace("__DKU_BACKEND_HOST__", RemoteRunNetworkingUtils.getBackendHost()).replace("__DKU_BACKEND_PORT__", RemoteRunNetworkingUtils.getBackendRPCPort()).replace("__DKU_BACKEND_PROTOCOL__", RemoteRunNetworkingUtils.getBackendRPCProtocol()).replace("__DKU_BASE_PORT__", RemoteRunNetworkingUtils.getBasePort()).replace("__DKU_BASE_PROTOCOL__", RemoteRunNetworkingUtils.getBaseProtocol()).replace("__DKU_BASE_CERT__", RemoteRunNetworkingUtils.getBaseSslCertificateAsB64()).replace("__DKU_SERVER_HOST__", RemoteRunNetworkingUtils.getServerHost()).replace("__DKU_SERVER_PORT__", String.valueOf(RemoteRunNetworkingUtils.getServerPort())).replace("__DKU_SERVER_KIND__", String.valueOf(RemoteRunNetworkingUtils.getServerKind())).replace("__DKU_SERVER_PROTOCOL__", String.valueOf(RemoteRunNetworkingUtils.getServerProtocol())).replace("__DKU_SERVER_CERT__", EncryptedRPC.getPEMCertificateTextB64orNA()).replace("__DKU_IMAGE_ID__", imageTag).replace("__NB_REPLICAS__", Integer.toString(nbReplicas)).replace("__DKU_EXECUTION_ID__", executionId);
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(contextProjectKey);
        Map<String, String> env = ContainerExecUtils.getContainerExecEnvironmentFlags(containerConfig, environment);
        replicaSetDesc = KubernetesExecUtils.fillEnv(env, replicaSetDesc, containerConfig);
        replicaSetDesc = KubernetesExecUtils.fillLabelsAndAnnotations(laa, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillResources(containerConfig.kubernetesResources, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillVolumes(containerConfig, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_NODESELECTOR__", containerConfig.nodeSelector, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_AFFINITY__", containerConfig.affinity, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOLERATIONS__", containerConfig.tolerations, replicaSetDesc);
        String tsc = containerConfig.deploymentTopologySpreadConstraints;
        replicaSetDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOPOLOGY_SPREAD_CONSTRAINTS__", StringUtils.isBlank((String)tsc) ? tsc : vc.expandEmptyIfUnresolved(tsc), replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.setupImagePullSecretsManifestSection(containerConfig.imagePullSecretName, replicaSetDesc);
        replicaSetDesc = KubernetesExecUtils.fillSecurityContext(containerConfig, replicaSetDesc);
        return replicaSetDesc;
    }

    public static String getAutoscalerConf(String executionId, String deploymentName, ContainerExecRuntimeConfig containerConfig, K8SAPIDeploymentInfra.K8SDeploymentScaling scaling) throws IOException {
        String apiVersion = KubernetesExecUtils.getAutoscalerApiVersion(containerConfig);
        String deploymentApiVersion = KubernetesExecUtils.getDeploymentApiVersion(containerConfig);
        String scalingCondition = KubernetesExecUtils.buildScalingCondition(scaling, apiVersion);
        HashMap<String, String> annotations = new HashMap<String, String>();
        for (SimpleKeyValue kv : scaling.hpaAnnotations) {
            annotations.put(kv.key, kv.value);
        }
        String annotationsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", annotations, "  ");
        String autoScalerDesc = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "autoscaler.yaml"})).replace("__DKU_EXECUTION_ID__", executionId).replace("__DEPLOYMENT_NAME__", deploymentName).replace("__API_VERSION__", apiVersion).replace("__DEPLOYMENT_API_VERSION__", deploymentApiVersion).replace("__ANNOTATIONS__", annotationsBlock).replace("__NB_REPLICAS__", Integer.toString(scaling.initialReplicas)).replace("__MIN_PODS__", Integer.toString(scaling.hpaMinPods)).replace("__MAX_PODS__", Integer.toString(scaling.hpaMaxPods)).replace("__SCALING_CONDITION__", scalingCondition);
        return autoScalerDesc;
    }

    public static String getPodDisruptionBudgetConf(String executionId, K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget podDisruptionBudget) throws IOException {
        String pdbCondition = podDisruptionBudget.isMaxUnavailable ? "maxUnavailable: " + podDisruptionBudget.maxUnavailable : "minAvailable: " + podDisruptionBudget.minAvailable;
        String pdbDesc = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "pdb.yaml"})).replace("__DKU_EXECUTION_ID__", executionId).replace("__PDB_CONDITION__", pdbCondition);
        return pdbDesc;
    }

    public static String buildScalingCondition(K8SAPIDeploymentInfra.K8SDeploymentScaling scaling, String apiVersion) throws IOException {
        Object scalingCondition;
        if (apiVersion.equals("autoscaling/v1")) {
            scalingCondition = String.format("  targetCPUUtilizationPercentage: %s\n", Integer.toString(scaling.hpaTargetCPUPercent));
            if (!scaling.hpaMetrics.isEmpty()) {
                throw new IOException("Can use HPA on cpu utilization, cluster is not flagged as version >= 1.10");
            }
        } else {
            ArrayList metricsLines = Lists.newArrayList();
            if (scaling.hpaTargetCPUPercent > 0) {
                metricsLines.add("- type: Resource");
                metricsLines.add("  resource:");
                metricsLines.add("    name: cpu");
                if (apiVersion.equals("autoscaling/v2beta1")) {
                    metricsLines.add("    targetAverageUtilization: " + scaling.hpaTargetCPUPercent);
                } else {
                    metricsLines.add("    target:");
                    metricsLines.add("      type: Utilization");
                    metricsLines.add("      averageUtilization: " + scaling.hpaTargetCPUPercent);
                }
            }
            if (scaling.hpaTargetMemoryPercent > 0) {
                metricsLines.add("- type: Resource");
                metricsLines.add("  resource:");
                metricsLines.add("    name: memory");
                if (apiVersion.equals("autoscaling/v2beta1")) {
                    metricsLines.add("    targetAverageUtilization: " + scaling.hpaTargetMemoryPercent);
                } else {
                    metricsLines.add("    target:");
                    metricsLines.add("      type: Utilization");
                    metricsLines.add("      averageUtilization: " + scaling.hpaTargetMemoryPercent);
                }
            }
            for (K8SAPIDeploymentInfra.K8SAutoscalerMetric metric : scaling.hpaMetrics) {
                metricsLines.add("- type: " + metric.type);
                metricsLines.add("  " + metric.type.toLowerCase() + ":");
                if (apiVersion.equals("autoscaling/v2beta1")) {
                    metricsLines.add("    name: " + metric.name);
                    if (metric.utilization) {
                        metricsLines.add("    targetAverageUtilization: " + metric.value);
                        continue;
                    }
                    metricsLines.add("    targetAverageValue: " + metric.value);
                    continue;
                }
                if ("Resource".equals(metric.type)) {
                    metricsLines.add("    name: " + metric.name);
                } else {
                    metricsLines.add("    metric:");
                    metricsLines.add("      name: " + metric.name);
                }
                metricsLines.add("    target:");
                if (metric.utilization) {
                    metricsLines.add("      type: Utilization");
                    metricsLines.add("      averageUtilization: " + metric.value);
                    continue;
                }
                metricsLines.add("      type: AverageValue");
                metricsLines.add("      averageValue: " + metric.value);
            }
            if (StringUtils.isNotBlank((String)scaling.hpaExtraMetrics)) {
                for (String line : scaling.hpaExtraMetrics.split("\n")) {
                    metricsLines.add(line);
                }
            }
            scalingCondition = "  metrics:\n  " + Joiner.on((String)"\n  ").join((Iterable)metricsLines) + "\n";
        }
        return scalingCondition;
    }

    public static String makeLabelsOrAnnotationsMap(String name, Map<String, String> map, String indent) {
        return KubernetesExecUtils.makeLabelsOrAnnotationsMap(name, map, indent, true);
    }

    public static String makeLabelsOrAnnotationsMap(String name, Map<String, String> map, String indent, boolean addNameIfNotEmpty) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (addNameIfNotEmpty) {
            sb.append(indent);
            sb.append(name);
            sb.append(": ");
        }
        sb.append(JSON.json(map));
        return sb.toString();
    }

    public static String getServiceConf(String namePrefix, String executionId, String specSnippet, Map<String, String> labels, Map<String, String> annotations, Map<String, String> selectors) throws IOException {
        String annotationsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", annotations, "  ");
        String labelsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("labels", labels, "  ");
        String selectorsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("selector", selectors, "  ");
        String spec = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "service.yaml"})).replace("__NAME_PREFIX__", namePrefix).replace("__DKU_EXECUTION_ID__", executionId).replaceAll("__SPEC_SNIPPET__", specSnippet).replace("__ANNOTATIONS__", annotationsBlock).replace("__LABELS__", labelsBlock).replace("__SELECTORS__", selectorsBlock);
        return spec;
    }

    public static String getBackendConfigConf(String namePrefix, String executionId, String backendSnippet, Map<String, String> labels, Map<String, String> annotations) throws IOException {
        String annotationsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", annotations, "  ");
        String labelsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("labels", labels, "  ");
        String spec = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "backend.yaml"})).replace("__NAME_PREFIX__", namePrefix).replace("__DKU_EXECUTION_ID__", executionId).replaceAll("__SPEC_SNIPPET__", backendSnippet).replace("__ANNOTATIONS__", annotationsBlock).replace("__LABELS__", labelsBlock);
        return spec;
    }

    public static String getIngressConf(String namePrefix, String executionId, int servicePort, @Nullable String servicePortName, String servicePath, Map<String, String> labels, Map<String, String> annotations, List<IngressTLS> tls, ContainerExecRuntimeConfig containerConfig, String ingressClassNameSpec) throws IOException {
        String annotationsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", annotations, "  ");
        String labelsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("labels", labels, "  ");
        String tlsBlock = tls == null || tls.isEmpty() ? "" : String.format("  tls:\n%s\n", Joiner.on((String)"\n").join(Iterables.transform(tls, (Function)new Function<IngressTLS, String>(){

            public String apply(IngressTLS x) {
                return x.toYaml();
            }
        })));
        String servicePathLine = StringUtils.isNotBlank((String)servicePath) ? String.format("path: %s\n        ", servicePath) : "";
        float k8Sversion = KubernetesExecUtils.getKubernetesVersion(containerConfig);
        logger.info((Object)("Working on K8S version " + k8Sversion));
        boolean usesLegacyApi = k8Sversion < 1.019f;
        String resourceFile = usesLegacyApi ? "ingress_pre1_19.yaml" : "ingress_1_19.yaml";
        String spec = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", resourceFile})).replace("__NAME_PREFIX__", namePrefix).replace("__DKU_EXECUTION_ID__", executionId).replace("__OPTIONAL_SERVICE_PATH__", servicePathLine).replace("__ANNOTATIONS__", annotationsBlock).replace("__LABELS__", labelsBlock).replace("__TLS__", tlsBlock);
        if (usesLegacyApi) {
            String servicePortIdentifier = StringUtils.isBlank((String)servicePortName) ? String.valueOf(servicePort) : servicePortName;
            spec = spec.replace("__SERVICE_PORT__", servicePortIdentifier);
        } else {
            String servicePortIdentifierLine = StringUtils.isBlank((String)servicePortName) ? "number: %d".formatted(servicePort) : "name: %s".formatted(servicePortName);
            spec = KubernetesExecUtils.fillSingleReplacement("__DKU_KUBERNETES_SERVICE_PORT_ID__", servicePortIdentifierLine, spec);
        }
        spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_INGRESSCLASSNAME__", ingressClassNameSpec, spec);
        return spec;
    }

    public static List<String> getResourcesLines(K8SAPIDeploymentInfra.K8SContainerLimits kubernetesResources) {
        ArrayList ret = Lists.newArrayList();
        if (kubernetesResources.hasLimits() || kubernetesResources.hasRequests()) {
            ret.add("resources:");
            if (kubernetesResources.hasRequests()) {
                ret.add("  requests:");
                if (kubernetesResources.cpuRequest > 0.0) {
                    ret.add("    cpu: \"" + kubernetesResources.cpuRequest + "\"");
                }
                if (kubernetesResources.memRequestMB > 0) {
                    ret.add("    memory: \"" + kubernetesResources.memRequestMB + "Mi\"");
                }
                for (ClusterProperty skv : kubernetesResources.customRequests) {
                    ret.add("    " + skv.key + ": \"" + skv.value + "\"");
                }
            }
            if (kubernetesResources.hasLimits()) {
                ret.add("  limits:");
                if (kubernetesResources.cpuLimit > 0.0) {
                    ret.add("    cpu: \"" + kubernetesResources.cpuLimit + "\"");
                }
                if (kubernetesResources.memLimitMB > 0) {
                    ret.add("    memory: \"" + kubernetesResources.memLimitMB + "Mi\"");
                }
                for (ClusterProperty skv : kubernetesResources.customLimits) {
                    ret.add("    " + skv.key + ": \"" + skv.value + "\"");
                }
            }
        }
        return ret;
    }

    public static String fillResources(K8SAPIDeploymentInfra.K8SContainerLimits kubernetesResources, String k8sDesc) {
        List<String> lines = KubernetesExecUtils.getResourcesLines(kubernetesResources);
        return KubernetesExecUtils.fillSingleReplacement("__DKU_KUBERNETES_RESOURCES__", lines, k8sDesc);
    }

    public static String fillLabelsAndAnnotations(LabelsAndAnnotations laa, String k8sDesc) {
        Matcher kubLabels;
        while ((kubLabels = Pattern.compile("^(\\s+)#\\s*__DKU_LABELS_AND_ANNOTATIONS__\n", 8).matcher(k8sDesc)).find()) {
            Object out = "";
            String indent = kubLabels.group(1);
            out = (String)out + indent + "labels: " + JSON.json(laa.getLabels()) + "\n";
            if (laa.annotations.size() > 0) {
                out = (String)out + indent + "annotations: " + JSON.json(laa.annotations) + "\n";
            }
            k8sDesc = kubLabels.replaceFirst("__DKU_LABELS_AND_ANNOTATIONS__").replaceFirst("__DKU_LABELS_AND_ANNOTATIONS__", Matcher.quoteReplacement((String)out));
        }
        return k8sDesc;
    }

    public static String fillContainerPorts(List<CodeStudioMeta.ExposedCodeStudioPort> exposedPorts, String k8sDesc) {
        Object out = "ports:\n";
        for (CodeStudioMeta.ExposedCodeStudioPort exposedPort : exposedPorts) {
            int port = exposedPort.containerPort == null ? exposedPort.port : exposedPort.containerPort;
            out = (String)out + "- containerPort: " + port + "\n";
        }
        k8sDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_CONTAINER_PORTS__", (String)out, k8sDesc);
        return k8sDesc;
    }

    public static String fillPotentiallyMultipleReplacement(String lookupKey, String value, String k8sDesc) {
        if (StringUtils.isNotBlank((String)value)) {
            Matcher yamlSection;
            while ((yamlSection = Pattern.compile("^(\\s+)#\\s*" + lookupKey + "\n", 8).matcher(k8sDesc)).find()) {
                Object out = "";
                String indent = yamlSection.group(1);
                for (String valueLine : StringUtils.split((String)value, (char)'\n')) {
                    out = (String)out + indent;
                    out = (String)out + valueLine;
                    out = (String)out + "\n";
                }
                k8sDesc = yamlSection.replaceFirst(lookupKey).replaceFirst(lookupKey, (String)out);
            }
        }
        return k8sDesc;
    }

    private static void requirePlaceholder(Matcher matcher, String placeholderName) {
        if (!matcher.find()) {
            throw new IllegalStateException("Placeholder '%s' not found in Kubernetes specification".formatted(placeholderName));
        }
    }

    public static String fillSingleReplacement(String lookupKey, List<String> lines, String k8sDesc) {
        if (!lines.isEmpty()) {
            Matcher yamlSection = Pattern.compile("^(\\s+)#\\s*" + lookupKey + "\n", 8).matcher(k8sDesc);
            KubernetesExecUtils.requirePlaceholder(yamlSection, lookupKey);
            StringBuilder out = new StringBuilder();
            String indent = yamlSection.group(1);
            for (String line : lines) {
                if (!StringUtils.isNotBlank((String)line)) continue;
                out.append(indent).append(line).append("\n");
            }
            k8sDesc = yamlSection.replaceFirst(lookupKey).replace(lookupKey, out.toString());
        }
        return k8sDesc;
    }

    public static String fillSingleReplacement(String lookupKey, String lines, String k8sDesc) {
        return KubernetesExecUtils.fillSingleReplacement(lookupKey, Arrays.asList(StringUtils.split((String)lines, (char)'\n')), k8sDesc);
    }

    private static String fillEnv(Map<String, String> environment, String k8sDesc, ContainerExecRuntimeConfig containerConfig) {
        Matcher envMatcher = Pattern.compile("^(\\s+)#\\s*__DKU_ENV__\n", 8).matcher(k8sDesc);
        KubernetesExecUtils.requirePlaceholder(envMatcher, "__DKU_ENV__");
        StringBuilder envSb = new StringBuilder();
        String envIndentation = envMatcher.group(1);
        Pattern excludedEnvVarsPattern = containerConfig.getExcludedEnvVarsPattern();
        for (Map.Entry<String, String> env : environment.entrySet()) {
            if (!ALLOWED_ENV_VARS.matcher(env.getKey()).matches()) {
                logger.warn((Object)"Found an env var with forbidden chars. It won't be passed to the container.");
                continue;
            }
            if (excludedEnvVarsPattern.matcher(env.getKey()).matches() || env.getKey().matches("^DKU_(?:API_TICKET|BACKEND_HOST|BACKEND_PORT|EXECUTION_ID)$")) continue;
            envSb.append(envIndentation).append("- name: ").append(env.getKey()).append('\n');
            String value = env.getValue().replaceAll("[\"\\\\]", "\\\\$0").replaceAll("\n", "\\\\n").replaceAll("\\p{Cntrl}", "");
            envSb.append(envIndentation).append("  value: \"").append(value).append("\"\n");
        }
        if (containerConfig.isReadOnlyRootFilesystem()) {
            envSb.append(envIndentation).append("- name: DKU_READONLY_ROOT_FS\n");
            envSb.append(envIndentation).append("  value: \"1\"\n");
        }
        k8sDesc = envMatcher.replaceFirst("__DKU_ENV__").replace("__DKU_ENV__", envSb.toString());
        return k8sDesc;
    }

    public static List<String> getVolumesLines(ContainerExecRuntimeConfig containerConfig) {
        ArrayList ret = Lists.newArrayList();
        if (!containerConfig.hostPathVolumes.isEmpty() || containerConfig.enableCustomSHM) {
            ret.add("volumes:");
            int volumeId = 0;
            for (ClusterProperty hostPathVolume : containerConfig.hostPathVolumes) {
                String volumeName = "volume-" + volumeId;
                ret.add("- name: \"" + volumeName + "\"");
                ret.add("  hostPath:");
                ret.add("    path: \"" + hostPathVolume.key.replace("\"", "\\\"") + "\"");
                ++volumeId;
            }
            if (containerConfig.enableCustomSHM) {
                ret.add("- name: \"dshm\"");
                ret.add("  emptyDir:");
                ret.add("    medium: Memory");
                if (containerConfig.customSHMValueMB > 0) {
                    ret.add("    sizeLimit: \"" + containerConfig.customSHMValueMB + "Mi\"");
                }
            }
        }
        return ret;
    }

    public static List<String> getVolumeMountsLines(ContainerExecRuntimeConfig containerConfig) {
        ArrayList ret = Lists.newArrayList();
        if (!containerConfig.hostPathVolumes.isEmpty() || containerConfig.enableCustomSHM) {
            ret.add("volumeMounts:");
            int volumeId = 0;
            for (ClusterProperty hostPathVolume : containerConfig.hostPathVolumes) {
                String volumeName = "volume-" + volumeId;
                ret.add("- name: \"" + volumeName + "\"");
                ret.add("  mountPath: \"" + hostPathVolume.value.replace("\"", "\\\"") + "\"");
                ++volumeId;
            }
            if (containerConfig.enableCustomSHM) {
                ret.add("- name: \"dshm\"");
                ret.add("  mountPath: \"/dev/shm\"");
            }
        }
        return ret;
    }

    public static String fillVolumes(ContainerExecRuntimeConfig containerConfig, String k8sDesc, @Nullable List<String> extraVolumeLines, @Nullable List<String> extraVolumeMountLines) {
        Matcher kubeHostVolumesMatcher = Pattern.compile("^(\\s+)#\\s*__DKU_KUBERNETES_HOSTPATH_HOST_VOLUMES__\n", 8).matcher(k8sDesc);
        KubernetesExecUtils.requirePlaceholder(kubeHostVolumesMatcher, "__DKU_KUBERNETES_HOSTPATH_HOST_VOLUMES__");
        Matcher kubeVolumeMountsMatcher = Pattern.compile("^(\\s+)#\\s*__DKU_KUBERNETES_HOSTPATH_VOLUME_MOUNTS__\n", 8).matcher(k8sDesc);
        KubernetesExecUtils.requirePlaceholder(kubeVolumeMountsMatcher, "__DKU_KUBERNETES_HOSTPATH_VOLUME_MOUNTS__");
        String kubVolumeMountsIndent = kubeVolumeMountsMatcher.group(1);
        StringBuilder kubVolumeMountsSb = new StringBuilder();
        String kubHostVolumesIndent = kubeHostVolumesMatcher.group(1);
        StringBuilder kubHostVolumesSb = new StringBuilder();
        if (!containerConfig.hostPathVolumes.isEmpty() || containerConfig.enableCustomSHM) {
            List<String> volumeLines = KubernetesExecUtils.getVolumesLines(containerConfig);
            List<String> volumeMountLines = KubernetesExecUtils.getVolumeMountsLines(containerConfig);
            for (String string : volumeLines) {
                kubHostVolumesSb.append(kubHostVolumesIndent).append(string).append("\n");
            }
            for (String string : volumeMountLines) {
                kubVolumeMountsSb.append(kubVolumeMountsIndent).append(string).append("\n");
            }
        }
        if (containerConfig.isReadOnlyRootFilesystem()) {
            String writableHomeVolumeSizeLimit = containerConfig.getProperty("writableHomeVolumeSizeLimit", "");
            Object defaultHomeVolumeDesc = StringUtils.isBlank((String)writableHomeVolumeSizeLimit) ? "emptyDir: {}" : "emptyDir:\n  sizeLimit: " + writableHomeVolumeSizeLimit;
            String writableHomeVolumeDesc = containerConfig.getProperty("writableHomeVolumeDesc", (String)defaultHomeVolumeDesc);
            if (kubHostVolumesSb.isEmpty()) {
                kubHostVolumesSb.append(kubHostVolumesIndent).append("volumes:\n");
            }
            kubHostVolumesSb.append(kubHostVolumesIndent).append("- name: dku-home-volume\n");
            for (String line3 : writableHomeVolumeDesc.split("\\\\n|\n")) {
                if (line3.isEmpty()) continue;
                kubHostVolumesSb.append(kubHostVolumesIndent).append("  ").append(line3).append("\n");
            }
            if (kubVolumeMountsSb.isEmpty()) {
                kubVolumeMountsSb.append(kubVolumeMountsIndent).append("volumeMounts:\n");
            }
            kubVolumeMountsSb.append(kubVolumeMountsIndent).append("- name: dku-home-volume\n");
            kubVolumeMountsSb.append(kubVolumeMountsIndent).append("  mountPath: /home/dataiku").append("\n");
            String string = containerConfig.getProperty("writableTmpVolumeSizeLimit", "");
            Object defaultTmpVolumeDesc = StringUtils.isBlank((String)string) ? "emptyDir: {}" : "emptyDir:\n  sizeLimit: " + string;
            String writableTmpVolumeDesc = containerConfig.getProperty("writableTmpVolumeDesc", (String)defaultTmpVolumeDesc);
            kubHostVolumesSb.append(kubHostVolumesIndent).append("- name: dku-tmp-volume\n");
            for (String line4 : writableTmpVolumeDesc.split("\\\\n|\n")) {
                if (line4.isEmpty()) continue;
                kubHostVolumesSb.append(kubHostVolumesIndent).append("  ").append(line4).append("\n");
            }
            kubVolumeMountsSb.append(kubVolumeMountsIndent).append("- name: dku-tmp-volume\n");
            kubVolumeMountsSb.append(kubVolumeMountsIndent).append("  mountPath: ").append(containerConfig.DKU_TMPDIR).append("\n");
        }
        if (extraVolumeLines != null) {
            if (kubHostVolumesSb.isEmpty() && !extraVolumeLines.isEmpty()) {
                kubHostVolumesSb.append(kubHostVolumesIndent).append("volumes:\n");
            }
            extraVolumeLines.forEach(line -> kubHostVolumesSb.append(kubHostVolumesIndent).append((String)line));
        }
        if (extraVolumeMountLines != null) {
            if (kubVolumeMountsSb.isEmpty() && !extraVolumeMountLines.isEmpty()) {
                kubVolumeMountsSb.append(kubVolumeMountsIndent).append("volumeMounts:\n");
            }
            extraVolumeMountLines.forEach(line -> kubVolumeMountsSb.append(kubVolumeMountsIndent).append((String)line));
        }
        if (!kubHostVolumesSb.isEmpty() && !kubVolumeMountsSb.isEmpty()) {
            k8sDesc = kubeHostVolumesMatcher.replaceFirst("__DKU_KUBERNETES_HOSTPATH_HOST_VOLUMES__").replace("__DKU_KUBERNETES_HOSTPATH_HOST_VOLUMES__", kubHostVolumesSb.toString());
            k8sDesc = kubeVolumeMountsMatcher.reset(k8sDesc).replaceFirst("__DKU_KUBERNETES_HOSTPATH_VOLUME_MOUNTS__").replace("__DKU_KUBERNETES_HOSTPATH_VOLUME_MOUNTS__", kubVolumeMountsSb.toString());
        }
        return k8sDesc;
    }

    public static String fillVolumes(ContainerExecRuntimeConfig containerConfig, String k8sDesc) {
        return KubernetesExecUtils.fillVolumes(containerConfig, k8sDesc, null, null);
    }

    public static String fillInitContainers(ContainerExecRuntimeConfig containerConfig, String k8sDesc, String imageTag) throws IOException {
        if (containerConfig.isReadOnlyRootFilesystem()) {
            String initContainer = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "init-container-rofs.yaml"})).replace("__DKU_IMAGE_ID__", imageTag);
            k8sDesc = KubernetesExecUtils.fillSingleReplacement("__DKU_KUBERNETES_INIT_CONTAINERS__", initContainer, k8sDesc);
        }
        return k8sDesc;
    }

    public static String fillSecurityContext(ContainerExecRuntimeConfig containerConfig, String k8sDesc) {
        Object podSecurityContextContent = "";
        if (containerConfig.podRunAsUid()) {
            String gid;
            String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
            podSecurityContextContent = (String)podSecurityContextContent + "\n  runAsUser: " + uid;
            if (containerConfig.podRunAsGid() && (gid = DKUApp.getParams().getParam("dku.container.dataiku.gid", null)) != null) {
                podSecurityContextContent = (String)podSecurityContextContent + "\n  runAsGroup: " + gid;
            }
        }
        if (containerConfig.podRunAsNonRoot()) {
            podSecurityContextContent = (String)podSecurityContextContent + "\n  runAsNonRoot: true";
        }
        if (!Strings.isEmpty((String)podSecurityContextContent)) {
            k8sDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_SECURITY_CONTEXT__", "securityContext:" + (String)podSecurityContextContent, k8sDesc);
        }
        if (containerConfig.isReadOnlyRootFilesystem()) {
            String containerConstraint = "\n  readOnlyRootFilesystem: true";
            k8sDesc = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_CONTAINER_SECURITY_CONTEXT__", "securityContext:" + containerConstraint, k8sDesc);
        }
        return k8sDesc;
    }

    public static String getServiceAccountTokenConf(String serviceAccountName, String secretName) throws IOException {
        String spec = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "kubernetes", "serviceaccount-token.yaml"})).replace("__SECRET_NAME__", secretName).replace("__SERVICEACCOUNT_NAME__", serviceAccountName);
        return spec;
    }

    public static String sanitizeValue(String value, boolean trimLeft) {
        return KubernetesExecUtils.sanitizeLabelValue(value, trimLeft);
    }

    public static String sanitizeName(String value, boolean trimLeft) {
        return KubernetesExecUtils.sanitizeLabelValue(value, trimLeft);
    }

    public static String sanitizeLabelValue(String value, boolean trimLeft) {
        return KubernetesExecUtils.sanitize(value, trimLeft, true);
    }

    private static String sanitize(String value, boolean trimLeft, boolean applyLowerCase) {
        if (applyLowerCase) {
            value = ((String)value).toLowerCase();
        }
        value = ((String)value).replaceAll("[^-.a-zA-Z0-9_]+", "-");
        String beginAndEndWithAlphanum = "^[^%]*([%](.*[%])?)[^%]*$".replace("%", "a-zA-Z0-9");
        if (((String)(value = ((String)value).replaceFirst(beginAndEndWithAlphanum, "$1"))).length() > 63) {
            value = trimLeft ? "z" + ((String)value).substring(((String)value).length() - 62) : ((String)value).substring(0, 62) + "z";
        }
        return value;
    }

    public static String getNormalizedId(String id) {
        id = id.toLowerCase().replaceAll("[^-.a-z0-9]+", "-");
        assert (id.matches("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")) : "ID for Kubernetes should be a DNS-1123 subdomain, was " + id;
        return id;
    }

    public static String getNormalizedId(String id, int maxLength) {
        id = KubernetesExecUtils.getNormalizedId((String)id);
        while (((String)id).length() > maxLength) {
            Matcher matcher = WORD_PATTERN.matcher((CharSequence)id);
            if (matcher.find()) {
                id = matcher.replaceFirst("$1");
                continue;
            }
            if (((String)(id = ((String)id).substring(((String)id).length() - maxLength))).charAt(0) != '-' && ((String)id).charAt(0) != '.') break;
            id = "z" + ((String)id).substring(1);
            break;
        }
        return id;
    }

    public static String getNormalizedExecutionId(String executionId) {
        return KubernetesExecUtils.getNormalizedId(executionId, 50);
    }

    public static String getPodName(String normalizedExecutionId) {
        return "dataiku-exec-" + normalizedExecutionId;
    }

    public static void createPod(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String podName, File secretFile, File podFile, File recipeTmpDir) throws Exception {
        ProcessDiedException exception;
        block18: {
            exception = null;
            int maxTransientErrorTries = DKUApp.getParams().getIntParam("dku.containerexec.kubernetes.podCreationMaxTransientErrorTries", Integer.valueOf(3));
            long maxCreationTimeMS = KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.podCreationMaxTimeMS", 21600000L);
            long transientErrorRetryDelayMS = KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.podCreationTransientErrorRetryDelayMS", 2000L);
            long quotaErrorRetryDelayMS = KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.podCreationQuotaErrorRetryDelayMS", 30000L);
            long creationStartTime = System.currentTimeMillis();
            int tries = 0;
            int transientErrors = 0;
            int quotaErrors = 0;
            boolean includeSecretInCreation = true;
            do {
                double waited;
                logger.infoV("Trying to create pod %s, try=%s previousTransientErrors=%d previousQuotaErrors=%d timeSinceStartMS=%s", new Object[]{podName, ++tries, transientErrors, quotaErrors, System.currentTimeMillis() - creationStartTime});
                JobActivity ja = JobContext.getCurrentActivityObj();
                if (ja != null) {
                    ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.PREPARING, null, "Initializing container run");
                }
                if ((waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire()) > 0.0) {
                    logger.infoV("Waited %.3f seconds for kubectl create (rate-limited by k8sExecUtils)", new Object[]{waited});
                }
                Object[] kubeCtlCreateCommand = includeSecretInCreation ? KubernetesExecUtils.getKubeCtlCreateCommand(authCtx, projectKey, containerConfig, "-f", secretFile.getAbsolutePath(), "-f", podFile.getAbsolutePath()) : KubernetesExecUtils.getKubeCtlCreateCommand(authCtx, projectKey, containerConfig, "-f", podFile.getAbsolutePath());
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                if (recipeTmpDir != null) {
                    pb.directory(recipeTmpDir);
                }
                pb.command((String[])kubeCtlCreateCommand);
                pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
                logger.debug((Object)("Pod creation command: " + StringUtils.join((Object[])kubeCtlCreateCommand, (String)" ")));
                DKUtils.ExecutionResults kubeCtlCreateResult = DKUtils.execAndGetOutputAndErrors((ProcessBuilder)pb);
                if (kubeCtlCreateResult.rv == 0) {
                    logger.infoV("Pod was successfully created", new Object[0]);
                    if (ja != null) {
                        ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.ACTIVE, null, null);
                    }
                    return;
                }
                logger.warnV("Pod creation for %s was not successful: %s", new Object[]{podName, kubeCtlCreateResult.err});
                if (kubeCtlCreateResult.err.contains("Error from server (AlreadyExists)")) {
                    logger.info((Object)"Pod was successfully created earlier.");
                    if (ja != null) {
                        ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.ACTIVE, null, null);
                    }
                    return;
                }
                if (Pattern.compile("forbidden.*exceeded quota").matcher(kubeCtlCreateResult.err).find()) {
                    logger.warn((Object)("Pod could not be created because the resource quota is exceeded, will retry: '" + kubeCtlCreateResult.err + "'."));
                    ++quotaErrors;
                    includeSecretInCreation = false;
                    exception = new ProcessDiedException("Failed to create pod because quota is still exceeded (exit code: " + kubeCtlCreateResult.rv + "). " + kubeCtlCreateResult.err, null, null, kubeCtlCreateResult.rv);
                    if (ja != null) {
                        if (DKUApp.isDataikuCloud()) {
                            ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_QUOTA_EXCEEDED_CLOUD, "Waiting for available compute resource to start the container");
                        } else {
                            ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_QUOTA_EXCEEDED_SELF_MANAGED, "The Kubernetes quota set by your administrator is exceeded. Waiting for available compute resources to start the container");
                        }
                    }
                    Thread.sleep(quotaErrorRetryDelayMS);
                } else if (KubernetesExecUtils.errorIsTransient(kubeCtlCreateResult)) {
                    logger.warn((Object)("Transient error while creating the pod: '" + kubeCtlCreateResult.err + "'. Will retry"));
                    ++transientErrors;
                    exception = new ProcessDiedException("Failed to create pod because of too many transient errors (exit code: " + kubeCtlCreateResult.rv + "). " + kubeCtlCreateResult.err, null, null, kubeCtlCreateResult.rv);
                    Thread.sleep(transientErrorRetryDelayMS);
                } else {
                    logger.error((Object)("Non-transient error while creating the pod: '" + kubeCtlCreateResult.err + "'."));
                    String errorMessage = kubeCtlCreateResult.err;
                    if (kubeCtlCreateResult.err.contains("error converting YAML to JSON") && kubeCtlCreateResult.err.contains("did not find expected key")) {
                        errorMessage = "Pod YAML configuration is invalid. A parameter key is missing. Please check your containerized execution settings.";
                        logger.error((Object)errorMessage);
                    } else if (kubeCtlCreateResult.err.contains("cannot be handled as a Pod:") && kubeCtlCreateResult.err.contains("quantities must match the regular expression")) {
                        errorMessage = "Pod YAML configuration is invalid. One of the values does not match expected format. Please check your containerized execution settings.";
                        logger.error((Object)errorMessage);
                    }
                    throw new ProcessDiedException("The kubectl create command process failed (exit code: " + kubeCtlCreateResult.rv + "). " + errorMessage, null, null, kubeCtlCreateResult.rv);
                }
                if (transientErrors <= maxTransientErrorTries) continue;
                logger.error((Object)"Max number of transient error tries reached, aborting");
                break block18;
            } while (System.currentTimeMillis() <= creationStartTime + maxCreationTimeMS);
            logger.error((Object)"Max time to create pod reached, aborting");
        }
        logger.error((Object)"Exited pod creation retry loop, creation failed");
        throw exception;
    }

    public static Exception waitForLogStart(AuthCtx authCtx, String projectKey, String podName, ContainerExecRuntimeConfig containerConfig) throws IOException, InterruptedException {
        long startWaitTimeout = ApplicationConfigurator.getParams().getLongParam("dku.containerexec.kubernetes.logFetch.startWaitTimeoutMS", 1800000L);
        long start = System.currentTimeMillis();
        JobActivity ja = JobContext.getCurrentActivityObj();
        logger.info((Object)"Starting to wait for logs to be available");
        boolean podFound = false;
        while (!podFound) {
            if (System.currentTimeMillis() - start > startWaitTimeout) {
                return new IOException("Error while checking kubernetes logs, no pod available after " + startWaitTimeout + " ms");
            }
            double waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds for get pod (rate-limited by k8sExecUtils)", new Object[]{waited});
            }
            logger.info((Object)"Getting pod");
            DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrors((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "pod", podName, "-o", "json"), KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            if (res.rv != 0) {
                if (res.err != null && KubernetesExecUtils.podHasNotStartedYet(res)) {
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                    continue;
                }
                logger.error((Object)("get pod failed, retcode=" + res.rv));
                logger.error((Object)("get pod stdout: " + res.out));
                logger.error((Object)("get pod stderr: " + res.err));
                if (res.err != null && KubernetesExecUtils.errorIsTransient(res)) {
                    logger.warn((Object)"The failure was a K8S apiserver transient error, will retry");
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                    continue;
                }
                return new IOException("Failed to look for pod " + podName);
            }
            podFound = true;
            Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
        }
        logger.info((Object)"Pod is now created, waiting for logs fetch to be successful");
        IOException exception = null;
        String podRunningTimeoutOpt = "--pod-running-timeout=" + ApplicationConfigurator.getParams().getParam("dku.containerexec.kubernetes.logFetch.podRunningTimeout", "1m", true);
        start = System.currentTimeMillis();
        String errorStatusMsg = "";
        while (System.currentTimeMillis() - start < startWaitTimeout) {
            double waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds for get logs (rate-limited by k8sExecUtils)", new Object[]{waited});
            }
            logger.info((Object)("Calling logs on pods/" + podName));
            DKUtils.ExecutionResults status = DKUtils.execAndGetOutputAndErrors((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "logs", "pods/" + podName, podRunningTimeoutOpt, "--tail=1"), KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            if (ja != null) {
                ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.ACTIVE, null, null);
            }
            if (status.rv != 0) {
                logger.info((Object)"Get logs failed");
                if (!errorStatusMsg.equals(status.err)) {
                    logger.infoV("Waiting for logs, time elapsed: %s milliseconds, status changed to: %s", new Object[]{System.currentTimeMillis() - start, status.err});
                    errorStatusMsg = status.err;
                }
                if (KubernetesExecUtils.podHasNotStartedYet(status)) {
                    logger.info((Object)("Pod has not started yet: '" + status.err + "'"));
                    if (ja != null) {
                        if (DKUApp.isDataikuCloud()) {
                            ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_CONTAINERSTARTING_CLOUD, "Execution container is initializing");
                        } else {
                            ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_CONTAINERSTARTING_SELF_MANAGED, "Execution container is initializing");
                        }
                    }
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                    continue;
                }
                if (KubernetesExecUtils.errorIsTransient(status)) {
                    KubernetesPodStatus kubernetesPodStatus = KubernetesExecUtils.getPodStatus(authCtx, projectKey, podName, containerConfig);
                    if (kubernetesPodStatus.isSucceeded()) {
                        logger.info((Object)"Kubectl returned log transient error but the pod was marked as suceeded.");
                        break;
                    }
                    if (kubernetesPodStatus.isFailed()) {
                        logger.error((Object)("Kubectl returned transient error but the pod was marked as failed, will mark logs as failed: " + status.err));
                        exception = new IOException("Error while checking kubernetes logs, returned " + status.rv + System.lineSeparator() + status.err);
                        break;
                    }
                    logger.info((Object)("Kubectl returned transient error but pod is still running. Error message detected, ignoring: '" + status.err + "'"));
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                    continue;
                }
                logger.error((Object)("Unexpected status received while waiting for logs, will mark logs as failed: " + status.err));
                exception = new IOException("Error while checking kubernetes logs, returned " + status.rv + System.lineSeparator() + status.err);
                break;
            }
            waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds for get pod (rate-limited by k8sExecUtils)", new Object[]{waited});
            }
            logger.info((Object)"Getting logs succeeded, but checking that pod is indeed running");
            DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrors((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "pod", podName, "-o", "json"), KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            if (res.rv != 0) {
                logger.error((Object)("get pod failed, retcode=" + res.rv));
                logger.error((Object)("get pod stdout: " + res.out));
                logger.error((Object)("get pod stderr: " + res.err));
                if (res.err != null && KubernetesExecUtils.errorIsTransient(res)) {
                    logger.warn((Object)"The failure was a K8S api server transient error, will retry");
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                    continue;
                }
                return new IOException("Failure while checking status of pod " + podName + ": " + res.err);
            }
            JsonObject pod = (JsonObject)JSON.parse((String)res.out, JsonObject.class);
            boolean podIsPending = false;
            JsonElement phase = JsonUtils.getOrNull((JsonElement)pod.getAsJsonObject(), "status", "phase");
            if (phase == null || phase.isJsonNull() || phase.getAsString().equalsIgnoreCase("pending")) {
                podIsPending = true;
            }
            if (podIsPending) {
                logger.info((Object)"Pod is still pending, keep waiting");
                if (ja != null) {
                    if (DKUApp.isDataikuCloud()) {
                        ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_POD_PENDING_CLOUD, "Container will start soon");
                    } else {
                        ja.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.WAITING_RESOURCES, JobRunCodes.WARN_ACTIVITY_WAITING_K8S_POD_PENDING_SELF_MANAGED, "Not enough compute resource is currently available on your Kubernetes cluster");
                    }
                }
            } else {
                exception = null;
                break;
            }
            exception = new IOException("Cluster cannot schedule pod, it is still pending (lack of available resources on the cluster?)");
            Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
        }
        if (System.currentTimeMillis() - start >= startWaitTimeout) {
            logger.error((Object)"Stopped waiting for log start: timeout exceeded.");
        }
        return exception;
    }

    public static boolean errorIsTransient(DKUtils.ExecutionResults status) {
        return status.err.matches(ApplicationConfigurator.getProperty((String)"dku.containerexec.kubernetes.logFetch.transientErrorsRegex", (String)"|(?s).*?\\(Timeout\\):.* the server was unable to return a response in the time allotted, but may still be processing the request.*|(?s).*?Get .*(?:no such host|TLS handshake timeout).*|(?s).*?ssh: rejected: connect failed \\(Connection (refused|timed out)\\).*|(?s).*?ssh: unexpected packet in response to channel open.*|(?s).*?please apply your changes to the latest version and try again.*|(?s).*?timed out waiting for the condition.*|(?s).*?etcdserver: leader changed.*|(?s).*?context deadline exceeded.*|(?s).*?dial timeout, backstop.*|(?s).*?dial tcp [0-9\\.:]*: i\\/o timeout.*|(?s).*?containerLogs.*dial tcp.*connection refused.*|(?s).*?TLS handshake timeout.*|(?s).*?remote error: tls: internal error.*|(?s).*?request timed out.*|(?s).*?tailLines=1\": EOF.*|(?s).*?gcloud crashed \\(OperationalError\\).*|(?s).*?Error from server: rpc error:.*transport is closing.*|(?s).*?CancelRequest not implemented by \\*genericclioptions\\.CommandHeaderRoundTripper.*"));
    }

    public static boolean podHasNotStartedYet(DKUtils.ExecutionResults status) {
        return status.err.matches(ApplicationConfigurator.getProperty((String)"dku.containerexec.kubernetes.logFetch.notStartedErrorsRegex", (String)"(?s).*?\\(BadRequest\\): container \"c\" in pod \"[^\"]++\" is (?:waiting to start: (ContainerCreating|PodInitializing|CreateContainerConfigError)|not available).*|(?s).*?\\(NotFound\\): the server could not find the requested resource.*pods/log.*|(?s).*?Error from server \\(NotFound\\): pods .* not found"));
    }

    public static int getPodStatusPollingMaxTries() {
        return Math.max(1, ApplicationConfigurator.getParams().getIntParam("dku.containerexec.kubernetes.job.getStatus", Integer.valueOf(3)));
    }

    public static KubernetesPodStatus getPodStatus(AuthCtx authCtx, String projectKey, String podName, ContainerExecRuntimeConfig containerConfig) throws IOException, InterruptedException {
        IOException exception = null;
        int maxTries = KubernetesExecUtils.getPodStatusPollingMaxTries();
        for (int tries = 1; tries <= maxTries; ++tries) {
            double waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds for get pod status (rate-limited by k8sExecUtils)", new Object[]{waited});
            }
            logger.info((Object)("Querying status on pod " + podName + "- try number " + tries));
            DKUtils.ExecutionResults executionResult = DKUtils.execAndGetOutputAndErrorsWithThreadsBasename((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "pods/" + podName, "-o", "jsonpath={.status.phase}", "--ignore-not-found=true"), KubernetesExecUtils.getKubeCtlEnv(containerConfig), (String)"kubectl-get-pod");
            if (executionResult.rv != 0) {
                logger.error((Object)("kubectl get pod failed, err=" + executionResult.err));
                logger.error((Object)("kubectl get pod failed, out=" + executionResult.out));
                exception = new IOException("Error while checking kubernetes pod status, returned " + executionResult.rv + "\n" + executionResult.err);
            } else if (StringUtils.isEmpty((String)executionResult.out)) {
                logger.error((Object)("kubectl get pod failed, no pod found : " + podName));
                exception = new IOException("Error while checking kubernetes pod status, no pod found");
            } else {
                logger.debug((Object)("kubectl get pod OK, out=" + executionResult.out));
                return new KubernetesPodStatus(executionResult);
            }
            Thread.sleep(KubernetesExecUtils.getPodStatusPollingPeriodInMillis());
        }
        assert (exception != null);
        throw exception;
    }

    public static Exception waitForPod(AuthCtx authCtx, String projectKey, String podName, ContainerExecRuntimeConfig containerConfig, KubernetesFailureCodeProvider codeProvider) throws IOException, InterruptedException {
        ProcessDiedException exception = null;
        while (true) {
            KubernetesPodStatus status;
            logger.info((Object)"wait for pod to complete, getting pod status");
            try {
                status = KubernetesExecUtils.getPodStatus(authCtx, projectKey, podName, containerConfig);
            }
            catch (IOException e) {
                logger.warn((Object)"Error getting pod status", (Throwable)e);
                return e;
            }
            if (status.isFailed()) {
                double waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
                if (waited > 0.0) {
                    logger.infoV("Waited %.3f seconds for get pods (rate-limited by k8sExecUtils)", new Object[]{waited});
                }
                logger.warn((Object)"Kubernetes Pod failed, trying to find out more");
                DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrorsWithThreadsBasename((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "pods/" + podName, "-o", "json", "--ignore-not-found=true"), KubernetesExecUtils.getKubeCtlEnv(containerConfig), (String)"kubectl-get-pods");
                if (res.rv == 0 && !StringUtils.isEmpty((String)res.out)) {
                    JsonObject ret = (JsonObject)JSON.parse((String)res.out, JsonObject.class);
                    JsonElement state = JsonUtils.getOrNull((JsonElement)ret, "status", "containerStatuses", 0, "state");
                    logger.info((Object)("state:" + JSON.log((Object)state)));
                    if (state != null && state.isJsonObject() && state.getAsJsonObject().has("terminated")) {
                        ProcessDiedException pde;
                        JsonObject terminatedObj = state.getAsJsonObject().getAsJsonObject("terminated");
                        int code = terminatedObj.get("exitCode").getAsInt();
                        String reason = JsonUtils.getStringMemberOrNull(terminatedObj, "reason");
                        logger.warn((Object)("Found Kubernetes pod failure details, code=" + code + " reason=" + reason));
                        exception = pde = new ProcessDiedException("Kubernetes pod failed, exitCode=" + code + ", reason=" + reason, null);
                        if (codeProvider != null && "OOMKilled".equals(reason)) {
                            pde.withCode(codeProvider.codeForOOMKilled());
                        }
                    } else {
                        logger.warn((Object)"Did not manage to find a proper state");
                    }
                } else if (StringUtils.isEmpty((String)res.out)) {
                    logger.warn((Object)("Failed to get pod details, no pod found : " + podName));
                } else {
                    logger.warn((Object)("Failed to get pod details, code=" + res.rv + " out: " + res.out + " stderr: " + res.err));
                }
                if (exception != null) break;
                exception = new ProcessDiedException("Kubernetes pod failed", null);
                break;
            }
            if (status.isSucceeded()) {
                logger.info((Object)"Kubernetes pod is succeeded");
                break;
            }
            logger.debug((Object)"Kubernetes pod is running");
            Thread.sleep(KubernetesExecUtils.getPodStatusPollingPeriodInMillis());
        }
        return exception;
    }

    public static int streamLogsUntilPodsAreDone(AuthCtx authCtx, String projectKey, File tmpDir, String podName, ContainerExecRuntimeConfig containerConfig, File logFile) throws IOException, InterruptedException {
        boolean podIsProducingLog;
        Object[] podlogCommand = KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "logs", "-f", "pods/" + podName, "--all-containers");
        String[] podListCommand = KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "pods/" + podName, "-o", "json", "--ignore-not-found=true");
        Map<String, String> cmdEnv = KubernetesExecUtils.getKubeCtlEnv(containerConfig);
        Integer returnValue = null;
        Long lastLogEnd = null;
        do {
            double waited;
            if ((waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire()) > 0.0) {
                logger.infoV("Waited %.3f seconds for stream pod logs (rate-limited by k8sExecUtils)", new Object[]{waited});
            }
            ArrayList podlogCommandWithSince = Lists.newArrayList((Object[])podlogCommand);
            if (lastLogEnd != null) {
                long sinceLast = Math.max(0L, System.currentTimeMillis() - lastLogEnd) + 1000L;
                logger.info((Object)("Fetch logs since " + sinceLast + " ms"));
                podlogCommandWithSince.add("--since=" + sinceLast + "ms");
            } else {
                logger.info((Object)"Fetch logs");
            }
            int podLogRv = DKUtils.execAndLogToFileMirrorWithThreadBaseName((String[])podlogCommandWithSince.toArray(new String[0]), cmdEnv, (File)tmpDir, (String)"kubectl-stream-logs", (File)logFile, (boolean)true);
            logger.info((Object)("Log streaming stopped with rv=" + podLogRv + ", checking if pods do not produce logs anymore..."));
            if (returnValue == null && podLogRv != 0) {
                returnValue = podLogRv;
            }
            lastLogEnd = System.currentTimeMillis();
            Thread.sleep(500L);
            long gettingPodsTimeout = ApplicationConfigurator.getParams().getLongParam("dku.containerexec.kubernetes.logFetch.pollWaitTimeoutMS", 120000L);
            long maxGettingPodsTime = System.currentTimeMillis() + gettingPodsTimeout;
            podIsProducingLog = false;
            while (System.currentTimeMillis() < maxGettingPodsTime) {
                waited = KubernetesExecUtils.getKubeCtlRateLimiter().acquire();
                if (waited > 0.0) {
                    logger.infoV("Waited %.3f seconds for get pods (rate-limited by k8sExecUtils)", new Object[]{waited});
                }
                logger.info((Object)"Check if pods could still produce logs");
                DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrorsWithThreadsBasename((String[])podListCommand, cmdEnv, (String)"kubectl-get-pods");
                if (res.rv != 0) {
                    if (!KubernetesExecUtils.errorIsTransient(res)) {
                        logger.error((Object)("Unexpected status received while checking for pods: rv=" + res.rv + "\nout=" + res.out + "\nerr=" + res.err));
                        break;
                    }
                } else {
                    if (StringUtils.isEmpty((String)res.out)) {
                        logger.warn((Object)("Failed to get pod details, no pod found: " + podName));
                        podIsProducingLog = false;
                        break;
                    }
                    podIsProducingLog = KubernetesExecUtils.checkPodStillProduceLogs(res);
                    break;
                }
                logger.warn((Object)("Pod listing returned with a (maybe) transient error: rv=" + res.rv + "\nout=" + res.out + "\nerr=" + res.err));
                logger.info((Object)"  > could not get pods list, retrying in a bit");
                try {
                    Thread.sleep(KubernetesExecUtils.getLogsPollingPeriodInMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!podIsProducingLog || returnValue == null) continue;
            logger.info((Object)"Pods are producing logs, erasing initial error");
            returnValue = null;
        } while (podIsProducingLog);
        return returnValue == null ? 0 : returnValue;
    }

    private static boolean checkPodStillProduceLogs(DKUtils.ExecutionResults res) {
        JsonObject pod = (JsonObject)JSON.parse((String)StringUtils.defaultIfBlank((String)res.out, (String)"{}"), JsonObject.class);
        if (pod == null) {
            return false;
        }
        HashMap countContainersByState = Maps.newHashMap();
        JsonElement phaseElt = JsonUtils.getOrNull((JsonElement)pod, "status", "phase");
        if (phaseElt == null || !phaseElt.isJsonPrimitive()) {
            return false;
        }
        String phase = StringUtils.defaultIfBlank((String)phaseElt.getAsString(), (String)"unknown");
        JsonElement containersElt = JsonUtils.getOrNull((JsonElement)pod, "status", "containerStatuses");
        if (containersElt != null && containersElt.isJsonArray()) {
            JsonArray containers = containersElt.getAsJsonArray();
            for (int j = 0; j < containers.size(); ++j) {
                JsonObject container = containers.get(j).getAsJsonObject();
                JsonElement nameElt = JsonUtils.getOrNull((JsonElement)container, "name");
                JsonElement stateElt = JsonUtils.getOrNull((JsonElement)container, "state");
                if (nameElt == null || !nameElt.isJsonPrimitive() || stateElt == null || !stateElt.isJsonObject()) continue;
                Set states = stateElt.getAsJsonObject().keySet();
                String name = StringUtils.defaultIfBlank((String)nameElt.getAsString(), (String)"unknown");
                if (!"c".equals(name)) continue;
                for (String state : states) {
                    countContainersByState.merge(state, 1, (a, b) -> a + b);
                }
            }
        }
        logger.info((Object)("Pods phase is: " + phase));
        logger.info((Object)("Container states are: " + JSON.log((Object)countContainersByState)));
        HashSet mayStillProduceLogs = Sets.newHashSet((Object[])new String[]{"pending", "running", "unknown"});
        return mayStillProduceLogs.contains(phase.toLowerCase());
    }

    public static void deleteFromFiles(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, boolean forceNow, Collection<File> files) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        for (File f : files) {
            args.add("-f");
            args.add(f.getAbsolutePath());
        }
        KubernetesExecUtils.delete(authCtx, projectKey, containerConfig, forceNow, args.toArray(new String[0]));
    }

    public static void delete(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, boolean forceNow, String ... args) throws IOException, InterruptedException {
        String[] command = new String[args.length + (forceNow ? 2 : 1)];
        command[0] = "delete";
        if (forceNow) {
            command[1] = "--force";
        }
        System.arraycopy(args, 0, command, forceNow ? 2 : 1, args.length);
        logger.info((Object)("Deleting Kubernetes object: " + JSON.log((Object)command)));
        DKUtils.ExecutionResults status = DKUtils.execAndGetOutputAndErrors((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, true, command), KubernetesExecUtils.getKubeCtlEnv(containerConfig));
        if (status.rv != 0) {
            throw new IOException("Could not stop kubernetes object: return value was " + status.rv + " (" + status.err + ")");
        }
    }

    public static String getObjectEvents(AuthCtx authCtx, String projectKey, String name, ContainerExecRuntimeConfig containerConfig) throws IOException, InterruptedException {
        DKUtils.ExecutionResults status = DKUtils.execAndGetOutputAndErrors((String[])KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "event", "--field-selector", "involvedObject.name=" + name, "--no-headers"), KubernetesExecUtils.getKubeCtlEnv(containerConfig));
        if (status.rv != 0) {
            throw new IOException("Error while checking kubernetes object status, returned " + status.rv + "\n" + status.err);
        }
        return status.out;
    }

    public static String applyYamlModifier(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String yaml, K8SAPIDeploymentInfra.K8SYamlModifier modifier, File tmpDir, JsonObject ctx) throws DKUSecurityException, Exception {
        JsonObject config = (JsonObject)JSON.deepCopy((Object)modifier.config);
        String runnableType = modifier.runnableType;
        config.add("dku_context", (JsonElement)ctx);
        config.add("dku_container", JSON.toJsonElement((Object)containerConfig));
        YamlUtils yamlUtils = new YamlUtils();
        String inputJson = yamlUtils.yamlToJsonString(yaml);
        DSSRunnablesService dssRunnablesService = (DSSRunnablesService)SpringUtils.getBean(DSSRunnablesService.class);
        JsonObject outputJson = dssRunnablesService.runMacroFunction(authCtx, projectKey, tmpDir, runnableType, config, inputJson);
        String modified = yamlUtils.jsonObjectToYamlString(outputJson);
        logger.info((Object)("modified to=\n" + modified));
        return modified;
    }

    public static PodStatusesSummary getPodStatusesCount(JsonObject obj) {
        PodStatusesSummary ret = new PodStatusesSummary();
        HashSet badOmenStatuses = Sets.newHashSet((Object[])new String[]{"errimagepull", "crashloopbackoff", "imagepullbackoff"});
        if (obj.has("items")) {
            JsonArray podList = obj.getAsJsonArray("items");
            for (JsonElement e : podList) {
                JsonObject statusObj;
                JsonObject podObj = (JsonObject)e;
                if (!podObj.has("metadata") || !podObj.getAsJsonObject("metadata").has("name")) continue;
                String podId = podObj.getAsJsonObject("metadata").get("name").getAsString();
                if (!podObj.has("status") || !(statusObj = podObj.getAsJsonObject("status")).has("containerStatuses")) continue;
                String podStatus = null;
                if (statusObj.has("phase")) {
                    podStatus = statusObj.get("phase").getAsString().toLowerCase();
                }
                JsonArray containerStatuses = statusObj.getAsJsonArray("containerStatuses");
                for (JsonElement containerStatus : containerStatuses) {
                    JsonObject waitingObj;
                    JsonObject containerStatusObj = containerStatus.getAsJsonObject();
                    if (!containerStatusObj.has("state") || !containerStatusObj.getAsJsonObject("state").has("waiting") || !(waitingObj = containerStatusObj.getAsJsonObject("state").getAsJsonObject("waiting")).has("reason") || !badOmenStatuses.contains(podStatus = waitingObj.get("reason").getAsString().toLowerCase())) continue;
                    String msg = "Found problematic status for pod " + podId + " : " + JSON.json((Object)waitingObj);
                    ret.errors.add(msg);
                }
                if (podStatus == null) continue;
                ret.byStatus.computeIfAbsent(podStatus, s -> new ArrayList()).add(podId);
            }
        }
        return ret;
    }

    public static HttpGetActionParts getProbeParts(String url) {
        HttpGetActionParts ret = new HttpGetActionParts();
        Pattern schemeHostPortPattern = Pattern.compile("^([^:]+)://([^:/]+)(:[0-9]+)?((/|\\$).*)?$");
        Matcher schemeHostPortMatcher = schemeHostPortPattern.matcher(url);
        if (schemeHostPortMatcher.matches()) {
            ret.scheme = schemeHostPortMatcher.group(1).toLowerCase();
            ret.host = schemeHostPortMatcher.group(2);
            ret.port = Integer.parseInt(schemeHostPortMatcher.group(3).substring(1));
            url = schemeHostPortMatcher.group(4);
        }
        ret.path = url;
        if ("localhost".equals(ret.host) || "127.0.0.1".equals(ret.host)) {
            ret.host = null;
        }
        return ret;
    }

    public static long getPodStatusPollingPeriodInMillis() {
        return KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.kubectl.getjobstatuspollingperiodinmillis", 5000L);
    }

    private static long getLogsPollingPeriodInMillis() {
        return KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.kubectl.getlogspollingperiodinmillis", 1000L);
    }

    public static long getWebappsPollingPeriodInMillis() {
        return KubernetesExecUtils.getLongParamSafe("dku.containerexec.kubernetes.kubectl.getwebappspollingperiodinmillis", 5000L);
    }

    private static long getLongParamSafe(String paramKey, long defaultValue) {
        try {
            return DKUApp.getParams().getLongParam(paramKey, defaultValue);
        }
        catch (NumberFormatException formatException) {
            logger.warn((Object)("Could not parse the numerical value for param '" + paramKey + "'. Using '" + defaultValue + "' instead."), (Throwable)formatException);
            return defaultValue;
        }
    }

    private static RateLimiter getKubeCtlRateLimiter() {
        return RateLimiterRegistry.forName("k8sExecUtils", KubernetesExecUtils.getKubeCtlRateLimitPerSeconds());
    }

    private static long getKubeCtlRateLimitPerSeconds() {
        long defaultRateLimit = 10L;
        try {
            return DKUApp.getParams().getLongParam("dku.containerexec.kubernetes.kubectl.ratelimitpersecond", 10L);
        }
        catch (NumberFormatException formatException) {
            logger.warn((Object)"Could not parse the rate limit property. Using '10' instead.", (Throwable)formatException);
            return 10L;
        }
    }

    public static class LabelsAndAnnotations {
        private Map<String, String> labels = new HashMap<String, String>();
        public Map<String, String> annotations = new HashMap<String, String>();

        public Map<String, String> getLabels() {
            return Maps.newHashMap(this.labels);
        }

        public void putLabel(String name, String value) {
            this.putLabel(name, value, false, true);
        }

        public void putLabelAndAnnotation(String name, String value) {
            this.putLabel(name, value);
            this.putAnnotation(name, value);
        }

        public void putLabel(String name, String value, boolean trimLeft, boolean lowerCase) {
            this.labels.put(name, KubernetesExecUtils.sanitize(value, trimLeft, lowerCase));
        }

        public void putLabelAndAnnotation(String name, String value, boolean trimLeft) {
            this.putLabel(name, value, trimLeft, true);
            this.putAnnotation(name, value);
        }

        public void putLabelIfNotExists(String name, String value) {
            if (!this.labels.containsKey(name)) {
                this.putLabel(name, value);
            }
        }

        public void putAllLabels(Map<String, String> allLabels) {
            for (Map.Entry<String, String> set : allLabels.entrySet()) {
                this.putLabel(set.getKey(), set.getValue());
            }
        }

        public String getLabel(String name) {
            return this.labels.get(name);
        }

        public void putAnnotation(String name, String value) {
            this.annotations.put(name, value);
        }
    }

    public static class ExtraList
    extends ArrayList<SimpleKeyValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class HttpGetActionParts {
        public String scheme = "http";
        public String host;
        public int port;
        public String path;
    }

    public static class KubernetesPodStatus {
        private DKUtils.ExecutionResults executionResults;

        private KubernetesPodStatus(DKUtils.ExecutionResults executionResults) {
            this.executionResults = executionResults;
        }

        public boolean isSucceeded() {
            return "Succeeded".equalsIgnoreCase(this.executionResults.out);
        }

        public boolean isFailed() {
            return "Failed".equalsIgnoreCase(this.executionResults.out);
        }

        public boolean isRunning() {
            return "Running".equalsIgnoreCase(this.executionResults.out);
        }

        public boolean isPending() {
            return "Pending".equalsIgnoreCase(this.executionResults.out);
        }

        public boolean isFinished() {
            return this.isSucceeded() || this.isFailed();
        }
    }

    public static interface KubernetesFailureCodeProvider {
        public InfoMessage.MessageCode codeForOOMKilled();
    }

    public static class PodStatusesSummary {
        public Map<String, List<String>> byStatus = Maps.newHashMap();
        public List<String> errors = Lists.newArrayList();

        public List<String> getRunningPods() {
            return this.byStatus.getOrDefault("running", new ArrayList());
        }

        public int getRunningCount() {
            return this.getRunningPods().size();
        }
    }

    public static class PodEventsSniffer
    implements DKUtils.LineSubscription {
        private boolean lowOnEphemeralStorageSeen = false;
        public static final String LOW_ON_EPHEMERAL_STORAGE_MSG = "The node was low on resource: ephemeral-storage";

        public void handle(String line, boolean replace) throws IOException {
            if (!this.lowOnEphemeralStorageSeen && line.contains(LOW_ON_EPHEMERAL_STORAGE_MSG)) {
                JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_TASK_DISKFULL, line, new Object[0]);
                this.lowOnEphemeralStorageSeen = true;
            }
        }

        public void close() throws IOException {
        }
    }

    public static class KubernetesPod
    extends RegularProcess {
        private final AuthCtx authCtx;
        private final String projectKey;
        private final String podName;
        private final File secretFile;
        private final File podFile;
        private final ContainerExecRuntimeConfig containerConfig;
        private String nsErrorLine = null;
        private boolean podCreationDone = false;

        public KubernetesPod(AuthCtx authCtx, String projectKey, String podName, ContainerExecRuntimeConfig containerConfig, File secretFile, File podFile) throws IOException, InterruptedException {
            super(KubernetesPod.makePB(authCtx, projectKey, podName, containerConfig), new File("."));
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.podName = podName;
            this.secretFile = secretFile;
            this.podFile = podFile;
            this.containerConfig = containerConfig;
        }

        public String getPodName() {
            return this.podName;
        }

        public boolean didCreatePod() {
            return this.podCreationDone;
        }

        public DKUtils.LineSubscription getErrorSniffer() {
            String host = RemoteRunNetworkingUtils.getBackendHost();
            final Pattern nsErrorPattern = Pattern.compile("UnknownHostException.*\\Q" + host + "\\E.*Name or service not known", 2);
            return new DKUtils.LineSubscription(){

                public void close() throws IOException {
                }

                public void handle(String line, boolean replace) throws IOException {
                    if (nsErrorPattern.matcher(line).find()) {
                        nsErrorLine = line;
                    }
                }
            };
        }

        public void checkSniffedException() throws IOException {
            IOException e = this.getSniffedException();
            if (e != null) {
                throw e;
            }
        }

        public IOException getSniffedException() {
            if (this.nsErrorLine != null) {
                String host = RemoteRunNetworkingUtils.getBackendHost();
                return new CodedIOException((InfoMessage.MessageCode)ContainerExecCodes.ERR_REMOTE_EXEC_NS_RESOLUTION_FAILED, "Remote host can't resolve DSS host ('" + host + "'), consider adjusting DKU_BACKEND_EXT_HOST");
            }
            return null;
        }

        private static ProcessBuilder makePB(AuthCtx authCtx, String projectKey, String podName, ContainerExecRuntimeConfig containerConfig) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "logs", "-f", "pods/" + podName));
            pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            return pb;
        }

        public void start() throws IOException {
            Exception exception;
            try {
                KubernetesExecUtils.createPod(this.authCtx, this.projectKey, this.containerConfig, this.podName, this.secretFile, this.podFile, null);
            }
            catch (Exception e) {
                throw new IOException("Failed to create pod", e);
            }
            this.podCreationDone = true;
            try {
                exception = KubernetesExecUtils.waitForLogStart(this.authCtx, this.projectKey, this.podName, this.containerConfig);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                exception = e;
            }
            if (exception != null) {
                throw new IOException("Kubernetes pod did not start", exception);
            }
            super.start();
        }

        public void delete(boolean forceNow) throws IOException {
            try {
                KubernetesExecUtils.deleteFromFiles(this.authCtx, this.projectKey, this.containerConfig, forceNow, Lists.newArrayList((Object[])new File[]{this.podFile, this.secretFile}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for kubernetes pod deletion", e);
            }
        }

        public void niceKill() throws IOException {
            this.delete(false);
        }

        public void evilKill() throws IOException {
            this.delete(false);
        }
    }

    public static class IngressTLS {
        public String secretName;
        public List<String> hosts = Lists.newArrayList();

        public IngressTLS(String secretName, List<String> hosts) {
            this.secretName = secretName;
            this.hosts = hosts == null ? new ArrayList() : hosts;
        }

        public String toYaml() {
            if (!this.hosts.isEmpty()) {
                return String.format("  - secretName: %s\n    hosts:\n    - %s", this.secretName, Joiner.on((String)"\n    - ").join(this.hosts));
            }
            return String.format("  - secretName: %s", this.secretName);
        }
    }
}

