/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ManualClustersDAO
implements ClustersDAO {
    private final Map<String, Cluster> clusters = Maps.newTreeMap();

    public ManualClustersDAO() {
    }

    public ManualClustersDAO(Cluster ... clusters) {
        for (Cluster cluster : clusters) {
            this.clusters.put(cluster.id, cluster);
        }
    }

    @Override
    public Cluster getOrNull(String id) throws IOException {
        return this.clusters.get(id);
    }

    @Override
    public Cluster getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id);
    }

    @Override
    public Cluster getMandatory(String id) throws IOException {
        Cluster cluster = this.getOrNull(id);
        if (cluster == null) {
            throw new NotFoundException("Cluster does not exist: " + id);
        }
        return cluster;
    }

    @Override
    public Cluster getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id);
    }

    @Override
    public void delete(String id) throws IOException {
        this.clusters.remove(id);
    }

    @Override
    public List<Cluster> list() throws IOException {
        ArrayList ret = Lists.newArrayList();
        for (String id : this.clusters.keySet()) {
            ret.add(this.clusters.get(id));
        }
        return ret;
    }

    @Override
    public List<Cluster> listUnsafe() throws IOException {
        return this.list();
    }

    @Override
    public List<PluginUsagesInspector.MissingType> listMissingTypes() throws IOException {
        return Lists.newArrayList();
    }

    @Override
    public int approximateCount() throws IOException {
        return this.clusters.size();
    }

    @Override
    public void save(Cluster cluster) throws IOException {
        this.clusters.put(cluster.id, cluster);
    }

    @Override
    public long getLastModifiedOrZero(String id) throws IOException {
        return 1L;
    }
}

