/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export;

import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.execution.DashboardEnrichedExport;
import com.dataiku.dip.dashboards.export.execution.DashboardExportPostProcessor;
import com.dataiku.dip.dashboards.export.execution.DashboardExportScriptRunner;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Range;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardsExportService
extends BaseExportService<DashboardExport, ExportFormat, DashboardEnrichedExport> {
    public static final String SCENARIO_RUN_FILE = "scenario-run.json";
    @Autowired
    private DashboardsService dashboardsService;

    @Override
    protected BaseExportService.ExportFutureThread newFutureThread(AuthCtx user, DashboardExport export) throws IOException, DKUSecurityException {
        return new DashboardExportFutureThread(user, (DashboardEnrichedExport)this.checkAndEnrichExport(user, export, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS));
    }

    @Override
    protected DashboardEnrichedExport checkAndEnrichExport(DashboardExport export, HrefContext hrefContext, boolean browserSandBoxing) throws IOException {
        Preconditions.checkArgument((!export.dashboards.isEmpty() ? 1 : 0) != 0, (Object)"At least one dashboard target must be to be specified");
        ArrayList<DashboardEnrichedExport.EnrichedDashboardExportTarget> dashboardExportItems = new ArrayList<DashboardEnrichedExport.EnrichedDashboardExportTarget>();
        for (DashboardExport.Target target : export.dashboards) {
            dashboardExportItems.add(this.checkAndEnrichDashboardTarget(export.projectKey, target, hrefContext, export));
        }
        return new DashboardEnrichedExport(export.exportId, export.projectKey, this.checkAndEnrichExportFormat(export.format, DashboardExport.SCREEN_RANGE_W, DashboardExport.SCREEN_RANGE_H), dashboardExportItems, browserSandBoxing, export.context);
    }

    @Override
    public ExportFormat checkAndEnrichExportFormat(ExportFormat format, Range<Integer> widthRange, Range<Integer> heightRange) {
        if (format.width == null || format.height == null) {
            return super.checkAndEnrichExportFormat(format, widthRange, heightRange);
        }
        Preconditions.checkNotNull((Object)((Object)format.paperSize), (Object)"Paper size must be specified (A4, US_LETTER, SCREEN_16_9, CUSTOM)");
        Preconditions.checkNotNull((Object)((Object)format.fileType), (Object)"File type must specified (PDF, JPEG, PNG)");
        ExportFormat result = this.newExportFormat();
        result.paperSize = format.paperSize;
        result.fileType = format.fileType;
        Preconditions.checkArgument((boolean)widthRange.contains((Object)format.width), (Object)("Specified width is out of range: " + format.width + ". Acceptable range:" + String.valueOf(widthRange)));
        Preconditions.checkArgument((boolean)heightRange.contains((Object)format.height), (Object)("Specified height is out of range: " + format.height + ". Acceptable range:" + String.valueOf(widthRange)));
        result.width = format.width;
        result.height = format.height;
        result.orientation = format.width > format.height ? ExportFormat.Orientation.LANDSCAPE : ExportFormat.Orientation.PORTRAIT;
        return result;
    }

    @Override
    protected ExportFormat newExportFormat() {
        return new ExportFormat();
    }

    private DashboardEnrichedExport.EnrichedDashboardExportTarget checkAndEnrichDashboardTarget(String projectKey, DashboardExport.Target dashboardTarget, HrefContext hrefContext, DashboardExport export) throws IOException {
        Preconditions.checkArgument((!StringUtils.isBlank((String)dashboardTarget.dashboardId) ? 1 : 0) != 0, (Object)"All dashboard targets must contains a valid dashboard Id.");
        Dashboard dashboard = this.dashboardsService.getOrNullUnsafe(projectKey, dashboardTarget.dashboardId);
        if (dashboard == null) {
            throw new NotFoundException("Dashboard " + projectKey + "." + dashboardTarget.dashboardId + " does not exist.");
        }
        Preconditions.checkArgument((dashboardTarget.slideIndex == null || dashboardTarget.slideIndex >= 0 && dashboardTarget.slideIndex < dashboard.pages.size() ? 1 : 0) != 0, (Object)"Specified slide index is out of range.");
        Preconditions.checkArgument((dashboardTarget.exportFormat != null ? 1 : 0) != 0, (Object)"exportFormat is undefined.");
        DashboardEnrichedExport.EnrichedDashboardExportTarget target = new DashboardEnrichedExport.EnrichedDashboardExportTarget();
        target.dashboardId = dashboardTarget.dashboardId;
        target.slideIndex = dashboardTarget.slideIndex;
        target.dashboard = dashboard;
        target.url = hrefContext.dashboard(dashboard.projectKey, dashboard.id, true, export.context != null ? export.exportId : null);
        target.filtersBySlide = dashboardTarget.filtersBySlide;
        target.exportFormat = this.checkAndEnrichExportFormat(dashboardTarget.exportFormat, DashboardExport.SCREEN_RANGE_W, DashboardExport.SCREEN_RANGE_H);
        return target;
    }

    private class DashboardExportFutureThread
    extends BaseExportService.ExportFutureThread {
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

        public DashboardExportFutureThread(AuthCtx user, DashboardEnrichedExport export) {
            super(DashboardsExportService.this, user, export);
        }

        @Override
        protected int getExportTargetCount() {
            int size = ((DashboardEnrichedExport)this.export).dashboards.size();
            return size > 1 ? size : -1;
        }

        @Override
        protected String getTitle() {
            return "Exporting dashboard";
        }

        @Override
        protected void executeScript(InternalAPIKeysService.APIKey key, File rawExportDirectory, FutureProgressState progressState) throws IOException, InterruptedException {
            DashboardEnrichedExport dashboardEnrichedExport = (DashboardEnrichedExport)this.export;
            if (dashboardEnrichedExport.context != null) {
                JSON.prettyToFile((Object)dashboardEnrichedExport.context, (File)new File(rawExportDirectory.getParent(), DashboardsExportService.SCENARIO_RUN_FILE));
            }
            new DashboardExportScriptRunner(dashboardEnrichedExport, rawExportDirectory, key, progressState).execute();
        }

        @Override
        protected File postProcessGeneratedFiles(File rawExportDirectory, File postProcessDirectory, File finalExportDirectory) throws Exception {
            return new DashboardExportPostProcessor((DashboardEnrichedExport)this.export, rawExportDirectory, postProcessDirectory, finalExportDirectory).execute();
        }

        @Override
        protected FuturePayload buildExportFuturePayload() {
            return this.buildExportFuturePayload("dashboard", this.export.format.fileType.toString());
        }
    }

    public static class ScenarioContext {
        public TriggerFire trigger;
        public JsonObject variables;

        public ScenarioContext() {
        }

        public ScenarioContext(TriggerFire trigger, JsonObject variables) {
            this.trigger = trigger;
            this.variables = variables;
        }
    }
}

