/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.utils.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JobExecutionResultHandler {
    private static Logger logger = Logger.getLogger((String)"dip.exec.resultHandler");

    public void handleExecutionResult(File directory, String languageInfo, CodeBasedThingHelper.ExecutionResult result) throws Exception {
        if (result.returnValue != 0) {
            this.throwFromErrorFileOrLogs(directory, languageInfo, result, null);
            logger.info((Object)"Did not find a specific error from error files or logs, falling back on return code");
            CodeBasedThingHelper.throwSubprocessError(languageInfo, result.returnValue);
        }
    }

    public void throwFromErrorFileOrLogs(File directory, String languageInfo, CodeBasedThingHelper.ExecutionResult result, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws Exception {
        this.throwFromErrorFileOrLogs(directory, languageInfo, result == null ? null : result.logOutputFile, codeProvider);
    }

    public void throwFromErrorFileOrLogs(File directory, String languageInfo, File logOutputFile, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws Exception {
        File errorFile = new File(directory, "error.json");
        this.throwFromErrorFileIfPossible(errorFile, languageInfo, codeProvider);
        this.throwFromRemoteNameResolutionErrorInLogs(logOutputFile);
    }

    protected void throwFromRemoteNameResolutionErrorInLogs(File logFile) throws IOException {
        if (logFile != null && logFile.exists()) {
            String host = RemoteRunNetworkingUtils.getBackendHost();
            Pattern nsErrorPattern = Pattern.compile("UnknownHostException.*\\Q" + host + "\\E.*Name or service not known", 2);
            try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
                String line = reader.readLine();
                while (line != null) {
                    if (nsErrorPattern.matcher(line).find()) {
                        throw new CodedIOException((InfoMessage.MessageCode)ContainerExecCodes.ERR_REMOTE_EXEC_NS_RESOLUTION_FAILED, "Remote host can't resolve DSS host ('" + host + "'), consider adjusting DKU_BACKEND_EXT_HOST");
                    }
                    line = reader.readLine();
                }
            }
        }
    }

    protected SerializedError parseErrorFile(File errorFile) {
        if (errorFile.isFile()) {
            SerializedError err;
            logger.info((Object)("Error file found, trying to throw it: " + String.valueOf(errorFile)));
            try {
                err = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                logger.info((Object)("Raw error is" + JSON.log((Object)err)));
            }
            catch (Throwable t) {
                err = new SerializedError(t, true);
                logger.error((Object)"Could not parse error file", t);
            }
            return err;
        }
        return null;
    }

    protected void throwFromSEEIfNSResolutionFailed(SerializedError err) throws CodedIOException {
        String host;
        Pattern nsErrorPattern;
        if (StringUtils.defaultIfEmpty((String)err.errorType, (String)"").contains("UnknownHostException") && (nsErrorPattern = Pattern.compile("\\Q" + (host = RemoteRunNetworkingUtils.getBackendHost()) + "\\E.*Name or service not known", 2)).matcher(StringUtils.defaultIfEmpty((String)err.message, (String)"")).find()) {
            APIError.SerializedErrorException e = new APIError.SerializedErrorException(err);
            throw new CodedIOException((InfoMessage.MessageCode)ContainerExecCodes.ERR_REMOTE_EXEC_NS_RESOLUTION_FAILED, "Remote host can't resolve DSS host ('" + host + "'), consider adjusting DKU_BACKEND_EXT_HOST", (Throwable)e);
        }
    }

    protected void throwFromSEEIfContainerizedOOM(SerializedError err, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws CodedIOException {
        if (codeProvider != null && "SubProcessFailed".equals(err.errorType) && err.message != null && err.message.contains("Containerized process execution failed, return code 119")) {
            APIError.SerializedErrorException e = new APIError.SerializedErrorException(err);
            throw new CodedIOException(codeProvider.codeForOOMKilled(), "Containerized process out of memory", (Throwable)e);
        }
    }

    protected void throwFromErrorFileIfPossible(File errorFile, String languageInfo, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws APIError.SerializedErrorException, IOException {
        SerializedError err = this.parseErrorFile(errorFile);
        if (err != null) {
            this.enrichErrorFile(languageInfo, err);
            logger.info((Object)("After enrichment of error file, error is: " + JSON.log((Object)err)));
            this.throwFromSEEIfNSResolutionFailed(err);
            this.throwFromSEEIfContainerizedOOM(err, codeProvider);
            throw new APIError.SerializedErrorException(err);
        }
    }

    protected void enrichErrorFile(String languageInfo, SerializedError err) {
        if (err.detailedMessage == null && err.message != null) {
            err.detailedMessage = err.message;
        }
        if (StringUtils.isNotBlank((String)languageInfo)) {
            err.message = "Error in " + languageInfo + " process: " + err.message;
            err.detailedMessage = "Error in " + languageInfo + " process: " + err.detailedMessage;
        }
    }
}

