/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.h2.H2RecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GroupingRecipeService;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class H2GroupingRecipeRunner
implements AbortableRecipeRunner {
    @Autowired
    private GroupingRecipeService service;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private JobActivity activity;
    private GroupingRecipePayloadParams params;
    private H2RecipeRunner h2Runner;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.group");

    public H2GroupingRecipeRunner(JobActivity activity, GroupingRecipePayloadParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.params = params;
    }

    public void init() throws Exception {
        logger.info((Object)"Using H2 grouping implementation");
        FlowDataset fdSource = this.activity.getSubgraph().getSourceDatasets().get(0);
        FlowDataset fdTarget = this.activity.getSubgraph().getTargetsDatasets().get(0);
        final Dataset source = fdSource.getMandatory(this.datasetsDAO);
        final Dataset target = fdTarget.getMandatory(this.datasetsDAO);
        StreamableDatasetSelection preSelection = StreamableDatasetSelection.full();
        FilterDesc postFilter = null;
        if (source.getPartitioningSchema().isPartitioned()) {
            preSelection.withSelectedPartitions(this.activity.getSubgraph().getSourcePartitions(fdSource));
        }
        if (this.params.preFilter != null && this.params.preFilter.enabled && this.params.preFilter.getExpressionLanguage() != FilterDesc.ExpressionLanguage.SQL) {
            preSelection.filter = this.params.preFilter;
        }
        if (this.params.postFilter != null && this.params.postFilter.enabled && this.params.postFilter.getExpressionLanguage() != FilterDesc.ExpressionLanguage.SQL) {
            postFilter = this.params.postFilter;
        }
        List<GroupingRecipePayloadParams.GroupingKey> resolvedGroupingKeys = this.params.getResolvedGroupingKeys(source.getSchema());
        ArrayList<String> columnNames = new ArrayList<String>(resolvedGroupingKeys.size() + this.params.values.size());
        boolean includeOnlyRequiredColumns = true;
        for (GroupingRecipePayloadParams.GroupingKey key : resolvedGroupingKeys) {
            columnNames.add(key.column);
        }
        if (this.params.preFilter != null && (this.params.preFilter.enabled || this.params.preFilter.distinct)) {
            includeOnlyRequiredColumns = false;
        }
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            includeOnlyRequiredColumns = false;
        }
        if (this.params.postFilter != null && this.params.postFilter.enabled) {
            includeOnlyRequiredColumns = false;
        }
        for (GroupingRecipePayloadParams.GroupingValue val : this.params.values) {
            if (val.column == null) {
                includeOnlyRequiredColumns = false;
                break;
            }
            if (!val.hasAnyAggr()) continue;
            columnNames.add(val.column);
        }
        ArrayList<List<String>> requiredColumns = null;
        if (includeOnlyRequiredColumns) {
            requiredColumns = new ArrayList<List<String>>();
            requiredColumns.add(columnNames);
        }
        this.h2Runner = new H2RecipeRunner(this.activity, this.datasetsDAO, preSelection, postFilter){

            @Override
            protected String getSql(H2DB dth, JobActivity activity) throws Exception {
                return H2GroupingRecipeRunner.this.service.generateSQLIgnorePartitions(new H2V2SQLDialect(), true, H2GroupingRecipeRunner.this.params, dth.getDataset(source.getName()), target, false);
            }
        };
        this.h2Runner.setRequiredColumns(requiredColumns);
        this.h2Runner.init();
    }

    @Override
    public void run() throws Exception {
        this.h2Runner.run();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.h2Runner != null) {
            this.h2Runner.notifyBeforeAborting();
        }
    }
}

